/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BaseMessageImpl;
import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.QueueMsg;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomListener;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.RoomUserEvent;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.TopicMsg;
import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.AclException;
import com.iplanet.im.server.ArchiveProviders;
import com.iplanet.im.server.BooleanAcl;
import com.iplanet.im.server.DestinationAcl;
import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.LDAPUserSettings;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.NMSSocket;
import com.iplanet.im.server.NMSSocketCallback;
import com.iplanet.im.server.NMSUser;
import com.iplanet.im.server.OutServerConnection;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.server.RoomStorage;
import com.iplanet.im.server.RoomUser;
import com.iplanet.im.server.RosterManager;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.Settings;
import com.iplanet.im.server.Storage;
import com.iplanet.im.server.StorageEvent;
import com.iplanet.im.server.StorageListener;
import com.iplanet.im.server.UserLogEvent;
import com.iplanet.im.server.UserLogListener;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.LazyDate;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.iplanet.im.util.Worker;
import com.sun.im.service.MessagePart;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class NMSConnection
implements RoomListener,
StorageListener,
RoomUser,
UserLogListener,
NMSSocketCallback {
    private NMSSocket nmsSocket;
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    private NMS nms;
    boolean authed = false;
    boolean serverConnection = false;
    private String uid;
    private NMSUser nmsUser;
    private iIMUser user;
    private Vector queuesStartList = new Vector(5);
    private HashSet roomsStartList = new HashSet();
    private Vector topicsStartList = new Vector(5);
    private Vector watchesList = new Vector(20);
    private Date lastNetworkAction = LazyDate.getDate();
    private UserSettings us = UserSettings.get();
    private float _peerVersion = 6.0f;
    private int loginType = 1;
    private boolean allow_file_transfer = true;
    private ArchiveProviders archive = ArchiveProviders.getArchiveProvider();
    static final String ONLINESTATUS_MANAGE_ATTR = "sunIMAllowOnlineStatusManage";
    static final String ALERTS_ACCESS_ATTR = "sunIMAllowAlertsAccess";
    static final String CHAT_INVITE_ATTR = "sunIMAllowChatInvite";
    static final String CHAT_ACCESS_ATTR = "sunIMAllowChatAccess";
    private static final String defaultProp = "FIRST_TIME_IN=false\n";

    void writeCommandDelayed(CommandData cd) {
        Worker w = this.nms.getWorker();
        if (w != null) {
            w.addRunnable(new DelayedWriteCommand(cd));
        }
    }

    public void messageAdded(MessageEvent e) {
        if (!this.writeCommand(e.getSourceMessage())) {
            e.getConnection().removeChangeListener((MessageListener)this);
        }
    }

    public void messageDeleted(MessageEvent e) {
        if (!this.writeCommand(e.getSourceMessage())) {
            e.getConnection().removeChangeListener((MessageListener)this);
        }
    }

    public void roomStarted() {
    }

    public void roomUserStatusChange(RoomUserEvent e) {
        if (!this.writeCommand(e.getSourceMessage())) {
            e.getRoomConnection().removeChangeListener((MessageListener)this);
        }
    }

    public void messageAdded(StorageEvent e) {
        Message m = e.getMessage();
        Storage s = (Storage)e.getSource();
        CommandData c = Command.create((int)101, (Object)s.getTopic(), (Object)m);
        this.writeCommand(c);
    }

    public void messageDeleted(StorageEvent e) {
        Message m = e.getMessage();
        Storage s = (Storage)e.getSource();
        CommandData c = Command.create((int)102, (Object)s.getTopic(), (Object)m.getMsgid());
        this.writeCommand(c);
    }

    public void statusChanged(UserLogEvent e) {
        NMSUser u = e.getUser();
        int status = u.getUserStatus();
        int prevStatus = u.getPrevUserStatus();
        String reason = u.getUserStatusReason();
        CommandData c = Command.create((int)103, (Object)u.getiIMUser().getUID(), (Object)new Integer(status), (Object)reason, (Object)new Integer(prevStatus));
        this.writeCommand(c);
    }

    public void accessDenied(UserLogEvent evt) {
        NMSUser u = evt.getUser();
        if (u.getUserStatus() == 2) {
            return;
        }
        int prevStatus = u.getUserStatus();
        int status = 2;
        String reason = this.res.getString("Offline");
        CommandData c = Command.create((int)103, (Object)u.getiIMUser().getUID(), (Object)new Integer(status), (Object)reason, (Object)new Integer(prevStatus));
        this.writeCommand(c);
    }

    public void messageAdded(RoomStorage rs, RoomMsg m) {
        CommandData c = Command.create((int)101, (Object)rs.getRoom(), (Object)m);
        this.writeCommand(c);
    }

    public void userAdded(RoomStorage rs, iIMUser u, String note) {
        if (u != null && rs != null) {
            this.userAdded(rs.getRoom(), u.getUID(), note);
        }
    }

    public void userAdded(Room r, iIMUser u, String note) {
        if (u != null) {
            this.userAdded(r, u.getUID(), note);
        }
    }

    public void userAdded(Room r, String uid, String note) {
        CommandData c = this._peerVersion > 3.0f ? Command.create((int)105, (Object)r, (Object)uid, (Object)"on", (Object)note) : Command.create((int)105, (Object)r, (Object)uid, (Object)"on");
        this.writeCommand(c);
        Log.out.debug(uid + ": user " + uid + " added to " + r.getUID());
    }

    public void userRemoved(RoomStorage rs, iIMUser u, String note) {
        Room r = rs.getRoom();
        String uid = u.getUID();
        CommandData c = this._peerVersion > 3.0f ? Command.create((int)105, (Object)r, (Object)uid, (Object)"off", (Object)note) : Command.create((int)105, (Object)r, (Object)uid, (Object)"off");
        this.writeCommand(c);
        Log.out.debug(uid + ": user " + uid + " removed from " + r.getUID());
    }

    public iIMUser getUser() {
        return this.user;
    }

    public void sendMessage(iIMUser u, Message m) {
        iIMQueue d = new iIMQueue(u);
        CommandData cd = Command.create((int)101, (Object)d, (Object)m);
        this.writeCommand(cd);
    }

    public boolean sendCommand(CommandData cd) {
        return this.writeCommand(cd);
    }

    public NMSConnection(NMS n, NMSSocket s) {
        this.nms = n;
        this.nmsSocket = s;
        this.nmsSocket.setCallback(this);
        try {
            CommandData nc = Command.create((int)106, (Object)"3.0", (Object)NMS.VERSION, (Object)ConnectionFactory.VERSION, (Object)"");
            this.sendCommand(nc);
            Log.out.debug("Sent HELLO");
        }
        catch (Exception e) {
            Log.out.error("Initial new client " + e.toString());
            Log.out.printStackTrace(e);
            this.close();
        }
    }

    private void startLogMsg(StringBuffer b) {
        if (this.user != null) {
            b.append(this.user.getUID());
        } else {
            b.append(this.res.getString("unknown"));
        }
        b.append(": ");
    }

    public StringBuffer createLogBuffer(String msg) {
        StringBuffer b = new StringBuffer();
        this.startLogMsg(b);
        b.append(msg);
        b.append(" ");
        return b;
    }

    public String createLogString(String msg) {
        StringBuffer b = this.createLogBuffer(msg);
        return b.toString();
    }

    private void archiveMessage(Message m) {
        if (!this.archive.enabled()) {
            return;
        }
        LinkedList<String> l = new LinkedList<String>();
        if (((QueueMsg)m).archiveEnabled() || this.archive.autoArchive()) {
            l.add(m.getFrom().getUID());
        }
        Realm r = NMS.getRealm();
        if (!m.getContentType().equals("net/pollreply")) {
            Destination[] to = m.getTo();
            int i = 0;
            while (i < to.length) {
                try {
                    NMSUser u = r.getUser((iIMPrincipal)this.user, to[i].getUID());
                    if (u.hasAlertArchiving()) {
                        l.add(to[i].getUID());
                    }
                }
                catch (Exception e) {
                    Log.out.warning("Recipient " + to[i].getUID() + " not found");
                    Log.out.printStackTrace(e);
                }
                ++i;
            }
        }
        this.archiveMessage(l, m, null);
    }

    private void archiveInviteMessage(Destination inviteTo, Message m) {
        this.archiveMessage(null, m, inviteTo);
    }

    private void archiveMessage(List accessList, Message m, Destination inviteTo) {
        if (this.archive.enabled()) {
            String ct = m.getContentType();
            if (this.archive.isPollArchiveEnabled() && (((QueueMsg)m).archiveEnabled() || this.archive.autoArchive())) {
                if (ct.equals("net/poll")) {
                    String pollAccess;
                    String pollType;
                    Hashtable ht = (Hashtable)m.getBody();
                    boolean allowCustom = false;
                    if (ht.get("CUSTOM") != null) {
                        allowCustom = true;
                    }
                    if ((pollType = (String)ht.get("POLLTYPE")) == null) {
                        pollType = "open";
                    }
                    if ((pollAccess = (String)ht.get("POLLACCESS")) == null) {
                        pollAccess = "private";
                    }
                    Poll poll = new Poll(m.getMsgid(), m.getSubject(), (List)ht.get("BODY"), allowCustom, pollType, pollAccess);
                    this.archive.newPoll(m.getFrom().getUID(), poll);
                    return;
                }
                if (ct.equals("net/pollreply")) {
                    this.archive.pollAnswer(m.getFrom().getUID(), ((QueueMsg)m).getCorrelationMsgId(), (String)m.getBody());
                    return;
                }
            }
            BaseMessageImpl message = new BaseMessageImpl(m);
            if (inviteTo != null && ct.equals("net/invite")) {
                this.archive.onInvite(inviteTo.getFQName(), (ReadOnlyMessage)message);
            } else if (accessList != null) {
                this.archive.onMessage(accessList, (ReadOnlyMessage)message);
                Log.out.debug("Archiving message with access list: " + accessList);
            } else {
                this.archive.onMessage((ReadOnlyMessage)message);
                Log.out.debug("Archiving message with default access list");
            }
        }
    }

    private void archiveConferenceMessage(Destination d, Message m) {
        if (this.archive.enabled()) {
            BaseMessageImpl message = new BaseMessageImpl(m);
            if (d instanceof Topic && this.archive.isNewsArchiveEnabled()) {
                this.archive.onNewsMessage(d.getFQName(), (ReadOnlyMessage)message);
                return;
            }
            this.archive.onConferenceMessage(d.getFQName(), (ReadOnlyMessage)message);
        }
    }

    private void archiveStart(Destination d) {
        if (this.archive.enabled() && this.user != null) {
            if (d instanceof Topic && this.archive.isNewsArchiveEnabled()) {
                this.archive.onSubscribe(d.getFQName(), this.user.getUID());
            } else {
                this.archive.onJoin(d.getFQName(), this.user.getUID());
            }
        }
    }

    private void archiveStop(Destination d) {
        if (this.archive.enabled() && this.user != null) {
            if (d instanceof Topic && this.archive.isNewsArchiveEnabled()) {
                this.archive.onUnsubscribe(d.getFQName(), this.user.getUID());
            } else {
                this.archive.onLeave(d.getFQName(), this.user.getUID());
            }
        }
    }

    private void archiveSetup(Destination d) {
        if (this.archive.enabled() && this.user != null) {
            this.archive.onSetup(d.getFQName(), this.user.getUID());
        }
    }

    private void archiveClose(Destination d) {
        if (this.archive.enabled() && this.user != null) {
            this.archive.onClose(d.getFQName(), this.user.getUID());
        }
    }

    private void handleSetArchive(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Destination d = (Destination)cd.args[0];
        boolean b = (Boolean)cd.args[1];
        if (this.user != null && d instanceof Room && this.isLocal(d)) {
            RoomStorage store = RoomStorage.get((Room)d);
            store.setArchive((iIMPrincipal)this.user, b);
        }
        CommandData reply = Command.createReply((int)cd.command, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
    }

    private int convert(Message m) throws Exception {
        int rc = 0;
        if (this.nms.converter != null) {
            String ct = m.getContentType();
            if (ct.startsWith("net/typing")) {
                return 0;
            }
            BaseMessageImpl message = new BaseMessageImpl(m);
            Iterator i = message.getPartsAsList().iterator();
            while (i.hasNext()) {
                MessagePart part = (MessagePart)i.next();
                this.nms.converter.convert(part);
            }
        }
        return rc;
    }

    public CommandData forwardToServer(String serverName, CommandData cd) {
        if (this.serverConnection) {
            CommandData reply = Command.createReply((int)cd.command, (int)-1, (String)this.res.getString("cannot_send_commands"));
            Log.out.error(this.createLogString("Only one server hop allowed"));
            return reply;
        }
        cd.user = this.user;
        return this.nms.forwardToServer(serverName, cd, this);
    }

    protected void handleSendGroups(CommandData cd) {
        CommandData reply;
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        if (!this.serverConnection) {
            reply = Command.createReply((int)cd.command, (int)-1, (String)this.res.getString("Server_command_only"));
            l.append("failed : server command only");
            Log.out.error(l.toString());
        } else {
            reply = Command.createReply((int)cd.command, (int)0, (String)this.res.getString("respond_ok"));
            NMSGroup[] ga = (NMSGroup[])cd.args[0];
            this.nms.setInboundGroups(this.uid, ga);
            Log.out.info(l.toString());
        }
        this.writeCommand(reply);
    }

    private boolean isLocal(Destination d) {
        String domain = d.getLocation();
        if (this.serverConnection) {
            return domain.equalsIgnoreCase(NMS.getName());
        }
        return domain.equalsIgnoreCase(this.user.getServer());
    }

    private boolean isLocal(iIMPrincipal p) {
        String domain = p.getServer();
        return domain.equalsIgnoreCase(this.user.getServer());
    }

    private boolean belongsToDefaultDomain(iIMPrincipal p) {
        return p.getServer().equalsIgnoreCase(NMS.getName());
    }

    private void checkMigration(iIMUser user) throws Exception {
        Log.out.debug("checkMigration(): NMS.getPropStore = " + NMS.getPropStore());
        if (NMS.getPropStore() != 1) {
            return;
        }
        Set p = user.getValueSet("sunimuserproperties");
        if (p == null || p.isEmpty()) {
            Log.out.debug("Performing online migration for " + user.getUID());
            HashMap<String, Object> m = new HashMap<String, Object>();
            FileUserSettings fileUserSettings = new FileUserSettings();
            LDAPUserSettings ldapUserSettings = new LDAPUserSettings();
            Properties prop = fileUserSettings.getUserProperties(user);
            if (prop == null || ((Hashtable)prop).size() == 0) {
                HashSet<String> v = new HashSet<String>();
                v.add(defaultProp);
                m.put("sunimuserproperties", v);
                user.setAttribute("sunimuserproperties", v);
            } else {
                m.put("sunimuserproperties", user.getValue("sunimuserproperties"));
            }
            ldapUserSettings.saveUserAttributes(m, user);
            BooleanAccessControlList bacl = fileUserSettings.getPresenceACL(user);
            if (bacl != null) {
                ldapUserSettings.savePresenceACL(user, bacl);
            }
        }
    }

    protected void handleAuth(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        if (this.authed) {
            CommandData reply = Command.createReply((int)200, (int)-1, (String)this.res.getString("duplicate_auth_is"));
            this.writeCommand(reply);
            l.append("already authenticated ");
            Log.out.error(l.toString());
            return;
        }
        String tu = (String)cd.args[0];
        String tp = (String)cd.args[1];
        char[] ua = new char[tu.length()];
        char[] pa = new char[tp.length()];
        tu.getChars(0, tu.length(), ua, 0);
        tp.getChars(0, tp.length(), pa, 0);
        int i = 0;
        while (i < ua.length) {
            ua[i] = (char)(ua[i] ^ 0xBA);
            ++i;
        }
        int i2 = 0;
        while (i2 < pa.length) {
            pa[i2] = (char)(pa[i2] ^ 0xBE);
            ++i2;
        }
        this.uid = new String(ua);
        String password = new String(pa);
        boolean b = false;
        if (cd.args.length >= 3) {
            Boolean bo = (Boolean)cd.args[2];
            b = bo;
        }
        if (cd.args.length > 3) {
            this.loginType = (Integer)cd.args[3];
        }
        l.append(" LoginType=" + this.loginType);
        if (b) {
            String local = StringUtility.getLocalPartFromAddress(this.uid);
            String domain = StringUtility.getDomainFromAddress(this.uid, null);
            NMSConnection c = this.nms.getInboundConnection(local);
            if (c != null) {
                l.append(local);
                l.append(" : server already connected");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)200, (int)-1, (String)this.res.getString("Server_already"));
                this.writeCommand(reply);
                this.close();
                Log.out.info("Pinging existing connection to verify that it is still up");
                CommandData ping = Command.create((int)10);
                if (!c.writeCommand(ping)) {
                    Log.out.info("Stale connection");
                    try {
                        c.close();
                    }
                    catch (Exception e) {
                        this.nms.disconnected(c);
                    }
                    NMSConnection c1 = this.nms.getInboundConnection(local);
                    if (c1 != null && c1 == c) {
                        this.nms.disconnected(c);
                    }
                }
            } else if (this.nms.authInboundServer(local, password)) {
                l.append(this.uid);
                l.append(": server connected");
                this.nms.setInboundServerConnection(local, this, domain);
                this.serverConnection = true;
                this.authed = true;
                Config config = new Config();
                config.server = NMS.getName();
                CommandData reply = Command.createReply((int)200, (int)0, (String)this.res.getString("respond_ok"), (Object)config, null);
                this.writeCommand(reply);
                Log.out.info(l.toString());
            } else {
                l.append(local);
                l.append(": server auth failed");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)200, (int)-1, (String)this.res.getString("Authentication_Failed"));
                this.writeCommand(reply);
                this.close();
            }
        } else {
            l.append(" ");
            l.append(this.uid);
            l.append(": ");
            List realms = NMS.getRealms();
            Iterator i3 = realms.iterator();
            while (i3.hasNext()) {
                Realm r = (Realm)i3.next();
                Log.out.debug("Trying the realm " + r.getClass().toString());
                try {
                    this.nmsUser = r.auth(this.uid, password);
                    if (this.nmsUser != null) {
                        l.append("passed");
                        this.user = this.nmsUser.getiIMUser();
                        this.checkMigration(this.user);
                        IMPolicy.print(this.user);
                        if (this.nmsUser.isLoggedOn() && this.loginType == 1) {
                            CommandData closecd = Command.create((int)108, (Object)"duplicate connection");
                            this.nmsUser.send(closecd);
                            l.append(" (duplicate logon) ");
                            this.nmsUser.deleteConnection(true);
                        }
                        l.append(" users(");
                        l.append(this.nms.getClientConnectionCount() + 1);
                        l.append(")");
                        Log.out.info(l.toString());
                        if (this.nms.addClientConnection(this)) {
                            this.nmsUser.setACL(this.us.getPresenceACL(this.user));
                            this.authed = true;
                            Settings s = Settings.getSettings();
                            Config config = new Config();
                            config.me = this.user;
                            config.server = this.user.getServer();
                            config.servers = this.nms.getOutboundServers();
                            config.groups = new iIMGroup[0];
                            config.queues = s.getQueues(this.user);
                            config.userSettings = RosterManager.migrate(this.user, this.us.getUserProperties(this.user));
                            config.rooms = RosterManager.getSubscribedRooms(this.user, this);
                            config.topics = RosterManager.getSubscribedTopics(this.user);
                            config.me.setAttribute("net.pinginterval", (Object)Integer.toString(this.nms.getClientTimeout()));
                            if (this.archive.enabled()) {
                                config.me.setAttribute("net.archive.enabled", (Object)"true");
                            }
                            CommandData reply = Command.createReply((int)200, (int)0, (String)this.res.getString("respond_ok"), (Object)config);
                            this.writeCommand(reply);
                            if (!this.archive.enabled()) break;
                            this.archive.onLogin(this.user.getUID());
                            break;
                        }
                        Log.out.error("Too many users for current license");
                        CommandData reply = Command.createReply((int)200, (int)-1, (String)"Too many Users");
                        this.writeCommand(reply);
                        this.close();
                        return;
                    }
                    l.append("failed");
                    Log.out.info(l.toString());
                }
                catch (RealmException re) {
                    l.append("failed - unknown user");
                    Log.out.error(l.toString());
                }
                catch (AclException aclException) {
                    l.append("failed to get User's acl");
                    Log.out.error(l.toString());
                }
                catch (Exception e) {
                    Log.out.printStackTrace(e);
                    l.append(e.toString());
                    Log.out.error(l.toString());
                }
            }
            if (!this.authed) {
                CommandData reply = Command.createReply((int)200, (int)-1, (String)this.res.getString("Authentication_Failed"));
                this.writeCommand(reply);
                this.close();
            }
        }
    }

    protected void handleSaveSettings(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        if (this.serverConnection) {
            l.append(this.res.getString("server_connection_can"));
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)205, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
            return;
        }
        if (IMPolicy.canChangeSettings(this.user)) {
            CommandData reply;
            iIMUser u = (iIMUser)cd.args[0];
            if (u == null) {
                u = this.user;
            }
            if (!u.getUID().equalsIgnoreCase(this.user.getUID()) && !IMPolicy.isAdmin(this.user)) {
                l.append(": Access Denied");
                Log.out.warning(l.toString());
                CommandData reply2 = Command.createReply((int)205, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply2);
                return;
            }
            Log.out.info(l.toString());
            Properties p = (Properties)cd.args[1];
            boolean merge = false;
            if (cd.args.length >= 3) {
                Boolean b = (Boolean)cd.args[2];
                merge = b;
            }
            try {
                this.us.saveUserProperties(p, u, merge);
                reply = Command.createReply((int)205, (int)0, (String)this.res.getString("respond_ok"));
            }
            catch (Exception e) {
                reply = Command.createReply((int)205, (int)-1, (String)e.toString());
            }
            this.writeCommand(reply);
        } else {
            l.append(": access denied");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)205, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
        }
    }

    protected void handleGetSettings(CommandData cd) {
        CommandData reply;
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        if (this.serverConnection) {
            l.append(this.res.getString("server_connection_can"));
            Log.out.error(l.toString());
            CommandData reply2 = Command.createReply((int)221, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply2);
            return;
        }
        iIMUser u = (iIMUser)cd.args[0];
        if (u == null) {
            u = this.user;
        }
        Log.out.debug("Command getsettings: " + u.getUID() + " getting user properties ");
        if (!u.getUID().equalsIgnoreCase(this.user.getUID()) && !IMPolicy.isAdmin(this.user)) {
            l.append("access denied");
            Log.out.warning(l.toString());
            CommandData reply3 = Command.createReply((int)221, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply3);
            return;
        }
        Log.out.info(l.toString());
        Log.out.debug("Command getsettings: " + u.getUID() + " getting user properties ");
        try {
            Properties p = this.us.getUserProperties(u);
            reply = Command.createReply((int)221, (int)0, (String)this.res.getString("respond_ok"), (Object)p);
        }
        catch (Exception e) {
            reply = Command.createReply((int)221, (int)-1, (String)e.toString());
        }
        this.writeCommand(reply);
    }

    protected void handleIsMemberOf(CommandData cd) {
        Log.out.info(this.createLogString(Command.toString((CommandData)cd)));
        iIMUser u = (iIMUser)cd.args[0];
        iIMGroup g = (iIMGroup)cd.args[1];
        String userDomain = null;
        userDomain = this.serverConnection ? NMS.getName() : this.user.getServer();
        if (this.serverConnection || g.getServer().equalsIgnoreCase(userDomain)) {
            Boolean ret = null;
            try {
                Realm r = NMS.getRealm();
                NMSGroup nmsg = r.getGroup((iIMPrincipal)this.user, g.getUID());
                ret = new Boolean(nmsg.hasMember((iIMPrincipal)u));
            }
            catch (Exception e) {
                ret = new Boolean(false);
            }
            CommandData reply = Command.createReply((int)222, (int)0, (String)this.res.getString("respond_ok"), (Object)ret);
            this.writeCommand(reply);
        } else if (userDomain.equalsIgnoreCase(NMS.getName())) {
            String[] servers = this.nms.getOutboundServers();
            CommandData reply = null;
            int i = 0;
            while (i < servers.length) {
                reply = this.forwardToServer(servers[i], cd);
                Boolean returnCode = (Boolean)Command.getReplyArg1((CommandData)reply);
                if (returnCode.booleanValue()) break;
                ++i;
            }
            this.writeCommand(reply);
        } else {
            Log.out.error("handleisMemberOf: user " + this.user.getUID() + "of non default domain " + "group " + g.getUID() + " belongs to domain " + g.getServer());
        }
    }

    protected void handleStartTopic(CommandData cd, Topic t, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("topic ");
        l.append(t.getName());
        l.append(" ");
        int access = DestinationAcl.getAccess((Destination)t, this.user);
        if (access >= 2) {
            Storage store = Storage.get(t.getFQName());
            if (store == null) {
                l.append(": does not exist");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)201, (int)-1, (String)this.res.getString("does_not_exist"));
                this.writeCommand(reply);
                return;
            }
            Log.out.info(l.toString());
            CommandData reply = Command.createReply((int)201, (int)0, (String)this.res.getString("respond_ok"), (Object)new Integer(access));
            this.writeCommand(reply);
            this.archiveStart((Destination)t);
            Enumeration e = store.messages();
            while (e.hasMoreElements()) {
                Message m = (Message)e.nextElement();
                CommandData c = Command.create((int)101, (Object)t, (Object)m);
                this.writeCommand(c);
            }
            store.addListener(this);
            this.topicsStartList.addElement(store);
        } else {
            l.append(": access denied");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)201, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
        }
    }

    protected void handleStartQueue(CommandData cd, iIMQueue q, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("user ");
        l.append(q.getUID());
        l.append(" ");
        Iterator i = NMS.getRealms().iterator();
        while (i.hasNext()) {
            Realm r = (Realm)i.next();
            try {
                NMSUser u = r.getUser((iIMPrincipal)this.user, q.getName());
                this.queuesStartList.addElement(u);
                u.setConnection(this);
                Log.out.info(l.toString());
                CommandData reply = Command.createReply((int)201, (int)0, (String)this.res.getString("respond_ok"), (Object)new Integer(14));
                this.writeCommand(reply);
                return;
            }
            catch (RealmException re) {
                Log.out.printStackTrace(re);
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                break;
            }
        }
        l.append(": user not found");
        Log.out.error(l.toString());
        CommandData reply = Command.createReply((int)201, (int)-1, (String)"user not found");
        this.writeCommand(reply);
    }

    protected void handleStartRoom(CommandData cd, Room r, String note, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("room ");
        l.append(r.getName());
        l.append(" ");
        RoomStorage rs = RoomStorage.get(r);
        if (rs == null) {
            l.append(": does not exist");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)201, (int)-1, (String)this.res.getString("does_not_exist"));
            this.writeCommand(reply);
            try {
                RosterManager.removeSubscription((Destination)r, this.user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        int access = 6;
        if (!rs.isTempRoom()) {
            access = DestinationAcl.getAccess((Destination)r, this.user);
        }
        if (rs.isTempRoom() && this.user != null) {
            rs.setArchive((iIMPrincipal)this.user, bArchive);
        }
        if (access < 2) {
            l.append(": acl check failed");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)201, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
            return;
        }
        CommandData reply = Command.createReply((int)201, (int)0, (String)this.res.getString("respond_ok"), (Object)new Integer(access));
        Log.out.debug("Check reply code before sending back " + Command.getReplyCode((CommandData)reply));
        Log.out.debug(this.uid + ": joined " + r.getUID() + " with access=" + access);
        this.writeCommand(reply);
        rs.addUser(this, this.serverConnection, note, access);
        this.roomsStartList.add(r.getFQName());
        this.archiveStart((Destination)r);
        Log.out.info(l.toString());
    }

    protected void handleStopTopic(CommandData cd, Topic t, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("topic ");
        l.append(t.getName());
        l.append(" ");
        if (DestinationAcl.check((Destination)t, this.user, 2)) {
            Storage store = Storage.get(t.getFQName());
            if (store == null) {
                l.append("does not exist");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)202, (int)-1, (String)this.res.getString("does_not_exist"));
                this.writeCommand(reply);
                return;
            }
            Log.out.info(l.toString());
            CommandData reply = Command.createReply((int)202, (int)0, (String)this.res.getString("respond_ok"));
            this.writeCommand(reply);
            store.removeListener(this);
            this.topicsStartList.removeElement(store);
            this.archiveStop((Destination)t);
        } else {
            l.append("access denied");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)202, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
        }
    }

    protected void handleStopQueue(CommandData cd, iIMQueue q, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("queue ");
        l.append(q.getName());
        l.append(" ");
        Iterator i = NMS.getRealms().iterator();
        while (i.hasNext()) {
            Realm r = (Realm)i.next();
            try {
                Log.out.info(l.toString());
                NMSUser u = r.getUser((iIMPrincipal)this.user, q.getName());
                this.queuesStartList.removeElement(u);
                u.deleteConnection(false);
                CommandData reply = Command.createReply((int)202, (int)0, (String)this.res.getString("respond_ok"));
                this.writeCommand(reply);
                return;
            }
            catch (RealmException re) {
            }
            catch (Exception e) {
                break;
            }
        }
        l.append("does not exist");
        Log.out.error(l.toString());
        CommandData reply = Command.createReply((int)202, (int)-1, (String)this.res.getString("does_not_exist"));
        this.writeCommand(reply);
    }

    protected void handleStopRoom(CommandData cd, Room r, boolean bArchive) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("room ");
        l.append(r.getName());
        l.append(" ");
        RoomStorage rs = RoomStorage.get(r);
        if (rs == null) {
            l.append("does not exist");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)202, (int)-1, (String)"not found");
            this.writeCommand(reply);
            return;
        }
        Log.out.info(l.toString());
        CommandData reply = Command.createReply((int)202, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
        rs.setArchive((iIMPrincipal)this.user, bArchive);
        this.archiveStop((Destination)r);
        rs.removeUser(this, this.serverConnection);
        this.roomsStartList.remove(r.getFQName());
        if (rs.size() == 0 && rs.isTempRoom()) {
            this.archiveClose((Destination)r);
        }
    }

    protected void handleStart(CommandData cd) {
        Destination d = (Destination)cd.args[0];
        String userDomain = null;
        userDomain = this.serverConnection ? NMS.getName() : this.user.getServer();
        if (this.isLocal(d)) {
            String note = null;
            if (cd.args.length > 1) {
                note = (String)cd.args[1];
            }
            boolean bArchive = this.archive.autoArchive();
            if (cd.args.length > 2 && !bArchive) {
                bArchive = (Boolean)cd.args[2];
            }
            if (d instanceof Topic) {
                this.handleStartTopic(cd, (Topic)d, bArchive);
            } else if (d instanceof iIMQueue) {
                this.handleStartQueue(cd, (iIMQueue)d, bArchive);
            } else if (d instanceof Room) {
                this.handleStartRoom(cd, (Room)d, note, bArchive);
            } else {
                Log.out.error(this.createLogString(this.res.getString("Invalid_request2")));
            }
        } else {
            StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
            if (userDomain.equalsIgnoreCase(NMS.getName())) {
                Log.out.error("handleStart (relaying) from " + this.user.getUID() + " to destination " + d.getUID());
                CommandData reply = this.forwardToServer(d.getLocation(), cd);
                this.writeCommand(reply);
                if (Command.getReplyCode((CommandData)reply) == -1) {
                    try {
                        RosterManager.removeSubscription(d, this.user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                l.append("Comand.START");
                l.append(d.getUID());
                l.append(":");
                l.append(this.user.getUID());
                l.append(" different domains");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)201, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
            }
        }
    }

    protected void handleStop(CommandData cd) {
        Destination d = (Destination)cd.args[0];
        if (this.isLocal(d)) {
            boolean bArchive = this.archive.autoArchive();
            if (cd.args.length > 1 && !bArchive) {
                bArchive = (Boolean)cd.args[1];
            }
            if (d instanceof Topic) {
                this.handleStopTopic(cd, (Topic)d, bArchive);
            } else if (d instanceof iIMQueue) {
                this.handleStopQueue(cd, (iIMQueue)d, bArchive);
            } else if (d instanceof Room) {
                this.handleStopRoom(cd, (Room)d, bArchive);
            } else {
                Log.out.error(this.createLogString(this.res.getString("Invalid_request2")));
            }
        } else {
            StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
            l.append("forwarded to ");
            l.append(d.getLocation());
            Log.out.info(l.toString());
            CommandData reply = this.forwardToServer(d.getLocation(), cd);
            this.writeCommand(reply);
        }
    }

    private void handleAddTopicMsg(iIMQueue from, Message m, Destination[] d, CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("topic ");
        if (d.length == 1) {
            Topic t = (Topic)d[0];
            l.append(" ");
            l.append(t.getName());
            l.append(" ");
            if (this.isLocal((Destination)t)) {
                if (DestinationAcl.check((Destination)t, this.user, 6)) {
                    CommandData reply = Command.createReply((int)203, (int)0, (String)this.res.getString("respond_ok"));
                    this.writeCommand(reply);
                    Storage store = Storage.get(t.getFQName());
                    if (store == null) {
                        CommandData c = Command.create((int)104, (Object)from, (Object)new Integer(-1), (Object)this.res.getString("does_not_exist"), (Object)m.getMsgid(), (Object)t);
                        this.writeCommand(c);
                        l.append(this.res.getString("storage_does_not"));
                        Log.out.error(l.toString());
                    } else if (store.addMessage(m)) {
                        Log.out.info(l.toString());
                        CommandData c = Command.create((int)104, (Object)from, (Object)new Integer(0), (Object)this.res.getString("OK"), (Object)m.getMsgid(), (Object)t);
                        this.writeCommand(c);
                        this.archiveConferenceMessage((Destination)t, m);
                    } else {
                        l.append(" File Error");
                        Log.out.error(l.toString());
                        CommandData c = Command.create((int)104, (Object)from, (Object)new Integer(-1), (Object)this.res.getString("File_Error"), (Object)m.getMsgid(), (Object)t);
                        this.writeCommand(c);
                    }
                } else {
                    CommandData reply = Command.createReply((int)203, (int)-1, (String)this.res.getString("Access_Denied"));
                    this.writeCommand(reply);
                    l.append(this.res.getString("Access_Denied"));
                    Log.out.warning(l.toString());
                }
            } else {
                l.append("forwarded to ");
                l.append(t.getLocation());
                Log.out.info(l.toString());
                CommandData reply = this.forwardToServer(t.getLocation(), cd);
                if (Command.getReplyCode((CommandData)reply) == -1) {
                    this.writeCommand(reply);
                }
            }
        } else {
            l.append("only one topic allowed");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)203, (int)-1, (String)"only one topic");
            this.writeCommand(reply);
        }
    }

    private void handleAddQueueMsg(iIMQueue from, Message m, Destination[] d, CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Room inviteTo = null;
        boolean applyPolicy = true;
        l.append(" alert ");
        boolean isReply = false;
        if (m.getContentType().equals("net/pollreply") || m.getContentType().equals("net/reply")) {
            isReply = true;
        }
        if (m.getContentType().equals("net/invite")) {
            RoomStorage rs;
            if (!IMPolicy.canInvite(this.user) || !IMPolicy.canChat(this.user)) {
                l.append("Access Denied");
                Log.out.warning(l.toString());
                CommandData reply = Command.createReply((int)203, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
                return;
            }
            Object[] a = (Object[])m.getBody();
            if (a.length > 1 && a[1] instanceof Room && ((rs = RoomStorage.get(inviteTo = (Room)a[1])) == null || rs.isTempRoom())) {
                applyPolicy = false;
            }
        } else if (m.getContentType().equals("net/poll")) {
            if (!IMPolicy.canPoll(this.user)) {
                l.append("Access Denied");
                Log.out.warning(l.toString());
                CommandData reply = Command.createReply((int)203, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
                return;
            }
        } else if (!m.getContentType().equals("net/pollreply") && !IMPolicy.canSendAlerts(this.user)) {
            l.append("Cannot send alerts");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)203, (int)-1, (String)"Cannot send alerts");
            this.writeCommand(reply);
            return;
        }
        CommandData reply = Command.createReply((int)203, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
        HashSet<String> forward = new HashSet<String>();
        int i = 0;
        while (i < d.length) {
            iIMQueue q = (iIMQueue)d[i];
            l.append(" ");
            l.append(q.getUID());
            if (this.isLocal((Destination)q)) {
                Realm r = NMS.getRealm();
                this.sendMessage(from, q, r, isReply, applyPolicy, inviteTo, l, m);
            } else if (!this.serverConnection && this.user.getServer().equalsIgnoreCase(NMS.getName()) && !forward.contains(q.getLocation())) {
                forward.add(q.getLocation());
                reply = this.forwardToServer(q.getLocation(), cd);
            }
            ++i;
        }
        if (inviteTo != null) {
            this.archiveInviteMessage((Destination)inviteTo, m);
        } else {
            this.archiveMessage(m);
        }
        Log.out.info(l.toString());
    }

    private void sendMessage(iIMQueue from, iIMQueue q, Realm r, boolean isReply, boolean applyPolicy, Room inviteTo, StringBuffer l, Message m) {
        CommandData c2;
        NMSUser u = null;
        try {
            u = this.serverConnection ? r.getUser(q.getUID(), false) : r.getUser((iIMPrincipal)this.user, q.getUID());
        }
        catch (Exception e) {
            CommandData c2 = Command.create((int)104, (Object)from, (Object)new Integer(-2), (Object)this.res.getString("does_not_exist"), (Object)m.getMsgid(), (Object)q);
            this.writeCommand(c2);
            return;
        }
        RoomStorage rs = null;
        if (inviteTo != null) {
            rs = RoomStorage.get(inviteTo);
        }
        if (!isReply && !IMPolicy.canWatch(this.user, u.getiIMUser(), NMS.getRealm())) {
            l.append("Recipient has denied access");
            Log.out.warning(l.toString());
            c2 = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)"Recipient has denied access", (Object)m.getMsgid(), (Object)q);
        } else if (inviteTo != null && rs != null && (rs.isTempRoom() && !IMPolicy.canChat(u.getiIMUser()) || !rs.isTempRoom() && !IMPolicy.canAccessConferenceRooms(u.getiIMUser()))) {
            l.append("Recipient cannot receive invites");
            Log.out.warning(l.toString());
            c2 = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)"Recipient cannot receive invites", (Object)m.getMsgid(), (Object)q);
        } else if (!isReply && m.getContentType().equals("net/poll") && !IMPolicy.canReceivePoll(u.getiIMUser())) {
            l.append("Recipient cannot receive polls");
            Log.out.warning(l.toString());
            c2 = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)"Recipient cannot receive polls", (Object)m.getMsgid(), (Object)q);
        } else if (!isReply && m.getContentType().startsWith("net/html") && !IMPolicy.canReceiveAlerts(u.getiIMUser())) {
            l.append("Recipient cannot receive Alerts");
            Log.out.warning(l.toString());
            c2 = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)"Recipient cannot receive Alerts", (Object)m.getMsgid(), (Object)q);
        } else if (u.isLoggedOn()) {
            if (isReply) {
                c2 = Command.create((int)104, (Object)q, (Object)new Integer(3), (Object)Message.toString((Message)m), (Object)((QueueMsg)m).getCorrelationMsgId(), (Object)from);
                u.send(c2);
            }
            if (u.getUserStatus() == 3) {
                u.send(m);
                c2 = Command.create((int)104, (Object)from, (Object)new Integer(2), (Object)u.getUserStatusReason(), (Object)m.getMsgid(), (Object)q);
            } else if (inviteTo != null && applyPolicy && !DestinationAcl.check((Destination)inviteTo, u.getiIMUser(), 2)) {
                c2 = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)this.res.getString("Access_Denied"), (Object)m.getMsgid(), (Object)q);
            } else {
                Log.out.debug("Sending Alert/Invite ");
                u.send(m);
                c2 = Command.create((int)104, (Object)from, (Object)new Integer(0), (Object)this.res.getString("OK"), (Object)m.getMsgid(), (Object)q);
            }
        } else {
            Log.out.debug("Message sent to offline user " + u.getiIMUser().getUID());
            if (u.hasForwarding() && !m.getContentType().equals("net/invite")) {
                u.forward(m, this.user);
                c2 = Command.create((int)104, (Object)from, (Object)new Integer(-4), (Object)this.res.getString("User_not_logged_on"), (Object)m.getMsgid(), (Object)q);
            } else {
                c2 = Command.create((int)104, (Object)from, (Object)new Integer(-1), (Object)this.res.getString("User_not_logged_on"), (Object)m.getMsgid(), (Object)q);
            }
        }
        this.writeCommand(c2);
    }

    private void handleAddRoomMsg(iIMQueue from, Message m, Destination[] d, CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("Room ");
        CommandData reply = Command.createReply((int)203, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
        HashSet<String> forward = new HashSet<String>();
        int i = 0;
        while (i < d.length) {
            CommandData c;
            Room r = (Room)d[i];
            l.append(" ");
            l.append(r.getName());
            if (this.isLocal((Destination)r)) {
                RoomStorage store = RoomStorage.get(r);
                if (store == null) {
                    c = Command.create((int)104, (Object)from, (Object)new Integer(-1), (Object)this.res.getString("does_not_exist"), (Object)m.getMsgid(), (Object)r);
                    this.writeCommand(c);
                    l.append("room " + r.getName() + " not found");
                    Log.out.error(l.toString());
                } else if (store.getParticipantAccess(from.getUID()) < 6) {
                    c = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)this.res.getString("Access_Denied"), (Object)m.getMsgid(), (Object)r);
                    this.writeCommand(c);
                    l.append(" insufficient access (" + store.getParticipantAccess(from.getUID()) + ") to room " + r.getName());
                    Log.out.warning(l.toString());
                } else {
                    Log.out.info(l.toString());
                    c = Command.create((int)104, (Object)from, (Object)new Integer(0), (Object)"OK", (Object)m.getMsgid(), (Object)r);
                    this.writeCommand(c);
                    store.addMessage((RoomMsg)m, this);
                    if (!m.getContentType().startsWith("net/typing")) {
                        this.archiveConferenceMessage((Destination)r, m);
                    }
                }
            } else if (!forward.contains(r.getLocation())) {
                forward.add(r.getLocation());
                l.append(" forwarded to ");
                l.append(r.getLocation());
                Log.out.info(l.toString());
                reply = this.forwardToServer(r.getLocation(), cd);
                if (Command.getReplyCode((CommandData)reply) == -1) {
                    c = Command.create((int)104, (Object)from, (Object)new Integer(-3), (Object)Command.getReplyString((CommandData)reply), (Object)m.getMsgid(), (Object)r);
                    this.writeCommand(c);
                }
            }
            ++i;
        }
    }

    protected void handleAddMsg(CommandData cd) {
        Message m = (Message)cd.args[0];
        if (m.getFrom() == null) {
            m.setFrom((Destination)new iIMQueue(this.user));
        }
        iIMQueue from = !IMPolicy.isAdmin(this.user) ? (iIMQueue)m.getFrom() : new iIMQueue(this.user);
        Map attachments = m.getAttachments();
        if (!this.allow_file_transfer && attachments != null && !attachments.isEmpty()) {
            CommandData reply = Command.createReply((int)203, (int)-1, (String)"File transfer is disabled for this user");
            this.writeCommand(reply);
            Log.out.error("File transfer is disabled for: " + this.user.getUID());
            return;
        }
        try {
            int cStatus = this.convert(m);
        }
        catch (Exception e) {
            CommandData reply = Command.createReply((int)203, (int)-1, (String)("error during conversion: " + e.toString()));
            this.writeCommand(reply);
            e.printStackTrace();
            Log.out.error("error during conversion: " + e.toString());
            return;
        }
        Destination[] d = m.getTo();
        if (d == null) {
            StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
            l.append("no destinations");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)203, (int)-1, (String)this.res.getString("No_destinations"));
            this.writeCommand(reply);
            return;
        }
        if (m instanceof TopicMsg) {
            this.handleAddTopicMsg(from, m, d, cd);
        } else if (m instanceof QueueMsg) {
            this.handleAddQueueMsg(from, m, d, cd);
        } else if (m instanceof RoomMsg) {
            this.handleAddRoomMsg(from, m, d, cd);
        } else {
            StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
            CommandData reply = Command.createReply((int)203, (int)-1, (String)this.res.getString("unknown_message_type"));
            this.writeCommand(reply);
            l.append("unknown message type");
            Log.out.error(l.toString());
        }
    }

    protected void handleDelMsg(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Settings s = Settings.getSettings();
        Destination d = (Destination)cd.args[0];
        if (d instanceof Topic) {
            l.append(" topic ");
            l.append(d.getName());
            if (this.isLocal(d)) {
                if (DestinationAcl.check((Destination)((Topic)d), this.user, 14)) {
                    String msgid = (String)cd.args[1];
                    Storage store = Storage.get(d.getFQName());
                    if (store != null) {
                        if (store.deleteMessage(msgid)) {
                            CommandData reply = Command.createReply((int)204, (int)0, (String)this.res.getString("respond_ok"));
                            this.writeCommand(reply);
                        } else {
                            CommandData reply = Command.createReply((int)204, (int)-1, (String)"Message Does Not Exist");
                            this.writeCommand(reply);
                        }
                    } else {
                        CommandData reply = Command.createReply((int)204, (int)-1, (String)this.res.getString("does_not_exist"));
                        this.writeCommand(reply);
                    }
                } else {
                    l.append("access denied to " + d.getUID());
                    Log.out.warning(l.toString());
                    CommandData reply = Command.createReply((int)204, (int)-1, (String)this.res.getString("Access_Denied"));
                    this.writeCommand(reply);
                }
            } else {
                CommandData reply = this.forwardToServer(d.getLocation(), cd);
                this.writeCommand(reply);
            }
        } else if (d instanceof iIMQueue) {
            l.append(" alert/Invalid request");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)204, (int)-1, (String)this.res.getString("Invalid_request"));
            this.writeCommand(reply);
        } else if (d instanceof Room) {
            l.append(" room/Invalid request");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)204, (int)-1, (String)this.res.getString("Invalid_request1"));
            this.writeCommand(reply);
        } else {
            l.append(" unknowntype/Invalid request");
            Log.out.error(l.toString());
            CommandData reply = Command.createReply((int)204, (int)-1, (String)this.res.getString("Invalid_request2"));
            this.writeCommand(reply);
        }
    }

    protected void handleAddTopic(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Topic addTopic = (Topic)cd.args[0];
        l.append(addTopic.getName());
        l.append(" ");
        if (this.isLocal((Destination)addTopic)) {
            if (IMPolicy.canManageNews(this.user)) {
                Settings s = Settings.getSettings();
                boolean b = s.addTopic(addTopic, this.user);
                if (b) {
                    Log.out.info(l.toString());
                    CommandData reply = Command.createReply((int)206, (int)0, (String)this.res.getString("respond_ok"));
                    this.writeCommand(reply);
                    this.archiveSetup((Destination)addTopic);
                } else {
                    Log.out.error(l.toString());
                    CommandData reply = Command.createReply((int)206, (int)-1, (String)this.res.getString("Error_creating_new"));
                    this.writeCommand(reply);
                }
            } else {
                CommandData reply = Command.createReply((int)206, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
                l.append("Add/remove topic access denied");
                Log.out.warning(l.toString());
            }
        } else {
            l.append(" forwarded to ");
            l.append(addTopic.getLocation());
            Log.out.info(l.toString());
            CommandData reply = this.forwardToServer(addTopic.getLocation(), cd);
            this.writeCommand(reply);
        }
    }

    protected void handleDelTopic(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("topic ");
        Topic delTopic = (Topic)cd.args[0];
        l.append(delTopic.getName());
        l.append(" ");
        if (this.isLocal((Destination)delTopic)) {
            if (DestinationAcl.check((Destination)delTopic, this.user, 14) && IMPolicy.canManageNews(this.user)) {
                Settings s = Settings.getSettings();
                s.removeTopic(delTopic, this.user);
                CommandData reply = Command.createReply((int)207, (int)0, (String)this.res.getString("respond_ok"));
                this.writeCommand(reply);
                Log.out.info(l.toString());
                this.archiveClose((Destination)delTopic);
            } else {
                CommandData reply = Command.createReply((int)207, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
                l.append("Access_Denied");
                Log.out.info(l.toString());
            }
        } else {
            l.append("forwarded to ");
            l.append(delTopic.getLocation());
            Log.out.info(l.toString());
            CommandData reply = this.forwardToServer(delTopic.getLocation(), cd);
            this.writeCommand(reply);
        }
    }

    protected void handleAddRoom(CommandData cd) {
        CommandData reply = null;
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(" room ");
        Room newRoom = (Room)cd.args[0];
        l.append(newRoom.getName());
        Log.out.debug("handleAddRoom: called ");
        Boolean temp = (Boolean)cd.args[1];
        if (this.isLocal((Destination)newRoom)) {
            if (temp.booleanValue()) {
                Settings s = Settings.getSettings();
                boolean b = s.addRoom(newRoom, this.user, temp);
                if (b) {
                    Log.out.info(l.toString());
                    reply = Command.createReply((int)212, (int)0, (String)this.res.getString("respond_ok"));
                    this.archiveSetup((Destination)newRoom);
                } else {
                    Log.out.error(l.toString());
                    reply = Command.createReply((int)212, (int)-1, (String)this.res.getString("Error_creating_room"));
                }
            } else if (IMPolicy.canManageConferenceRooms(this.user)) {
                Log.out.debug("adding room " + newRoom.getFQName());
                Settings s = Settings.getSettings();
                boolean b = s.addRoom(newRoom, this.user, temp);
                if (b) {
                    Log.out.info(l.toString());
                    reply = Command.createReply((int)212, (int)0, (String)this.res.getString("respond_ok"));
                } else {
                    Log.out.error(l.toString());
                    reply = Command.createReply((int)212, (int)-1, (String)this.res.getString("Error_creating_room"));
                }
            } else {
                l.append(" access denied");
                Log.out.warning(l.toString());
                reply = Command.createReply((int)212, (int)-1, (String)this.res.getString("Access_Denied"));
            }
        } else {
            l.append("forwarded to ");
            l.append(newRoom.getLocation());
            Log.out.info(l.toString());
            reply = this.forwardToServer(newRoom.getLocation(), cd);
        }
        this.writeCommand(reply);
    }

    protected void handleRemoveRoom(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(" room ");
        Room delRoom = (Room)cd.args[0];
        l.append(delRoom.getUID());
        if (this.isLocal((Destination)delRoom)) {
            RoomStorage rs = RoomStorage.get(delRoom);
            if (rs == null) {
                l.append(" does not exist");
                Log.out.error(l.toString());
                CommandData reply = Command.createReply((int)213, (int)-1, (String)this.res.getString("does_not_exist"));
                this.writeCommand(reply);
                return;
            }
            if (rs.isTempRoom() || DestinationAcl.check((Destination)delRoom, this.user, 14) && IMPolicy.canManageConferenceRooms(this.user)) {
                Settings s = Settings.getSettings();
                if (rs.isTempRoom()) {
                    RoomStorage.remove(delRoom);
                } else {
                    s.removeRoom(delRoom, this.user);
                }
                Log.out.info(l.toString());
                CommandData reply = Command.createReply((int)213, (int)0, (String)this.res.getString("OK"), (Object)delRoom);
                this.writeCommand(reply);
                this.archiveClose((Destination)delRoom);
            } else {
                CommandData reply = Command.createReply((int)213, (int)-1, (String)this.res.getString("Access_Denied"));
                this.writeCommand(reply);
                l.append("no remove room priviledge");
                Log.out.warning(l.toString());
            }
        } else {
            CommandData reply = this.forwardToServer(delRoom.getLocation(), cd);
            this.writeCommand(reply);
            l.append("forwarded to " + delRoom.getLocation());
            Log.out.info(l.toString());
        }
    }

    private iIMUser[] getUsersInGroup(String groupName) throws RealmException {
        Realm r = NMS.getRealm();
        NMSGroup g = r.getGroup((iIMPrincipal)this.user, groupName);
        if (g == null) {
            throw new RealmException("group not found: " + groupName);
        }
        iIMPrincipal[] p = g.getMembers();
        if (p == null) {
            throw new RealmException("group empty: " + groupName);
        }
        Vector<iIMPrincipal> visibleUsers = new Vector<iIMPrincipal>();
        int z = 0;
        while (z < p.length) {
            if (p[z] instanceof iIMUser) {
                visibleUsers.addElement(p[z]);
            }
            ++z;
        }
        Object[] sa = new iIMUser[visibleUsers.size()];
        visibleUsers.copyInto(sa);
        return sa;
    }

    protected void handleUserSearch(CommandData cd) {
        CommandData reply2;
        String error;
        boolean byid;
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Log.out.info(l.toString());
        String server = (String)cd.args[0];
        String search = (String)cd.args[1];
        String userDomain = this.user.getServer();
        if (cd.args.length > 2) {
            Boolean t = (Boolean)cd.args[2];
            byid = t;
        } else {
            byid = true;
        }
        if (server == null || server.length() == 0 || server.equals("*")) {
            UserSearchReply searchreply;
            error = "OK";
            int errorVal = 0;
            try {
                Realm r = NMS.getRealm();
                searchreply = r.search((iIMPrincipal)this.user, search, byid, null);
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                CommandData reply2 = Command.createReply((int)226, (int)-1, (String)e.toString(), null);
                this.writeCommand(reply2);
                return;
            }
            if (userDomain.equalsIgnoreCase(NMS.getName())) {
                String[] sa = this.nms.getOutboundServers();
                int i = 0;
                while (i < sa.length) {
                    CommandData cd1 = Command.create((int)226, (Object)sa[i], (Object)search, (Object)cd.args[2]);
                    CommandData rep = this.forwardToServer(sa[i], cd1);
                    UserSearchReply usr = (UserSearchReply)Command.getReplyArg1((CommandData)rep);
                    if (usr != null) {
                        searchreply.merge(usr);
                    }
                    Log.out.warning("Added " + usr.getPrincipals().length + " users from " + sa[i]);
                    ++i;
                }
            }
            reply2 = Command.createReply((int)226, (int)errorVal, (String)error, (Object)searchreply);
        } else if (server.equalsIgnoreCase(NMS.getName())) {
            int errorVal;
            UserSearchReply searchreply;
            try {
                Realm r = NMS.getRealm();
                searchreply = r.search(r.getSearchBase(NMS.getName()), search, byid, null);
                errorVal = 0;
                error = "OK";
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                searchreply = null;
                error = e.toString();
                errorVal = -1;
            }
            reply2 = Command.createReply((int)226, (int)errorVal, (String)error, (Object)searchreply);
        } else {
            reply2 = this.forwardToServer(server, cd);
        }
        this.writeCommand(reply2);
    }

    protected void handleGetUsers(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        String userDomain = null;
        iIMUser userRequester = null;
        if (this.serverConnection) {
            userDomain = NMS.getName();
        } else {
            userDomain = this.user.getServer();
            userRequester = this.user;
        }
        Boolean b = (Boolean)cd.args[0];
        if (b.booleanValue()) {
            l.append(" list");
            Log.out.info(l.toString());
            String[] uids = (String[])cd.args[1];
            iIMUser[] sa = new iIMUser[uids.length];
            Realm r = NMS.getRealm();
            int i = 0;
            while (i < uids.length) {
                String userUID = StringUtility.appendDomainToAddress(uids[i], userDomain);
                String userServer = StringUtility.getDomainFromAddress(userUID, userDomain);
                if (this.serverConnection || userDomain.equalsIgnoreCase(userServer)) {
                    try {
                        NMSUser nmsu = null;
                        nmsu = this.serverConnection ? r.getUser(userUID) : r.getUser((iIMPrincipal)userRequester, userUID);
                        sa[i] = nmsu.getiIMUser();
                    }
                    catch (Exception e) {
                        sa[i] = null;
                    }
                } else if (userDomain.equalsIgnoreCase(NMS.getName())) {
                    String[] servers = this.nms.getOutboundServers();
                    String[] remoteuids = new String[1];
                    int j = 0;
                    while (j < servers.length) {
                        remoteuids[0] = uids[i];
                        CommandData nc = Command.create((int)208, (Object)new Boolean(true), (Object)remoteuids);
                        nc.user = cd.user;
                        CommandData reply = this.forwardToServer(servers[j], nc);
                        if (reply == null) {
                            sa[i] = null;
                        } else if (Command.getReplyCode((CommandData)reply) < 0) {
                            sa[i] = null;
                        } else {
                            iIMUser[] gotIt = (iIMUser[])Command.getReplyArg1((CommandData)reply);
                            if (gotIt[0] != null) {
                                sa[i] = gotIt[0];
                                break;
                            }
                            sa[i] = null;
                        }
                        ++j;
                    }
                } else {
                    Log.out.error("User " + this.user.getUID() + " belonging to a non-default domain contains a user" + userUID + " from another domain");
                    sa[i] = null;
                }
                ++i;
            }
            CommandData reply = Command.createReply((int)208, (int)0, (String)this.res.getString("respond_ok"), (Object)sa);
            this.writeCommand(reply);
        } else {
            String groupUID = StringUtility.appendDomainToAddress((String)cd.args[1], userDomain);
            String groupServer = StringUtility.getDomainFromAddress(groupUID, userDomain);
            l.append(" ");
            l.append(groupUID);
            l.append(" (group) ");
            if (this.serverConnection || userDomain.equalsIgnoreCase(groupServer)) {
                iIMUser[] sa;
                String groupName = StringUtility.getLocalPartFromAddress(groupUID);
                String error = this.res.getString("OK");
                int errorVal = 0;
                try {
                    sa = this.getUsersInGroup(groupName);
                    Log.out.info(l.toString());
                }
                catch (Exception e) {
                    sa = new iIMUser[]{};
                    error = e.toString();
                    errorVal = -1;
                    l.append(": " + e);
                    Log.out.warning(l.toString());
                    Log.out.printStackTrace(e);
                }
                CommandData reply = Command.createReply((int)208, (int)errorVal, (String)error, (Object)sa);
                this.writeCommand(reply);
            } else if (userDomain.equalsIgnoreCase(NMS.getName())) {
                CommandData reply = this.forwardToServer(groupServer, cd);
                this.writeCommand(reply);
                Log.out.info(l.toString());
            } else {
                Log.out.warning("error");
            }
        }
    }

    protected void handleGetAnyFromID(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        Log.out.info(l.toString());
        String[] uid = (String[])cd.args[1];
        iIMPrincipal[] sa = new iIMPrincipal[uid.length];
        Realm r = NMS.getRealm();
        int i = 0;
        while (i < uid.length) {
            String id = StringUtility.appendDomainToAddress(uid[i], NMS.getName());
            String domain = StringUtility.getDomainFromAddress(id, NMS.getName());
            sa[i] = null;
            try {
                if (domain.equalsIgnoreCase(NMS.getName())) {
                    UserSearchReply usr = r.search((iIMPrincipal)this.user, uid[i], true, null);
                    if (usr != null) {
                        sa[i] = usr.getPrincipals()[0];
                    }
                } else {
                    CommandData cd1 = Command.create((int)226, (Object)domain, (Object)uid[i], null);
                    CommandData rep = this.forwardToServer(domain, cd1);
                    UserSearchReply usr = (UserSearchReply)Command.getReplyArg1((CommandData)rep);
                    sa[i] = usr.getPrincipals()[0];
                }
            }
            catch (Exception e) {
                Log.out.warning("Search Error while looking up " + uid[i] + " : " + e.toString());
            }
            ++i;
        }
        CommandData reply = Command.createReply((int)229, (int)0, (String)this.res.getString("respond_ok"), (Object)sa);
        this.writeCommand(reply);
    }

    protected void handleGetGroupsFromID(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        String userDomain = null;
        iIMUser userRequester = null;
        if (this.serverConnection) {
            userDomain = NMS.getName();
            userRequester = null;
        } else {
            userDomain = this.user.getServer();
            userRequester = this.user;
        }
        Log.out.info(l.toString());
        String[] uids = (String[])cd.args[1];
        iIMGroup[] sa = new iIMGroup[uids.length];
        Realm r = NMS.getRealm();
        int i = 0;
        while (i < uids.length) {
            String groupUID = StringUtility.appendDomainToAddress(uids[i], userDomain);
            String groupServer = StringUtility.getDomainFromAddress(groupUID, userDomain);
            if (this.serverConnection || groupServer.equalsIgnoreCase(userDomain)) {
                try {
                    NMSGroup nmsG = r.getGroup((iIMPrincipal)userRequester, groupUID);
                    sa[i] = nmsG.getiIMGroup();
                }
                catch (Exception e) {
                    sa[i] = null;
                }
            } else if (userDomain.equalsIgnoreCase(NMS.getName())) {
                String[] servers = this.nms.getOutboundServers();
                int j = 0;
                while (j < servers.length) {
                    Object[] remoteuids = new String[]{uids[i]};
                    CommandData nc = Command.create((int)225, (Object[])remoteuids);
                    nc.user = cd.user;
                    CommandData reply = this.forwardToServer(servers[j], nc);
                    if (reply == null) {
                        sa[i] = null;
                    }
                    if (Command.getReplyCode((CommandData)reply) < 0) {
                        sa[i] = null;
                    } else {
                        iIMGroup[] gotIt = (iIMGroup[])Command.getReplyArg1((CommandData)reply);
                        if (gotIt[0] != null) {
                            sa[i] = gotIt[0];
                            break;
                        }
                        sa[i] = null;
                    }
                    ++j;
                }
            } else {
                Log.out.error("User ");
            }
            ++i;
        }
        CommandData reply = Command.createReply((int)225, (int)0, (String)this.res.getString("respond_ok"), (Object)sa);
        this.writeCommand(reply);
    }

    protected void handleGetGroups(CommandData cd) {
        CommandData reply = Command.createReply((int)209, (int)-1, (String)"Command not supported", (Object)new iIMGroup[0]);
        this.writeCommand(reply);
    }

    protected void handleSetUserStatus(CommandData cd) {
        if (!IMPolicy.canPublishPresence(this.user)) {
            CommandData reply = Command.createReply((int)224, (int)0, (String)this.res.getString("Access_Denied"));
            return;
        }
        Integer io = (Integer)cd.args[0];
        String reason = (String)cd.args[1];
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(io.toString());
        l.append(" ");
        l.append(reason);
        Log.out.info(l.toString());
        this.nmsUser.setUserStatus(io, reason);
        CommandData reply = Command.createReply((int)224, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
    }

    protected void handleWatch(CommandData cd) {
        Realm r = NMS.getRealm();
        iIMQueue[] q = (iIMQueue[])cd.args[0];
        Boolean b = (Boolean)cd.args[1];
        Integer[] curStatus = new Integer[q.length];
        Integer[] prevStatus = new Integer[q.length];
        String[] reason = new String[q.length];
        int i = 0;
        while (i < q.length) {
            block16: {
                StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
                l.append(q[i].getName());
                l.append(" ");
                if (this.isLocal((Destination)q[i])) {
                    NMSUser u;
                    try {
                        u = this.serverConnection ? r.getUser(q[i].getName(), true) : r.getUser((iIMPrincipal)this.user, q[i].getUID());
                    }
                    catch (Exception e) {
                        l.append(" does not exist");
                        Log.out.error(l.toString());
                        curStatus[i] = new Integer(-1);
                        prevStatus[i] = new Integer(-1);
                        reason[i] = "NOTFOUND";
                        break block16;
                    }
                    if (b.booleanValue()) {
                        u.addListener(this);
                        Log.out.debug("Adding user " + u.getiIMUser().getUID() + " to the " + this.user.getUID() + "  watchlist ");
                        this.watchesList.addElement(u);
                    } else {
                        u.removeListener(this);
                        this.watchesList.removeElement(this);
                    }
                    if (!IMPolicy.canWatch(this.user, u.getiIMUser(), NMS.getRealm())) {
                        l.append(" access denied ");
                        Log.out.warning(l.toString());
                        curStatus[i] = new Integer(2);
                        prevStatus[i] = new Integer(2);
                        reason[i] = this.res.getString("Offline");
                    } else {
                        curStatus[i] = new Integer(u.getUserStatus());
                        prevStatus[i] = new Integer(u.getPrevUserStatus());
                        reason[i] = u.getUserStatusReason();
                        Log.out.debug(u.getiIMUser().getUID() + ": curStatus :  " + curStatus[i] + "prevStatus:  " + prevStatus[i]);
                        Log.out.info(l.toString());
                    }
                } else if (this.belongsToDefaultDomain((iIMPrincipal)this.user)) {
                    Log.out.info(l.toString());
                    iIMQueue[] newq = new iIMQueue[]{q[i]};
                    CommandData nc = Command.create((int)210, (Object)newq, (Object)b);
                    nc.user = cd.user;
                    CommandData reply = this.forwardToServer(q[i].getLocation(), nc);
                    if (reply == null) {
                        curStatus[i] = new Integer(-1);
                        prevStatus[i] = new Integer(-1);
                        reason[i] = this.res.getString("user_does_not_exist");
                    } else if (Command.getReplyCode((CommandData)reply) < 0) {
                        curStatus[i] = new Integer(-1);
                        prevStatus[i] = new Integer(-1);
                        reason[i] = this.res.getString("user_does_not_exist");
                    } else {
                        Integer[] replyio = (Integer[])Command.getReplyArg1((CommandData)reply);
                        String[] replyreason = (String[])Command.getReplyArg2((CommandData)reply);
                        Integer[] replyprevStatus = (Integer[])Command.getReplyArg3((CommandData)reply);
                        curStatus[i] = replyio[0];
                        prevStatus[i] = replyprevStatus[0];
                        reason[i] = replyreason[0];
                        OutServerConnection sc = this.nms.getOutboundServer(q[i].getLocation());
                        if (sc != null) {
                            sc.addUserListener(this, q[i].getUID());
                        }
                    }
                } else {
                    curStatus[i] = new Integer(-1);
                    prevStatus[i] = new Integer(-1);
                    reason[i] = this.res.getString("user_does_not_exist");
                }
            }
            ++i;
        }
        CommandData reply = Command.createReply((int)210, (int)0, (String)this.res.getString("respond_ok"), (Object)curStatus, (Object)reason, (Object)prevStatus);
        this.writeCommand(reply);
    }

    protected void handleMarkRead(CommandData cd) {
        CommandData reply;
        Realm r = NMS.getRealm();
        String msgid = (String)cd.args[0];
        iIMQueue q = (iIMQueue)cd.args[1];
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(msgid);
        Log.out.info(l.toString());
        if (this.isLocal((Destination)q)) {
            NMSUser u;
            reply = Command.createReply((int)211, (int)0, (String)this.res.getString("respond_ok"));
            try {
                u = this.serverConnection ? r.getUser(q.getUID(), false) : r.getUser((iIMPrincipal)this.user, q.getUID());
            }
            catch (Exception e) {
                Log.out.warning(this.createLogString("User not found: " + q.getName()));
                return;
            }
            if (u.isLoggedOn()) {
                iIMQueue from = new iIMQueue(this.user);
                CommandData c = Command.create((int)104, (Object)q, (Object)new Integer(1), (Object)this.res.getString("Read"), (Object)msgid, (Object)from);
                u.send(c);
            } else {
                Log.out.debug("Message status sent to offline user " + q.getUID());
            }
        } else {
            reply = this.forwardToServer(q.getLocation(), cd);
        }
        this.writeCommand(reply);
    }

    protected void handleGetACL(CommandData cd) {
        CommandData reply = null;
        String type = (String)cd.args[0];
        String location = (String)cd.args[1];
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(type);
        l.append(" ");
        l.append(location);
        Log.out.info(l.toString());
        Destination d = null;
        iIMUser u = null;
        if (this.serverConnection) {
            this.user.setServer(NMS.getName());
        }
        if (this.serverConnection || location.equalsIgnoreCase(this.user.getServer())) {
            try {
                DestinationAccessControlList acl;
                if (type.equals("destination")) {
                    d = (Destination)cd.args[2];
                    acl = DestinationAcl.get(d, this.user);
                } else if (type.equals("user")) {
                    u = (iIMUser)cd.args[2];
                    acl = IMPolicy.getPresenceACL(this.user, u);
                } else {
                    reply = Command.createReply((int)214, (int)-1, (String)this.res.getString("Invalid_request3"));
                    this.writeCommand(reply);
                    return;
                }
                reply = Command.createReply((int)214, (int)0, (String)this.res.getString("respond_ok"), (Object)acl);
            }
            catch (AclException acle) {
                reply = Command.createReply((int)214, (int)-1, (String)this.res.getString("Access_Denied"));
                Log.out.warning("getACL Access denied");
            }
            catch (Exception e) {
                reply = Command.createReply((int)214, (int)-1, (String)e.toString());
                Log.out.error("Failed to getACL: " + e.toString());
            }
        } else {
            reply = this.forwardToServer(location, cd);
        }
        this.writeCommand(reply);
    }

    protected void handleSaveACL(CommandData cd) {
        CommandData reply;
        block23: {
            reply = null;
            String type = (String)cd.args[0];
            String location = (String)cd.args[1];
            Destination d = null;
            iIMUser u = null;
            Object acl = cd.args[3];
            StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
            l.append(type);
            l.append(" ");
            l.append(location);
            Log.out.info(l.toString());
            String searchBase = null;
            try {
                searchBase = NMS.getRealm().getSearchBase((iIMPrincipal)this.user);
            }
            catch (RealmException re) {
                Log.out.error("users domain is invalid:" + this.user.getUID());
                Log.out.printStackTrace(re);
                return;
            }
            if (this.serverConnection || location.equalsIgnoreCase(this.user.getServer())) {
                try {
                    if (type.equals("admin")) {
                        BooleanAcl.setAdmin((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("watch")) {
                        BooleanAcl.setWatch((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("topicsAddDel")) {
                        BooleanAcl.setTopicsAddDel((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("sendAlerts")) {
                        BooleanAcl.setSendAlerts((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("roomsAddDel")) {
                        BooleanAcl.setRoomsAddDel((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("saveUserSettings")) {
                        BooleanAcl.setSaveUserSettings((BooleanAccessControlList)acl, this.user);
                        break block23;
                    }
                    if (type.equals("destination")) {
                        d = (Destination)cd.args[2];
                        boolean destinationHasAclFile = true;
                        RoomStorage rs = null;
                        if (d instanceof Room && (rs = RoomStorage.get((Room)d)).isTempRoom()) {
                            destinationHasAclFile = false;
                        }
                        if (destinationHasAclFile) {
                            DestinationAcl.set(d, (DestinationAccessControlList)acl, this.user);
                        } else {
                            RoomStorage.updateParticipantAccess(d, (DestinationAccessControlList)acl, this.user);
                        }
                        reply = Command.createReply((int)215, (int)0, (String)this.res.getString("respond_ok"));
                        break block23;
                    }
                    if (type.equals("user")) {
                        u = (iIMUser)cd.args[2];
                        if (IMPolicy.setPresenceACL(this.user, u, (BooleanAccessControlList)acl)) {
                            Realm r = NMS.getRealm();
                            try {
                                NMSUser nmsUser = r.getUser((iIMPrincipal)this.user, u.getUID());
                                nmsUser.aclChanged((BooleanAccessControlList)acl);
                            }
                            catch (Exception e) {
                                Log.out.warning("unable to apply users changed ACL");
                            }
                            reply = Command.createReply((int)215, (int)0, (String)this.res.getString("respond_ok"));
                            break block23;
                        }
                        reply = Command.createReply((int)215, (int)-1, (String)this.res.getString("Access_Denied"));
                        Log.out.warning("set presence acl access denied for " + this.user.getUID());
                        break block23;
                    }
                    reply = Command.createReply((int)215, (int)-1, (String)this.res.getString("Invalid_request3"));
                }
                catch (AclException acle) {
                    reply = Command.createReply((int)215, (int)-1, (String)this.res.getString("Access_Denied"));
                    String dests = "";
                    if (d != null) {
                        dests = ":" + d.getName();
                    }
                    if (u != null) {
                        dests = ":" + u.getName();
                    }
                    Log.out.warning("Access denied :" + dests);
                }
                catch (Exception ioe) {
                    reply = Command.createReply((int)215, (int)-1, (String)ioe.toString());
                    Log.out.error("Failed to set ACL: " + ioe.toString());
                }
            } else {
                reply = this.forwardToServer(location, cd);
            }
        }
        this.writeCommand(reply);
    }

    protected void handleCheckACL(CommandData cd) {
        String type = (String)cd.args[0];
        String location = (String)cd.args[1];
        Destination[] d = null;
        iIMUser[] u = null;
        Integer sAccess = (Integer)cd.args[3];
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(type);
        l.append(" ");
        l.append(location);
        Log.out.info(l.toString());
        int access = 0;
        if (sAccess != null) {
            access = sAccess;
        }
        if (this.serverConnection || location.equalsIgnoreCase(this.user.getServer())) {
            int i;
            boolean[] b;
            if (type.equals("admin")) {
                b = new boolean[]{IMPolicy.isAdmin(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " adminAccess: " + b[0]);
            } else if (type.equals("watch")) {
                b = new boolean[]{IMPolicy.canWatch(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " watchAccess: " + b[0]);
            } else if (type.equals("topicsAddDel")) {
                b = new boolean[]{IMPolicy.canManageNews(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " topicsAddDelAccess: " + b[0]);
            } else if (type.equals("sendAlerts")) {
                b = new boolean[]{IMPolicy.canSendAlerts(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " sendAlertsAccess: " + b[0]);
            } else if (type.equals("roomsAddDel")) {
                b = new boolean[]{IMPolicy.canManageConferenceRooms(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + "roomsAddDelAccess: " + b[0]);
            } else if (type.equals("saveUserSettings")) {
                b = new boolean[]{IMPolicy.canChangeSettings(this.user)};
                Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " saveUserSettingsAccess: " + b[0]);
            } else if (type.equals("destination")) {
                d = (Destination[])cd.args[2];
                if (d == null) {
                    CommandData reply = Command.createReply((int)216, (int)-1, (String)this.res.getString("Empty_destination"));
                    this.writeCommand(reply);
                    return;
                }
                b = new boolean[d.length];
                i = 0;
                while (i < d.length) {
                    RoomStorage store;
                    b[i] = d[i] instanceof Topic ? DestinationAcl.check(d[i], this.user, access) : (d[i] instanceof Room ? ((store = RoomStorage.get((Room)d[i])) != null && !store.isTempRoom() ? DestinationAcl.check(d[i], this.user, access) : true) : false);
                    ++i;
                }
            } else if (type.equals("user")) {
                u = (iIMUser[])cd.args[2];
                if (u == null) {
                    CommandData reply = Command.createReply((int)216, (int)-1, (String)this.res.getString("Empty_destination"));
                    this.writeCommand(reply);
                    return;
                }
                b = new boolean[u.length];
                i = 0;
                while (i < u.length) {
                    b[i] = IMPolicy.canWatch(this.user, u[i], NMS.getRealm());
                    Log.out.debug("DEBUG: " + this.user.getUID() + ": " + " userAccess: " + b[i]);
                    ++i;
                }
            } else {
                CommandData reply = Command.createReply((int)216, (int)-1, (String)this.res.getString("Invalid_request3"));
                this.writeCommand(reply);
                return;
            }
            CommandData reply = Command.createReply((int)216, (int)0, (String)this.res.getString("respond_ok"), (Object)b);
            this.writeCommand(reply);
        } else {
            CommandData reply = this.forwardToServer(location, cd);
            this.writeCommand(reply);
        }
    }

    protected void handleGetTopics(CommandData cd) {
        CommandData reply;
        String location = (String)cd.args[0];
        String pattern = null;
        if (cd.args.length > 1) {
            pattern = (String)cd.args[1];
        }
        int access = 2;
        if (cd.args.length > 2) {
            access = (Integer)cd.args[2];
        }
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(location);
        if (location == null || location.length() == 0 || location.equals("*")) {
            Settings s = Settings.getSettings();
            Topic[] t = null;
            t = pattern != null || this.serverConnection ? s.getTopics(this.user, pattern, access, false) : RosterManager.getSubscribedTopics(this.user);
            String[] sa = this.nms.getOutboundServers();
            if (sa != null && sa.length > 0) {
                int i;
                LinkedList<Topic> list = new LinkedList<Topic>();
                if (t != null) {
                    i = 0;
                    while (i < t.length) {
                        list.add(t[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < sa.length) {
                    CommandData cd1 = Command.create((int)218, (Object)sa[i], (Object)pattern, (Object)new Integer(access));
                    CommandData rep = this.forwardToServer(sa[i], cd1);
                    t = (Topic[])Command.getReplyArg1((CommandData)rep);
                    if (t != null) {
                        i = 0;
                        while (i < t.length) {
                            list.add(t[i]);
                            ++i;
                        }
                    }
                    ++i;
                }
                i = 0;
                t = new Topic[list.size()];
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    t[i++] = (Topic)iter.next();
                }
            }
            if (t != null) {
                l.append(", found " + t.length);
            }
            reply = Command.createReply((int)218, (int)0, (String)this.res.getString("respond_ok"), (Object)t);
        } else if (location.equalsIgnoreCase(NMS.getName())) {
            Settings s = Settings.getSettings();
            Topic[] t = pattern != null || this.serverConnection ? s.getTopics(this.user, pattern, access, true) : RosterManager.getSubscribedTopics(this.user);
            if (t != null) {
                l.append(", found " + t.length);
            }
            reply = Command.createReply((int)218, (int)0, (String)this.res.getString("respond_ok"), (Object)t);
        } else {
            reply = this.forwardToServer(location, cd);
        }
        Log.out.info(l.toString());
        this.writeCommand(reply);
    }

    protected void handleGetRooms(CommandData cd) {
        CommandData reply;
        String location = (String)cd.args[0];
        Log.out.debug("handleGetRooms: location: " + location);
        String pattern = null;
        if (cd.args.length > 1) {
            pattern = (String)cd.args[1];
        }
        Log.out.debug("handleGetRooms: pattern: " + pattern);
        int access = 2;
        if (cd.args.length > 2) {
            Log.out.debug("handleGetRooms: access: " + cd.args[2]);
            access = (Integer)cd.args[2];
        }
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(location);
        Log.out.info(l.toString());
        if (location == null || location.length() == 0 || location.equals("*")) {
            String[] sa;
            String userDomain;
            Settings s = Settings.getSettings();
            Room[] r = pattern != null || this.serverConnection ? s.getRooms(this.user, pattern, access, false) : RosterManager.getSubscribedRooms(this.user, this);
            if (pattern != null && (userDomain = this.user.getServer()).equalsIgnoreCase(NMS.getName()) && (sa = this.nms.getOutboundServers()) != null && sa.length > 0) {
                int i;
                LinkedList<Room> list = new LinkedList<Room>();
                if (r != null) {
                    i = 0;
                    while (i < r.length) {
                        list.add(r[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < sa.length) {
                    CommandData cd1 = Command.create((int)217, (Object)sa[i], (Object)pattern, (Object)new Integer(access));
                    CommandData rep = this.forwardToServer(sa[i], cd1);
                    r = (Room[])Command.getReplyArg1((CommandData)rep);
                    if (r != null) {
                        i = 0;
                        while (i < r.length) {
                            list.add(r[i]);
                            ++i;
                        }
                    }
                    ++i;
                }
                r = new Room[list.size()];
                i = 0;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    r[i++] = (Room)iter.next();
                }
            }
            if (r != null) {
                Log.out.debug("handleGetRooms - returning " + r.length + " rooms.");
            } else {
                Log.out.debug("handleGetRooms - returning 0 rooms.");
            }
            reply = Command.createReply((int)217, (int)0, (String)this.res.getString("respond_ok"), (Object)r);
        } else if (location.equalsIgnoreCase(NMS.getName())) {
            Settings s = Settings.getSettings();
            Room[] r = pattern != null || this.serverConnection ? s.getRooms(this.user, pattern, access, true) : RosterManager.getSubscribedRooms(this.user, this);
            reply = Command.createReply((int)217, (int)0, (String)this.res.getString("respond_ok"), (Object)r);
        } else {
            reply = this.forwardToServer(location, cd);
        }
        this.writeCommand(reply);
    }

    protected void handleGetQueues(CommandData cd) {
        String location = (String)cd.args[0];
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(location);
        Log.out.info(l.toString());
        if (location.equalsIgnoreCase(NMS.getName())) {
            Settings s = Settings.getSettings();
            iIMQueue[] q = s.getQueues(this.user);
            CommandData reply = Command.createReply((int)219, (int)0, (String)this.res.getString("respond_ok"), (Object)q);
            this.writeCommand(reply);
        } else {
            CommandData reply = this.forwardToServer(location, cd);
            this.writeCommand(reply);
        }
    }

    protected void handleGetServers(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        if (this.serverConnection) {
            l.append("Access Denied");
            Log.out.warning(l.toString());
            CommandData reply = Command.createReply((int)220, (int)-1, (String)this.res.getString("Access_Denied"));
            this.writeCommand(reply);
        } else {
            Log.out.info(l.toString());
            String[] sa = this.nms.getOutboundServers();
            CommandData reply = Command.createReply((int)220, (int)0, (String)this.res.getString("respond_ok"), (Object)sa);
            this.writeCommand(reply);
        }
    }

    protected void handleSaveDestinationProperties(CommandData cd) {
        CommandData reply;
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append(" dest ");
        Destination d = (Destination)cd.args[0];
        l.append(d.getUID());
        if (this.isLocal(d)) {
            if (DestinationAcl.check(d, this.user, 14)) {
                Settings s = Settings.getSettings();
                try {
                    s.updateDestination(d);
                    Log.out.info(l.toString());
                    reply = Command.createReply((int)cd.command, (int)0, (String)this.res.getString("OK"));
                }
                catch (Exception e) {
                    l.append(": " + e.getMessage());
                    Log.out.warning(l.toString());
                    reply = Command.createReply((int)cd.command, (int)-1, (String)e.getMessage());
                }
            } else {
                reply = Command.createReply((int)cd.command, (int)-1, (String)this.res.getString("Access_Denied"));
                l.append("no sufficient privilege");
                Log.out.warning(l.toString());
            }
        } else {
            reply = this.forwardToServer(d.getLocation(), cd);
        }
        this.writeCommand(reply);
    }

    protected void handleHello(CommandData cd) {
        StringBuffer l = this.createLogBuffer(Command.toString((CommandData)cd));
        l.append("peer version ");
        l.append((String)cd.args[1]);
        l.append(" - protocol version ");
        String ver = (String)cd.args[2];
        String netVer = ver.charAt(0) + "." + ver.charAt(ver.length() - 1);
        this._peerVersion = Float.parseFloat(netVer);
        l.append(netVer);
        Log.out.info(l.toString());
        CommandData reply = Command.createReply((int)106, (int)0, (String)this.res.getString("respond_ok"));
        this.writeCommand(reply);
    }

    void handleSubscribe(CommandData cd, boolean remove) {
        CommandData reply;
        block12: {
            reply = null;
            iIMUser u = this.user;
            Destination d = (Destination)cd.args[0];
            if (cd.args.length > 1) {
                u = (iIMUser)cd.args[1];
            }
            if (this.user != null && u.equals((Object)this.user)) {
                u = this.user;
            }
            if (this.isLocal(d)) {
                try {
                    if (remove) {
                        RosterManager.removeSubscription(d, u);
                        reply = Command.createReply((int)cd.command, (int)0, (String)this.res.getString("respond_ok"));
                        break block12;
                    }
                    if (DestinationAcl.check(d, u, 2)) {
                        RosterManager.addSubscription(d, u);
                        reply = Command.createReply((int)cd.command, (int)0, (String)this.res.getString("respond_ok"));
                        break block12;
                    }
                    Log.out.info("Subscribe access denied for " + u.getUID() + " to " + d.getUID());
                    reply = Command.createReply((int)cd.command, (int)-1, (String)this.res.getString("Access_Denied"));
                }
                catch (Exception e) {
                    Log.out.printStackTrace(e);
                    reply = Command.createReply((int)cd.command, (int)-1, (String)e.getMessage());
                }
            } else if (this.user.getServer().equals(NMS.getName())) {
                reply = this.forwardToServer(d.getLocation(), cd);
                try {
                    if (Command.getReplyCode((CommandData)reply) == 0) {
                        RosterManager.addSubscription(d, u);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.writeCommand(reply);
    }

    public long getLastNetworkActionTime() {
        return this.lastNetworkAction.getTime();
    }

    public boolean writeCommand(CommandData cd) {
        if (cd == null) {
            Thread.dumpStack();
        }
        if (this.nmsSocket == null) {
            return false;
        }
        return this.nmsSocket.sendCommand(cd);
    }

    public void close() {
        if (this.nmsSocket == null) {
            return;
        }
        this.nmsSocket.close();
    }

    public void onClose() {
        if (this.nmsSocket == null) {
            return;
        }
        this.nmsSocket = null;
        if (this.loginType == 1) {
            Enumeration e = this.queuesStartList.elements();
            while (e.hasMoreElements()) {
                NMSUser u = (NMSUser)e.nextElement();
                u.deleteConnection(false);
            }
            this.queuesStartList.removeAllElements();
            Iterator i = this.roomsStartList.iterator();
            while (i.hasNext()) {
                String roomName = (String)i.next();
                RoomStorage rs = RoomStorage.get(roomName);
                if (rs == null) continue;
                rs.removeUser(this, false);
            }
            this.roomsStartList.clear();
            e = this.topicsStartList.elements();
            while (e.hasMoreElements()) {
                Storage s = (Storage)e.nextElement();
                s.removeListener(this);
            }
            this.topicsStartList.removeAllElements();
            e = this.watchesList.elements();
            while (e.hasMoreElements()) {
                NMSUser u = (NMSUser)e.nextElement();
                u.removeListener(this);
            }
            this.watchesList.removeAllElements();
        }
        this.nms.disconnected(this);
        if (this.archive.enabled() && this.user != null) {
            this.archive.onLogout(this.user.getUID());
        }
        StringBuffer s = this.createLogBuffer("Disconnected");
        s.append(" users(");
        s.append(this.nms.getClientConnectionCount());
        s.append(")");
        Log.out.info(s.toString());
    }

    public void onCommand(CommandData nc) {
        block43: {
            try {
                this.lastNetworkAction = LazyDate.getDate();
                if (!this.authed && nc.command != 200 && nc.command != 106) {
                    Log.out.error("unknown> issued " + Command.toString((CommandData)nc) + " without logging on first");
                    CommandData reply = Command.create((int)100, (Object)new Integer(nc.command), (Object)new Integer(-1), (Object)this.res.getString("Must_Auth_First"));
                    this.writeCommand(reply);
                    this.close();
                    return;
                }
                if (this.serverConnection) {
                    this.user = nc.user;
                }
                if (this.user != null) {
                    Log.out.debug(this.user.getUID() + ": Received " + Command.toString((CommandData)nc));
                } else {
                    Log.out.debug(this.uid + ": Received " + Command.toString((CommandData)nc));
                }
                if (!this.serverConnection && nc.command != 10 && nc.command != 106 && nc.command != 200 && !SSO.refresh(this.user)) {
                    Log.out.info("session expired: " + this.user.getUID());
                    CommandData reply = Command.create((int)100, (Object)new Integer(nc.command), (Object)new Integer(-1), (Object)"Session expired");
                    this.writeCommand(reply);
                    this.close();
                    this.authed = false;
                    return;
                }
                switch (nc.command) {
                    case 10: {
                        break;
                    }
                    case 106: {
                        this.handleHello(nc);
                        break;
                    }
                    case 200: {
                        this.handleAuth(nc);
                        break;
                    }
                    case 201: {
                        this.handleStart(nc);
                        break;
                    }
                    case 202: {
                        this.handleStop(nc);
                        break;
                    }
                    case 203: {
                        this.handleAddMsg(nc);
                        break;
                    }
                    case 204: {
                        this.handleDelMsg(nc);
                        break;
                    }
                    case 205: {
                        this.handleSaveSettings(nc);
                        break;
                    }
                    case 206: {
                        this.handleAddTopic(nc);
                        break;
                    }
                    case 207: {
                        this.handleDelTopic(nc);
                        break;
                    }
                    case 212: {
                        this.handleAddRoom(nc);
                        break;
                    }
                    case 213: {
                        this.handleRemoveRoom(nc);
                        break;
                    }
                    case 208: {
                        this.handleGetUsers(nc);
                        break;
                    }
                    case 209: {
                        this.handleGetGroups(nc);
                        break;
                    }
                    case 210: {
                        this.handleWatch(nc);
                        break;
                    }
                    case 211: {
                        this.handleMarkRead(nc);
                        break;
                    }
                    case 214: {
                        this.handleGetACL(nc);
                        break;
                    }
                    case 215: {
                        this.handleSaveACL(nc);
                        break;
                    }
                    case 216: {
                        this.handleCheckACL(nc);
                        break;
                    }
                    case 217: {
                        this.handleGetRooms(nc);
                        break;
                    }
                    case 218: {
                        this.handleGetTopics(nc);
                        break;
                    }
                    case 219: {
                        this.handleGetQueues(nc);
                        break;
                    }
                    case 220: {
                        this.handleGetServers(nc);
                        break;
                    }
                    case 221: {
                        this.handleGetSettings(nc);
                        break;
                    }
                    case 222: {
                        this.handleIsMemberOf(nc);
                        break;
                    }
                    case 301: {
                        this.handleSendGroups(nc);
                        break;
                    }
                    case 224: {
                        this.handleSetUserStatus(nc);
                        break;
                    }
                    case 225: {
                        this.handleGetGroupsFromID(nc);
                        break;
                    }
                    case 226: {
                        this.handleUserSearch(nc);
                        break;
                    }
                    case 227: {
                        this.handleSaveDestinationProperties(nc);
                        break;
                    }
                    case 228: {
                        this.handleSetArchive(nc);
                        break;
                    }
                    case 229: {
                        this.handleGetAnyFromID(nc);
                        break;
                    }
                    case 231: {
                        this.handleSubscribe(nc, false);
                        break;
                    }
                    case 232: {
                        this.handleSubscribe(nc, true);
                        break;
                    }
                    default: {
                        Log.out.error(this.createLogString("Unknown Command: " + nc.command));
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.out.error("Exception while processing " + Command.toString((CommandData)nc) + " - " + e.toString());
                Log.out.printStackTrace(e);
                if (nc == null) break block43;
                CommandData reply = Command.createReply((int)nc.command, (int)-1, (String)("Exception while processing " + e.toString()));
                this.writeCommand(reply);
            }
        }
    }

    class DelayedWriteCommand
    implements Runnable {
        CommandData cd;

        public DelayedWriteCommand(CommandData cd) {
            this.cd = cd;
        }

        public void run() {
            NMSConnection.this.writeCommand(this.cd);
        }
    }
}

