/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.resource.ServerResource;
import com.iplanet.im.server.ArchiveProviders;
import com.iplanet.im.server.CertPasswordCallback;
import com.iplanet.im.server.Counters;
import com.iplanet.im.server.DestinationAcl;
import com.iplanet.im.server.Email;
import com.iplanet.im.server.Http;
import com.iplanet.im.server.InServerConnection;
import com.iplanet.im.server.JMSManager;
import com.iplanet.im.server.LDAPRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MultiplexSocketListener;
import com.iplanet.im.server.NMSConnection;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.NMSUser;
import com.iplanet.im.server.NormalPortListener;
import com.iplanet.im.server.OutServerConnection;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RoomStorage;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.Settings;
import com.iplanet.im.server.Storage;
import com.iplanet.im.util.HTMLConverter;
import com.iplanet.im.util.LazyDate;
import com.iplanet.im.util.PlatformUtil;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.iplanet.im.util.Worker;
import com.sun.im.provider.AccessControlList;
import com.sun.im.provider.MessageConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.PasswordCallback;

public class NMS
implements Runnable {
    static SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    public static String VERSION = "6.1";
    private static final String DEFAULT_NORMAL_PORT = "9909";
    private static final String DEFAULT_SSL_PORT = "9910";
    private static final String DEFAULT_MULTIPLEX_PORT = "9999";
    private static String DEFAULT_HTTP_PORT = "9980";
    public static final String COSERVERS = "iim_server.coservers";
    public static final String IIMSERVER = "iim_server";
    public static final String HOST = "host";
    public static final String USERNAME = "serverid";
    public static final String PASSWORD = "password";
    public static final String USESSL = "usessl";
    public static final String GLOBALLOGLEVEL = "iim.log.severity";
    public static final String IIMSERVERLOGLEVEL = "iim.log.iim_server.severity";
    public static final String USE_CONVERSION = "iim_server.conversion";
    public static final String CONVERSION_PROVIDER = "iim_server.conversion.provider";
    public static final String IIMTOPLOGURL = "iim.log.url";
    public static final String IIMSERVERLOGURL = "iim.log.iim_server.url";
    public static final String INSTANCEDIR = "iim.instancedir";
    public static final String INSTANCEVARDIR = "iim.instancevardir";
    public static final String MAXLOGSIZE = "iim.log.maxlogsize";
    public static final String IIMSERVERMAXLOGSIZE = "iim.log.iim_server.maxlogsize";
    public static final String NAME = "iim_server.domainname";
    public static final String USENORMALPORT = "iim_server.useport";
    public static final String USEMUXPORT = "iim_server.usemuxport";
    public static final String USESSLPORT = "iim_server.usesslport";
    public static final String PORT = "iim_server.port";
    public static final String SSLPORT = "iim_server.sslport";
    public static final String MULTIPLEXPORT = "iim_mux.serverport";
    public static final String HTTPPORT = "iim_server.httpport";
    public static final String POLICYPREFIX = "iim.policy";
    public static final String POLICYMODULES = "modules";
    public static final String POLICYPROVIDER = "provider";
    public static final String LDAPMODULE = "iim_ldap";
    public static final String TEXTMODULE = "iim_text";
    public static final String IDMODULE = "identity";
    public static final String DEFAULTPOLICYMODULE = "iim_ldap";
    public static final String LDAPPROVIDER = "com.iplanet.im.server.LDAPRealm";
    public static final String TEXTPROVIDER = "com.iplanet.im.server.PasswordFileRealm";
    public static final String IDPROVIDER = "com.iplanet.im.server.IdentityRealm";
    public static final String TIMEOUT = "iim_server.clienttimeout";
    public static final String SERVER_TIMEOUT = "iim_server.servertimeout";
    public static final String RESYNC = "iim.policy.resynctime";
    public static final String ACLSTORE = "iim.policy.store";
    public static final String PROPSTORE = "iim.userprops.store";
    public static final String STATUSUPDATE = "iim_server.stats_frequency";
    public static final String DBDIR = "iim_server.db_path";
    public static final String NODISPLAY = "iim_server.nodisplay";
    public static final String RESOURCEBUNDLENAME = "com.iplanet.im.server.NMSBundle";
    public static final String SERVER_SECCONFIGDIR = "iim_server.secconfigdir";
    public static final String SECCONFIGDIR = "iim.secconfigdir";
    public static final String SERVER_KEYDBPREFIX = "iim_server.keydbprefix";
    public static final String KEYDBPREFIX = "iim.keydbprefix";
    public static final String SERVER_CERTDBPREFIX = "iim_server.certdbprefix";
    public static final String CERTDBPREFIX = "iim.certdbprefix";
    public static final String SERVER_SECMODFILE = "iim_server.secmodfile";
    public static final String SECMODFILE = "iim.secmodfile";
    public static final String SERVER_CERTNICKNAME = "iim_server.certnickname";
    public static final String CERTNICKNAME = "iim.certnickname";
    private static String cert_nickname = "Server-Cert";
    public static final String SERVER_KEYSTOREPASSWORDFILE = "iim_server.keystorepasswordfile";
    public static final String KEYSTOREPASSWORDFILE = "iim.keystorepasswordfile";
    public static final String SERVER_TRUST_ALL_CERT = "iim_server.trust_all_cert";
    protected MessageConverter converter;
    private Vector outServerConnections = new Vector(4);
    private Vector inUnknownConnections = new Vector(4);
    private Vector inNLClientConnections = new Vector();
    private Vector inServerConnections = new Vector(4);
    private int maxConnections;
    private static HTMLConverter htmlConverter = null;
    private String _updateURL;
    private String _httpPort;
    private boolean _useNormalPort;
    private boolean _useSSLPort;
    private static String _sslPort;
    private boolean _useMuxPort;
    private String _multiplexPort;
    private static String _port;
    private int _timeout = 900000;
    private int _server_timeout = 240000;
    private static String _name;
    private static String _configFile;
    private static String _dbDir;
    private static String _instanceDir;
    private static String _instanceVarDir;
    private static ArrayList _realms;
    private static String _resync;
    private static int _aclStore;
    private static int _propStore;
    private static String _statusUpdate;
    private Date lastUpdate;
    private boolean running = false;
    private boolean startingup = false;
    private ServerSocket serv;
    private ServerSocket sslServ;
    private ServerSocket multiplexServer;
    private DatagramSocket udp;
    private Worker worker;
    private static int _worker_count;
    private int _maxLogSize = 0x200000;
    private static NMS nms;

    public static NMS create() {
        nms = new NMS();
        return nms;
    }

    public static NMS get() {
        return nms;
    }

    public Worker getWorker() {
        return this.worker;
    }

    protected static int getAclStore() {
        return _aclStore;
    }

    protected static int getPropStore() {
        return _propStore;
    }

    public static String getName() {
        return _name;
    }

    public static String getPort() {
        return _port;
    }

    public static String getsslPort() {
        return _sslPort;
    }

    public static String getConfigDir() {
        return _instanceDir + File.separator + "config";
    }

    public static String getLogDir() {
        return _instanceVarDir + File.separator + "log";
    }

    public static String getConfigurationFile() {
        return _configFile;
    }

    public static String getDBDir() {
        return _dbDir;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void sendEmail(Message m, iIMUser originator, String to, boolean convertHtmlToText) {
        String fromS;
        iIMQueue from = (iIMQueue)m.getFrom();
        String subj = m.getSubject();
        String body = Message.toString((Message)m);
        if (convertHtmlToText) {
            try {
                body = NMS.convertHTMLtoText(body);
            }
            catch (Exception e) {
                Log.out.error(e.toString());
            }
        }
        if ((fromS = from.getMailaddr()) == null || fromS.equals("")) {
            Log.out.error("User " + from.getName() + " does not have valid email address");
            return;
        }
        Map attachments = Message.getAttachments((Message)m);
        boolean multipart = false;
        if (attachments != null) {
            multipart = true;
        }
        String personal = null;
        if (originator != null) {
            personal = originator.getDisplayName();
        }
        Email.send(fromS, personal, to, subj, body, !convertHtmlToText, multipart, attachments, m.getLangTag());
    }

    private NMS() {
        _name = null;
        _resync = "720";
        _statusUpdate = "1";
        Log.out.notice("Starting IM Server:  Version " + VERSION);
        this.worker = new Worker(_worker_count);
        this.maxConnections = Integer.MAX_VALUE;
        this.loadConfig();
        Realm.reset();
        try {
            JMSManager.initialize();
        }
        catch (Exception e) {
            Log.out.error("Failed to initialize JMS");
            Log.out.printStackTrace(e);
        }
        Counters.add(Counters.CNT_SESSIONS);
        Counters.add(Counters.CNT_MESSAGES);
        Counters.add(Counters.CNT_PRESENCE);
        Counters.add(Counters.CNT_CHAT_ROOMS);
        Counters.add(Counters.CNT_CHAT_SUBSCRIPTIONS);
    }

    public static Realm getRealm() {
        return (Realm)_realms.get(0);
    }

    public static List getRealms() {
        return _realms;
    }

    public static String getDistinguishedName(String uid) throws Exception {
        String dn;
        NMSUser u;
        Realm r = NMS.getRealm();
        if (r instanceof LDAPRealm && (u = r.getUser(uid)) != null && (dn = u.getiIMUser().getDistinguishedName()) != null) {
            return dn;
        }
        return uid;
    }

    public static void setDestinationContext(String uid, String key, Object o) {
        try {
            RoomStorage rs = RoomStorage.get(uid);
            if (rs != null) {
                rs.setContext(key, o);
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        try {
            Storage s = Storage.get(uid);
            if (s != null && s != null) {
                s.setContext(key, o);
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
    }

    public static Object getDestinationContext(String uid, String key) {
        try {
            RoomStorage rs = RoomStorage.get(uid);
            if (rs != null) {
                return rs.getContext(key);
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        try {
            Storage s = Storage.get(uid);
            if (s != null && s != null) {
                s.getContext(key);
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        return null;
    }

    public static AccessControlList getAccessControlList(String uid) {
        try {
            RoomStorage rs = RoomStorage.get(uid);
            if (rs != null) {
                if (rs.isTempRoom()) {
                    return rs.getAccessControlList();
                }
                return DestinationAcl.getAccessControlList((Destination)rs.getRoom());
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        try {
            Storage s = Storage.get(uid);
            if (s != null) {
                return DestinationAcl.getAccessControlList((Destination)s.getTopic());
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        return null;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public File rollover_logfile(File f) {
        String path = f.getPath();
        Calendar cal = Calendar.getInstance();
        String ext = "." + cal.get(13) + cal.get(12) + cal.get(10) + cal.get(5) + cal.get(2) + cal.get(1);
        File newFile = new File(path + ext);
        f.renameTo(newFile);
        return new File(path);
    }

    public void initJSS() {
        ServerConfig sc = ServerConfig.getServerConfig();
        File f = new File(_configFile);
        String confDir = f.getParent();
        if (confDir == null) {
            confDir = ".";
        }
        String secconfdir = sc.getSetting(SECCONFIGDIR, confDir);
        secconfdir = sc.getSetting(SERVER_SECCONFIGDIR, secconfdir);
        String keydbprefix = sc.getSetting(KEYDBPREFIX, "");
        keydbprefix = sc.getSetting(SERVER_KEYDBPREFIX, keydbprefix);
        String certdbprefix = sc.getSetting(CERTDBPREFIX, "");
        certdbprefix = sc.getSetting(SERVER_CERTDBPREFIX, certdbprefix);
        String secmodfile = sc.getSetting(SECMODFILE, "secmod.db");
        secmodfile = sc.getSetting(SERVER_SECMODFILE, secmodfile);
        cert_nickname = sc.getSetting(CERTNICKNAME, cert_nickname);
        cert_nickname = sc.getSetting(SERVER_CERTNICKNAME, cert_nickname);
        String passfile = sc.getSetting(KEYSTOREPASSWORDFILE, "sslpassword.conf");
        if (!(passfile = sc.getSetting(SERVER_KEYSTOREPASSWORDFILE, passfile)).startsWith(File.separator)) {
            passfile = secconfdir + File.separator + passfile;
        }
        String pass = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(passfile));
            String nextLine = pass = br.readLine();
            while (nextLine != null) {
                int colon = nextLine.indexOf(58);
                if (colon != -1) {
                    String label = nextLine.substring(0, colon);
                    if (label.toLowerCase().equals("internal (software) token")) {
                        pass = nextLine.substring(colon + 1);
                        break;
                    }
                    Log.out.info("ignore label is ssl password file: " + label);
                }
                pass = nextLine;
                nextLine = br.readLine();
            }
        }
        catch (IOException ie) {
            Log.out.error("Error reading " + passfile);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        String trust_all_cert = sc.getSetting(SERVER_TRUST_ALL_CERT, "false");
        System.setProperty("com.iplanet.im.trust_all_server_certs", trust_all_cert);
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(secconfdir, keydbprefix, certdbprefix, secmodfile);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            Log.out.info("JSS is initialized");
        }
        catch (KeyDatabaseException kdbe) {
            Log.out.error("Couldn't open the key database");
        }
        catch (CertDatabaseException cdbe) {
            Log.out.error("Couldn't open the certificate database");
        }
        catch (AlreadyInitializedException aie) {
            Log.out.error("CryptoManager already initialized");
        }
        catch (GeneralSecurityException e) {
            Log.out.error("General security exception while initializing");
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        try {
            CryptoManager cm = CryptoManager.getInstance();
            if (pass != null) {
                cm.setPasswordCallback((PasswordCallback)new CertPasswordCallback(pass));
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
    }

    public void loadConfig() {
        int tmptimeout;
        String filename;
        String s;
        ServerConfig sc = ServerConfig.getServerConfig();
        _instanceDir = sc.getSetting(INSTANCEDIR, ".");
        _instanceVarDir = sc.getSetting(INSTANCEVARDIR, ".");
        String level = sc.getSetting(IIMSERVERLOGLEVEL);
        if (level == null || level.length() == 0) {
            level = sc.getSetting(GLOBALLOGLEVEL, "ERROR");
        }
        Log.out.setLogLevel(level);
        boolean useConversion = Boolean.valueOf(sc.getSetting(USE_CONVERSION, "false"));
        if (useConversion && (s = sc.getSetting(CONVERSION_PROVIDER)) != null) {
            try {
                this.converter = (MessageConverter)Class.forName(s).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to load document converter: " + s);
            }
        }
        if ((filename = sc.getSetting(IIMSERVERLOGURL)) == null) {
            filename = sc.getSetting(IIMTOPLOGURL);
        }
        if (filename == null) {
            filename = _instanceVarDir + "/log" + File.separator + "iim_server.log";
        }
        if (!filename.equals("stdout")) {
            try {
                String sSize;
                File f = new File(filename);
                File dir = f.getParentFile();
                if (dir != null && !dir.exists()) {
                    dir.mkdirs();
                }
                if ((sSize = sc.getSetting(IIMSERVERMAXLOGSIZE)) == null) {
                    sSize = sc.getSetting(MAXLOGSIZE);
                }
                if (sSize != null) {
                    this._maxLogSize = Integer.parseInt(sSize);
                }
                if (f.exists() && f.length() > (long)this._maxLogSize) {
                    f = this.rollover_logfile(f);
                }
                PrintStream ps = new PrintStream(new FileOutputStream(filename, true));
                Log.out.setPrintStream(ps);
            }
            catch (Exception e) {
                Log.out.error("unable to create log file");
            }
        }
        _dbDir = sc.getSetting(DBDIR, _instanceVarDir + "/db");
        _resync = sc.getSetting(RESYNC, "720");
        _statusUpdate = sc.getSetting(STATUSUPDATE, "1");
        String ps = sc.getSetting(PROPSTORE, "file");
        if (ps.equalsIgnoreCase("ldap")) {
            _propStore = 1;
        }
        String t = sc.getSetting(TIMEOUT, "15");
        try {
            tmptimeout = Integer.parseInt(t);
        }
        catch (Exception e) {
            tmptimeout = 15;
        }
        if (tmptimeout < 0) {
            this._timeout = tmptimeout;
        } else {
            if (tmptimeout < 5) {
                tmptimeout = 5;
            }
            this._timeout = tmptimeout * 60 * 1000;
        }
        t = sc.getSetting(SERVER_TIMEOUT, "-1");
        try {
            tmptimeout = Integer.parseInt(t);
        }
        catch (Exception e) {
            tmptimeout = 4;
        }
        if (tmptimeout < 0) {
            this._server_timeout = tmptimeout;
        } else {
            if (tmptimeout < 3) {
                tmptimeout = 3;
            }
            this._server_timeout = tmptimeout * 60 * 1000;
        }
        this._useNormalPort = Boolean.valueOf(sc.getSetting(USENORMALPORT, "true"));
        this._useMuxPort = Boolean.valueOf(sc.getSetting(USEMUXPORT, "true"));
        boolean bl = this._useSSLPort = PlatformUtil.isJava2() ? Boolean.valueOf(sc.getSetting(USESSLPORT, "false")) : false;
        if (this._useSSLPort) {
            this.initJSS();
        }
        String tPort = sc.getSetting(PORT, DEFAULT_NORMAL_PORT);
        if (_port == null) {
            _port = tPort;
        } else if (!tPort.equals(_port)) {
            Log.out.warning(res.getString("Port_not_change"));
        }
        String tSSLPort = sc.getSetting(SSLPORT, DEFAULT_SSL_PORT);
        if (_sslPort == null) {
            _sslPort = tSSLPort;
        } else if (!tSSLPort.equals(_sslPort)) {
            Log.out.warning(res.getString("Port_not_change"));
        }
        String tMXPort = sc.getSetting(MULTIPLEXPORT, DEFAULT_MULTIPLEX_PORT);
        if (this._multiplexPort == null) {
            this._multiplexPort = tMXPort;
        } else if (!tMXPort.equals(this._multiplexPort)) {
            Log.out.warning(res.getString("Port_not_change"));
        }
        String tName = sc.getSetting(NAME, "");
        if (_name == null) {
            _name = tName.toLowerCase();
            if (_name.equals("")) {
                try {
                    InetAddress ia = InetAddress.getLocalHost();
                    _name = ia.getHostName();
                }
                catch (Exception e) {
                    _name = "localhost";
                }
            }
        } else if (!tName.equalsIgnoreCase(_name)) {
            Log.out.warning(res.getString("Server_not_change"));
        }
        _realms.clear();
        String policyModules = sc.getSetting("iim.policy.modules", "iim_ldap");
        StringTokenizer st = new StringTokenizer(policyModules, ",");
        while (st.hasMoreTokens()) {
            String policyModule = st.nextToken();
            String realmClassName = sc.getSetting("iim.policy." + policyModule + "." + POLICYPROVIDER);
            if (realmClassName == null || realmClassName.length() == 0) {
                if (policyModule.equals(TEXTMODULE)) {
                    realmClassName = TEXTPROVIDER;
                } else if (policyModule.equals(IDMODULE)) {
                    realmClassName = IDPROVIDER;
                    String as = sc.getSetting(ACLSTORE, IDMODULE);
                    _aclStore = as.equalsIgnoreCase(IDMODULE) ? 1 : 0;
                } else {
                    realmClassName = LDAPPROVIDER;
                }
            }
            Log.out.info("Realm Class Name = " + realmClassName);
            Realm r = Realm.get(realmClassName);
            if (r == null) continue;
            if (!_realms.contains(r)) {
                _realms.add(r);
            }
            Log.out.info("Loaded realm: " + realmClassName);
        }
        SSO.init();
        ArchiveProviders a = ArchiveProviders.getArchiveProvider();
        String tHttpPort = sc.getSetting(HTTPPORT, "");
        if (this._httpPort == null) {
            this._httpPort = tHttpPort;
        } else if (!tHttpPort.equals(this._httpPort)) {
            Log.out.warning(res.getString("HTTP_Port_number_will"));
        }
        Enumeration e = this.outServerConnections.elements();
        while (e.hasMoreElements()) {
            OutServerConnection s2 = (OutServerConnection)e.nextElement();
            s2.shutdown();
        }
        this.outServerConnections.removeAllElements();
        e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (in.connection == null) continue;
            in.connection.close();
        }
        this.inServerConnections.removeAllElements();
        String servers = sc.getSetting(COSERVERS, "");
        st = new StringTokenizer(servers, ",");
        while (st.hasMoreTokens()) {
            String server = st.nextToken().trim();
            InServerConnection in = new InServerConnection();
            in.name = sc.getSetting("iim_server." + server + "." + USERNAME, "");
            in.pass = sc.getSetting("iim_server." + server + "." + PASSWORD, "");
            if (in.name.length() == 0 || in.pass.length() == 0) {
                Log.out.error("Invalid or missing iim_server." + server + "." + USERNAME + " or " + IIMSERVER + "." + server + "." + PASSWORD);
            } else {
                Log.out.debug("adding inbound server " + in.name + " " + in.pass);
                this.inServerConnections.addElement(in);
            }
            String host = sc.getSetting("iim_server." + server + "." + HOST, "");
            boolean usessl = false;
            String sslstring = sc.getSetting("iim_server." + server + "." + USESSL, "false");
            if (sslstring.equalsIgnoreCase("true")) {
                usessl = true;
            }
            String username = sc.getSetting("iim_server.serverid", "");
            String password = sc.getSetting("iim_server.password", "");
            if (host.length() == 0 || username.length() == 0 || password.length() == 0) {
                Log.out.error("Invalid or missing iim_server.serverid or iim_server.password");
                continue;
            }
            Log.out.debug("Adding outbound server " + host + " " + username + " " + password);
            this.outServerConnections.addElement(new OutServerConnection(host, username, password, usessl, NMS.getName()));
        }
        boolean nodisplay = false;
        try {
            nodisplay = StringUtility.getBoolean(sc.getSetting(NODISPLAY));
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (!nodisplay) {
            htmlConverter = new HTMLConverter();
        } else {
            Log.out.warning("iim_server.nodisplay is true.  The use of HTML to text conversion will be disabled.");
        }
    }

    public static String convertHTMLtoText(String html) throws Exception {
        if (htmlConverter != null) {
            return htmlConverter.convertToText(html);
        }
        throw new Exception("iim_server.nodisplay is true. This disables HTML conversion");
    }

    protected int getClientTimeout() {
        return this._timeout;
    }

    protected int getServerTimeout() {
        return this._server_timeout;
    }

    public void setInboundServerConnection(String name, NMSConnection n, String domain) {
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (!name.equalsIgnoreCase(in.name)) continue;
            this.inUnknownConnections.removeElement(n);
            in.connection = n;
            in.domain = domain;
            Log.out.info("Server " + name + " active");
            return;
        }
    }

    public void addUnknownConnection(NMSConnection n) {
        this.inUnknownConnections.addElement(n);
    }

    public boolean addClientConnection(NMSConnection n) {
        if (this.inNLClientConnections.size() + 1 <= this.maxConnections) {
            this.inUnknownConnections.removeElement(n);
            this.inNLClientConnections.addElement(n);
            Counters.increment(Counters.CNT_SESSIONS);
            return true;
        }
        return false;
    }

    public NMSConnection getInboundConnection(String name) {
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (!name.equalsIgnoreCase(in.name)) continue;
            return in.connection;
        }
        return null;
    }

    public NMSConnection getInboundConnectionFromDomain(String domain) {
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (in.domain == null || !in.domain.equalsIgnoreCase(domain)) continue;
            return in.connection;
        }
        return null;
    }

    public NMSGroup getInboundGroup(String server, String group) {
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            NMSGroup[] ga;
            InServerConnection in = (InServerConnection)e.nextElement();
            if (!server.equalsIgnoreCase(in.name) || (ga = in.nmsGroups) == null) continue;
            int i = 0;
            while (i < ga.length) {
                if (group.equalsIgnoreCase(ga[i].getiIMGroup().getName())) {
                    return ga[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void setInboundGroups(String server, NMSGroup[] ga) {
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (!server.equalsIgnoreCase(in.name)) continue;
            in.nmsGroups = ga;
        }
    }

    public boolean authInboundServer(String name, String pass) {
        String realPass = null;
        Enumeration e = this.inServerConnections.elements();
        while (e.hasMoreElements()) {
            InServerConnection in = (InServerConnection)e.nextElement();
            if (!name.equals(in.name)) continue;
            realPass = in.pass;
            break;
        }
        if (realPass == null) {
            Log.out.warning("Inbound server " + name + " not configured.");
            return false;
        }
        if (pass.equals(realPass)) {
            Log.out.notice("Server " + name + " authenticated");
            return true;
        }
        Log.out.warning("Inbound server password mismatch: " + pass + " vs " + realPass);
        return false;
    }

    public OutServerConnection getOutboundServer(String name) {
        Enumeration e = this.outServerConnections.elements();
        while (e.hasMoreElements()) {
            OutServerConnection s = (OutServerConnection)e.nextElement();
            String othername = s.getName();
            if (othername == null || !othername.equals(name)) continue;
            return s;
        }
        return null;
    }

    public String[] getOutboundServers() {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.outServerConnections.elements();
        while (e.hasMoreElements()) {
            OutServerConnection s = (OutServerConnection)e.nextElement();
            if (!s.isConnected()) continue;
            v.addElement(s.getName());
        }
        Object[] sa = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    public CommandData forwardToServer(String serverName, CommandData cd) {
        OutServerConnection sc = nms.getOutboundServer(serverName);
        if (sc == null) {
            CommandData reply = Command.createReply((int)cd.command, (int)-1, (String)res.getString("does_not_exist"));
            return reply;
        }
        return sc.sendCommand(cd);
    }

    public CommandData forwardToServer(String serverName, CommandData cd, NMSConnection c) {
        OutServerConnection sc = nms.getOutboundServer(serverName);
        if (sc == null) {
            CommandData reply = Command.createReply((int)cd.command, (int)-1, (String)res.getString("does_not_exist"));
            return reply;
        }
        return sc.sendCommand(cd, c);
    }

    private ServerSocket getSSLServerSocket(int port, InetAddress addr) throws SocketException, IOException {
        SSLServerSocket.configServerSessionIDCache((int)0, (int)0, (int)0, null);
        int[] cipherSuites = new int[]{4, 10, 9, 3, 6, 1, 0};
        int i = 0;
        while (cipherSuites[i] != 0) {
            SSLSocket.setCipherPreference((int)cipherSuites[i], (boolean)true);
            ++i;
        }
        SSLServerSocket s = new SSLServerSocket(port, 10, addr);
        s.setServerCertNickname(cert_nickname);
        return s;
    }

    private int getPort(String addr, String defaultPort) {
        String sPort = defaultPort;
        if (addr != null) {
            int i = addr.indexOf(":");
            if (i != -1) {
                sPort = addr.substring(i + 1);
            } else if (addr.indexOf(".") == -1 && !Character.isLetter(addr.charAt(0))) {
                sPort = addr;
            }
        }
        int ret = 0;
        try {
            ret = Integer.parseInt(sPort);
        }
        catch (Exception e) {
            Log.out.error("incorrect port " + addr);
        }
        return ret;
    }

    private InetAddress getBindAddr(String addr) {
        InetAddress ret = null;
        String host = null;
        int i = addr.indexOf(":");
        if (i != -1) {
            host = addr.substring(0, i);
        } else if (addr.indexOf(".") != -1 || Character.isLetter(addr.charAt(0))) {
            host = addr;
        }
        try {
            ret = host != null ? InetAddress.getByName(host) : null;
        }
        catch (Exception e) {
            Log.out.error("Cannot resolve host " + (host == null ? "localhost" : host));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean error;
        block19: {
            block18: {
                this.running = true;
                this.startingup = true;
                error = false;
                try {
                    NormalPortListener l;
                    InetAddress in;
                    int port;
                    Settings s = Settings.getSettings();
                    if (s == null) {
                        error = true;
                        Object var6_3 = null;
                        this.startingup = false;
                        if (!error) return;
                        this.stop();
                        return;
                    }
                    Log.out.notice("IM Server (" + VERSION + ", RESOURCE:" + ServerResource.VERSION + ", NET:" + ConnectionFactory.VERSION + ")");
                    if (!(this._useNormalPort || this._useSSLPort || this._useMuxPort)) {
                        Log.out.fatal("Normal, SSL or Mux server must be selected");
                        error = true;
                        break block18;
                    }
                    if (this._useNormalPort) {
                        try {
                            port = this.getPort(_port, DEFAULT_NORMAL_PORT);
                            in = this.getBindAddr(_port);
                            Log.out.notice("starting normal server: " + (in == null ? "0.0.0.0" : in.toString()) + ":" + port);
                            this.serv = new ServerSocket(port, 10, in);
                            this.udp = new DatagramSocket(port, in);
                        }
                        catch (Exception e) {
                            Log.out.error("Failed to initialize normal port - " + e.toString());
                            this._useNormalPort = false;
                        }
                    }
                    if (this._useMuxPort) {
                        try {
                            port = this.getPort(this._multiplexPort, DEFAULT_MULTIPLEX_PORT);
                            in = this.getBindAddr(this._multiplexPort);
                            Log.out.notice("starting MultiPlex Listener: " + (in == null ? "0.0.0.0" : in.toString()) + ":" + port);
                            this.multiplexServer = new ServerSocket(port, 10, in);
                        }
                        catch (Exception e) {
                            Log.out.error("Failed to initialize normal port - " + e.toString());
                            this._useMuxPort = false;
                            Object var6_5 = null;
                            this.startingup = false;
                            if (!error) return;
                            this.stop();
                            return;
                        }
                    }
                    if (this._useSSLPort) {
                        try {
                            port = this.getPort(_sslPort, DEFAULT_SSL_PORT);
                            in = this.getBindAddr(_sslPort);
                            Log.out.notice("starting ssl port: " + (in == null ? "0.0.0.0" : in.toString()) + ":" + port);
                            this.sslServ = this.getSSLServerSocket(port, in);
                            Log.out.notice("ssl port listening: " + (in == null ? "0.0.0.0" : in.toString()) + ":" + port);
                        }
                        catch (Exception e) {
                            Log.out.error("Failed to initialize ssl port - " + e.toString());
                            this._useSSLPort = false;
                        }
                    }
                    if (this.udp != null) {
                        Thread bthread = new Thread(new Runnable(){

                            public void run() {
                                byte[] a = new byte[255];
                                while (NMS.this.running) {
                                    try {
                                        DatagramPacket in = new DatagramPacket(a, a.length);
                                        NMS.this.udp.receive(in);
                                        String req = new String(in.getData(), 0, in.getLength());
                                        if (!req.equals("WhereIsNetLertMessageServer")) continue;
                                        String ans = "HereIsNetLertMessageServer";
                                        byte[] b = ans.getBytes();
                                        DatagramPacket out = new DatagramPacket(b, b.length, in.getAddress(), in.getPort());
                                        NMS.this.udp.send(out);
                                    }
                                    catch (Exception e) {
                                        if (!NMS.this.running) continue;
                                        Log.out.error(res.getString("udp_error") + e.toString());
                                    }
                                }
                            }
                        });
                        bthread.start();
                    }
                    if (this._httpPort != null && this._httpPort.length() > 0) {
                        Thread httpThread = new Thread(new Runnable(){

                            public void run() {
                                int port = NMS.this.getPort(NMS.this._httpPort, DEFAULT_HTTP_PORT);
                                InetAddress in = NMS.this.getBindAddr(NMS.this._httpPort);
                                Http.startServ(_instanceDir + "/html", port, in);
                            }
                        });
                        httpThread.start();
                    }
                    Thread pingThread = new Thread(new Runnable(){
                        Date lastRealmResync;
                        Date lastStatusUpdate;

                        public void run() {
                            while (NMS.this.running) {
                                int minutes;
                                long now;
                                block24: {
                                    try {
                                        Thread.sleep(60000L);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    Date d = LazyDate.getDate();
                                    now = d.getTime();
                                    try {
                                        Realm rt;
                                        if (this.lastRealmResync == null) {
                                            this.lastRealmResync = LazyDate.getDate();
                                            break block24;
                                        }
                                        long last = this.lastRealmResync.getTime();
                                        try {
                                            minutes = Integer.parseInt(_resync);
                                        }
                                        catch (Exception e) {
                                            minutes = 720;
                                        }
                                        if (now - last <= (long)(minutes * 60 * 1000)) break block24;
                                        Log.out.info("Resyncing the realm");
                                        Realm realm = rt = NMS.getRealm();
                                        synchronized (realm) {
                                            rt.resync();
                                        }
                                        this.lastRealmResync = LazyDate.getDate();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    if (this.lastStatusUpdate == null) {
                                        this.lastStatusUpdate = LazyDate.getDate();
                                    }
                                    long last = this.lastStatusUpdate.getTime();
                                    try {
                                        minutes = Integer.parseInt(_statusUpdate);
                                    }
                                    catch (Exception e) {
                                        minutes = 720;
                                    }
                                    if (minutes > 0 && now - last > (long)(minutes * 60 * 1000)) {
                                        StringBuffer b = new StringBuffer("clients: ");
                                        b.append(NMS.this.inNLClientConnections.size());
                                        b.append(" inbound servers: ");
                                        int count = 0;
                                        Enumeration e = NMS.this.inServerConnections.elements();
                                        while (e.hasMoreElements()) {
                                            InServerConnection in = (InServerConnection)e.nextElement();
                                            if (in.connection == null) continue;
                                            ++count;
                                        }
                                        b.append(count);
                                        b.append("/");
                                        b.append(NMS.this.inServerConnections.size());
                                        b.append(" outbound servers: ");
                                        count = 0;
                                        e = NMS.this.outServerConnections.elements();
                                        while (e.hasMoreElements()) {
                                            OutServerConnection s = (OutServerConnection)e.nextElement();
                                            if (!s.isConnected()) continue;
                                            ++count;
                                        }
                                        b.append(count);
                                        b.append("/");
                                        b.append(NMS.this.outServerConnections.size());
                                        Log.out.info(b.toString());
                                        Counters.log(false);
                                        Counters.reset(Counters.CNT_PRESENCE);
                                        Counters.reset(Counters.CNT_MESSAGES);
                                        this.lastStatusUpdate = LazyDate.getDate();
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    if (NMS.this._server_timeout > 0) {
                                        Enumeration e = NMS.this.inServerConnections.elements();
                                        while (e.hasMoreElements()) {
                                            long l;
                                            InServerConnection nc = (InServerConnection)e.nextElement();
                                            NMSConnection n = nc.connection;
                                            if (n == null || now - (l = n.getLastNetworkActionTime()) <= (long)NMS.this._server_timeout) continue;
                                            StringBuffer b = n.createLogBuffer("shutting down inactive server connection from " + nc.name);
                                            Log.out.warning(b.toString());
                                            n.close();
                                            NMS.this.disconnected(n);
                                            nc.connection = null;
                                        }
                                    }
                                    if (NMS.this._timeout <= 0) continue;
                                    Enumeration e = NMS.this.inNLClientConnections.elements();
                                    while (e.hasMoreElements()) {
                                        NMSConnection n = (NMSConnection)e.nextElement();
                                        long l = n.getLastNetworkActionTime();
                                        if (now - l <= (long)NMS.this._timeout) continue;
                                        StringBuffer b = n.createLogBuffer("shutting down inactive connection from " + n.getUser().getUID());
                                        Log.out.warning(b.toString());
                                        n.onClose();
                                        n.close();
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    pingThread.start();
                    if (this.serv != null) {
                        l = new NormalPortListener(this.serv, this);
                        l.start();
                    }
                    if (this.sslServ != null) {
                        l = new NormalPortListener(this.sslServ, this);
                        l.start();
                    }
                    if (this.multiplexServer != null) {
                        MultiplexSocketListener ml = new MultiplexSocketListener(this.multiplexServer, this);
                        ml.start();
                    }
                    Log.out.notice("Server start completed");
                    JMSManager.start();
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.startingup = false;
                    if (!error) throw throwable;
                    this.stop();
                    throw throwable;
                }
            }
            Object var6_4 = null;
            this.startingup = false;
            if (!error) return;
            this.stop();
            return;
        }
        Object var6_6 = null;
        this.startingup = false;
        if (!error) return;
        this.stop();
    }

    public void stop() {
        while (this.startingup) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.running) {
            return;
        }
        Log.out.notice(res.getString("stoping_server"));
        this.running = false;
        JMSManager.stop();
        this.worker.stop();
        Object[] tc = new NMSConnection[this.inUnknownConnections.size()];
        this.inUnknownConnections.copyInto(tc);
        int i = 0;
        while (i < tc.length) {
            ((NMSConnection)tc[i]).close();
            ++i;
        }
        this.inUnknownConnections.removeAllElements();
        tc = new NMSConnection[this.inNLClientConnections.size()];
        this.inNLClientConnections.copyInto(tc);
        i = 0;
        while (i < tc.length) {
            ((NMSConnection)tc[i]).close();
            ++i;
        }
        this.inNLClientConnections.removeAllElements();
        Object[] oc = new OutServerConnection[this.outServerConnections.size()];
        this.outServerConnections.copyInto(oc);
        i = 0;
        while (i < oc.length) {
            ((OutServerConnection)oc[i]).shutdown();
            ++i;
        }
        this.outServerConnections.removeAllElements();
        Object[] is = new InServerConnection[this.inServerConnections.size()];
        this.inServerConnections.copyInto(is);
        i = 0;
        while (i < is.length) {
            Object nc = is[i];
            if (((InServerConnection)nc).connection != null) {
                ((InServerConnection)nc).connection.close();
            }
            ++i;
        }
        this.inServerConnections.removeAllElements();
        try {
            if (this.serv != null) {
                this.serv.close();
            }
            if (this.udp != null) {
                this.udp.close();
            }
            if (this.sslServ != null) {
                this.sslServ.close();
            }
            if (this.multiplexServer != null) {
                this.multiplexServer.close();
            }
            this.serv = null;
            this.udp = null;
            this.sslServ = null;
            this.multiplexServer = null;
        }
        catch (Exception ex) {
            System.out.println("exception closing socket");
            Log.out.printStackTrace(ex);
        }
        Http.stopServ();
        RoomStorage.removeAll();
        Storage.removeAll();
        Realm.reset();
        Settings.reset();
    }

    public void disconnected(NMSConnection n) {
        boolean b = this.inUnknownConnections.removeElement(n);
        if (!b) {
            b = this.inNLClientConnections.removeElement(n);
            if (!b) {
                Enumeration e = this.inServerConnections.elements();
                while (e.hasMoreElements()) {
                    InServerConnection nc = (InServerConnection)e.nextElement();
                    if (nc.connection != n) continue;
                    nc.connection = null;
                    Log.out.info("disconnected server " + nc.name);
                    return;
                }
                Log.out.warning("disconnected - connection not found");
            } else {
                Counters.decrement(Counters.CNT_SESSIONS);
                if (n.getUser() != null) {
                    Log.out.debug("disconnected client connection from " + n.getUser().getUID());
                } else {
                    Log.out.debug("disconnected client connection from unknown user");
                }
            }
        } else {
            Log.out.debug("disconnected unknown connection");
        }
    }

    public int getClientConnectionCount() {
        return this.inNLClientConnections.size();
    }

    private static void useage() {
        System.out.println("com.iplanet.im.server.NMS [-c configfile][-noui][-l lang country]");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean auto = false;
        Locale currentLocale = Locale.getDefault();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    _configFile = args[++i];
                    Log.out.info(res.getString("Using_Configuration") + _configFile);
                } else {
                    NMS.useage();
                }
            } else if (args[i].equals("-auto")) {
                auto = true;
            } else if (args[i].equals("-l")) {
                if (i + 2 < args.length) {
                    String language = args[++i];
                    String country = args[++i];
                    Locale newLocale = new Locale(language, country);
                    Locale.setDefault(newLocale);
                    res = new SafeResourceBundle(RESOURCEBUNDLENAME);
                } else {
                    NMS.useage();
                }
            } else if (args[i].equals("-?")) {
                NMS.useage();
            } else if (args[i].equals("-w")) {
                _worker_count = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        NMS nms = NMS.create();
        nms.run();
    }

    static {
        _configFile = "../config/iim.conf";
        _realms = new ArrayList();
        _aclStore = 0;
        _propStore = 0;
        _worker_count = 5;
    }
}

