/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.CertificateVerify;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.SSLConnectionFactory;
import com.iplanet.im.server.Email;
import com.iplanet.im.server.Log;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.TimeoutException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;

public class Monitor
implements Runnable,
SecureSessionListener {
    long period;
    String service;
    String uid = null;
    String password = null;
    String exception = null;
    boolean raiseTimeout;
    public static boolean secure = false;
    public static boolean nologin = false;

    public Monitor(long period, boolean raiseTimeout, String service, String uid, String password) {
        this.period = period > 10000L || period <= 0L ? period : 10000L;
        this.service = service;
        this.uid = uid;
        this.password = password;
        this.raiseTimeout = raiseTimeout;
    }

    public void run() {
        block10: {
            while (true) {
                block9: {
                    this.exception = null;
                    try {
                        SSLConnectionFactory cf;
                        if (this.uid != null) {
                            CollaborationSessionFactory fac = new CollaborationSessionFactory();
                            CollaborationSession s = fac.getSession(this.service, this.uid, this.password, (CollaborationSessionListener)this);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (s != null) {
                                s.logout();
                            }
                            fac.close();
                            break block9;
                        }
                        Properties props = new Properties();
                        ((Hashtable)props).put("net.nms", this.service);
                        if (secure) {
                            cf = new SSLConnectionFactory(props);
                            cf.connect(new CertificateVerify(){

                                public boolean doYouTrustCertificate(X509Certificate[] chain) {
                                    return true;
                                }
                            });
                            cf.close();
                        } else {
                            cf = new ConnectionFactory(props);
                            cf.connect();
                            cf.close();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof TimeoutException && !this.raiseTimeout) continue;
                        StringWriter w = new StringWriter();
                        PrintWriter writer = new PrintWriter((Writer)w, true);
                        e.printStackTrace(writer);
                        this.exception = w.toString();
                        break block10;
                    }
                }
                if (this.period <= 0L) break;
            }
            return;
        }
    }

    public String getException() {
        return this.exception;
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return true;
    }

    public void onError(CollaborationException e) {
    }

    public static void usage() {
        System.out.println("Usage: java com.iplanet.im.server.Monitor [options]");
        System.out.println("Options:");
        System.out.println("  --help|-h       // prints help");
        System.out.println("  --ssl           // use SSL");
        System.out.println("  --raisetimeout  // do not ignore timeout exceptions");
        System.out.println("  --server|-s <host:port>");
        System.out.println("  --mail|-m <valid email address for alerts>");
        System.out.println("  --time|-t <sampling period in seconds. default=120>");
        System.out.println("  --factory|-f <session provider class>");
        System.out.println("  --nologin       // connect only - no auth");
    }

    public static void main(String[] arg) {
        try {
            long period = 120000L;
            String service = null;
            String mail = null;
            boolean raiseTimeout = false;
            Log.out.setLogLevel(0);
            System.setProperty("com.sun.im.service.CollaborationSessionFactory", "com.iplanet.im.client.api.iIMSecondarySessionFactory");
            int i = 0;
            while (i < arg.length) {
                if (arg[i].equalsIgnoreCase("--factory")) {
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", arg[++i]);
                } else if (arg[i].equalsIgnoreCase("--mail") || arg[i].equalsIgnoreCase("-m")) {
                    mail = arg[++i];
                } else if (arg[i].equalsIgnoreCase("--raisetimeout")) {
                    raiseTimeout = true;
                } else if (arg[i].equalsIgnoreCase("--ssl")) {
                    secure = true;
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", "com.iplanet.im.client.api.iIMSecureSecondarySessionFactory");
                } else if (arg[i].equalsIgnoreCase("--nologin")) {
                    nologin = true;
                } else if (arg[i].equalsIgnoreCase("--help") || arg[i].equalsIgnoreCase("-h")) {
                    Monitor.usage();
                    System.exit(0);
                } else if (arg[i].equalsIgnoreCase("--debug") || arg[i].equalsIgnoreCase("-d")) {
                    System.setProperty("com.iplanet.im.client.api.debug", "true");
                    Log.out.setLogLevel(5);
                } else if (arg[i].equalsIgnoreCase("--time") || arg[i].equalsIgnoreCase("-t")) {
                    period = Long.parseLong(arg[++i]) * 1000L;
                } else if (arg[i].equalsIgnoreCase("--server") || arg[i].equalsIgnoreCase("-s")) {
                    service = arg[++i];
                }
                ++i;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            if (service == null) {
                System.out.print("IM server/port: ");
                service = reader.readLine();
            }
            String user = null;
            String password = null;
            if (!nologin) {
                System.out.print("login: ");
                user = reader.readLine();
                System.out.print("password: ");
                password = reader.readLine();
            }
            String host = "localhost";
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ne) {
                // empty catch block
            }
            String from = System.getProperty("user.name") + "@" + host;
            while (true) {
                Monitor monitor = new Monitor(period, raiseTimeout, service, user, password);
                Thread t = new Thread(monitor);
                t.start();
                t.join();
                if (mail != null && monitor.getException() != null) {
                    System.out.println("Monitor has returned - send alert email to " + mail);
                    Email.send(from, "IM Server Monitor", mail, "IM server outage: " + service, monitor.getException(), false, null);
                }
                if (period > 0L) continue;
                if (monitor.getException() != null) {
                    System.out.println(monitor.getException());
                    System.exit(-1);
                    continue;
                }
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

