/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.util.LazyDate;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;

public class Log {
    public static final int FATAL_ERROR = 0;
    public static final int ERROR = 1;
    public static final int NOTICE = 2;
    public static final int WARNING = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public String[] desc = new String[]{"FATAL", "ERROR", "NOTICE", "WARNING", "INFO", "DEBUG"};
    public static Log out = new Log();
    int logLevel = 1;
    PrintStream os;
    Calendar calendar = Calendar.getInstance();
    String[] shortMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public Log() {
        this.os = System.out;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public void setLogLevel(String level) {
        int i = 0;
        while (i < this.desc.length) {
            if (this.desc[i].equalsIgnoreCase(level)) {
                this.logLevel = i;
                return;
            }
            ++i;
        }
        this.error("unknown log level " + level);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setPrintStream(PrintStream ps) {
        this.os = ps;
    }

    private void addDate(Date d, StringBuffer sbuf) {
        this.calendar.setTime(d);
        int day = this.calendar.get(5);
        if (day < 10) {
            sbuf.append('0');
        }
        sbuf.append(day);
        sbuf.append('/');
        sbuf.append(this.shortMonths[this.calendar.get(2)]);
        sbuf.append('/');
        int year = this.calendar.get(1);
        sbuf.append(year);
        sbuf.append(':');
        int hour = this.calendar.get(11);
        if (hour < 10) {
            sbuf.append('0');
        }
        sbuf.append(hour);
        sbuf.append(':');
        int mins = this.calendar.get(12);
        if (mins < 10) {
            sbuf.append('0');
        }
        sbuf.append(mins);
        sbuf.append(':');
        int secs = this.calendar.get(13);
        if (secs < 10) {
            sbuf.append('0');
        }
        sbuf.append(secs);
        sbuf.append(' ');
        int minutes = (this.calendar.get(15) + this.calendar.get(16)) / 1000 / 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        if (hours > 0) {
            sbuf.append("+");
        } else {
            sbuf.append("-");
        }
        hours = Math.abs(hours);
        if (hours < 10) {
            sbuf.append('0');
        }
        sbuf.append(hours);
        minutes = Math.abs(minutes);
        if (minutes < 10) {
            sbuf.append('0');
        }
        sbuf.append(minutes);
    }

    private void println(int level, String msg) {
        Date d = LazyDate.getDate();
        StringBuffer out = new StringBuffer("[");
        this.addDate(d, out);
        out.append("] ");
        out.append(this.desc[level]);
        out.append(": ");
        out.append(msg);
        String print = out.toString();
        this.os.println(print);
    }

    public void printStackTrace(Exception e) {
        if (this.logLevel >= 5) {
            e.printStackTrace(this.os);
        }
    }

    public void debug(String msg) {
        if (this.logLevel >= 5) {
            this.println(5, msg);
        }
    }

    public void notice(String msg) {
        if (this.logLevel >= 2) {
            this.println(2, msg);
        }
    }

    public void error(String msg) {
        if (this.logLevel >= 1) {
            this.println(1, msg);
        }
    }

    public void fatal(String msg) {
        if (this.logLevel >= 0) {
            this.println(0, msg);
        }
    }

    public void warning(String msg) {
        if (this.logLevel >= 3) {
            this.println(3, msg);
        }
    }

    public void info(String msg) {
        if (this.logLevel >= 4) {
            this.println(4, msg);
        }
    }
}

