/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.HostPort;
import com.iplanet.im.util.StringUtility;
import com.sun.im.identity.util.Auth;
import com.sun.im.xmpp.RosterDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import org.xml.sax.SAXException;

public class LDAPUserSettings
extends UserSettings {
    static final String PROPERTIES_ATTRIBUTE = "sunimuserproperties";
    public static final String DYNAMIC_PROPERTIES_ATTRIBUTE = "sunimproperties";
    static final String DEFAULTACL_ATTRIBUTE = "sunpresenceentitydefaultaccess";
    static final String ALLOWACL_ATTRIBUTE = "sunpresenceentityaccesspermitted";
    static final String DENYACL_ATTRIBUTE = "sunpresenceentityaccessdenied";
    static final String DYNAMIC_DEFAULTACL_ATTRIBUTE = "sunpresencedefaultaccess";
    static final String DYNAMIC_ALLOWACL_ATTRIBUTE = "sunpresenceaccesspermitted";
    static final String DYNAMIC_DENYACL_ATTRIBUTE = "sunpresenceaccessdenied";
    static final String ROSTER_ATTRIBUTE = "sunimuserroster";
    static final String CONFERENCE_ROSTER_ATTRIBUTE = "sunimuserconferenceroster";
    static final String NEWS_ROSTER_ATTRIBUTE = "sunimusernewsroster";
    static final String DYNAMIC_ROSTER_ATTRIBUTE = "sunimroster";
    static final String DYNAMIC_CONFERENCE_ROSTER_ATTRIBUTE = "sunimconferenceroster";
    static final String DYNAMIC_NEWS_ROSTER_ATTRIBUTE = "sunimnewsroster";
    static final String GROUP_MARKER = "g:";

    protected Properties getUserProperties(iIMUser u) {
        try {
            iIMUser user = NMS.getRealm().getUser(u.getUID()).getiIMUser();
            return this.getMergedProperties(user.getSingleStringValue(PROPERTIES_ATTRIBUTE), user.getSingleStringValue(DYNAMIC_PROPERTIES_ATTRIBUTE));
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.error("[LDAPUserSettings] Failed to load properties for " + u.getUID() + " - " + e.toString());
            return null;
        }
    }

    private Properties getProperties(String val) throws Exception {
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(val.getBytes()));
        return p;
    }

    private Properties getMergedProperties(String val, String dval) throws Exception {
        if (val == null) {
            if (dval != null) {
                return this.getProperties(dval);
            }
            return new Properties();
        }
        Properties p = this.getProperties(val);
        if (dval == null) {
            return p;
        }
        Properties dp = this.getProperties(dval);
        ((Hashtable)p).putAll(dp);
        return p;
    }

    protected void saveUserProperties(Properties newProps, iIMUser u, boolean merge) throws Exception {
        Properties p = newProps;
        if (merge) {
            p = this.mergeProperties(this.getUserProperties(u), newProps);
        }
        Log.out.debug("[LDAPUserSettings] saveUserProperties");
        HashMap m = new HashMap();
        HashSet<String> v = new HashSet<String>();
        ByteArrayOutputStream t = new ByteArrayOutputStream();
        p.store(t, u.getDisplayName());
        String sp = t.toString();
        v.add(sp);
        m.put(PROPERTIES_ATTRIBUTE, v);
        this.saveUserAttributes(m, u);
        u.setAttribute(PROPERTIES_ATTRIBUTE, v);
        iIMUser user = NMS.getRealm().getUser(u.getUID()).getiIMUser();
        user.setAttribute(PROPERTIES_ATTRIBUTE, v);
    }

    protected void saveUserAttributes(Map m, iIMUser u) throws LDAPException {
        Set _changableAttrs = (Set)m.get("changableAttrs");
        String userDN = (String)m.get("dn");
        if (userDN == null || userDN.equals("")) {
            String entryDN;
            userDN = entryDN = u.getSingleStringValue("dn");
        }
        Log.out.debug("[LDAPUserSettings] for " + u.getUID() + " aka " + userDN);
        LDAPModificationSet mods = new LDAPModificationSet();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String attr = (String)i.next();
            Object o = m.get(attr);
            u.setAttribute(attr, o);
            if (_changableAttrs != null && !_changableAttrs.contains(attr)) continue;
            LDAPAttribute changeAttr = new LDAPAttribute(attr);
            if (o instanceof Set) {
                Set vals = (Set)o;
                if (vals != null && vals.size() > 0) {
                    Iterator j = vals.iterator();
                    while (j.hasNext()) {
                        String val = (String)j.next();
                        changeAttr.addValue(val);
                    }
                }
            } else if (o instanceof String) {
                String val = (String)o;
                changeAttr.addValue(val);
            }
            mods.add(2, changeAttr);
        }
        LDAPConnection ld = this.getLDAPConnection();
        ld.modify(userDN, mods);
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException e) {
                // empty catch block
            }
        }
    }

    private LDAPConnection getLDAPConnection() throws LDAPException {
        ServerConfig sc = ServerConfig.getServerConfig();
        String ldapServer = sc.getSetting("iim_ldap.host", "");
        HostPort hp = new HostPort(ldapServer, 389);
        LDAPConnection ld = null;
        ld = new LDAPConnection();
        ld.connect(3, hp.getHostName(), hp.getPort(), Auth.getAdminDN(), Auth.getAdminPassword());
        return ld;
    }

    protected BooleanAccessControlList getPresenceACL(iIMUser u) throws IOException {
        Set principals;
        BooleanAccessControlList l = new BooleanAccessControlList();
        iIMUser user = null;
        try {
            user = NMS.getRealm().getUser(u.getUID()).getiIMUser();
        }
        catch (Exception e) {
            user = u;
        }
        boolean canManage = IMPolicy.canManagePresenceACL(user);
        Log.out.debug("getPresenceACL - canManagePresenceACL : " + canManage);
        String val = this.getMergedAccess(user.getSingleStringValue(DEFAULTACL_ATTRIBUTE), user.getSingleStringValue(DYNAMIC_DEFAULTACL_ATTRIBUTE), canManage);
        if (val != null && !val.equals("") && !StringUtility.getBoolean(val)) {
            Log.out.debug("getPresenceACL for " + u.getUID() + " : default is false");
            l.setDefault(false);
            principals = this.getMergedAccessList(user.getValueSet(ALLOWACL_ATTRIBUTE), user.getValueSet(DYNAMIC_ALLOWACL_ATTRIBUTE), canManage);
            Log.out.debug("getPresenceACL: principals - " + principals);
        } else {
            Log.out.debug("getPresenceACL for " + u.getUID() + " : default is true");
            l.setDefault(true);
            principals = this.getMergedAccessList(user.getValueSet(DENYACL_ATTRIBUTE), user.getValueSet(DYNAMIC_DENYACL_ATTRIBUTE), canManage);
            Log.out.debug("getPresenceACL for " + u.getUID() + " : principals - " + principals);
        }
        if (principals != null && principals.size() > 0) {
            Iterator i = principals.iterator();
            while (i.hasNext()) {
                try {
                    iIMGroup p;
                    String uid = (String)i.next();
                    if (uid.startsWith(GROUP_MARKER)) {
                        p = new iIMGroup(uid.substring(GROUP_MARKER.length()), null, null);
                        l.add((iIMPrincipal)p);
                        continue;
                    }
                    if (uid.length() <= 0) continue;
                    p = new iIMUser(StringUtility.getLocalPartFromAddress(uid), StringUtility.getDomainFromAddress(uid, NMS.getName()), StringUtility.getLocalPartFromAddress(uid));
                    l.add((iIMPrincipal)p);
                }
                catch (Exception e) {
                    Log.out.error("[getPresenceACL] failed: " + e.getMessage());
                }
            }
        }
        return l;
    }

    private String getMergedAccess(String val, String dval, boolean canManage) {
        Log.out.debug("getMergedAccess " + val + " / " + dval);
        if (dval == null || dval.equals("") || canManage) {
            return val;
        }
        return dval;
    }

    private Set getMergedAccessList(Set val, Set dval, boolean canManage) {
        Log.out.debug("getMergedAccessList " + val + " / " + dval);
        if (canManage) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        if (dval != null) {
            val.addAll(dval);
        }
        return val;
    }

    protected void savePresenceACL(iIMUser user, BooleanAccessControlList l) throws Exception {
        HashMap m = new HashMap();
        boolean defaultAccess = l.getDefault();
        HashSet<String> u = new HashSet<String>();
        u.add(defaultAccess ? "true" : "false");
        user.setAttribute(DEFAULTACL_ATTRIBUTE, u);
        m.put(DEFAULTACL_ATTRIBUTE, u);
        HashSet<String> v = new HashSet<String>();
        Enumeration enumeration = l.entries();
        while (enumeration.hasMoreElements()) {
            iIMPrincipal p = (iIMPrincipal)enumeration.nextElement();
            if (p instanceof iIMGroup) {
                v.add(GROUP_MARKER + p.getUID());
                continue;
            }
            v.add(p.getUID());
        }
        if (defaultAccess && v.size() > 0) {
            m.put(DENYACL_ATTRIBUTE, v);
            user.setAttribute(DENYACL_ATTRIBUTE, v);
        } else {
            m.put(ALLOWACL_ATTRIBUTE, v);
            user.setAttribute(ALLOWACL_ATTRIBUTE, v);
        }
        this.saveUserAttributes(m, user);
    }

    private RosterDocument getRoster(String xml) throws Exception {
        try {
            return new RosterDocument(xml);
        }
        catch (SAXException spe) {
            Log.out.printStackTrace(spe);
            Log.out.error("Removing corrupted roster value: " + xml);
            return new RosterDocument();
        }
    }

    private RosterDocument getMergedRoster(String val, String dval) throws Exception {
        Log.out.debug("getMergedRoster " + val + " / " + dval);
        if (val == null) {
            if (dval != null) {
                return this.getRoster(dval);
            }
            return new RosterDocument();
        }
        RosterDocument roster = this.getRoster(val);
        if (dval == null) {
            return roster;
        }
        RosterDocument droster = this.getRoster(dval);
        roster.merge(droster);
        return roster;
    }

    protected RosterDocument getRoster(iIMUser user) throws Exception {
        return this.getMergedRoster(user.getSingleStringValue(ROSTER_ATTRIBUTE), user.getSingleStringValue(DYNAMIC_ROSTER_ATTRIBUTE));
    }

    protected void saveRoster(iIMUser user, RosterDocument roster) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ROSTER_ATTRIBUTE, roster.toString());
        this.saveUserAttributes(m, user);
    }

    protected RosterDocument getConferenceRoster(iIMUser user) throws Exception {
        return this.getMergedRoster(user.getSingleStringValue(CONFERENCE_ROSTER_ATTRIBUTE), user.getSingleStringValue(DYNAMIC_CONFERENCE_ROSTER_ATTRIBUTE));
    }

    protected void saveConferenceRoster(iIMUser user, RosterDocument roster) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(CONFERENCE_ROSTER_ATTRIBUTE, roster.toString());
        this.saveUserAttributes(m, user);
    }

    protected RosterDocument getNewsRoster(iIMUser user) throws Exception {
        return this.getMergedRoster(user.getSingleStringValue(NEWS_ROSTER_ATTRIBUTE), user.getSingleStringValue(DYNAMIC_NEWS_ROSTER_ATTRIBUTE));
    }

    protected void saveNewsRoster(iIMUser user, RosterDocument roster) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(NEWS_ROSTER_ATTRIBUTE, roster.toString());
        this.saveUserAttributes(m, user);
    }
}

