/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.BooleanAcl;
import com.iplanet.im.server.IdentityRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.util.StringUtility;
import java.util.Set;

public class IMPolicy {
    static boolean idsvr = NMS.getAclStore() == 1;
    static UserSettings us = UserSettings.get();

    private static boolean getBooleanPolicy(iIMUser user, String attribute, boolean defaultVal) {
        if (IMPolicy.isAdmin(user)) {
            return true;
        }
        String val = user.getSingleStringValue(attribute);
        boolean b = defaultVal;
        if (val != null) {
            try {
                b = StringUtility.getBoolean(val);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return b;
    }

    static boolean canSendAlerts(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowAlertsSend", true);
        }
        return BooleanAcl.checkSendAlerts(u);
    }

    static boolean canChat(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowChat", true);
        }
        return true;
    }

    static boolean canAccessConferenceRooms(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowForumAccess", true);
        }
        return true;
    }

    static boolean canManageConferenceRooms(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowForumManage", false);
        }
        return BooleanAcl.checkRoomsAddDel(u);
    }

    static boolean canModerate(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowForumModerate", true);
        }
        return true;
    }

    static boolean canReceiveAlerts(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowAlertsAccess", true);
        }
        return true;
    }

    static boolean canReceivePoll(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowPollingAccess", true);
        }
        return true;
    }

    static boolean canAccessNews(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowNewsAccess", true);
        }
        return true;
    }

    static boolean canManageNews(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowNewsManage", false);
        }
        return BooleanAcl.checkTopicsAddDel(u);
    }

    static boolean canManageRoster(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowContactListManage", true);
        }
        return BooleanAcl.checkSaveUserSettings(u);
    }

    static boolean canChangeSettings(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowUserSettings", true);
        }
        return BooleanAcl.checkSaveUserSettings(u);
    }

    static boolean canPoll(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowPollingSend", true);
        }
        return true;
    }

    static boolean canInvite(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowChatInvite", true);
        }
        return true;
    }

    static boolean canWatch(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunPresenceAllowAccess", true);
        }
        return BooleanAcl.checkWatch(u);
    }

    static boolean canManagePresenceACL(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunPresenceAllowManage", true);
        }
        return BooleanAcl.checkSaveUserSettings(u);
    }

    static boolean canTransferFiles(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunIMAllowFileTransfer", true);
        }
        return true;
    }

    static boolean canPublishPresence(iIMUser u) {
        if (idsvr) {
            return IMPolicy.getBooleanPolicy(u, "sunPresenceAllowPublish", true);
        }
        return true;
    }

    static boolean isAdmin(iIMUser u) {
        if (idsvr) {
            try {
                Set userRoles = ((IdentityRealm)NMS.getRealm()).getUserRoles(u);
                if (userRoles == null) {
                    return false;
                }
                return userRoles.contains(IdentityRealm._IMAdminRoleDN);
            }
            catch (Exception e) {
                Log.out.debug("isAdmin(): exception - " + e.getMessage());
                return false;
            }
        }
        return BooleanAcl.checkAdmin(u);
    }

    static BooleanAccessControlList getPresenceACL(iIMUser u, iIMUser by) throws Exception {
        if (u.equals((Object)by) || IMPolicy.isAdmin(by)) {
            BooleanAccessControlList l = us.getPresenceACL(u);
            if (l == null) {
                l = new BooleanAccessControlList();
                l.setDefault(true);
            }
            return l;
        }
        return null;
    }

    static boolean setPresenceACL(iIMUser u, iIMUser by, BooleanAccessControlList l) throws Exception {
        if (u.equals((Object)by) || IMPolicy.isAdmin(by)) {
            us.savePresenceACL(u, l);
            return true;
        }
        return false;
    }

    static boolean canWatch(iIMUser watcher, iIMUser target, Realm realm) {
        if (watcher.equals((Object)target) || IMPolicy.isAdmin(watcher)) {
            return true;
        }
        try {
            BooleanAccessControlList bacl = us.getPresenceACL(target);
            return bacl == null || bacl.getAccess((iIMPrincipal)watcher, (iIMRealm)realm);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            Log.out.error("Failed to read presence ACL: " + e.toString());
            return false;
        }
    }

    private static void printPolicyAttribute(iIMUser u, String name) {
        String val = u.getSingleStringValue(name);
        Log.out.debug("[IMPolicy] " + name + "=" + val);
    }

    static void print(iIMUser u) {
        IMPolicy.printPolicyAttribute(u, "sunIMllowAlertOnly");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowChat");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumModerate");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowAlertsSend");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowAlertsAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowNewsAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowNewsManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowContactListManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowUserSettings");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowPollingSend");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowPollingAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowChatInvite");
        IMPolicy.printPolicyAttribute(u, "sunPresenceAllowAccess");
        IMPolicy.printPolicyAttribute(u, "sunPresenceAllowManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowFileTransfer");
    }
}

