/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.ArchiveData;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.Timer;
import com.iplanet.im.util.FileUtility;
import com.iplanet.im.util.HtmlUtility;
import com.iplanet.im.util.StringUtility;
import com.sun.im.provider.AccessControlItem;
import com.sun.im.provider.AccessControlList;
import com.sun.im.provider.ArchiveProvider;
import com.sun.im.provider.NewsArchiveProvider;
import com.sun.im.provider.PollArchiveProvider;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.ReadOnlyMessagePart;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IMPSArchive
extends ArchiveProvider
implements PollArchiveProvider,
NewsArchiveProvider {
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat _dayFormat = new SimpleDateFormat("[yyyy/MM/dd]");
    private static final String NAME_SEPARATOR = ", ";
    private static final String PROVIDER_KEY = "impsarch";
    private static final int JOIN = 1;
    private static final int CLOSE = 2;
    private static final int LEFT = 3;
    private static final int OPEN = 4;
    private static final int MESSAGE = 5;
    private static final int LOGIN = 6;
    private static final int LOGOUT = 7;
    private static String DESCRIPTION;
    private static String FULLTEXT;
    private static String TITLE;
    private static String KEYWORDS;
    private static String READACL;
    private static String ADMIN;
    private static String CLASSIFICATION;
    private static String DATABASE;
    public static String CATEGORYNAME;
    public static String ALERT_CATEGORYNAME;
    public static String CHAT_CATEGORYNAME;
    public static String CONFERENCE_CATEGORYNAME;
    public static String POLL_CATEGORYNAME;
    public static String NEWS_CATEGORYNAME;
    public static long SUBMIT_TIMER;
    public static long QUIET_TIME;
    public static long MAX_WAIT_TIME;
    public static boolean ARCHIVE_ALERT;
    public static boolean ARCHIVE_CHAT;
    public static boolean ARCHIVE_CONFERENCE;
    public static boolean ARCHIVE_POLL;
    public static boolean ARCHIVE_NEWS;
    public static boolean ADMIN_ONLY;
    public static boolean IGNORE_EXPLICIT_DENY;
    public static boolean TEST;
    public static PrintStream psTest;
    static Hashtable htArchiveData;
    static LinkedList removeaclList;
    static LinkedList deleteList;
    public static String SEARCH_SERVLET;
    public static String SUBMIT_SERVLET;
    private static String SUBMIT_SERVLET_URL;
    private static final String GET = "get";
    private static final String REMOVE_ACL = "removeacl";
    private static final String DELETE = "delete";
    private static final String RUN_RDMGR = "runrdmgr";
    private static final String CGI_URL = "cgiurl";
    private static final String TIMESTAMP = "TIMESTAMP-";
    private static String BOUNDARY;
    private static boolean SUCCESSFUL_SUBMISSION;
    private static Object lock;
    private static String BACKUP_FILE;
    private static String BACKUP_FILE_TMP;
    private static String ADMIN_DN;
    private static String ADMIN_PASSWORD;

    public IMPSArchive() {
        this._dateFormat = new SimpleDateFormat("HH:mm:ss");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized List callServlet(List soifList, String op) {
        LinkedList<SOIF> retList = new LinkedList<SOIF>();
        try {
            try {
                SOIF s;
                SOIF hdr;
                URL url = new URL(SUBMIT_SERVLET_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                FilterOutputStream outStream = null;
                if (soifList != null) {
                    SOIF soif;
                    SOIFOutputStream sos = new SOIFOutputStream(conn.getOutputStream());
                    conn.connect();
                    hdr = new SOIF("RDMHEADER", "-");
                    hdr.insert("rdm-type", "rd-submit-request");
                    if (!ADMIN_DN.equals("") && !ADMIN_PASSWORD.equals("")) {
                        hdr.insert("rdm-user", ADMIN_DN);
                        hdr.insert("rdm-password", ADMIN_PASSWORD);
                    }
                    if (!DATABASE.equals("")) {
                        hdr.insert("submit-database", DATABASE);
                    }
                    sos.write(hdr);
                    Log.out.info("[IMPSArchive] Written " + hdr);
                    SOIF req = new SOIF("Request", "-");
                    req.insert("submit-type", "nonpersistent");
                    if (op != null && op.equals(DELETE)) {
                        req.insert("submit-operation", DELETE);
                    } else {
                        req.insert("submit-operation", "update");
                    }
                    sos.write(req);
                    Log.out.info("[IMPSArchive] Written " + req);
                    if (!SUCCESSFUL_SUBMISSION && BACKUP_FILE != null) {
                        Log.out.info("[IMPSArchive] Submitting the data from backup file " + BACKUP_FILE);
                        SOIFInputStream sis = new SOIFInputStream(BACKUP_FILE_TMP);
                        while ((soif = sis.readSOIF()) != null) {
                            void var10_12;
                            sos.write((SOIF)var10_12);
                            Log.out.info("[IMPSArchive] Written " + var10_12);
                        }
                    } else {
                        Iterator iter = soifList.iterator();
                        while (iter.hasNext()) {
                            soif = (SOIF)iter.next();
                            sos.write(soif);
                            Log.out.info("[IMPSArchive] Written " + soif);
                        }
                    }
                    sos.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                outStream = null;
                SOIFInputStream sis = new SOIFInputStream(conn.getInputStream());
                while ((s = sis.readSOIF()) != null) {
                    File f;
                    if (hdr.getSchemaName().equalsIgnoreCase("RDMHEADER") && hdr.contains("rdm-error-message")) {
                        Log.out.error("[IMPSArchive] Submit RD failed");
                        SUCCESSFUL_SUBMISSION = false;
                        if (BACKUP_FILE == null) return null;
                        IMPSArchive.restoreBackup();
                        return null;
                    }
                    SUCCESSFUL_SUBMISSION = true;
                    if (BACKUP_FILE != null && (f = new File(BACKUP_FILE_TMP)).exists()) {
                        f.delete();
                    }
                    retList.add(hdr);
                }
                sis.close();
                return retList;
            }
            catch (ConnectException e) {
                Log.out.printStackTrace(e);
                SUCCESSFUL_SUBMISSION = false;
                IMPSArchive.restoreBackup();
                return retList;
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                SUCCESSFUL_SUBMISSION = false;
                IMPSArchive.restoreBackup();
                return retList;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            throw throwable;
        }
    }

    public static synchronized void submitRD() {
        long StartTime;
        block19: {
            Object os = null;
            StartTime = System.currentTimeMillis();
            LinkedList<SOIF> soifList = new LinkedList<SOIF>();
            Vector<String> v = new Vector<String>();
            try {
                Enumeration e = htArchiveData.keys();
                while (e.hasMoreElements()) {
                    SOIF soif;
                    String key = (String)e.nextElement();
                    ArchiveData ad = (ArchiveData)htArchiveData.get(key);
                    if (ad.TYPE == 1 && !ARCHIVE_CHAT || ad.TYPE == 2 && !ARCHIVE_CONFERENCE) continue;
                    if (!ad.dirty && ad.TYPE == 3 && System.currentTimeMillis() - ad.startTime > MAX_WAIT_TIME) {
                        htArchiveData.remove(ad.id.substring(5));
                        Log.out.info("[IMPSArchive] Removing the Poll data from the global buffer");
                    }
                    if (!ad.dirty) continue;
                    if (!(ADMIN_ONLY || ad.TYPE != 1 && ad.TYPE != 0 || ad.readacl.size() != 0)) {
                        htArchiveData.remove(key);
                        continue;
                    }
                    if (ad.remove) {
                        ad.full_text.append("<center>");
                        if (ad.back != null) {
                            ad.full_text.append("<a href=");
                            ad.full_text.append(ad.back);
                            ad.full_text.append("> ");
                            ad.full_text.append("%back%");
                            ad.full_text.append("</a>");
                        }
                        if (ad.next != null) {
                            ad.full_text.append("<a href=");
                            ad.full_text.append(ad.next);
                            ad.full_text.append("> ");
                            ad.full_text.append("%next%");
                            ad.full_text.append("</a>");
                        }
                        ad.full_text.append("</center>");
                    }
                    if ((soif = IMPSArchive.toSOIF(ad)) == null) continue;
                    soifList.add(soif);
                    IMPSArchive.backup(soif);
                    v.add(key);
                }
                if (soifList.isEmpty()) break block19;
                Object object = lock;
                synchronized (object) {
                    if (BACKUP_FILE != null) {
                        byte[] b = FileUtility.readByte(BACKUP_FILE);
                        BACKUP_FILE_TMP = File.createTempFile("soif", null).getAbsolutePath();
                        FileUtility.writeByte(BACKUP_FILE_TMP, b, false);
                        new File(BACKUP_FILE).delete();
                    }
                }
                IMPSArchive.callServlet(soifList, null);
                if (SUCCESSFUL_SUBMISSION) {
                    int i = 0;
                    while (i < v.size()) {
                        String id = (String)v.get(i);
                        ArchiveData temp = (ArchiveData)htArchiveData.get(id);
                        temp.dirty = false;
                        if (temp.remove) {
                            htArchiveData.remove(id);
                        }
                        ++i;
                    }
                }
                if (removeaclList.size() > 0) {
                    Log.out.debug("[IMPSArchive] Calling servlet with removeacl command");
                    IMPSArchive.callServlet(removeaclList, REMOVE_ACL);
                    if (SUCCESSFUL_SUBMISSION) {
                        removeaclList = new LinkedList();
                    }
                }
                if (deleteList.size() > 0) {
                    Log.out.debug("[IMPSArchive] Calling servlet with delete command");
                    IMPSArchive.callServlet(deleteList, DELETE);
                    if (SUCCESSFUL_SUBMISSION) {
                        removeaclList = new LinkedList();
                    }
                }
            }
            catch (Exception e) {
                Log.out.warning("[IMPSArchive] Failed to archive message " + e);
                Log.out.printStackTrace(e);
            }
        }
        Log.out.info("[IMPSArchive] Total time required for submitting RD's is " + (System.currentTimeMillis() - StartTime) + " msec");
    }

    private void readConfig() {
        ServerConfig sc = ServerConfig.getServerConfig();
        DESCRIPTION = sc.getSetting("iim_arch.description.attr", "Description");
        FULLTEXT = sc.getSetting("iim_arch.full-text.attr", "Full-Text");
        KEYWORDS = sc.getSetting("iim_arch.keywords.attr", "Keywords");
        TITLE = sc.getSetting("iim_arch.title.attr", "Title");
        READACL = sc.getSetting("iim_arch.readacl.attr", "ReadACL");
        ADMIN = sc.getSetting("iim_arch.readacl.admin", "");
        try {
            ADMIN_ONLY = StringUtility.getBoolean(sc.getSetting("iim_arch.readacl.adminonly", "false"));
        }
        catch (IllegalArgumentException e) {
            Log.out.error("[IMPSArchive] iim_arch.readacl.adminonly contains invalid value");
        }
        try {
            IGNORE_EXPLICIT_DENY = StringUtility.getBoolean(sc.getSetting("iim_arch.ignoreexplicitdeny", "false"));
        }
        catch (IllegalArgumentException e) {
            Log.out.error("[IMPSArchive] iim_arch.ignoreexplicitdeny contains invalid value");
        }
        String categories = sc.getSetting("iim_arch.categories", "");
        if (!categories.equals("")) {
            ARCHIVE_ALERT = false;
            ARCHIVE_CHAT = false;
            ARCHIVE_POLL = false;
            ARCHIVE_CONFERENCE = false;
            ARCHIVE_NEWS = false;
            StringTokenizer st = new StringTokenizer(categories, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("alert")) {
                    ARCHIVE_ALERT = true;
                    continue;
                }
                if (token.equalsIgnoreCase("chat")) {
                    ARCHIVE_CHAT = true;
                    continue;
                }
                if (token.equalsIgnoreCase("conference")) {
                    ARCHIVE_CONFERENCE = true;
                    continue;
                }
                if (token.equalsIgnoreCase("news")) {
                    ARCHIVE_NEWS = true;
                    continue;
                }
                if (token.equalsIgnoreCase("poll")) {
                    ARCHIVE_POLL = true;
                    continue;
                }
                Log.out.error("[IMPSArchive] iim_arch.categories contains invalid value");
            }
        }
        CLASSIFICATION = sc.getSetting("iim_arch.category.attr", "Classification");
        CATEGORYNAME = sc.getSetting("iim_arch.categoryname", "");
        ALERT_CATEGORYNAME = sc.getSetting("iim_arch.alert.categoryname", CATEGORYNAME);
        CHAT_CATEGORYNAME = sc.getSetting("iim_arch.chat.categoryname", CATEGORYNAME);
        CONFERENCE_CATEGORYNAME = sc.getSetting("iim_arch.conference.categoryname", CATEGORYNAME);
        POLL_CATEGORYNAME = sc.getSetting("iim_arch.poll.categoryname", CATEGORYNAME);
        NEWS_CATEGORYNAME = sc.getSetting("iim_arch.news.categoryname", CATEGORYNAME);
        QUIET_TIME = Long.parseLong(sc.getSetting("iim_arch.conference.quiettime", "10")) * 60L * 1000L;
        MAX_WAIT_TIME = Long.parseLong(sc.getSetting("iim_arch.poll.maxwaittime", "10")) * 60L * 1000L;
        if (MAX_WAIT_TIME < (SUBMIT_TIMER = Long.parseLong(sc.getSetting("iim_arch.submit_timer", "120")) * 1000L)) {
            Log.out.notice("[IMPSArchive] iim_arch.poll.maxwaittime should be greater  than (iim_arch.submit_timer. Resetting the value to " + (SUBMIT_TIMER / 1000L + 1L) + " sec.");
            MAX_WAIT_TIME = SUBMIT_TIMER + 1000L;
        }
        if ((SUBMIT_SERVLET_URL = sc.getSetting("iim_arch.portal.search", "")).equals("")) {
            String protocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
            String host = SystemProperties.get((String)"com.iplanet.am.server.host");
            String port = SystemProperties.get((String)"com.iplanet.am.server.port");
            String uri = sc.getSetting("iim_arch.portal.deployuri", "/portal");
            SUBMIT_SERVLET_URL = protocol + "://" + host + ":" + port + uri + "/" + SUBMIT_SERVLET;
        }
        ADMIN_DN = sc.getSetting("iim_arch.portal.admindn", "");
        ADMIN_PASSWORD = sc.getSetting("iim_arch.portal.adminpassword", "");
        DATABASE = sc.getSetting("iim_arch.portal.search.database", "");
        String provider = sc.getSetting("iim_arch.portal.channelname", "IMChannel");
        if (!provider.equals("IMChannel")) {
            SEARCH_SERVLET = "dt?provider=" + provider + "&display=true&last=false";
        }
        try {
            TEST = StringUtility.getBoolean(sc.getSetting("iim_arch.test", "false"));
        }
        catch (IllegalArgumentException e) {
            Log.out.error("[IMPSArchive] iim_arch.test contains invalid value");
        }
        BACKUP_FILE = sc.getSetting("iim_arch.backup_file", "");
        if (BACKUP_FILE.equals("")) {
            BACKUP_FILE = null;
        } else {
            SUCCESSFUL_SUBMISSION = !new File(BACKUP_FILE).exists();
        }
        String test_file = sc.getSetting("iim_arch.test_file", "");
        if (!test_file.equals("")) {
            try {
                psTest = new PrintStream(new FileOutputStream(test_file, true));
            }
            catch (FileNotFoundException e) {
                Log.out.info("[IMPSArchive] Test file not found");
                psTest = System.out;
            }
        }
    }

    private String getDisplayName(String uid) {
        iIMUser u = null;
        try {
            String userUID = StringUtility.getLocalPartFromAddress(uid);
            String userDomain = StringUtility.getDomainFromAddress(uid, NMS.getName());
            Realm r = NMS.getRealm();
            String searchBase = r.getSearchBase(userDomain);
            u = NMS.getRealm()._getiIMUser(searchBase, uid);
            if (u == null) {
                return uid;
            }
        }
        catch (RealmException e) {
            Log.out.printStackTrace(e);
        }
        return u.getDisplayName();
    }

    private String removeHTML(String str) {
        try {
            return NMS.convertHTMLtoText(str);
        }
        catch (Exception e) {
            Log.out.error(e.toString());
            return str;
        }
    }

    private StringBuffer removeTags(String str) {
        str = this.removeHTML(str);
        StringBuffer ret = new StringBuffer();
        boolean found = false;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%' && i < str.length() - 1) {
                if (str.charAt(i + 1) != '%') {
                    if (found) {
                        found = false;
                        ++i;
                    } else {
                        found = true;
                    }
                } else {
                    ret.append(str.charAt(++i));
                }
            }
            if (!found) {
                ret.append(str.charAt(i));
            }
            ++i;
        }
        return ret;
    }

    private static String expandMacro(String macro) {
        char[] source = macro.toCharArray();
        StringBuffer dest = new StringBuffer();
        int i = 0;
        boolean j = false;
        while (i < source.length) {
            if (source[i] != '%') {
                dest.append(source[i]);
            } else {
                if (++i >= source.length) break;
                char ch = source[i];
                switch (ch) {
                    case '%': {
                        dest.append('%');
                        break;
                    }
                    case 'Y': 
                    case 'y': {
                        dest.append(Calendar.getInstance().get(1));
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        dest.append(Calendar.getInstance().get(2) + 1);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        dest.append(Calendar.getInstance().get(5));
                        break;
                    }
                    default: {
                        dest.append("%");
                        dest.append(ch);
                    }
                }
            }
            ++i;
        }
        return dest.toString();
    }

    private String addEscapeChar(String str) {
        return StringUtility.replaceString("%", "%%", str);
    }

    private String getDN(String uid) {
        try {
            return NMS.getDistinguishedName(uid);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            return uid;
        }
    }

    private ArchiveData getArchiveData(String address, int type) {
        return this.getArchiveData(address, type, true);
    }

    private ArchiveData getArchiveData(String address, int type, boolean create) {
        if (address == null) {
            return null;
        }
        ArchiveData ad = (ArchiveData)htArchiveData.get(address);
        if (ad == null) {
            if (create) {
                ad = new ArchiveData(address, type);
                htArchiveData.put(address, ad);
            } else {
                return null;
            }
        }
        return ad;
    }

    private void setReadacl(String address, ArchiveData ad) {
        try {
            ad.deny_access = false;
            AccessControlList acl = NMS.getAccessControlList(address);
            if (acl == null) {
                return;
            }
            int def = acl.getDefaultAccess();
            if (def != 1) {
                Enumeration e = acl.getAccessControlItems();
                while (e.hasMoreElements()) {
                    AccessControlItem a = (AccessControlItem)e.nextElement();
                    if (a.access != 1) continue;
                    if (IGNORE_EXPLICIT_DENY) {
                        Log.out.warning("[IMPSArchive] An RD with explicit deny access to " + a.subjectDistinguishedName + " has been added");
                        continue;
                    }
                    Log.out.warning("[IMPSArchive] Messages to room " + address + " will not be added");
                    ad.deny_access = true;
                }
            } else {
                Enumeration e = acl.getAccessControlItems();
                while (e.hasMoreElements()) {
                    AccessControlItem a = (AccessControlItem)e.nextElement();
                    if (a.access == 1 || ad.readacl.contains(a.subjectDistinguishedName)) continue;
                    ad.readacl.add(a.subjectDistinguishedName);
                    Log.out.debug("[IMPSArchive] Adding " + a.subjectDistinguishedName + " to ReadAcl list for " + address);
                }
            }
        }
        catch (Exception e) {
            Log.out.error("[IMPSArchive] " + e.toString());
        }
    }

    private void submitMessage(ReadOnlyMessage message, ArchiveData ad) {
        this.submitMessage(message, ad, null);
    }

    private void submitMessage(ReadOnlyMessage message, ArchiveData ad, List accessList) {
        Date date = new Date();
        ad.title.append(this._dayFormat.format(date));
        ad.title.append(" ");
        ad.title.append(message.getHeader("subject"));
        ad.title.append(" [");
        ad.title.append(this.getDisplayName(message.getOriginator()));
        ad.title.append("]");
        StringBuffer ret = new StringBuffer("%{0}");
        ret.append(this.addEscapeChar(this.getDisplayName(message.getOriginator())));
        this.addNonHTMLText(ad, this.getDisplayName(message.getOriginator()));
        ret.append("{0}from%");
        ret.append("<br>");
        if (!ADMIN_ONLY && ad.TYPE == 0 && accessList == null) {
            ad.readacl.add(this.getDN(message.getOriginator()));
        }
        try {
            if (accessList == null && !ADMIN_ONLY && ad.TYPE == 0) {
                ad.readacl.add(this.getDN(message.getOriginator()));
            }
            String[] to = message.getRecipients();
            ret.append("%{0}");
            int i = 0;
            while (i < to.length) {
                ret.append(this.addEscapeChar(this.getDisplayName(to[i])));
                this.addNonHTMLText(ad, this.getDisplayName(to[i]));
                if (accessList == null && !ADMIN_ONLY) {
                    if (ad.TYPE == 0) {
                        ad.readacl.add(this.getDN(to[i]));
                    } else {
                        this.setReadacl(to[i], ad);
                    }
                }
                ret.append(this.addEscapeChar(NAME_SEPARATOR));
                ++i;
            }
            if (accessList != null && !ADMIN_ONLY && ad.TYPE == 0) {
                Iterator i2 = accessList.iterator();
                while (i2.hasNext()) {
                    ad.readacl.add(this.getDN((String)i2.next()));
                }
            }
            int nsLength = this.addEscapeChar(NAME_SEPARATOR).length();
            ret.delete(ret.length() - nsLength, ret.length());
            ret.append("{0}to%");
            ret.append("<br>");
            ret.append("%subject%");
            ret.append(HtmlUtility.escape(this.addEscapeChar(message.getHeader("subject"))));
            this.addNonHTMLText(ad, message.getHeader("subject"));
            ret.append("<br>");
            ret.append("%{0}");
            ret.append(TIMESTAMP);
            ret.append(date.getTime());
            ret.append("{0}date%");
            ret.append("<br>");
            String message_content = this.appendMessageContent(message);
            ret.append(message_content);
            this.addNonHTMLText(ad, this.removeHTML(message_content));
            this.addHTMLText(ad, ret.toString());
            ad.dirty = true;
            ad.remove = true;
            IMPSArchive.backup(ad);
        }
        catch (Exception e) {
            Log.out.warning("[IMPSArchive] Failed to archive message " + e);
            Log.out.printStackTrace(e);
        }
    }

    private void writeMessage(ReadOnlyMessage message, ArchiveData ad) {
        if (ad.deny_access) {
            return;
        }
        if (ad.renew_access || System.currentTimeMillis() - ad.lastModified > QUIET_TIME && ad.has_data) {
            ad = this.createNextRD(ad, ad.address);
            this.setReadacl(ad.address, ad);
            Log.out.info("[IMPSArchive] A new RD created for conference " + ad.address);
            if (ad.TYPE == 1) {
                this.updateUserACL(ad);
            }
        }
        try {
            Date date = new Date();
            StringBuffer ret = new StringBuffer("");
            ret.append("<span class=eventTimestamp>");
            ret.append(this.addEscapeChar(this.getDisplayName(message.getOriginator())));
            this.addNonHTMLText(ad, this.getDisplayName(message.getOriginator()));
            ret.append(" ");
            ret.append(this._dateFormat.format(date));
            ret.append("</span>");
            String message_content = this.appendMessageContent(message);
            ret.append(message_content);
            this.addNonHTMLText(ad, this.removeHTML(message_content.trim()));
            this.addHTMLText(ad, ret.toString());
            ad.has_data = true;
            ad.dirty = true;
            ad.lastModified = System.currentTimeMillis();
            IMPSArchive.backup(ad);
        }
        catch (Exception e) {
            Log.out.warning("[IMPSArchive] Failed to archive message " + e);
            Log.out.printStackTrace(e);
        }
    }

    private void writeConferenceEvent(String conferenceAddress, int type, String uid) {
        ArchiveData ad = this.getArchiveData(conferenceAddress, 2, true);
        Date date = new Date();
        try {
            StringBuffer ret = new StringBuffer();
            if (uid != null) {
                ret.append("<span class=eventTimestamp>");
                ret.append(this._dateFormat.format(date));
                ret.append("</span>");
                ret.append("%{0}");
                ret.append(this.addEscapeChar(this.getDisplayName(uid)));
                this.addNonHTMLText(ad, this.getDisplayName(uid));
                ret.append("{0}");
            }
            switch (type) {
                case 1: {
                    ret.append("has_joined_the_room%");
                    if (ad.numParticipants < 2) {
                        ad.has_data = false;
                    }
                    ++ad.numParticipants;
                    break;
                }
                case 3: {
                    ret.append("has_left_the_room%");
                    --ad.numParticipants;
                    if (ad.numParticipants < 2) {
                        ad.has_data = false;
                    }
                    if (ARCHIVE_CONFERENCE || ad.TYPE != 2 || ad.numParticipants != 0) break;
                    htArchiveData.remove(conferenceAddress);
                    return;
                }
                case 2: {
                    ret.append("has_closed_the_room%");
                    if (ARCHIVE_CHAT) break;
                    htArchiveData.remove(conferenceAddress);
                    return;
                }
                case 4: {
                    ret.append("has_opened_the_room%");
                    if (ad == null) break;
                    ad.TYPE = 1;
                    ad.category = CHAT_CATEGORYNAME;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    ret.append("has_logged_in%");
                    break;
                }
                case 7: {
                    ret.append("has_logged_out%");
                    break;
                }
                default: {
                    ret.append("unknown%");
                }
            }
            if (ad != null) {
                if (!ARCHIVE_CHAT && ad.TYPE == 1) {
                    return;
                }
                if (!ARCHIVE_CONFERENCE && ad.TYPE == 2) {
                    return;
                }
                String displayName = this.getDisplayName(uid);
                if (ad.title.toString().indexOf(displayName) < 0) {
                    if (ad.title.length() > 0) {
                        ad.title.append(NAME_SEPARATOR);
                        ad.title.append(displayName);
                    } else {
                        ad.title = new StringBuffer(this._dayFormat.format(date));
                        ad.title.append(" ");
                        ad.title.append(displayName);
                    }
                }
                ad.full_text.append(ret.toString());
                ad.full_text.append("<br>");
                ad.dirty = true;
                if (!ADMIN_ONLY) {
                    Hashtable<String, Hashtable<String, LinkedList>> userACL;
                    if (type == 1 && ad.TYPE == 1) {
                        if (ad.has_data) {
                            Log.out.info("[IMPSArchive] " + uid + " joining existing conference " + conferenceAddress);
                            ad = this.createNextRD(ad, conferenceAddress);
                            this.setReadacl(conferenceAddress, ad);
                            userACL = this.updateUserACL(ad);
                        } else {
                            Log.out.info("[IMPSArchive] " + uid + " joining blank conference " + conferenceAddress);
                            userACL = (Map)NMS.getDestinationContext(conferenceAddress, PROVIDER_KEY);
                            if (userACL == null) {
                                Log.out.info("[IMPSArchive] No hashtable found for conference" + conferenceAddress);
                                userACL = new Hashtable<String, Hashtable<String, LinkedList>>();
                                NMS.setDestinationContext(conferenceAddress, PROVIDER_KEY, userACL);
                            }
                            if (!ad.readacl.contains(this.getDN(uid))) {
                                ad.readacl.add(this.getDN(uid));
                            }
                        }
                        Hashtable<String, LinkedList> rdAcl = new Hashtable<String, LinkedList>();
                        rdAcl.put(ad.id, ad.readacl);
                        userACL.put(uid, rdAcl);
                    }
                    if (type == 3 && ad.TYPE == 1) {
                        IMPSArchive.submitRD();
                        userACL = (Hashtable<String, Hashtable<String, LinkedList>>)NMS.getDestinationContext(conferenceAddress, PROVIDER_KEY);
                        Log.out.info("[IMPSArchive] RD's for user " + this.getDisplayName(uid) + " is " + userACL.get(uid));
                        boolean doArchive = false;
                        AccessControlList acl = null;
                        acl = NMS.getAccessControlList(conferenceAddress);
                        if (acl != null) {
                            Enumeration e = acl.getAccessControlItems();
                            while (e.hasMoreElements()) {
                                AccessControlItem aci = (AccessControlItem)e.nextElement();
                                if (!aci.subjectDistinguishedName.equals(this.getDN(uid))) continue;
                                doArchive = true;
                                break;
                            }
                        }
                        if (doArchive) {
                            Log.out.info("[IMPSArchive] Archiving for user " + uid + " is enabled");
                            if (userACL.size() > 2) {
                                ad.renew_access = true;
                            }
                        } else {
                            Log.out.info("[IMPSArchive] Archiving for user " + uid + " is disabled");
                            this.removeacl((Hashtable)userACL.get(uid), this.getDN(uid));
                        }
                        userACL.remove(uid);
                    }
                }
                if (type == 2) {
                    ad.remove = true;
                }
                IMPSArchive.backup(ad);
            }
        }
        catch (Exception e) {
            Log.out.warning("[IMPSArchive] Failed to archive conference event " + e);
            Log.out.printStackTrace(e);
        }
    }

    public void onConferenceMessage(String conferenceAddress, ReadOnlyMessage message) {
        ArchiveData ad = (ArchiveData)htArchiveData.get(conferenceAddress);
        if (ad.TYPE == 1 && !ARCHIVE_CHAT) {
            return;
        }
        if (ad.TYPE == 2 && !ARCHIVE_CONFERENCE) {
            return;
        }
        this.writeMessage(message, (ArchiveData)htArchiveData.get(conferenceAddress));
    }

    public void onSetup(String conferenceAddress, String uid) {
        this.writeConferenceEvent(conferenceAddress, 4, uid);
    }

    public void open() throws Exception {
        this.readConfig();
        Timer t = new Timer();
        t.start();
    }

    public void onLogin(String uid) {
    }

    public void onJoin(String conferenceAddress, String uid) {
        this.writeConferenceEvent(conferenceAddress, 1, uid);
    }

    public void onMessage(ReadOnlyMessage message) {
        if (!ARCHIVE_ALERT) {
            return;
        }
        ArchiveData ad = this.getArchiveData(message.getMessageId(), 0);
        this.submitMessage(message, ad);
    }

    public void onMessage(List accessList, ReadOnlyMessage message) {
        if (!ARCHIVE_ALERT) {
            return;
        }
        ArchiveData ad = this.getArchiveData(message.getMessageId(), 0);
        this.submitMessage(message, ad, accessList);
    }

    public void onLogout(String uid) {
    }

    public void close() {
    }

    public void onClose(String conferenceAddress, String uid) {
        this.writeConferenceEvent(conferenceAddress, 2, uid);
    }

    public void onLeave(String conferenceAddress, String uid) {
        this.writeConferenceEvent(conferenceAddress, 3, uid);
    }

    public void onInvite(String conferenceAddress, ReadOnlyMessage message) {
    }

    public void onNewsMessage(String addr, ReadOnlyMessage message) {
        if (!ARCHIVE_NEWS) {
            return;
        }
        ArchiveData ad = this.getArchiveData(message.getMessageId(), 4);
        this.submitMessage(message, ad);
    }

    public void onSubscribe(String addr, String uid) {
    }

    public void onUnsubscribe(String addr, String uid) {
    }

    public void newPoll(String originator, Poll pollData) {
        if (!ARCHIVE_POLL) {
            return;
        }
        if (ADMIN.length() < 1 && pollData.getAccess().equals("none")) {
            return;
        }
        ArchiveData ad = this.getArchiveData(pollData.getPollID(), 3, false);
        Log.out.debug("[IMPSArchive] new poll: id=" + pollData.getPollID() + " question=" + pollData.getQuestion());
        if (ad != null) {
            return;
        }
        ad = this.getArchiveData(pollData.getPollID(), 3, true);
        Date date = new Date();
        StringBuffer ret = new StringBuffer("");
        ret.append("%poll_question%");
        ret.append("<br>");
        ret.append(HtmlUtility.escape(this.addEscapeChar(pollData.getQuestion())));
        this.addNonHTMLText(ad, pollData.getQuestion());
        ad.title = new StringBuffer(this._dayFormat.format(date));
        ad.title.append(" ");
        ad.title.append(pollData.getQuestion() + " [" + this.getDisplayName(originator) + "]");
        this.addNonHTMLText(ad, this.getDisplayName(originator));
        ret.append("<br>");
        ret.append("%{0}");
        ret.append(TIMESTAMP);
        ret.append(date.getTime());
        ret.append("{0}date%");
        ret.append("<br>");
        ret.append("%poll_answers%");
        int i = 0;
        while (i < pollData.countAnswers()) {
            ret.append("<br>");
            ret.append("%{0}");
            ret.append(i);
            ret.append("{0}");
            ret.append("{1}");
            ret.append(HtmlUtility.escape(this.addEscapeChar(pollData.getAnswer(i))));
            this.addNonHTMLText(ad, pollData.getAnswer(i));
            ret.append("{1}answer%");
            ++i;
        }
        this.addHTMLText(ad, ret.toString());
        ad.access = pollData.getAccess();
        if (!ADMIN_ONLY && !ad.access.equals("public")) {
            ad.readacl.add(this.getDN(originator));
        }
        ad.dirty = true;
        IMPSArchive.backup(ad);
    }

    /*
     * WARNING - void declaration
     */
    public void pollAnswer(String originator, String pollId, String answer) {
        if (!ARCHIVE_POLL) {
            return;
        }
        StringBuffer ret = new StringBuffer("");
        ret.append("<p>");
        ret.append("%{0}");
        ret.append(HtmlUtility.escape(this.addEscapeChar(this.getDisplayName(originator))));
        ret.append("{0}");
        ret.append("replied%");
        ret.append(HtmlUtility.escape(this.addEscapeChar(answer)));
        ret.append("</p>");
        Log.out.info("[IMPSArchive] Received poll answer from" + this.getDisplayName(originator) + " answer = " + answer);
        boolean submit_now = false;
        ArchiveData ad = this.getArchiveData(pollId, 3, false);
        if (ad == null) {
            Log.out.info("[IMPSArchive] Getting the Poll data from database.");
            try {
                SOIF s = new SOIF("DOCUMENT", SEARCH_SERVLET + "&scope=" + ad.id);
                LinkedList<SOIF> list = new LinkedList<SOIF>();
                list.add(s);
                LinkedList soifList = (LinkedList)IMPSArchive.callServlet(list, GET);
                if (soifList == null) {
                    return;
                }
                int j = 0;
                while (j < soifList.size()) {
                    SOIF soif = (SOIF)soifList.get(j);
                    if (soif.getSchemaName().equalsIgnoreCase("DOCUMENT")) {
                        String aclItem;
                        ad = new ArchiveData(pollId, 3);
                        htArchiveData.put(pollId, ad);
                        ad.full_text = new StringBuffer(soif.getValue(FULLTEXT));
                        ad.description = new StringBuffer(soif.getValue(DESCRIPTION));
                        ad.title = new StringBuffer(soif.getValue(TITLE));
                        ad.category = soif.getValue(CLASSIFICATION);
                        int i = 0;
                        while ((aclItem = soif.getValue(READACL, i++)) != null) {
                            void var13_14;
                            ad.readacl.add(var13_14);
                        }
                        submit_now = true;
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                Log.out.warning("[IMPSArchive] Error parsing portal server search response: " + e.toString());
                Log.out.printStackTrace(e);
            }
        }
        if (ad == null) {
            return;
        }
        this.addHTMLText(ad, ret.toString());
        this.addNonHTMLText(ad, this.getDisplayName(originator));
        this.addNonHTMLText(ad, answer);
        IMPSArchive.backup(ad);
        if (submit_now) {
            ad.remove = true;
        }
        ad.dirty = true;
    }

    private String retrivePoll(String str) {
        int endTag = 0;
        int startTag = 0;
        do {
            if ((endTag = str.indexOf("replied%", endTag + 1)) != -1) continue;
            return str;
        } while (str.charAt(endTag + 8) == '%');
        String substr = str.substring(0, endTag);
        while (substr.charAt((startTag = substr.lastIndexOf(37)) - 1) == '%') {
            substr = substr.substring(0, startTag - 1);
        }
        return str.substring(0, startTag);
    }

    private void addHTMLText(ArchiveData ad, String text) {
        ad.full_text.append(text);
        Log.out.debug("[IMPSArchive] Archived HTML text: " + text);
    }

    private void addNonHTMLText(ArchiveData ad, String text) {
        if (ad.description.toString().indexOf(text) >= 0) {
            return;
        }
        ad.description.append(text.trim());
        ad.description.append(" ");
        Log.out.debug("[IMPSArchive] Archived Non HTML text: " + text);
    }

    private String appendMessageContent(ReadOnlyMessage message) throws CollaborationException {
        StringBuffer ret = new StringBuffer();
        ReadOnlyMessagePart[] parts = message.getReadOnlyParts();
        if (parts.length > 0) {
            String text = this.addEscapeChar(parts[0].getContent());
            text = StringUtility.substitute(text, "\r\n", "\n");
            ret.append(text);
        }
        return ret.toString();
    }

    private ArchiveData createNextRD(ArchiveData ad, String key) {
        ArchiveData newad = new ArchiveData(ad.address, ad.TYPE);
        ad.next = newad.URL;
        newad.back = ad.URL;
        newad.title = ad.title;
        ad.dirty = true;
        ad.remove = true;
        IMPSArchive.submitRD();
        htArchiveData.put(key, newad);
        Log.out.debug("[IMPSArchive] created next RD: " + newad.URL);
        return newad;
    }

    private static SOIF toSOIF(ArchiveData ad) {
        SOIF soif = new SOIF("DOCUMENT", ad.URL);
        soif.insert(TITLE, ad.title.toString());
        soif.insert(DESCRIPTION, ad.description.toString());
        soif.insert(FULLTEXT, ad.full_text.toString());
        String strKeyword = ad.keywords + NAME_SEPARATOR + ad.title.toString();
        soif.insert(KEYWORDS, strKeyword);
        if (ad.TYPE != 2 || ADMIN_ONLY || !ad.readacl.isEmpty()) {
            StringTokenizer st = new StringTokenizer(ADMIN, ";");
            int count = 0;
            while (st.hasMoreTokens()) {
                String stracl = st.nextToken();
                soif.insert(READACL, stracl, count);
                ++count;
            }
            if (!ADMIN_ONLY && !ad.readacl.isEmpty()) {
                int i = 0;
                while (i < ad.readacl.size()) {
                    String stracl = (String)ad.readacl.get(i);
                    soif.insert(READACL, stracl, i + count);
                    ++i;
                }
            }
        }
        if (ad.category == null) {
            ad.category = "";
        }
        if (!ad.category.equals("")) {
            String str = IMPSArchive.expandMacro(ad.category);
            soif.insert(CLASSIFICATION, str);
        }
        return soif;
    }

    private static void backup(ArchiveData ad) {
        if (BACKUP_FILE == null) {
            return;
        }
        switch (ad.TYPE) {
            case 0: {
                if (ARCHIVE_ALERT) break;
                return;
            }
            case 1: {
                if (ARCHIVE_CHAT) break;
                return;
            }
            case 2: {
                if (ARCHIVE_CONFERENCE) break;
                return;
            }
            case 3: {
                if (ARCHIVE_POLL) break;
                return;
            }
            case 5: {
                if (ARCHIVE_POLL) break;
                return;
            }
            case 4: {
                if (ARCHIVE_NEWS) break;
                return;
            }
        }
        try {
            SOIF soif = IMPSArchive.toSOIF(ad);
            IMPSArchive.backup(soif);
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
    }

    private static void backup(SOIF soif) {
        if (BACKUP_FILE == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                FileUtility.writeByte(BACKUP_FILE, soif.toByteArray(), true);
            }
            catch (IOException e) {
                Log.out.printStackTrace(e);
            }
        }
    }

    public static void restoreBackup() {
        Object object = lock;
        synchronized (object) {
            byte[] b = FileUtility.readByte(BACKUP_FILE);
            if (b != null) {
                FileUtility.writeByte(BACKUP_FILE_TMP, b, true);
            }
            if ((b = FileUtility.readByte(BACKUP_FILE_TMP)) != null) {
                FileUtility.writeByte(BACKUP_FILE, b, false);
            }
        }
    }

    private void removeacl(Hashtable list, String user) {
        Enumeration e = list.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            LinkedList acl = (LinkedList)list.get(id);
            Log.out.debug("[IMPSArchive] RD = " + id);
            if (!acl.remove(user)) continue;
            Log.out.debug("[IMPSArchive] Removed user " + user + " from the acl list of " + id);
            SOIF soif = new SOIF("DOCUMENT", SEARCH_SERVLET + "&scope=" + id);
            if (ADMIN.equals("") && acl.size() == 0) {
                Log.out.debug("[IMPSArchive] ReadACL size is 0");
                deleteList.add(soif);
                continue;
            }
            StringTokenizer st = new StringTokenizer(ADMIN, ";");
            int count = 0;
            while (st.hasMoreTokens()) {
                String stracl = st.nextToken();
                soif.insert(READACL, stracl, count);
                ++count;
            }
            int i = 0;
            while (i < acl.size()) {
                String stracl = (String)acl.get(i);
                soif.insert(READACL, stracl, i + count);
                ++i;
            }
            removeaclList.add(soif);
            Log.out.debug("[IMPSArchive] Added " + id + " to the removeacl list");
        }
    }

    private Map updateUserACL(ArchiveData ad) {
        Hashtable userACLMap = (Hashtable)NMS.getDestinationContext(ad.address, PROVIDER_KEY);
        if (userACLMap == null) {
            Log.out.info("[IMPSArchive] No hashtable found for conference" + ad.address);
            userACLMap = new Hashtable();
            NMS.setDestinationContext(ad.address, PROVIDER_KEY, userACLMap);
        } else {
            Iterator iter = userACLMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Map newval = (Map)entry.getValue();
                newval.put(ad.id, ad.readacl);
                entry.setValue(newval);
            }
        }
        return userACLMap;
    }

    private static void printTestData(String data, String op, String user) {
        psTest.println("---START OP---");
        psTest.println(data);
        psTest.println("---END OP---");
        psTest.println("---START USER---");
        psTest.println(op);
        psTest.println("---END USER---");
        psTest.println("---START DATA---");
        psTest.println(user);
        psTest.println("---END DATA---");
    }

    static {
        CATEGORYNAME = "";
        ARCHIVE_ALERT = true;
        ARCHIVE_CHAT = true;
        ARCHIVE_CONFERENCE = true;
        ARCHIVE_POLL = true;
        ARCHIVE_NEWS = true;
        IGNORE_EXPLICIT_DENY = true;
        TEST = false;
        psTest = System.out;
        htArchiveData = new Hashtable();
        removeaclList = new LinkedList();
        deleteList = new LinkedList();
        SEARCH_SERVLET = "dt?provider=IMChannel&display=true&last=false";
        SUBMIT_SERVLET = "search";
        BOUNDARY = "---------------------------soimsoif";
        SUCCESSFUL_SUBMISSION = false;
        lock = new Object();
        BACKUP_FILE_TMP = null;
    }
}

