/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.util.LazyDate;
import com.iplanet.im.util.SafeResourceBundle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;

public class Http
extends Thread {
    static SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    Socket s;
    static final String index = "index.html";
    static ServerSocket serv;
    static boolean running;
    static File rootDir;

    public Http(Socket s) {
        this.s = s;
    }

    public static void main(String[] args) {
        int port = 9980;
        String root = ".";
        int x = 0;
        while (x < args.length) {
            if (args[x].equals("-port")) {
                port = Integer.parseInt(args[++x]);
            }
            if (args[x].equals("-root")) {
                root = args[++x];
            }
            ++x;
        }
        Http.startServ(root, port, null);
    }

    public static void startServ(String root, int port, InetAddress i) {
        block5: {
            if (running) {
                Log.out.error(res.getString("trying_to_run_HTTP"));
                return;
            }
            running = true;
            rootDir = new File(root);
            if (!rootDir.isDirectory()) {
                Log.out.warning(res.getString("Invalid_HTTP_Root") + rootDir.getAbsolutePath());
                return;
            }
            try {
                serv = new ServerSocket(port, 10, i);
                Log.out.info(res.getString("accepting_HTTP") + " : " + serv.getLocalPort() + " : " + rootDir.getAbsolutePath());
                while (running) {
                    Http n = new Http(serv.accept());
                    n.start();
                }
            }
            catch (IOException e) {
                if (!running) break block5;
                Log.out.error(res.getString("HTTP_Server"));
            }
        }
        Http.stopServ();
    }

    public static void stopServ() {
        if (!running) {
            return;
        }
        running = false;
        if (serv != null) {
            try {
                serv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        serv = null;
        Log.out.info(res.getString("Stopping_HTTP_server"));
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        block19: {
            String version = "";
            try {
                PrintStream os = new PrintStream(new BufferedOutputStream(this.s.getOutputStream()));
                BufferedReader is = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                String line = is.readLine();
                if (line == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(line);
                String method = st.nextToken();
                String fileName = st.nextToken();
                if (st.hasMoreTokens()) {
                    version = st.nextToken();
                }
                while ((line = is.readLine()) != null) {
                    if (line.trim().equals("")) break;
                }
                Log.out.debug("HTTP request = " + method + " " + fileName);
                if (method.equals("GET") || method.equals("HEAD")) {
                    FileInputStream fs;
                    File file;
                    boolean headOnly = false;
                    if (method.equals("HEAD")) {
                        headOnly = true;
                    }
                    try {
                        if (fileName.endsWith("/")) {
                            fileName = fileName + index;
                        }
                        if ((file = new File(rootDir, fileName.substring(1, fileName.length()))).isDirectory()) {
                            file = new File(file, index);
                        }
                        fs = new FileInputStream(file);
                    }
                    catch (IOException e) {
                        file = null;
                        fs = null;
                        if (version.startsWith("HTTP/")) {
                            String header = "HTTP/1.0 404 File Not Found\r\n";
                            header = header + this.standardHeaders();
                            header = header + "Content-type: text/html\r\n\r\n";
                            os.print(header);
                        }
                        os.println("<HTML><HEAD><TITLE>File Not Found</TITLE><HEAD>");
                        os.println("<BODY><H1>HTTP Error 404: File Not Found</H1></BODY></HTML>");
                        os.close();
                        Log.out.warning("Requested HTTP File: >" + fileName + "< not found");
                    }
                    if (file != null) {
                        if (version.startsWith("HTTP/")) {
                            String header = "HTTP/1.0 200 OK\r\n";
                            header = header + this.standardHeaders();
                            header = header + "Content-length: " + file.length() + "\r\n";
                            header = header + "Content-type: " + this.contentType(fileName) + "\r\n\r\n";
                            os.print(header);
                        }
                        if (!headOnly) {
                            int r;
                            byte[] data = new byte[1024];
                            while ((r = fs.read(data)) > 0) {
                                void header;
                                os.write(data, 0, (int)header);
                            }
                        }
                        os.flush();
                        os.close();
                        fs.close();
                        this.s.close();
                        Log.out.info("HTTP File: >" + fileName + "<  size: " + file.length() + " bytes - Content-type: " + this.contentType(fileName));
                    }
                    break block19;
                }
                if (version.startsWith("HTTP/")) {
                    String header = "HTTP/1.0 501 Not Implemented\r\n";
                    header = header + this.standardHeaders();
                    header = header + "Content-type: text/html\r\n\r\n";
                    os.print(header);
                }
                os.println("<HTML><HEAD><TITLE>Not Implemented</TITLE><HEAD>");
                os.println("<BODY><H1>HTTP Error 501: Not Implemented</H1></BODY></HTML>");
                os.close();
                Log.out.error("HTTP only supports GET or HEAD");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String standardHeaders() {
        Date now = LazyDate.getDate();
        return "Date: " + now + "\r\nServer: iim http 1.0\r\n";
    }

    private String contentType(String filename) {
        String[] a = new String[]{".html", "text/html", ".htm", "text/html", ".txt", "text/plain", ".jar", "application/octet-stream", ".class", "application/octet-stream", ".gif", "image/gif", ".jpg", "image/jpeg", ".jpeg", "image/jpeg", ".jnlp", "application/x-java-jnlp-file", ".nlc", "application/x-x509-ca-cert"};
        int x = 0;
        while (x < a.length - 1) {
            if (filename.endsWith(a[x])) {
                return a[x + 1];
            }
            x += 2;
        }
        return "application/octet-stream";
    }
}

