/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.im.server.IdentityRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.Realm;
import com.iplanet.im.util.StringUtility;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.im.provider.SSOProvider;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class DSAMESSOProvider
implements SSOProvider,
SSOTokenListener {
    Hashtable uid2token = new Hashtable();
    Hashtable token2uid = new Hashtable();
    Realm realm = NMS.getRealm();
    boolean usePolicy = false;

    public DSAMESSOProvider() {
        if (this.realm instanceof IdentityRealm) {
            this.usePolicy = true;
        }
    }

    public boolean verify(String uid, String token, Map attributes, Set attributeNames) {
        Log.out.info("Authenticating using Identity Server SSO");
        String userId = "";
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken ssoToken = manager.createSSOToken(token);
            SSOTokenID ssoTokenId = ssoToken.getTokenID();
            if (!manager.isValidToken(ssoToken)) {
                Log.out.info("[IS-SSO] SSO Validation failed");
                return false;
            }
            ssoToken.addSSOTokenListener((SSOTokenListener)this);
            String localname = StringUtility.getLocalPartFromAddress(uid);
            AMStoreConnection connection = new AMStoreConnection(ssoToken);
            userId = ssoToken.getPrincipal().getName();
            AMUser user = connection.getUser(userId);
            Set u = user.getAttribute("uid");
            String _uid = userId;
            if (u != null && !u.isEmpty()) {
                _uid = (String)u.iterator().next();
            }
            if (!_uid.equals(localname)) {
                Log.out.info("[IS-SSO] uid mismatch: ");
                return false;
            }
            String domain = NMS.getName();
            if (this.usePolicy) {
                domain = this.realm.getDomainName(user.getOrganizationDN());
            }
            String fquid = localname + "@" + domain;
            this.token2uid.put(ssoTokenId.toString(), fquid);
            this.uid2token.put(fquid, ssoToken);
            Log.out.debug("[IS-SSO] Session Created: " + fquid);
            if (this.usePolicy) {
                ((IdentityRealm)this.realm).loadUserAttributes(ssoToken, user, attributes, attributeNames);
            } else {
                attributes.putAll(user.getAttributes(attributeNames));
                attributes.put("dn", user.getDN());
            }
            return true;
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            return false;
        }
    }

    public void ssoTokenChanged(SSOTokenEvent event) {
        try {
            SSOToken token = event.getToken();
            SSOTokenID tokenId = token.getTokenID();
            String uid = (String)this.token2uid.get(tokenId.toString());
            if (uid != null) {
                this.uid2token.remove(uid);
                this.token2uid.remove(tokenId.toString());
            }
            Log.out.info("[IS-SSO] Session Expired: " + uid + " reason=" + event.getType());
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
    }

    public boolean refresh(String uid) {
        SSOToken token = (SSOToken)this.uid2token.get(uid);
        if (token != null) {
            try {
                SSOTokenManager manager = SSOTokenManager.getInstance();
                if (manager.isValidToken(token)) {
                    long maxIdleTime;
                    long idleTime = token.getIdleTime();
                    if (idleTime * 2L > (maxIdleTime = token.getIdleTime()) * 60L) {
                        manager.refreshSession(token);
                        Log.out.debug("[IS-SSO] Session Refreshed: " + uid);
                        return true;
                    }
                    return true;
                }
                Log.out.debug("[IS-SSO] Token Invalid: " + uid);
                return false;
            }
            catch (Exception e) {
                Log.out.printStackTrace(e);
                return false;
            }
        }
        Log.out.debug("[IS-SSO] Session token not found: " + uid);
        return false;
    }

    public void open() throws Exception {
    }

    public void close() {
    }
}

