/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Counter;
import com.iplanet.im.server.Log;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class Counters {
    public static String CNT_SESSIONS = "sessions";
    public static String CNT_MESSAGES = "messages";
    public static String CNT_PRESENCE = "presence";
    public static String CNT_CHAT_ROOMS = "rooms";
    public static String CNT_CHAT_SUBSCRIPTIONS = "joins";
    public static String CNT_SETTINGS = "settings";
    private static Hashtable _counters = new Hashtable(19);
    private static LinkedList _names = new LinkedList();

    public static void add(String name) {
        if (!_names.contains(name)) {
            _names.add(name);
        }
        _counters.put(name, new Counter(name));
    }

    public static void increment(String name) {
        Counter c = (Counter)_counters.get(name);
        if (c != null) {
            c.increment();
        }
    }

    public static void increment(String name, int val) {
        Counter c = (Counter)_counters.get(name);
        if (c != null) {
            c.increment(val);
        }
    }

    public static void decrement(String name) {
        Counter c = (Counter)_counters.get(name);
        if (c != null) {
            c.decrement();
        }
    }

    public static void reset(String name) {
        Counter c = (Counter)_counters.get(name);
        if (c != null) {
            c.reset();
        }
    }

    public static void reset() {
        Iterator i = _names.iterator();
        while (i.hasNext()) {
            Counter c = (Counter)_counters.get((String)i.next());
            c.reset();
        }
    }

    public static void log(boolean reset) {
        StringBuffer b = new StringBuffer("STATS|");
        StringBuffer bCumul = new StringBuffer("STATS_CUMUL|");
        Iterator i = _names.iterator();
        while (i.hasNext()) {
            Counter c = (Counter)_counters.get((String)i.next());
            b.append(" ");
            b.append(c.name);
            b.append(" ");
            b.append(c.getCurrent());
            bCumul.append(" ");
            bCumul.append(c.name);
            bCumul.append(" ");
            bCumul.append(c.getAccumulated());
            if (!reset) continue;
            c.reset();
        }
        Log.out.notice(b.toString());
        Log.out.notice(bCumul.toString());
    }
}

