/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FreeBusy {
    public static final String FREEBUSY = "FREEBUSY";
    public static final String FBTYPE = "FBTYPE";
    public static final String BUSY = "BUSY";
    public static final String BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    public static final String BUSY_TENTATIVE = "BUSY-TENTATIVE";
    public static final String FREE = "FREE";
    private String fbtype = "BUSY";
    private DateTime dtstart = null;
    private DateTime dtend = null;
    private Duration duration = null;
    private boolean hasDuration = false;
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();
    private static final Hashtable freeBusyTypes = new Hashtable();

    public FreeBusy(String string, DateTime dateTime, DateTime dateTime2) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        if (!freeBusyTypes.containsKey(string = string.toUpperCase())) {
            throw new IllegalArgumentException("\"" + string + "\" is invalid Free/Busy time type");
        }
        this.fbtype = string;
        this.dtstart = dateTime;
        this.dtend = dateTime2;
        this.duration = null;
        this.hasDuration = false;
    }

    public FreeBusy(String string, DateTime dateTime, Duration duration) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        if (!freeBusyTypes.containsKey(string = string.toUpperCase())) {
            throw new IllegalArgumentException("\"" + string + "\" is invalid Free/Busy time type");
        }
        this.fbtype = string;
        this.dtstart = dateTime;
        this.dtend = null;
        this.duration = duration;
        this.hasDuration = true;
    }

    public FreeBusy(FreeBusy freeBusy) throws IllegalArgumentException, PropertiesException {
        if (null == freeBusy) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.fbtype = new String(freeBusy.getFBtype());
        this.dtstart = (DateTime)((Calendar)freeBusy.getStart()).clone();
        this.dtend = null == freeBusy.getEnd() ? null : (DateTime)((Calendar)freeBusy.getEnd()).clone();
        Duration duration = freeBusy.getDuration();
        this.duration = null != duration ? new Duration(duration.toRFC2445()) : null;
        this.hasDuration = freeBusy.hasDuration();
    }

    public static FreeBusy[] fromRFC2445(String string) throws IllegalArgumentException, PropertiesException, ParseException {
        Object object;
        int n;
        if (null == string) {
            throw new IllegalArgumentException("input given for \"rfcForm\" argument was found to be null");
        }
        String string2 = new String(string.toUpperCase());
        String string3 = "FREEBUSY:";
        String string4 = "FREEBUSY;FBTYPE=";
        String string5 = BUSY;
        if (string2.startsWith(string3)) {
            string2 = string2.substring(string3.length(), string2.length());
        } else if (string2.startsWith(string4)) {
            n = (string2 = string2.substring(string4.length(), string2.length())).indexOf(":");
            if (-1 == n || string2.startsWith(":")) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            string5 = string2.substring(0, n);
            if (!freeBusyTypes.containsKey(string5)) {
                throw new PropertiesException("invalid Free/Busy time type \"" + string5 + "\" was specified in input string <" + string + ">", 2);
            }
            string2 = string2.substring(n + 1, string2.length());
        } else {
            throw FreeBusy.getInvalidFormatException(string);
        }
        if (0 == string2.length()) {
            throw FreeBusy.getInvalidFormatException(string);
        }
        ArrayList<FreeBusy> arrayList = new ArrayList<FreeBusy>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            object = (String)stringTokenizer.nextElement();
            n = ((String)object).indexOf("/");
            if (-1 == n) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            String string6 = ((String)object).substring(0, n);
            String string7 = ((String)object).substring(n + 1, ((String)object).length());
            if (0 == string6.length() || 0 == string7.length()) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            FreeBusy freeBusy = null;
            DateTime dateTime = new DateTime(string6);
            if (string7.startsWith("P") || string7.startsWith("p")) {
                object2 = new Duration(string7);
                freeBusy = new FreeBusy(string5, dateTime, (Duration)object2);
            } else {
                object2 = new DateTime(string7);
                freeBusy = new FreeBusy(string5, dateTime, (DateTime)object2);
            }
            arrayList.add(freeBusy);
        }
        object = new FreeBusy[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public Object clone() {
        try {
            return new FreeBusy(this);
        }
        catch (PropertiesException propertiesException) {
            return null;
        }
    }

    public String toRFC2445() {
        return "FREEBUSY;FBTYPE=" + this.getFBtype() + ":" + this.getStart().toISOString() + "/" + (this.hasDuration() ? this.getDuration().toRFC2445().substring(rfcDurationPrefixLength) : this.getEnd().toISOString());
    }

    public String toString() {
        return "FreeBusy[fbtype=" + this.getFBtype() + "; start=" + this.getStart().toISOString() + "; hasDuration=" + this.hasDuration() + "; end=" + (null == this.getEnd() ? null : this.getEnd().toISOString()) + "; duration=" + (null == this.getDuration() ? null : this.getDuration().toRFC2445().substring(rfcDurationPrefixLength)) + "]";
    }

    public String getFBtype() {
        return this.fbtype;
    }

    public DateTime getStart() {
        return this.dtstart;
    }

    public DateTime getEnd() {
        return this.dtend;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    private static PropertiesException getInvalidFormatException(String string) {
        return new PropertiesException("Cannot parse the input string <" + string + "> -- does not confirm to \"FREEBUSY\" property format as specified in RFC 2445", 2);
    }

    static {
        freeBusyTypes.put(BUSY, BUSY);
        freeBusyTypes.put(BUSY_UNAVAILABLE, BUSY_UNAVAILABLE);
        freeBusyTypes.put(BUSY_TENTATIVE, BUSY_TENTATIVE);
        freeBusyTypes.put(FREE, FREE);
    }
}

