/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.CommandToNet;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.MultiplexConnectionFactory;
import com.iplanet.im.net.MultiplexSocketFactory;
import com.iplanet.im.util.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;

class MultiplexSocket
extends Socket {
    private MultiplexConnectionFactory[] _channel;
    private int _numChannels = 0;
    private int _lastIndex;
    private int _capacity;
    private InetAddress _host;
    private int _port;
    private DataOutputStream _dataos;
    private CommandToNet c2n = new CommandToNet(true);
    private MultiplexReader _reader;
    private Worker _worker;
    private Stack _runners = new Stack();
    private MultiplexSocketFactory _factory;
    public static final byte CMD_NEW = 1;
    public static final byte CMD_CLOSE = 2;
    public static final byte CMD_DATA = 3;
    public static final byte CMD_HELLO = 4;
    public static final byte CMD_BYE = 5;

    public MultiplexSocket(MultiplexSocketFactory factory, InetAddress host, int port, int capacity) throws IOException {
        super(host, port);
        this._factory = factory;
        this._channel = new MultiplexConnectionFactory[capacity];
        this._capacity = capacity;
        this._host = host;
        this._port = port;
        this._worker = new Worker(2);
        DataOutputStream dataOutputStream = this._dataos = new DataOutputStream(new BufferedOutputStream(this.getOutputStream()));
        synchronized (dataOutputStream) {
            this._dataos.writeByte(4);
            this._dataos.writeByte(3);
            this._dataos.writeByte(0);
            this._dataos.flush();
        }
        DataInputStream is = new DataInputStream(new BufferedInputStream(this.getInputStream()));
        this._reader = new MultiplexReader(this, is);
        this._reader.start();
    }

    private InputRunner getRunner(ConnectionFactory cf, CommandData cd) {
        InputRunner r = null;
        try {
            r = (InputRunner)this._runners.pop();
            r.initialize(cf, cd);
        }
        catch (EmptyStackException e) {
            r = new InputRunner(cf, cd);
        }
        return r;
    }

    public synchronized MultiplexConnectionFactory createChannel(InetAddress clientHost, int clientPort, Properties props) throws IOException {
        int i = 0;
        while (i < this._capacity) {
            int j = (i + this._lastIndex) % this._capacity;
            if (this._channel[j] == null) {
                MultiplexConnectionFactory c;
                this._channel[j] = c = new MultiplexConnectionFactory(j, this, props);
                this._lastIndex = j + 1;
                ++this._numChannels;
                DataOutputStream dataOutputStream = this._dataos;
                synchronized (dataOutputStream) {
                    try {
                        this._dataos.write(1);
                        this._dataos.writeInt(j);
                        this._dataos.write(clientHost.getAddress());
                        this._dataos.flush();
                    }
                    catch (IOException e) {
                        --this._numChannels;
                        this._channel[j] = null;
                        throw e;
                    }
                }
                return c;
            }
            ++i;
        }
        return null;
    }

    public boolean isPrettyFull() {
        return this._numChannels * 2 > this._capacity;
    }

    public boolean matches(InetAddress host, int port) {
        return this._port == port && host.equals(this._host);
    }

    public void close() throws IOException {
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.writeByte(5);
            this._dataos.flush();
        }
        this._dataos.close();
        this._reader.shutdown();
        try {
            this._reader.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._worker.stop();
        this._runners.clear();
        super.close();
    }

    public void close(int channel) throws IOException {
        this.deleteChannel(channel);
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.write(2);
            this._dataos.writeInt(channel);
            this._dataos.flush();
        }
    }

    private synchronized void deleteChannel(int channel) {
        this._channel[channel] = null;
        --this._numChannels;
    }

    public void writeCommand(int channel, CommandData nc) throws IOException {
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.write(3);
            this._dataos.writeInt(channel);
            this.c2n.sendCommand(this._dataos, nc);
        }
    }

    static /* synthetic */ CommandToNet access$100(MultiplexSocket x0) {
        return x0.c2n;
    }

    static /* synthetic */ MultiplexConnectionFactory[] access$200(MultiplexSocket x0) {
        return x0._channel;
    }

    static /* synthetic */ InputRunner access$300(MultiplexSocket x0, ConnectionFactory x1, CommandData x2) {
        return x0.getRunner(x1, x2);
    }

    static /* synthetic */ Worker access$400(MultiplexSocket x0) {
        return x0._worker;
    }

    static /* synthetic */ void access$500(MultiplexSocket x0, int x1) {
        x0.deleteChannel(x1);
    }

    static /* synthetic */ MultiplexSocketFactory access$600(MultiplexSocket x0) {
        return x0._factory;
    }

    class MultiplexReader
    extends Thread {
        private DataInputStream _datais;
        private boolean _shutdown = false;
        MultiplexSocket _socket;

        public MultiplexReader(MultiplexSocket s, DataInputStream is) {
            this._datais = is;
            this._socket = s;
        }

        public void shutdown() {
            this._shutdown = true;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block10: while (!this._shutdown) {
                try {
                    cmd = this._datais.readByte();
                    switch (cmd) {
                        case 3: {
                            id = this._datais.readInt();
                            nc = MultiplexSocket.access$100(MultiplexSocket.this).readCommand(this._datais);
                            if (MultiplexSocket.access$200(MultiplexSocket.this)[id] != null) {
                                runner = MultiplexSocket.access$300(MultiplexSocket.this, MultiplexSocket.access$200(MultiplexSocket.this)[id], nc);
                                MultiplexSocket.access$400(MultiplexSocket.this).addRunnable(runner);
                                break;
                            }
                            System.err.println("received data " + Command.toString(nc) + " for non-existant channel " + id);
                            break;
                        }
                        case 2: {
                            id = this._datais.readInt();
                            if (MultiplexSocket.access$200(MultiplexSocket.this)[id] == null) continue block10;
                            MultiplexSocket.access$200(MultiplexSocket.this)[id].closed("Connection closed by server");
                            MultiplexSocket.access$500(MultiplexSocket.this, id);
                            break;
                        }
                        case 5: {
                            id = 0;
                            while (id < MultiplexSocket.access$200(MultiplexSocket.this).length) {
                                if (MultiplexSocket.access$200(MultiplexSocket.this)[id] != null) {
                                    MultiplexSocket.access$200(MultiplexSocket.this)[id].closed("Connection closed by server");
                                    MultiplexSocket.access$500(MultiplexSocket.this, id);
                                }
                                ++id;
                            }
                            this._shutdown = true;
                            break;
                        }
                        case 4: {
                            major = this._datais.readByte();
                            minor = this._datais.readByte();
                            break;
                        }
                        default: {
                            System.err.println("Unexpected command " + cmd);
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    MultiplexSocket.access$600(MultiplexSocket.this).remove(this._socket);
                    i = 0;
                    ** while (i < MultiplexSocket.access$200((MultiplexSocket)MultiplexSocket.this).length)
                }
lbl-1000:
                // 1 sources

                {
                    if (MultiplexSocket.access$200(MultiplexSocket.this)[i] != null) {
                        MultiplexSocket.access$200(MultiplexSocket.this)[i].closed(e.toString());
                    }
                    ++i;
                    continue;
                }
lbl46:
                // 1 sources

                this._shutdown = true;
                break;
            }
            try {
                this._datais.close();
                this._datais = null;
            }
            catch (Exception var1_3) {
                // empty catch block
            }
        }
    }

    class InputRunner
    implements Runnable {
        private CommandData _cd;
        private ConnectionFactory _cf;

        InputRunner(ConnectionFactory cf, CommandData cd) {
            this._cd = cd;
            this._cf = cf;
        }

        void initialize(ConnectionFactory cf, CommandData cd) {
            this._cd = cd;
            this._cf = cf;
        }

        public void run() {
            this._cf.handleCommand(this._cd);
            MultiplexSocket.this._runners.push(this);
        }
    }
}

