/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.util.StringUtility;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class Destination
implements Serializable {
    static final long serialVersionUID = 882997869721079849L;
    protected String _name;
    protected String _location;
    protected String _mailaddr;
    protected int _access = 14;
    protected HashMap _props = null;

    public Destination(String name, String location) {
        this._name = name;
        this._location = location;
    }

    public Destination(String address) {
        this._location = StringUtility.getDomainFromAddress(address, "");
        this._name = StringUtility.getLocalPartFromAddress(address);
    }

    public Destination(String name, String location, String mailaddr) {
        this._name = name;
        this._location = location;
        this._mailaddr = mailaddr;
    }

    public String getMailaddr() {
        return this._mailaddr;
    }

    public String getName() {
        return this._name;
    }

    public String getLocation() {
        return this._location;
    }

    public abstract String getUID();

    public String getFQName() {
        return this._name + "@" + this._location;
    }

    public String toString() {
        return this.getUID();
    }

    public int getAccessLevel() {
        return this._access;
    }

    public synchronized String getProperty(String attribute) {
        if (this._props != null) {
            return (String)this._props.get(attribute);
        }
        return null;
    }

    public synchronized void setProperty(String attribute, String value) {
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(attribute, value);
    }

    public synchronized Map getProperties() {
        if (this._props == null) {
            this._props = new HashMap();
        }
        return this._props;
    }

    public boolean equals(Object other) {
        try {
            Destination otherDestination = (Destination)other;
            return this.getUID().equals(otherDestination.getUID());
        }
        catch (Exception e) {
            return false;
        }
    }
}

