/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.jni;

import com.iplanet.im.jni.DesktopIndicatorListener;
import com.iplanet.im.jni.JNILink;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;

public class DesktopIndicator {
    private int image = -1;
    private String tooltip = "";
    private Vector listeners = new Vector();
    private int handler = 0;
    public static final int POPUP_MENUITEM = 1;
    public static final int POPUP_SEPARATOR = 2;

    private static synchronized native int nativeLoadImage(byte[] var0) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private synchronized native boolean nativeSetupPopup(String[] var1, int[] var2, int var3) throws UnsatisfiedLinkError;

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private static synchronized native int getMouseX() throws UnsatisfiedLinkError;

    private static synchronized native int getMouseY() throws UnsatisfiedLinkError;

    public static Point getMousePos() {
        return new Point(DesktopIndicator.getMouseX(), DesktopIndicator.getMouseY());
    }

    public DesktopIndicator(int image, String tooltip) {
        this.image = image;
        this.tooltip = tooltip;
        if (!JNILink.JNI_LOADED) {
            return;
        }
        try {
            this.nativeEnable(image, tooltip);
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int loadImage(String filename) {
        if (!JNILink.JNI_LOADED) {
            return -1;
        }
        try {
            return DesktopIndicator.nativeLoadImage(filename.getBytes());
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
            return -1;
        }
        catch (Exception e) {
            System.out.println(e);
            return -1;
        }
    }

    public static void freeImage(int image) {
        if (!JNILink.JNI_LOADED) {
            return;
        }
        try {
            DesktopIndicator.nativeFreeImage(image);
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void show() {
        if (!JNILink.JNI_LOADED) {
            return;
        }
        try {
            this.nativeEnable(this.image, this.tooltip);
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void update(int image, String tooltip) {
        if (!JNILink.JNI_LOADED) {
            return;
        }
        this.image = image;
        this.tooltip = tooltip;
        try {
            this.nativeEnable(image, tooltip);
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void hide() {
        if (!JNILink.JNI_LOADED) {
            return;
        }
        try {
            this.nativeDisable();
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void setPopupMenu(String[] menuLabels, int[] menuTypes, int size) {
        if (!JNILink.JNI_LOADED) {
            return;
        }
        try {
            if (!this.nativeSetupPopup(menuLabels, menuTypes, size)) {
                System.out.println("There was an error creating the system tray popup menu");
            }
        }
        catch (UnsatisfiedLinkError x) {
            System.out.println(x);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void fireMousePressed(int button) {
        ActionEvent evt = new ActionEvent(this, 0, button == 0 ? "Left" : "Right");
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            DesktopIndicatorListener listener = (DesktopIndicatorListener)e.nextElement();
            listener.onDesktopIndicatorMousePressed(evt);
        }
    }

    public void fireMouseDblClicked(int button) {
        ActionEvent evt = new ActionEvent(this, 0, button == 0 ? "Left" : "Right");
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            DesktopIndicatorListener listener = (DesktopIndicatorListener)e.nextElement();
            listener.onDesktopIndicatorMouseDblClicked(evt);
        }
    }

    public void firePopupClicked(int menuID) {
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            DesktopIndicatorListener listener = (DesktopIndicatorListener)e.nextElement();
            listener.onDesktopIndicatorPopupClicked(menuID);
        }
    }

    public void addDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void finalize() {
    }
}

