/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.management.client.util.ResourceSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

class LDAPSearchExport
extends GenericProgressDialog
implements IEntryChangeListener,
ActionListener {
    private DSFramework _framework;
    private DSExportImport _ds;
    private String _fileName;
    private int _entryNumber = 0;
    private boolean _isCancelled;
    private static ResourceSet _resource = DSUtil._resource;

    public LDAPSearchExport(DSFramework dSFramework, String string, String string2) {
        super((JFrame)((Object)dSFramework), true, 7);
        this._framework = dSFramework;
        this._fileName = string;
        this.setTitle(_resource.getString("ldapsearchexport", "title"));
        this.addActionListener(this);
        this.setLabelRows(2);
        this.setTextInTextAreaLabel(_resource.getString("ldapsearchexport", "errors-label"));
        this.setTextInLabel(_resource.getString("ldapsearchexport", "startingexport-label"));
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        this._ds = new DSExportImport(lDAPConnection, string, string2, true);
        this._ds.addEntryChangeListener(this);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LDAPSearchExport.this._ds.run();
            }
        });
        thread.start();
        this.packAndShow();
    }

    public boolean entryChanged(String string, String string2) {
        boolean bl = true;
        if (!this._isCancelled && string != null) {
            ++this._entryNumber;
            if (this._entryNumber % 5 == 0) {
                String[] stringArray = new String[]{String.valueOf(this._entryNumber), DSUtil.abreviateString(string, 30)};
                this.setTextInLabel(_resource.getString("ldapsearchexport", "progresslabel-label", stringArray));
            }
            if (string2 != null) {
                if (!string.trim().equals("")) {
                    this.appendTextToTextArea(string + ": " + string2 + "\n");
                } else {
                    this.appendTextToTextArea(string2 + "\n");
                }
            }
        } else {
            bl = false;
            this.waitForClose();
            boolean bl2 = this._ds.getStatus();
            if (bl2) {
                if (!this._isCancelled) {
                    String[] stringArray = new String[]{DSUtil.abreviateString(this._fileName, 40), String.valueOf(this._entryNumber)};
                    this.setTextInLabel(_resource.getString("ldapsearchexport", "succeeded-label", stringArray));
                } else {
                    String[] stringArray = new String[]{DSUtil.abreviateString(this._fileName, 40)};
                    this.setTextInLabel(_resource.getString("ldapsearchexport", "cancelled-label", stringArray));
                }
            } else {
                this.setTextInLabel(_resource.getString("ldapsearchexport", "error-label"));
                Exception exception = this._ds.getException();
                if (exception != null && exception instanceof LDAPException) {
                    if (this._ds.getChainingSuffix() != null) {
                        String string3 = ((LDAPException)((Object)exception)).getLDAPErrorMessage();
                        String[] stringArray = new String[]{this._ds.getChainingSuffix(), DSUtil.getLDAPErrorMessage((LDAPException)((Object)exception))};
                        String string4 = _resource.getString("ldapsearchexport", "failedinchaining-label", stringArray);
                        this.appendTextToTextArea(string4 + "\n");
                    } else {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage((LDAPException)((Object)exception))};
                        String string5 = _resource.getString("ldapsearchexport", "genericldaperror-label", stringArray);
                        this.appendTextToTextArea(string5 + "\n");
                    }
                } else if (this._ds.getChainingSuffix() != null) {
                    String[] stringArray = new String[]{this._ds.getChainingSuffix()};
                    String string6 = _resource.getString("ldapsearchexport", "failedinchainingnonldaperror-label", stringArray);
                    this.appendTextToTextArea(string6 + "\n");
                } else {
                    String string7 = _resource.getString("ldapsearchexport", "unknownerror-label");
                    this.appendTextToTextArea(string7 + "\n");
                }
            }
        }
        return bl;
    }

    public boolean entryChanged(String string) {
        return this.entryChanged(string, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this.setTextInLabel(_resource.getString("ldapsearchexport", "cancelling-label"));
            this._isCancelled = true;
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this.closeCallBack();
        }
    }
}

