/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.LDAPBackup;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class BackupDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private boolean _isLocal;
    private JTextField _tfDirectory;
    private JButton _bBrowse;
    private JButton _bUseDefault;
    private boolean _isCancelled = true;
    private String _baseDir;
    private static final String HELP_TOKEN = "tasks-backup-help";
    private static ResourceSet _resource = DSUtil._resource;

    public BackupDialog(DSFramework dSFramework) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        ((Dialog)((Object)this)).setTitle(_resource.getString("backupdialog", "title"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        String string = this._isLocal ? "ldirectory" : "ldirectoryonserver";
        JLabel jLabel = UIFactory.makeJLabel("backupdialog", string, _resource);
        this._tfDirectory = UIFactory.makeJTextField(this, "backupdialog", string, null, 30, _resource);
        jLabel.setLabelFor(this._tfDirectory);
        this._bBrowse = UIFactory.makeJButton(this, "backupdialog", "bbrowse", _resource);
        this._bUseDefault = UIFactory.makeJButton(this, "backupdialog", "busedefault", _resource);
        this._bBrowse.setEnabled(this._isLocal);
        String string2 = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
        String string3 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
        this._baseDir = string2 + '/' + string3 + "/bak";
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfDirectory, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bUseDefault, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.top = 0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this.setComponent(jPanel);
        this.actionUseDefault();
        this.setFocusComponent(this._tfDirectory);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bBrowse) {
            String string;
            String string2 = this._tfDirectory.getText().trim();
            if (string2.length() == 0) {
                if (DSFileDialog.getDefaultDirectory() == null) {
                    DSFileDialog.setDefaultDirectory(this._baseDir);
                }
            } else {
                DSFileDialog.setDefaultDirectory(string2);
            }
            if ((string = DSFileDialog.browseDirectories(true, this._bBrowse)) != null) {
                this._tfDirectory.setText(string);
            }
        } else if (object == this._bUseDefault) {
            this.actionUseDefault();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._tfDirectory.getDocument()) {
            this.setOKButtonEnabled(!this._tfDirectory.getText().trim().equals(""));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        String string = this._tfDirectory.getText();
        DSUtil.showInformationDialog((Component)((Object)this._framework), "warning-server-permission", null, "backupdialog", _resource);
        super.okInvoked();
        new LDAPBackup(this._framework, string);
        this._isCancelled = false;
    }

    private void actionUseDefault() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String string = this._baseDir + '/' + simpleDateFormat.format(date);
        this._tfDirectory.setText(string);
    }
}

