/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.admin.dirserv.status.ILogClientListener;
import com.netscape.admin.dirserv.status.ILogParser;
import com.netscape.admin.dirserv.status.LogClient;
import com.netscape.admin.dirserv.status.LogReaderException;
import com.netscape.admin.dirserv.task.CGIReportTask;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommManager;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ResourceSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

abstract class LogReader
implements ILogClientListener {
    private ConsoleInfo _serverInfo;
    private String _logFileName;
    private String _filter;
    private ILogParser _logParser;
    private LogClient _logClient;
    protected ArrayList _logLines = new ArrayList();
    private boolean _finished;
    private Exception _exception;
    private static ResourceSet _resource = DSStatusPage._resource;
    private static int DEFAULT_RESPONSE_TIMEOUT = 180000;

    LogReader() {
    }

    public void setServerInfo(ConsoleInfo consoleInfo) {
        this._serverInfo = consoleInfo;
    }

    public ConsoleInfo getServerInfo() {
        return this._serverInfo;
    }

    public void setLogFileName(String string) {
        this._logFileName = string;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public void setParser(ILogParser iLogParser) {
        this._logParser = iLogParser;
    }

    public ILogParser getParser() {
        return this._logParser;
    }

    public void setFilter(String string) {
        this._filter = null;
        if (string != null && !string.trim().equals("")) {
            this._filter = string;
        }
    }

    public String getFilter() {
        return this._filter;
    }

    public ArrayList getLogs() throws LogReaderException {
        this._exception = null;
        this._logLines.clear();
        String string = this.getUrlString();
        Hashtable hashtable = this.getArguments();
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new LogReaderException(_resource.getString("logreader", "malformedurlexception-label"));
        }
        HttpManager httpManager = new HttpManager();
        CommManager.setSendUTF8((boolean)true);
        httpManager.setResponseTimeout(DEFAULT_RESPONSE_TIMEOUT);
        ByteArrayInputStream byteArrayInputStream = CGIReportTask.encode(hashtable);
        LogClient logClient = this.getLogClient();
        try {
            httpManager.post(uRL, (CommClient)logClient, null, (InputStream)byteArrayInputStream, ((InputStream)byteArrayInputStream).available(), 3);
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{iOException.getMessage()};
            throw new LogReaderException(_resource.getString("logreader", "error-posting-label", stringArray));
        }
        this.waitForFinish();
        if (this._exception != null) {
            String[] stringArray = new String[]{this._exception.getMessage()};
            throw new LogReaderException(_resource.getString("logreader", "error-reading-label", stringArray));
        }
        return this._logLines;
    }

    public void logReadingFinished() {
        this.finish();
    }

    public void logLineRead(Object object) {
        this._logLines.add(object);
    }

    public void errorReading(Exception exception) {
        this._exception = exception;
    }

    private LogClient getLogClient() {
        if (this._logClient == null) {
            this._logClient = new LogClient();
            this._logClient.addListener(this);
            this._logClient.setAuthenticationDn((String)this._serverInfo.get("AdminUsername"));
            this._logClient.setAuthenticationPwd((String)this._serverInfo.get("AdminUserPassword"));
        }
        this._logClient.setParser(this.getParser());
        return this._logClient;
    }

    protected abstract String getUrlString();

    protected abstract Hashtable getArguments();

    private synchronized void waitForFinish() {
        this._finished = false;
        try {
            while (!this._finished) {
                this.wait();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void finish() {
        this._finished = true;
        try {
            this.notify();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

