/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.ppoledit.RoleAndCosAndPpolLinker;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;

public class RoleCache {
    Vector _roleLinks = new Vector();
    Vector _roleDNs = new Vector();
    Vector _roleNames = new Vector();
    Vector _roleDescriptions = new Vector();
    Vector _addRecords = new Vector();
    Vector _removeRecords = new Vector();
    boolean _recordingOn;
    boolean _keepDanglingRole = true;
    RoleTableModel _tableModel = new RoleTableModel();
    RoleAndCosAndPpolLinker _linker;
    private static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "roleCache";
    private static final String NSROLEDN_ATTR = "nsRoleDN";
    private static final String NSROLE_ATTR = "nsRole";
    private static final String[] ROLE_ATTRS = new String[]{"nsRoleDN", "nsRole"};
    private static final String CN_ATTR = "cn";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String OBJECTCLASS_ATTR = "objectclass";
    public static final String[] BASIC_ATTRS = new String[]{"cn", "description", "objectclass"};

    public RoleCache() {
        this(false);
    }

    public RoleCache(boolean bl) {
    }

    public void add(String string, LDAPConnection lDAPConnection) throws LDAPException {
        try {
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, BASIC_ATTRS, null);
            this.add(lDAPEntry, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                throw lDAPException;
            }
            if (this._keepDanglingRole) {
                this.addDangling(string);
            }
            Debug.println((String)("RoleCache.add: skipping " + string + " because it does not exist"));
        }
    }

    public void add(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        if (this.isRoleDefinition(lDAPEntry)) {
            String string = lDAPEntry.getDN();
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(CN_ATTR);
            LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute(DESCRIPTION_ATTR);
            LDAPAttribute lDAPAttribute3 = lDAPEntry.getAttribute(OBJECTCLASS_ATTR);
            JLabel jLabel = new JLabel(this.makeValueString(lDAPAttribute));
            jLabel.setIcon((Icon)this.makeIcon(lDAPAttribute3));
            String string2 = this.makeValueString(lDAPAttribute2);
            JLabel jLabel2 = new JLabel("");
            RemoteImage remoteImage = this.getIconLinked(lDAPEntry, lDAPConnection);
            if (remoteImage != null) {
                jLabel2.setIcon((Icon)remoteImage);
            }
            this._roleDNs.addElement(string);
            this._roleNames.addElement(jLabel);
            this._roleDescriptions.addElement(string2);
            this._roleLinks.addElement(jLabel2);
            this.sortRoles();
            this._tableModel.fireTableDataChanged();
            this.updateRecording(string, true);
        } else {
            Debug.println((String)("RoleCache.add: skipping " + lDAPEntry.getDN() + " because it's not a role"));
        }
    }

    private RemoteImage getIconLinked(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        DN dN = new DN(lDAPEntry.getDN());
        String string = dN.getParent().toString();
        this._linker = new RoleAndCosAndPpolLinker(lDAPConnection, string, lDAPEntry.getDN());
        if (this._linker.initializeCosSchemaIfExists()) {
            String string2 = _resource.getString("EntryObject", "passwordpolicy-icon-16");
            return DSUtil.getPackageImage(string2);
        }
        return null;
    }

    public void sync(String string, LDAPConnection lDAPConnection) throws LDAPException {
        int n = this._roleDNs.indexOf(string);
        if (n == -1) {
            Debug.println((String)("RoleCache.sync: skipping " + string + " because it is not in the cache"));
        } else {
            try {
                LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, BASIC_ATTRS, null);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(DESCRIPTION_ATTR);
                this._roleDescriptions.setElementAt(this.makeValueString(lDAPAttribute), n);
                this._tableModel.fireTableDataChanged();
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("RoleCache.add of " + string + ": " + (Object)((Object)lDAPException)));
            }
        }
    }

    public void remove(String string) {
        int n = this._roleDNs.indexOf(string);
        if (n != -1) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        this.updateRecording((String)this._roleDNs.elementAt(n), false);
        this._roleDNs.removeElementAt(n);
        this._roleNames.removeElementAt(n);
        this._roleDescriptions.removeElementAt(n);
        this._roleLinks.removeElementAt(n);
        this._tableModel.fireTableDataChanged();
    }

    public void clear() {
        this.clearRecording();
        this._roleDNs.removeAllElements();
        this._roleNames.removeAllElements();
        this._roleDescriptions.removeAllElements();
        this._roleLinks.removeAllElements();
        this._tableModel.fireTableDataChanged();
    }

    public boolean contains(String string) {
        return this._roleDNs.indexOf(string) != -1;
    }

    public boolean contains(DN dN) {
        boolean bl = false;
        Enumeration enumeration = this._roleDNs.elements();
        while (enumeration.hasMoreElements() && !bl) {
            if (!dN.equals(new DN((String)enumeration.nextElement()))) continue;
            bl = true;
        }
        return bl;
    }

    public void enableRecording(boolean bl) {
        this._recordingOn = bl;
        this._addRecords.removeAllElements();
        this._removeRecords.removeAllElements();
    }

    public void saveRecording(String string, LDAPConnection lDAPConnection) throws LDAPException {
        LDAPModification[] lDAPModificationArray;
        LDAPAttribute lDAPAttribute;
        LDAPModification lDAPModification = null;
        if (this._addRecords.size() >= 1) {
            lDAPAttribute = new LDAPAttribute(NSROLEDN_ATTR);
            lDAPModificationArray = this._addRecords.elements();
            while (lDAPModificationArray.hasMoreElements()) {
                lDAPAttribute.addValue((String)lDAPModificationArray.nextElement());
            }
            lDAPModification = new LDAPModification(0, lDAPAttribute);
        }
        lDAPAttribute = null;
        if (this._removeRecords.size() >= 1) {
            lDAPModificationArray = new LDAPAttribute(NSROLEDN_ATTR);
            Enumeration enumeration = this._removeRecords.elements();
            while (enumeration.hasMoreElements()) {
                lDAPModificationArray.addValue((String)enumeration.nextElement());
            }
            lDAPAttribute = new LDAPModification(1, (LDAPAttribute)lDAPModificationArray);
        }
        if (lDAPModification != null && lDAPAttribute != null) {
            lDAPModificationArray = new LDAPModification[]{lDAPModification, lDAPAttribute};
            lDAPConnection.modify(string, lDAPModificationArray);
        } else if (lDAPModification != null) {
            lDAPConnection.modify(string, lDAPModification);
        } else if (lDAPAttribute != null) {
            lDAPConnection.modify(string, (LDAPModification)lDAPAttribute);
        }
    }

    public boolean isRecordingEmpty() {
        return this._addRecords.size() + this._removeRecords.size() == 0;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public String getRoleDN(int n) {
        return (String)this._roleDNs.elementAt(n);
    }

    public Vector getRoleDNs() {
        return (Vector)this._roleDNs.clone();
    }

    public boolean isEmpty() {
        return this._roleDNs.isEmpty();
    }

    private boolean isRoleDefinition(LDAPEntry lDAPEntry) {
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(OBJECTCLASS_ATTR);
        if (lDAPAttribute == null) {
            Debug.println((String)"RoleCache.isRoleDefinition: cannot find objectclass !");
        } else {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && !bl) {
                String string = (String)enumeration.nextElement();
                bl = string.equalsIgnoreCase("nsroledefinition");
            }
        }
        return bl;
    }

    private void addDangling(String string) {
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
        JLabel jLabel = new JLabel(stringArray[0]);
        String string2 = _resource.getString(_section, "dangling-role-icon");
        jLabel.setIcon((Icon)DSUtil.getPackageImage(string2));
        JLabel jLabel2 = new JLabel("");
        this._roleDNs.addElement(string);
        this._roleNames.addElement(jLabel);
        this._roleDescriptions.addElement("");
        this._roleLinks.addElement(jLabel2);
        this.sortRoles();
        this._tableModel.fireTableDataChanged();
        this.updateRecording(string, true);
    }

    private String makeValueString(LDAPAttribute lDAPAttribute) {
        String string = null;
        if (lDAPAttribute == null) {
            string = "";
        } else {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            if (enumeration == null) {
                Debug.println((String)("RoleTableModel.makeStringValue: cannot get values from " + lDAPAttribute));
                string = "";
            } else {
                string = (String)enumeration.nextElement();
            }
        }
        return string;
    }

    private void updateRecording(String string, boolean bl) {
        if (this._recordingOn) {
            if (bl) {
                int n = this._removeRecords.indexOf(string);
                if (n == -1) {
                    this._addRecords.addElement(string);
                } else {
                    this._removeRecords.removeElementAt(n);
                }
            } else {
                int n = this._addRecords.indexOf(string);
                if (n == -1) {
                    this._removeRecords.addElement(string);
                } else {
                    this._addRecords.removeElementAt(n);
                }
            }
        }
    }

    private void clearRecording() {
        this._removeRecords.removeAllElements();
        this._addRecords.removeAllElements();
    }

    private void sortRoles() {
        boolean bl;
        int n = this._roleDNs.size();
        do {
            bl = true;
            int n2 = 0;
            while (n2 < n - 1) {
                JLabel jLabel = (JLabel)this._roleNames.elementAt(n2);
                JLabel jLabel2 = (JLabel)this._roleNames.elementAt(n2 + 1);
                if (jLabel.getText().compareTo(jLabel2.getText()) > 0) {
                    bl = false;
                    RoleCache.swapElements(this._roleDNs, n2, n2 + 1);
                    RoleCache.swapElements(this._roleNames, n2, n2 + 1);
                    RoleCache.swapElements(this._roleDescriptions, n2, n2 + 1);
                    RoleCache.swapElements(this._roleLinks, n2, n2 + 1);
                }
                ++n2;
            }
        } while (!bl);
    }

    RemoteImage makeIcon(LDAPAttribute lDAPAttribute) {
        String string = null;
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && string == null) {
                String string2 = ((String)enumeration.nextElement()).toLowerCase();
                string = _resource.getString("EntryObject", string2 + "-icon");
            }
        }
        if (string == null) {
            string = _resource.getString("EntryObject", "default-icon");
        }
        return DSUtil.getPackageImage(string);
    }

    private static void swapElements(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        Object e2 = vector.elementAt(n2);
        vector.setElementAt(e2, n);
        vector.setElementAt(e, n2);
    }

    class RoleTableModel
    extends AbstractTableModel {
        static /* synthetic */ Class class$javax$swing$JLabel;
        static /* synthetic */ Class class$java$lang$String;

        RoleTableModel() {
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return _resource.getString(RoleCache._section, "header-name");
            }
            if (n == 1) {
                return _resource.getString(RoleCache._section, "header-description");
            }
            return _resource.getString(RoleCache._section, "header-ppolLink");
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return RoleCache.this._roleDNs.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return RoleCache.this._roleNames.elementAt(n);
            }
            if (n2 == 1) {
                return RoleCache.this._roleDescriptions.elementAt(n);
            }
            return RoleCache.this._roleLinks.elementAt(n);
        }

        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        public void fireTableRowsDeleted(int n, int n2) {
            super.fireTableRowsDeleted(n, n2);
        }

        public void fireTableRowsInserted(int n, int n2) {
            super.fireTableRowsInserted(n, n2);
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            if (n == 0) {
                clazz = class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = RoleTableModel.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
            } else if (n == 1) {
                clazz = class$java$lang$String == null ? (class$java$lang$String = RoleTableModel.class$("java.lang.String")) : class$java$lang$String;
            } else if (n == 2) {
                clazz = class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = RoleTableModel.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
            } else {
                Thread.dumpStack();
            }
            return clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

