/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.propedit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.propedit.EntryPageDescription;
import com.netscape.admin.dirserv.propedit.IDSPropertyModel;
import com.netscape.management.client.util.Debug;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSchema;

public class DSPropertyModel
implements IDSPropertyModel,
Serializable {
    private static LDAPSchema _schema = null;
    private LDAPEntry _entry = null;
    private Vector _pages = new Vector();
    private Hashtable _attributes = new Hashtable();

    protected DSPropertyModel() {
    }

    public DSPropertyModel(LDAPSchema lDAPSchema, LDAPEntry lDAPEntry) {
        _schema = lDAPSchema;
        this._entry = lDAPEntry;
        this.checkObjectClasses();
    }

    public DSPropertyModel(LDAPSchema lDAPSchema, LDAPEntry lDAPEntry, EntryPageDescription entryPageDescription) {
        this(lDAPSchema, lDAPEntry);
        this.addPage(entryPageDescription);
    }

    public DSPropertyModel(LDAPSchema lDAPSchema, LDAPEntry lDAPEntry, Vector vector) {
        this(lDAPSchema, lDAPEntry);
        this._pages = (Vector)vector.clone();
    }

    private void checkObjectClasses() {
        this._attributes = DSUtil.getAllAttributeList(_schema, this._entry);
    }

    public void updateObjectClasses(Vector vector) {
        this._attributes = DSUtil.getAllAttributeList(_schema, vector);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.elements();
    }

    public String getTitle() {
        return this._entry.getDN();
    }

    public void addPage(EntryPageDescription entryPageDescription) {
        this._pages.addElement(entryPageDescription);
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public int getItemCount(int n) {
        try {
            EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
            return entryPageDescription.getItemCount();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public String getItemName(int n, int n2) {
        try {
            EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
            return entryPageDescription.getItemName(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public String getItemLabel(int n, int n2) {
        try {
            EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
            return entryPageDescription.getItemLabel(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int getItemValueCount(int n, int n2) {
        try {
            EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
            String string = entryPageDescription.getItemName(n2);
            LDAPAttribute lDAPAttribute = this._entry.getAttribute(string);
            if (lDAPAttribute != null) {
                return lDAPAttribute.size();
            }
            Debug.println((String)("DSPropertyModel.getItemValueCount:  no attribute for " + string));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return 0;
    }

    public static int getAttributeType(String string) {
        LDAPAttributeSchema lDAPAttributeSchema = _schema.getAttribute(string);
        if (lDAPAttributeSchema == null) {
            lDAPAttributeSchema = _schema.getAttribute(LDAPAttribute.getBaseName((String)string));
        }
        if (lDAPAttributeSchema != null) {
            return lDAPAttributeSchema.getSyntax();
        }
        return -1;
    }

    public static boolean isSingleValued(String string) {
        LDAPAttributeSchema lDAPAttributeSchema = _schema.getAttribute(string);
        if (lDAPAttributeSchema == null) {
            lDAPAttributeSchema = _schema.getAttribute(LDAPAttribute.getBaseName((String)string));
        }
        if (lDAPAttributeSchema != null) {
            return lDAPAttributeSchema.isSingleValued();
        }
        return false;
    }

    public int getPropertyType(String string) {
        return DSPropertyModel.getPropertyType(string, _schema);
    }

    public static int getPropertyType(String string, LDAPSchema lDAPSchema) {
        try {
            LDAPAttributeSchema lDAPAttributeSchema = lDAPSchema.getAttribute(string);
            if (lDAPAttributeSchema == null) {
                lDAPAttributeSchema = lDAPSchema.getAttribute(LDAPAttribute.getBaseName((String)string));
            }
            if (lDAPAttributeSchema != null) {
                if (string.equalsIgnoreCase("jpegphoto")) {
                    return 2;
                }
                if (string.equalsIgnoreCase("usercertificate;binary")) {
                    return 3;
                }
                if (string.equalsIgnoreCase("userpassword")) {
                    return 6;
                }
                if (string.equalsIgnoreCase("aci")) {
                    return 1;
                }
                if (string.equalsIgnoreCase("mgmemmailuserpassword")) {
                    return 6;
                }
                int n = lDAPAttributeSchema.getSyntax();
                if (n == 1 || n == 4 || n == 5 || n == 3 || n == 0) {
                    return 1;
                }
                if (n == 6) {
                    return 5;
                }
                return 0;
            }
            Debug.println((String)("DSPropertyModel.getPropertyType: no known attribute " + string));
            return 1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public int getItemValueType(int n, int n2) {
        EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
        String string = entryPageDescription.getItemName(n2);
        return this.getPropertyType(string);
    }

    public Vector getItemValues(int n, int n2) {
        int n3 = this.getItemValueType(n, n2);
        if (n3 == -1) {
            return null;
        }
        try {
            EntryPageDescription entryPageDescription = (EntryPageDescription)this._pages.elementAt(n);
            String string = entryPageDescription.getItemName(n2);
            LDAPAttribute lDAPAttribute = this._entry.getAttribute(string);
            if (lDAPAttribute != null) {
                Vector vector = new Vector();
                Enumeration enumeration = null;
                enumeration = n3 == 1 || n3 == 5 || n3 == 6 ? lDAPAttribute.getStringValues() : lDAPAttribute.getByteValues();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                return vector;
            }
            Debug.println((String)("DSPropertyModel.getItemValues:  no attribute for " + string));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public LDAPSchema getSchema() {
        return _schema;
    }

    public LDAPEntry getEntry() {
        return this._entry;
    }

    public Vector getPages() {
        return this._pages;
    }
}

