/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.ppoledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.management.client.util.Debug;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class RoleAndCosAndPpolLinker {
    private String _suffixDN;
    private String _roleDN;
    private LDAPEntry _container = null;
    private LDAPEntry _cos = null;
    private LDAPEntry _cosTemplate = null;
    private LDAPEntry _ppol = null;
    private Vector _allCos;
    private LDAPConnection _ldc;
    private static final String PASSWORDPOLICY_ATTR = "passwordPolicySubentry";
    private static final String MARKED_DESCRIPTION = "Entry created by the console for password policy management.";

    public RoleAndCosAndPpolLinker(LDAPConnection lDAPConnection, String string, String string2) {
        this._ldc = lDAPConnection;
        this._suffixDN = string;
        this._roleDN = string2;
        this._allCos = new Vector();
    }

    public String getCurrentRole() {
        return this._roleDN;
    }

    public String getCurrentSuffix() {
        return this._suffixDN;
    }

    public boolean isSchemaExist() {
        return this._container != null && this._cos != null && this._cosTemplate != null;
    }

    public boolean isSchemaValid() {
        return this.isSchemaExist() && this._ppol != null;
    }

    public LDAPEntry getContainerGuessed() {
        return this._container;
    }

    public LDAPEntry getCosGuessed() {
        return this._cos;
    }

    public LDAPEntry getCosTemplateGuessed() {
        return this._cosTemplate;
    }

    public LDAPEntry getPpolGuessed() {
        return this._ppol;
    }

    public String guessPPolDN() {
        if (this._cosTemplate != null) {
            return this.getPPolDN(this._cosTemplate);
        }
        return null;
    }

    public boolean initializeCosSchemaIfExists() {
        this._allCos = this.getAllCosForPPol();
        Vector vector = null;
        vector = this.getAllContainerForPPol(this._allCos);
        Object var2_2 = null;
        this._cosTemplate = this.guessCosTemplateForPPol(vector);
        Object var3_3 = null;
        if (this._cosTemplate != null) {
            this._ppol = this.guessPPol(this._cosTemplate);
        }
        if (this._cosTemplate != null) {
            this._cos = this.guessCos();
            this._container = this.guessContainer();
        }
        return this.isSchemaExist();
    }

    private LDAPEntry guessPPol(LDAPEntry lDAPEntry) {
        try {
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(PASSWORDPOLICY_ATTR);
            if (lDAPAttribute != null) {
                String string = lDAPAttribute.getStringValueArray()[0];
                String[] stringArray = new String[]{"*", "objectclass", "ldapsubentry"};
                LDAPEntry lDAPEntry2 = DSUtil.readEntry(this._ldc, string, stringArray, null);
                return lDAPEntry2;
            }
            return null;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.guessPPol(LDAPEntry)  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            return null;
        }
    }

    private LDAPEntry guessContainer() {
        if (this._cosTemplate != null) {
            try {
                DN dN = new DN(this._cosTemplate.getDN());
                String string = dN.getParent().toString();
                String[] stringArray = new String[]{"*", "objectclass"};
                LDAPEntry lDAPEntry = DSUtil.readEntry(this._ldc, string, stringArray, null);
                return lDAPEntry;
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                Debug.println((String)("RoleAndCosAndPpolLiner.guessContainer()  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            }
        }
        return null;
    }

    private LDAPEntry guessCos() {
        if (this._cosTemplate != null) {
            DN dN = new DN(this._cosTemplate.getDN());
            String string = dN.getParent().toString();
            int n = 0;
            while (n < this._allCos.size()) {
                String string2;
                LDAPEntry lDAPEntry = (LDAPEntry)this._allCos.elementAt(n);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cosTemplateDn");
                if (lDAPAttribute != null && LDAPDN.equals((String)(string2 = lDAPAttribute.getStringValueArray()[0]), (String)string)) {
                    return lDAPEntry;
                }
                ++n;
            }
            return null;
        }
        return null;
    }

    private LDAPEntry guessCosTemplateForPPol(Vector vector) {
        Vector<LDAPEntry> vector2 = new Vector<LDAPEntry>();
        try {
            String string;
            LDAPEntry lDAPEntry;
            int n = 0;
            while (n < vector.size()) {
                lDAPEntry = (LDAPEntry)vector.elementAt(n);
                string = lDAPEntry.getDN();
                String string2 = "(&(objectclass=ldapsubentry)(objectclass=cosTemplate))";
                String[] stringArray = new String[]{"*", PASSWORDPOLICY_ATTR};
                LDAPSearchResults lDAPSearchResults = null;
                try {
                    lDAPSearchResults = this._ldc.search(string, 2, string2, stringArray, false);
                }
                catch (LDAPException lDAPException) {
                    int n2 = lDAPException.getLDAPResultCode();
                    Debug.println((String)("RoleAndCosAndPpolLiner.guessCosTemplateForPPol(Vector)  : \n   Error code = " + n2 + "\n   LDAPException raised  = " + lDAPException.getMessage()));
                }
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPAttribute lDAPAttribute;
                    String string3;
                    LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                    String string4 = lDAPEntry2.getDN();
                    LDAPAttribute lDAPAttribute2 = lDAPEntry2.getAttribute("cn");
                    if (lDAPAttribute2 == null || !LDAPDN.equals((String)(string3 = lDAPAttribute2.getStringValueArray()[0]).trim(), (String)this._roleDN) || (lDAPAttribute = lDAPEntry2.getAttribute("passwordpolicysubentry")) == null) continue;
                    String string5 = lDAPAttribute.getStringValueArray()[0];
                    vector2.addElement(lDAPEntry2);
                }
                ++n;
            }
            if (vector2.size() == 1) {
                lDAPEntry = (LDAPEntry)vector2.elementAt(0);
                string = lDAPEntry.getDN();
                this._cosTemplate = lDAPEntry;
                return lDAPEntry;
            }
            if (vector2.size() > 1) {
                this._cosTemplate = (LDAPEntry)vector2.elementAt(0);
                Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.guessCosTemplateForPPol(Vector) - WARNING :\n chose a cosTemplate but there was several possibilities (" + vector2.size() + ")"));
                return (LDAPEntry)vector2.elementAt(0);
            }
            return null;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.guessCosTemplateForPPol(Vector)  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
        }
        catch (Exception exception) {
            Debug.println((String)("RoleAndCosAndPpolLiner.guessCosTemplateForPPol(Vector)  : \n   Exception raised  = " + exception.getMessage()));
            return null;
        }
        return null;
    }

    private String getPPolDN(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(PASSWORDPOLICY_ATTR);
        if (lDAPAttribute != null) {
            String string = lDAPAttribute.getStringValueArray()[0];
            return string;
        }
        return null;
    }

    private Vector getAllContainerForPPol(Vector vector) {
        Vector<LDAPEntry> vector2 = new Vector<LDAPEntry>();
        try {
            int n = 0;
            while (n < vector.size()) {
                LDAPEntry lDAPEntry = (LDAPEntry)vector.elementAt(n);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cosTemplateDN");
                String string = lDAPAttribute.getStringValueArray()[0];
                String[] stringArray = new String[]{"*", "objectclass"};
                LDAPEntry lDAPEntry2 = DSUtil.readEntry(this._ldc, string, stringArray, null);
                if (lDAPEntry2 != null) {
                    LDAPAttribute lDAPAttribute2 = lDAPEntry2.getAttribute("objectclass");
                    String[] stringArray2 = lDAPAttribute2.getStringValueArray();
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        String string2 = stringArray2[n2];
                        if (string2.toLowerCase().equals("nscontainer")) {
                            vector2.addElement(lDAPEntry2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return vector2;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.getAllContainerForPPol(Vector)  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            return vector2;
        }
        catch (Exception exception) {
            Debug.println((String)("RoleAndCosAndPpolLiner.getAllContainerForPPol(Vector)  : \n   Exception raised  = " + exception.getMessage()));
            return vector2;
        }
    }

    private Vector getAllCosForPPol() {
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        try {
            String string = "(&(objectclass=ldapsubentry)(objectclass=cosclassicdefinition))";
            String[] stringArray = new String[]{"cosTemplateDN", "cosSpecifier", "cosAttribute", "*"};
            LDAPSearchResults lDAPSearchResults = null;
            lDAPSearchResults = this._ldc.search(this._suffixDN, 2, string, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPAttribute lDAPAttribute;
                String string2;
                LDAPAttribute lDAPAttribute2;
                String string3;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = lDAPEntry.getDN();
                LDAPAttribute lDAPAttribute3 = lDAPEntry.getAttribute("cosAttribute");
                if (lDAPAttribute3 == null || !(string3 = lDAPAttribute3.getStringValueArray()[0]).toLowerCase().equals("passwordpolicysubentry operational") || (lDAPAttribute2 = lDAPEntry.getAttribute("cosSpecifier")) == null || !(string2 = lDAPAttribute2.getStringValueArray()[0]).toLowerCase().equals("nsrole") || (lDAPAttribute = lDAPEntry.getAttribute("cosTemplateDN")) == null) continue;
                String string5 = lDAPAttribute.getStringValueArray()[0];
                vector.addElement(lDAPEntry);
            }
            return vector;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.getAllCosForPPol()  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
        }
        catch (Exception exception) {
            Debug.println((String)("RoleAndCosAndPpolLiner.getAllCosForPPol()  :\n   Exception raised  = " + exception));
        }
        return vector;
    }

    private Vector getContainerCreatedByconsoleAvailable() {
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        try {
            String string = "(&(objectclass=nscontainer)(objectclass=top)(objectclass=extensibleobject))";
            String[] stringArray = new String[]{"*", "description"};
            LDAPSearchResults lDAPSearchResults = null;
            lDAPSearchResults = this._ldc.search(this._suffixDN, 2, string, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                String string2;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string3 = lDAPEntry.getDN();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("description");
                if (lDAPAttribute == null || !(string2 = lDAPAttribute.getStringValueArray()[0]).equals(MARKED_DESCRIPTION)) continue;
                vector.add(lDAPEntry);
            }
            return vector;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.getContainerCreatedByconsoleAvailable()  : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
        }
        catch (Exception exception) {
            Debug.println((String)("RoleAndCosAndPpolLiner.getContainerCreatedByconsoleAvailable() : \n   Exception raised = " + exception.getMessage()));
        }
        return vector;
    }

    private LDAPEntry createNewContainer() throws LDAPException {
        LDAPEntry lDAPEntry = null;
        try {
            String string = "cn=nsPwpTmp," + this._suffixDN;
            int n = 1;
            while (this.getLDAPEntry(string) != null) {
                string = "cn=nsPwpTmp" + n + "," + this._suffixDN;
                ++n;
            }
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "top"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsContainer"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
            lDAPAttributeSet.add(new LDAPAttribute("description", MARKED_DESCRIPTION));
            lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
            this._ldc.add(lDAPEntry);
            Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.createNewContainer() : Create COS template entry = " + lDAPEntry.getDN()));
            return lDAPEntry;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.createNewContainer()  : \n   Error code = " + n + "\n   LDAPException raised and throwed = " + lDAPException.getMessage()));
            throw lDAPException;
        }
    }

    private LDAPEntry createNewCosTemplate(LDAPEntry lDAPEntry, String string) throws LDAPException {
        String string2 = "cn=" + DSUtil.getRdnValue(this._roleDN) + "," + lDAPEntry.getDN();
        LDAPEntry lDAPEntry2 = null;
        try {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "top"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleObject"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "cosTemplate"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "ldapsubentry"));
            lDAPAttributeSet.add(new LDAPAttribute("cosPriority", "1"));
            lDAPAttributeSet.add(new LDAPAttribute(PASSWORDPOLICY_ATTR, string));
            lDAPAttributeSet.add(new LDAPAttribute("description", MARKED_DESCRIPTION));
            LDAPEntry lDAPEntry3 = this.getLDAPEntry(string2);
            if (lDAPEntry3 == null) {
                lDAPEntry2 = new LDAPEntry(string2, lDAPAttributeSet);
                this._ldc.add(lDAPEntry2);
                Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.createCos(LDAPEntry) : Create COS template entry = " + lDAPEntry2.getDN()));
                return lDAPEntry2;
            }
            return null;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.createNewCosTemplate(LDAPEntry, String)  : \n   Error code = " + n + "\n   LDAPException raised and throwed = " + lDAPException.getMessage()));
            throw lDAPException;
        }
    }

    private LDAPEntry createCos(LDAPEntry lDAPEntry) throws LDAPException {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
        String string = "";
        if (lDAPAttribute != null) {
            string = lDAPAttribute.getStringValueArray()[0];
        }
        String string2 = "cn=nsPwp_cos," + this._suffixDN;
        int n = 1;
        while (this.getLDAPEntry(string2) != null) {
            string2 = "cn=nsPwp_cos_" + n + "," + this._suffixDN;
            ++n;
        }
        try {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "top"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "ldapsubentry"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "cosSuperDefinition"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "cosClassicDefinition"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleObject"));
            lDAPAttributeSet.add(new LDAPAttribute("cosTemplateDN", lDAPEntry.getDN()));
            lDAPAttributeSet.add(new LDAPAttribute("cosSpecifier", "nsRole"));
            lDAPAttributeSet.add(new LDAPAttribute("cosAttribute", "passwordPolicySubentry operational"));
            lDAPAttributeSet.add(new LDAPAttribute("description", MARKED_DESCRIPTION));
            LDAPEntry lDAPEntry2 = new LDAPEntry(string2, lDAPAttributeSet);
            this._ldc.add(lDAPEntry2);
            Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.createCos(LDAPEntry) : Create COS entry = " + lDAPEntry2.getDN()));
            return lDAPEntry2;
        }
        catch (LDAPException lDAPException) {
            int n2 = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.createCos(LDAPEntry)  : \n   Error code = " + n2 + "\n   LDAPException raised and throwed = " + lDAPException.getMessage()));
            throw lDAPException;
        }
    }

    private LDAPEntry getCosAvailable(LDAPEntry lDAPEntry) {
        try {
            String string = "(&(objectclass=cosClassicDefinition)(objectclass=ldapsubentry))";
            String[] stringArray = new String[]{"*", "description", "cosTemplateDN"};
            LDAPSearchResults lDAPSearchResults = null;
            lDAPSearchResults = this._ldc.search(this._suffixDN, 2, string, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                LDAPAttribute lDAPAttribute = lDAPEntry2.getAttribute("description");
                LDAPAttribute lDAPAttribute2 = lDAPEntry2.getAttribute("cosTemplateDN");
                if (lDAPAttribute == null || lDAPAttribute2 == null) continue;
                String string2 = lDAPAttribute.getStringValueArray()[0];
                String string3 = lDAPAttribute2.getStringValueArray()[0];
                if (!string2.equals(MARKED_DESCRIPTION) || !LDAPDN.equals((String)string3, (String)lDAPEntry.getDN())) continue;
                return lDAPEntry2;
            }
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.getCosAvailable(LDAPEntry)  : \n   Error code = " + n + "\n   LDAPException raised " + lDAPException.getMessage()));
        }
        catch (Exception exception) {
            Debug.println((String)("RoleAndCosAndPpolLiner.getCosAvailable(LDAPEntry)  : Exception raised " + exception.getMessage()));
        }
        return null;
    }

    private LDAPEntry getLDAPEntry(String string) {
        block3: {
            String string2 = "(|(objectclass=ldapsubentry)(objectclass=*))";
            String[] stringArray = new String[]{"*"};
            LDAPSearchResults lDAPSearchResults = null;
            try {
                lDAPSearchResults = this._ldc.search(string, 2, string2, stringArray, false);
                if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                    return lDAPSearchResults.next();
                }
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 32) break block3;
                Debug.println((String)("RoleAndCosAndPpolLiner.getLDAPEntry(String)  : \n   Error code = " + n + "\n   LDAPException raised " + lDAPException.getMessage()));
            }
        }
        return null;
    }

    public void createNewSchema(String string) throws LDAPException {
        LDAPEntry lDAPEntry;
        LDAPEntry lDAPEntry2;
        LDAPEntry lDAPEntry3;
        Vector vector = this.getContainerCreatedByconsoleAvailable();
        Vector<LDAPEntry> vector2 = new Vector<LDAPEntry>();
        int n = 0;
        while (n < vector.size()) {
            LDAPEntry lDAPEntry4 = (LDAPEntry)vector.elementAt(n);
            try {
                lDAPEntry3 = this.getCosAvailable(lDAPEntry4);
                if (lDAPEntry3 == null) {
                    vector2.addElement(lDAPEntry4);
                } else {
                    lDAPEntry2 = this.createNewCosTemplate(lDAPEntry4, string);
                    if (lDAPEntry2 != null) {
                        LDAPEntry lDAPEntry5;
                        Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.createNewSchema(String)  : INFO : \n   Reuse the container entry = " + lDAPEntry4.getDN() + "\n   Reuse the cos entry = " + lDAPEntry3.getDN()));
                        this._cos = lDAPEntry3;
                        this._cosTemplate = lDAPEntry2;
                        this._container = lDAPEntry4;
                        this._ppol = lDAPEntry5 = this.getLDAPEntry(string);
                        this._allCos = new Vector();
                        return;
                    }
                }
            }
            catch (LDAPException lDAPException) {
                int n2 = lDAPException.getLDAPResultCode();
                Debug.println((String)("RoleAndCosAndPpolLiner.createNewSchema(String)  : \n   Error code = " + n2 + "\n   LDAPException raised " + lDAPException.getMessage()));
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector2.size()) {
            lDAPEntry3 = (LDAPEntry)vector2.elementAt(n3);
            lDAPEntry2 = this.createCos(lDAPEntry3);
            lDAPEntry = this.createNewCosTemplate(lDAPEntry3, string);
            if (lDAPEntry != null && lDAPEntry2 != null) {
                LDAPEntry lDAPEntry6;
                Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.createNewSchema(String)  : INFO : \n   Reuse the container " + lDAPEntry3.getDN()));
                this._cos = lDAPEntry2;
                this._cosTemplate = lDAPEntry;
                this._container = lDAPEntry3;
                this._ppol = lDAPEntry6 = this.getLDAPEntry(string);
                this._allCos = new Vector();
                return;
            }
            ++n3;
        }
        try {
            lDAPEntry3 = this.createNewContainer();
            lDAPEntry2 = this.createNewCosTemplate(lDAPEntry3, string);
            lDAPEntry = this.createCos(lDAPEntry3);
            LDAPEntry lDAPEntry7 = this.getLDAPEntry(string);
            this._container = lDAPEntry3;
            this._cos = lDAPEntry;
            this._cosTemplate = lDAPEntry2;
            this._ppol = lDAPEntry7;
            this._allCos = new Vector();
        }
        catch (LDAPException lDAPException) {
            int n4 = lDAPException.getLDAPResultCode();
            Debug.println((String)("RoleAndCosAndPpolLiner.createNewSchema(String)  : \n   Error code = " + n4 + "\n   LDAPException raised and throwed" + lDAPException.getMessage()));
            throw lDAPException;
        }
    }

    public void removeSchema() throws LDAPException {
        String[] stringArray;
        String string;
        String string2;
        LDAPAttribute lDAPAttribute;
        LDAPException lDAPException = null;
        if (this._cosTemplate != null) {
            try {
                this._ldc.delete(this._cosTemplate.getDN());
                Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.removeSchema() : REMOVE " + this._cosTemplate.getDN()));
            }
            catch (LDAPException lDAPException2) {
                int n = lDAPException2.getLDAPResultCode();
                Debug.println((String)("RoleAndCosAndPpolLiner.removeSchema() for the cosTemplate removal : \n   Error code = " + n + "\n   LDAPException raised and throwed " + lDAPException2.getMessage()));
                lDAPException = lDAPException2;
            }
        }
        if (this._container != null && (lDAPAttribute = this._container.getAttribute("description")) != null && (string2 = lDAPAttribute.getStringValueArray()[0]).equals(MARKED_DESCRIPTION)) {
            try {
                string = "(|(objectclass=ldapsubentry)(objectclass=*))";
                stringArray = new String[]{"*"};
                LDAPSearchResults lDAPSearchResults = null;
                lDAPSearchResults = this._ldc.search(this._container.getDN(), 2, string, stringArray, false);
                if (lDAPSearchResults.getCount() == 1) {
                    Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.removeSchema() : REMOVE " + this._container.getDN()));
                    this._ldc.delete(this._container.getDN());
                }
            }
            catch (LDAPException lDAPException3) {
                int n = lDAPException3.getLDAPResultCode();
                Debug.println((String)("RoleAndCosAndPpolLiner.removeSchema() for the container removal : \n   Error code = " + n + "\n   LDAPException raised and throwed " + lDAPException3.getMessage()));
                lDAPException = lDAPException3;
            }
        }
        if (this._cos != null) {
            String string3;
            lDAPAttribute = this._cos.getAttribute("description");
            if (lDAPAttribute != null && (string3 = lDAPAttribute.getStringValueArray()[0]).equals(MARKED_DESCRIPTION)) {
                try {
                    string = this._cos.getAttribute("cosTemplateDN");
                    stringArray = string.getStringValueArray()[0];
                    if (this.getLDAPEntry((String)stringArray) == null) {
                        this._ldc.delete(this._cos.getDN());
                        Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.removeSchema() : REMOVE " + this._cos.getDN()));
                    }
                }
                catch (LDAPException lDAPException4) {
                    int n = lDAPException4.getLDAPResultCode();
                    Debug.println((String)("RoleAndCosAndPpolLiner.removeSchema() for the cos removal : \n   Error code = " + n + "\n   LDAPException raised and throwed " + lDAPException4.getMessage()));
                    lDAPException = lDAPException4;
                }
            }
            if (lDAPException != null) {
                throw lDAPException;
            }
        }
    }

    public void updateCosTemplate(String string) throws LDAPException {
        LDAPEntry lDAPEntry = this.getLDAPEntry(string);
        if (this.isSchemaExist() && this._cosTemplate != null) {
            try {
                LDAPAttribute lDAPAttribute = new LDAPAttribute(PASSWORDPOLICY_ATTR, string);
                LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
                this._ldc.modify(this._cosTemplate.getDN(), lDAPModification);
                Debug.println((int)0, (String)("RoleAndCosAndPpolLiner.updateCosTemplate(String ppolDN): modified " + this._cosTemplate.getDN()));
                this._cosTemplate = this.getLDAPEntry(this._cosTemplate.getDN());
                this._ppol = this.getLDAPEntry(string);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                Debug.println((String)("RoleAndCosAndPpolLiner.updateCosTemplate(String)  : \n   Error code = " + n + "\n   LDAPException raised and throwed " + lDAPException.getMessage()));
                throw lDAPException;
            }
        }
    }
}

