/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.ppoledit;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSResourceEditor;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.SubtreeSelectionDialog;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.ppoledit.RoleAndCosAndPpolLinker;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;

public class PasswordPolicyEditorDialog
extends AbstractDialog
implements ActionListener {
    protected DSFramework _framework;
    protected ConsoleInfo _info;
    protected JPanel _contentPane;
    protected JPanel _assignedPpolPane;
    protected JPanel _buttonsPanel;
    protected JPanel _infoPane;
    protected JPanel _warningPane;
    protected JLabel _lAssignedPpolName;
    protected JLabel _lAssignedPpol;
    protected JTextArea _lInfoLabel;
    protected JLabel _lWarningLabel;
    protected JButton _replaceButton;
    protected JButton _removeButton;
    protected JButton _editButton;
    protected JButton _showButton;
    protected static final ResourceSet _resource = DSUtil._resource;
    protected static final String _section = "passwordPolicyEditorDialog";
    protected static final String PASSWORDPOLICY_CLASS = "passwordpolicy";
    protected static final String PASSWORDPOLICY_ATTR = "passwordPolicySubentry";
    protected String _ppolEntryDN = null;
    protected String _ppolEntryName;
    protected boolean _ppolIsAssigned = false;
    protected boolean _entryHasPpol = false;
    protected String _roleGivingPPol = "";
    protected Icon _warningIcon;
    private SubtreeSelectionDialog _browseDlg;

    public PasswordPolicyEditorDialog(DSFramework dSFramework, ConsoleInfo consoleInfo) {
        super((Frame)((Object)dSFramework), _resource.getString(_section, "title"), true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "description"));
        this._framework = dSFramework;
        this._info = consoleInfo;
        String string = DSUtil._resource.getString(_section, "warning-icon");
        this._warningIcon = DSUtil.getPackageImage(string);
        this.createComponents();
        this.initialize();
        this.layoutComponents();
    }

    protected boolean ppolAssignedExist() {
        try {
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            String[] stringArray = new String[]{"*"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, this._ppolEntryDN, stringArray, null);
            return lDAPEntry != null;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("PasswordPolicyEditorDialog.ppolAssignedExist() \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            return false;
        }
    }

    protected boolean ppolAssignedisPPol() {
        try {
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            String[] stringArray = new String[]{"objectclass"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, this._ppolEntryDN, stringArray, null);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
            String[] stringArray2 = lDAPAttribute.getStringValueArray();
            int n = 0;
            while (n < stringArray2.length) {
                String string = stringArray2[n];
                if (string.toLowerCase().equals(PASSWORDPOLICY_CLASS)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("PasswordPolicyEditorDialog.ppolAssignedisPPol() \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
            return false;
        }
    }

    protected String getRoleGivingPPol() {
        return this._roleGivingPPol;
    }

    protected boolean isPPolInherited() {
        return !this._roleGivingPPol.equals("");
    }

    protected String guessRoleGivenPPol() {
        if (this._ppolIsAssigned) {
            Vector vector = new Vector();
            try {
                LDAPAttribute lDAPAttribute;
                LDAPConnection lDAPConnection = this._info.getLDAPConnection();
                String string = this._info.getCurrentDN();
                String[] stringArray = new String[]{"nsrole"};
                LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, stringArray, null);
                if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("nsrole")) != null) {
                    String string2 = this.getSuffixForDn(this._info.getCurrentDN());
                    String[] stringArray2 = lDAPAttribute.getStringValueArray();
                    int n = 0;
                    while (n < stringArray2.length) {
                        DN dN;
                        String string3 = stringArray2[n];
                        RoleAndCosAndPpolLinker roleAndCosAndPpolLinker = new RoleAndCosAndPpolLinker(this._info.getLDAPConnection(), string2, string3);
                        if (roleAndCosAndPpolLinker.initializeCosSchemaIfExists() && (dN = new DN(roleAndCosAndPpolLinker.guessPPolDN())).equals(new DN(this._ppolEntryDN))) {
                            return string3;
                        }
                        ++n;
                    }
                }
                return "";
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                Debug.println((String)("PasswordPolicyEditorDialog.guessRoleGivenPPol() : NO Role found \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
                return "";
            }
            catch (Exception exception) {
                Debug.println((String)("PasswordPolicyEditorDialog.guessRoleGivenPPol() : NO Role found \n   Exception raised = " + exception.getMessage()));
                return "";
            }
        }
        return "";
    }

    protected void setAllTextPPolAssigned(boolean bl) {
        this._replaceButton.setText(_resource.getString(_section, "replaceButton-label"));
        this._lInfoLabel.setText("");
        this._lInfoLabel.setColumns(1);
        this._lAssignedPpol.setText(_resource.getString(_section, "policyLabel"));
        this._lWarningLabel.setText("");
        this._lWarningLabel.setIcon(null);
        this._editButton.setEnabled(true);
        this._showButton.setEnabled(true);
        this._replaceButton.setEnabled(true);
        this._removeButton.setEnabled(true);
        if (this._ppolEntryName.trim().equals("")) {
            this._showButton.setText(_resource.getString(_section, "showNameButton-label"));
            this._showButton.setEnabled(false);
        }
        if (this._showButton.getText().equals(_resource.getString(_section, "showDNButton-label"))) {
            this._lAssignedPpolName.setText(this._ppolEntryName);
        } else {
            this._lAssignedPpolName.setText(this._ppolEntryDN);
        }
        if (!this.ppolAssignedisPPol()) {
            this._lWarningLabel.setText(_resource.getString(_section, "notPpolEntry"));
            this._lWarningLabel.setIcon(this._warningIcon);
            this._editButton.setEnabled(false);
        }
        if (!bl) {
            this._lWarningLabel.setText(_resource.getString(_section, "ppolNoLongerExist"));
            this._lWarningLabel.setIcon(this._warningIcon);
        }
        if (this.isPPolInherited()) {
            this._lInfoLabel.setText(_resource.getString(_section, "ppolInherited", new String[]{this._roleGivingPPol}));
            this._lInfoLabel.setColumns(50);
            this._replaceButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        }
        this.pack();
    }

    protected void setAllTextPPolNotAssigned() {
        this._replaceButton.setText(_resource.getString(_section, "assignButton-label"));
        this._lAssignedPpol.setText(_resource.getString(_section, "noPPolAssigned-entry"));
        this._lInfoLabel.setText(_resource.getString(_section, "infoGlobalPolicy"));
        this._lInfoLabel.setColumns(50);
        this._lWarningLabel.setText("");
        this._lWarningLabel.setIcon(null);
    }

    protected void initialize() {
        try {
            this._ppolEntryDN = "";
            this._entryHasPpol = false;
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            String string = this._info.getCurrentDN();
            String[] stringArray = new String[]{"passwordpolicysubentry"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, string, stringArray, null);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("passwordpolicysubentry");
            if (lDAPAttribute == null || lDAPAttribute != null && lDAPAttribute.getStringValueArray()[0].trim().equals("")) {
                this._ppolIsAssigned = false;
                this.setAllTextPPolNotAssigned();
                this._roleGivingPPol = this.guessRoleGivenPPol();
            } else {
                this._entryHasPpol = true;
                this._ppolIsAssigned = true;
                this._ppolEntryDN = lDAPAttribute.getStringValueArray()[0];
                this.displayNewPPol(this._ppolEntryDN);
                this._roleGivingPPol = this.guessRoleGivenPPol();
                this.setAllTextPPolAssigned(this.ppolAssignedExist());
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("PasswordPolicyEditorDialog.initialize : LDAPException catched : " + this._ppolEntryDN + " is obsolete"));
            this._roleGivingPPol = this.guessRoleGivenPPol();
            this.setAllTextPPolAssigned(this.ppolAssignedExist());
        }
        catch (Exception exception) {
            Debug.println((String)("PasswordPolicyEditorDialog.initialize: Exception raised = " + exception.getMessage()));
            this._roleGivingPPol = this.guessRoleGivenPPol();
            this.setAllTextPPolAssigned(this.ppolAssignedExist());
        }
    }

    protected boolean isPPolAssignedExists() {
        if (this._ppolEntryDN == null || this._ppolEntryDN.equals("")) {
            return false;
        }
        try {
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            String[] stringArray = new String[]{"*"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, this._ppolEntryDN, stringArray, null);
            return lDAPEntry != null;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("PasswordPolicyEditorDialog.isPPolAssignedExists: LDAPException catched = " + lDAPException.getMessage()));
        }
        catch (Exception exception) {
            Debug.println((String)("PasswordPolicyEditorDialog.isPPolAssignedExists: Exception catched = " + exception.getMessage()));
        }
        return false;
    }

    protected void createComponents() {
        this._contentPane = new JPanel(new GridBagLayout());
        this._replaceButton = UIFactory.makeJButton(null, _section, "replaceButton", _resource);
        this._removeButton = UIFactory.makeJButton(null, _section, "removeButton", _resource);
        this._editButton = UIFactory.makeJButton(null, _section, "editButton", _resource);
        this._showButton = UIFactory.makeJButton(null, _section, "showDNButton", _resource);
        this._replaceButton.addActionListener(this);
        this._removeButton.addActionListener(this);
        this._editButton.addActionListener(this);
        this._showButton.addActionListener(this);
        JButton[] jButtonArray = new JButton[]{this._replaceButton, this._removeButton, this._editButton, this._showButton};
        JButtonFactory.resize((JButton[])jButtonArray);
        this._buttonsPanel = new JPanel(new GridBagLayout());
        this._assignedPpolPane = new JPanel();
        this._lAssignedPpolName = new JLabel("");
        this._lAssignedPpolName.setLabelFor(this._contentPane);
        this._lAssignedPpolName.setPreferredSize(new Dimension(300, (int)new JLabel("Toto ").getPreferredSize().getHeight()));
        this._lAssignedPpol = new JLabel(_resource.getString(_section, "policyLabel"));
        this._infoPane = new JPanel();
        this._lInfoLabel = new MultilineLabel("", 2, 40);
        this._infoPane.add(this._lInfoLabel);
        ((MultilineLabel)this._lInfoLabel).setLabelFor((Component)this._infoPane);
        this._warningPane = new JPanel();
        this._lWarningLabel = new JLabel("");
        this._lWarningLabel.setIcon(null);
        this._lWarningLabel.setLabelFor(this._warningPane);
        this._warningPane.add(this._lWarningLabel);
    }

    protected void rebuildPanel() {
        this._buttonsPanel.removeAll();
        this._assignedPpolPane.removeAll();
        this._contentPane.removeAll();
        this.layoutComponents();
    }

    protected void layoutComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        if (!this._ppolIsAssigned) {
            this._replaceButton.setText(_resource.getString(_section, "assignButton-label"));
            this._buttonsPanel.add((Component)this._replaceButton, gridBagConstraints);
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            this._buttonsPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        } else {
            this._buttonsPanel.add((Component)this._replaceButton, gridBagConstraints);
            gridBagConstraints.insets.top = 0;
            this._buttonsPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
            this._buttonsPanel.add((Component)this._removeButton, gridBagConstraints);
            this._buttonsPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
            this._buttonsPanel.add((Component)this._editButton, gridBagConstraints);
            this._buttonsPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
            this._buttonsPanel.add((Component)this._showButton, gridBagConstraints);
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            this._buttonsPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        }
        this._assignedPpolPane.setLayout(new GridBagLayout());
        if (!this._ppolIsAssigned) {
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = UIFactory.getComponentSpace();
            gridBagConstraints.insets.top = UIFactory.getComponentSpace();
            this._assignedPpolPane.add((Component)this._lAssignedPpol, gridBagConstraints);
        } else {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = UIFactory.getComponentSpace();
            gridBagConstraints.insets.top = UIFactory.getComponentSpace();
            this._assignedPpolPane.add((Component)this._lAssignedPpol, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            this._assignedPpolPane.add((Component)this._lAssignedPpolName, gridBagConstraints);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        this._contentPane.add((Component)this._assignedPpolPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._contentPane.add((Component)this._buttonsPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)this._infoPane, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.top = 0;
        this._contentPane.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 40;
        this._contentPane.add((Component)this._warningPane, gridBagConstraints);
        this.setComponent(this._contentPane);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBusyCursor(true);
        Object object = actionEvent.getSource();
        if (object == this._replaceButton) {
            this.actionReplace();
        } else if (object == this._editButton) {
            this.actionEdit();
        } else if (object == this._showButton) {
            this.actionShow();
        } else if (object == this._removeButton) {
            this.actionRemove();
        }
        this.setBusyCursor(false);
    }

    protected void displayNewPPol(String string) {
        block14: {
            if (string.trim().equals("")) {
                if (this._ppolIsAssigned) {
                    this._ppolIsAssigned = false;
                    this.setAllTextPPolNotAssigned();
                    this.rebuildPanel();
                }
            } else {
                try {
                    block13: {
                        try {
                            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
                            this._ppolEntryDN = string;
                            this._ppolEntryName = "";
                            String[] stringArray = new String[]{PASSWORDPOLICY_ATTR, "cn"};
                            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, this._ppolEntryDN, stringArray, null);
                            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
                            if (lDAPAttribute == null) {
                                this.setAllTextPPolAssigned(this.ppolAssignedExist());
                                break block13;
                            }
                            this._ppolEntryName = lDAPAttribute.getStringValueArray()[0];
                            this.setAllTextPPolAssigned(this.ppolAssignedExist());
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println((String)("PasswordPolicyEditorDialog.displayNewPPol: " + this._ppolEntryDN + " is obsolete"));
                            Object var7_9 = null;
                            this.setAllTextPPolAssigned(this.ppolAssignedExist());
                            if (!this._ppolIsAssigned) {
                                this._ppolIsAssigned = true;
                                this.setAllTextPPolAssigned(this.ppolAssignedExist());
                                this.rebuildPanel();
                            }
                            break block14;
                        }
                        catch (Exception exception) {
                            Debug.println((String)("PasswordPolicyEditorDialog.displayNewPPol: " + this._ppolEntryDN + " is obsolete"));
                            Object var7_10 = null;
                            this.setAllTextPPolAssigned(this.ppolAssignedExist());
                            if (!this._ppolIsAssigned) {
                                this._ppolIsAssigned = true;
                                this.setAllTextPPolAssigned(this.ppolAssignedExist());
                                this.rebuildPanel();
                            }
                        }
                    }
                    Object var7_8 = null;
                    this.setAllTextPPolAssigned(this.ppolAssignedExist());
                    if (!this._ppolIsAssigned) {
                        this._ppolIsAssigned = true;
                        this.setAllTextPPolAssigned(this.ppolAssignedExist());
                        this.rebuildPanel();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.setAllTextPPolAssigned(this.ppolAssignedExist());
                    if (!this._ppolIsAssigned) {
                        this._ppolIsAssigned = true;
                        this.setAllTextPPolAssigned(this.ppolAssignedExist());
                        this.rebuildPanel();
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void actionReplace() {
        if (this._browseDlg == null) {
            this._browseDlg = new SubtreeSelectionDialog(this._framework);
            this._browseDlg.setShowContainerOnly(false);
            this._browseDlg.displaySelectionField(true);
        }
        this._browseDlg.packAndShow();
        if (this._browseDlg.isOk()) {
            this.displayNewPPol(this._browseDlg.getDN());
        }
    }

    protected void actionRemove() {
        this.displayNewPPol("");
    }

    protected void actionEdit() {
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        try {
            String[] stringArray = new String[]{PASSWORDPOLICY_ATTR, "*"};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, this._ppolEntryDN, stringArray, null);
            DSResourceEditor dSResourceEditor = new DSResourceEditor((JFrame)((Object)this._framework), this._info, lDAPEntry);
            dSResourceEditor.showModal();
            DSUtil.dialogCleanup();
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("PasswordPolicyEditorDialog.actionEdit: " + this._ppolEntryDN + " is obsolete"));
        }
    }

    protected void actionShow() {
        if (this._showButton.getText().equals(_resource.getString(_section, "showDNButton-label"))) {
            this._showButton.setText(_resource.getString(_section, "showNameButton-label"));
            this._lAssignedPpolName.setText(this._ppolEntryDN);
        } else {
            this._showButton.setText(_resource.getString(_section, "showDNButton-label"));
            this._lAssignedPpolName.setText(this._ppolEntryName);
        }
        this._showButton.repaint();
    }

    protected void okInvoked() {
        try {
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            String string = this._info.getCurrentDN();
            if (!this._ppolIsAssigned) {
                if (this._entryHasPpol) {
                    LDAPAttribute lDAPAttribute = new LDAPAttribute(PASSWORDPOLICY_ATTR);
                    LDAPModification lDAPModification = new LDAPModification(1, lDAPAttribute);
                    lDAPConnection.modify(string, lDAPModification);
                }
            } else if (!this.isPPolInherited()) {
                LDAPAttribute lDAPAttribute = new LDAPAttribute(PASSWORDPOLICY_ATTR, this._ppolEntryDN);
                LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
                lDAPConnection.modify(string, lDAPModification);
            }
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println((String)("PasswordPolicyEditorDialog.okInvoked() - WARNING - PPol not saved properly : \n   Error code = " + n + "\n   LDAPException raised  = " + lDAPException.getMessage()));
        }
        super.okInvoked();
    }

    protected void helpInvoked() {
        DSUtil.help("configuration-set-passwordpolicy-help", this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private String getSuffixForDn(String string) {
        boolean bl = false;
        DN dN = null;
        DN dN2 = new DN(string);
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext() && !bl) {
            DN dN3;
            Suffix suffix = (Suffix)listIterator.next();
            if (suffix.getParentSuffix() != null || !dN2.isDescendantOf(dN3 = new DN(suffix.getName())) && !dN2.equals(dN3)) continue;
            bl = true;
            dN = dN3;
        }
        return bl ? dN.toString() : string;
    }
}

