/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;

public class ReplicationAgreement {
    public String host;
    public int port;
    public boolean isSSL;
    public int authentication;
    public String authenticationDn;
    public String authenticationPwd;
    public String schedule;
    public String description;
    public String suffix;
    public String partialReplication;
    public int windowSize = 10;
    public int groupSize = 1;
    public String dn;
    public boolean isEnabled;
    public boolean isInitializing;
    public boolean isSuspended;
    public String lastUpdateStart;
    public String lastUpdateEnd;
    public String lastUpdateMessage;
    public String lastInitMessage;
    public String lastInitStart;
    public String lastInitEnd;
    public int numberChangesSent;
    public static final int SIMPLE_AUTHENTICATION = 0;
    public static final int CLIENT_AUTHENTICATION = 1;
    public static final int SIMPLE_AUTHENTICATION_START_TLS = 2;
    public static final String IN_SYNC = "*";
    public static final String NO_TIME_AVAILABLE = "NO_TIME_AVAILABLE";

    public Object clone() {
        ReplicationAgreement replicationAgreement = new ReplicationAgreement();
        replicationAgreement.host = this.host;
        replicationAgreement.port = this.port;
        replicationAgreement.isSSL = this.isSSL;
        replicationAgreement.authentication = this.authentication;
        replicationAgreement.authenticationDn = this.authenticationDn;
        replicationAgreement.authenticationPwd = this.authenticationPwd;
        replicationAgreement.schedule = this.schedule;
        replicationAgreement.description = this.description;
        replicationAgreement.partialReplication = this.partialReplication;
        replicationAgreement.suffix = this.suffix;
        replicationAgreement.dn = this.dn;
        replicationAgreement.windowSize = this.windowSize;
        replicationAgreement.groupSize = this.groupSize;
        replicationAgreement.isEnabled = true;
        return replicationAgreement;
    }

    public static void updateAgreement(LDAPEntry lDAPEntry, ReplicationAgreement replicationAgreement) {
        replicationAgreement.host = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaHost");
        try {
            replicationAgreement.port = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaPort"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        replicationAgreement.isSSL = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaTransportInfo").equalsIgnoreCase("SSL");
        replicationAgreement.authentication = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaBindMethod").equalsIgnoreCase("SIMPLE") ? 0 : 1;
        replicationAgreement.authenticationDn = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaBindDN");
        replicationAgreement.authenticationPwd = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaCredentials");
        replicationAgreement.schedule = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaUpdateSchedule");
        if (replicationAgreement.schedule.equals("")) {
            replicationAgreement.schedule = IN_SYNC;
        }
        replicationAgreement.description = DSUtil.getAttrValue(lDAPEntry, "description");
        replicationAgreement.suffix = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaRoot");
        try {
            replicationAgreement.windowSize = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, "ds5ReplicaTransportWindowSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            replicationAgreement.groupSize = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, "ds5ReplicaTransportGroupSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        replicationAgreement.partialReplication = DSUtil.getAttrValue(lDAPEntry, "ds5PartialReplConfiguration");
        replicationAgreement.dn = lDAPEntry.getDN();
        String string = DSUtil.getAttrValue(lDAPEntry, "ds5AgreementEnable");
        replicationAgreement.isEnabled = string.equalsIgnoreCase("on") || string.equals("");
        String string2 = DSUtil.getAttrValue(lDAPEntry, "nsds5BeginReplicaRefresh");
        replicationAgreement.isInitializing = string2.equalsIgnoreCase("start");
        replicationAgreement.isSuspended = DSUtil.getAttrValue(lDAPEntry, "theAttribute").equals("theValue");
        replicationAgreement.lastUpdateStart = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStart");
        if (replicationAgreement.lastUpdateStart.equals("") || replicationAgreement.lastUpdateStart.equals("0")) {
            replicationAgreement.lastUpdateStart = NO_TIME_AVAILABLE;
        }
        replicationAgreement.lastUpdateEnd = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateEnd");
        if (replicationAgreement.lastUpdateEnd.equals("") || replicationAgreement.lastUpdateEnd.equals("0")) {
            replicationAgreement.lastUpdateEnd = NO_TIME_AVAILABLE;
        }
        replicationAgreement.lastUpdateMessage = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStatus");
        replicationAgreement.lastInitStart = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitStart");
        if (replicationAgreement.lastInitStart.equals("") || replicationAgreement.lastInitStart.equals("0")) {
            replicationAgreement.lastInitStart = NO_TIME_AVAILABLE;
        }
        replicationAgreement.lastInitEnd = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitEnd");
        if (replicationAgreement.lastInitEnd.equals("") || replicationAgreement.lastInitEnd.equals("0")) {
            replicationAgreement.lastInitEnd = NO_TIME_AVAILABLE;
        }
        replicationAgreement.lastInitMessage = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitStatus");
        replicationAgreement.numberChangesSent = 0;
        try {
            replicationAgreement.numberChangesSent = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, "nsds5replicaChangesSentSinceStartup"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static LDAPEntry getEntryForAgreement(ReplicationAgreement replicationAgreement) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsDS5ReplicationAgreement"));
        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaHost", replicationAgreement.host));
        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaPort", String.valueOf(replicationAgreement.port)));
        if (replicationAgreement.isSSL) {
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaTransportInfo", "SSL"));
        }
        if (replicationAgreement.authentication == 0) {
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindMethod", "SIMPLE"));
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindDN", replicationAgreement.authenticationDn));
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaCredentials", replicationAgreement.authenticationPwd));
        } else {
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindMethod", "SSLCLIENTAUTH"));
            lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindDN", replicationAgreement.authenticationDn));
        }
        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaUpdateSchedule", replicationAgreement.schedule));
        if (!replicationAgreement.partialReplication.equals("")) {
            lDAPAttributeSet.add(new LDAPAttribute("ds5PartialReplConfiguration", replicationAgreement.partialReplication));
        }
        if (!replicationAgreement.description.equals("")) {
            lDAPAttributeSet.add(new LDAPAttribute("description", replicationAgreement.description));
        }
        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaRoot", replicationAgreement.suffix));
        lDAPAttributeSet.add(new LDAPAttribute("ds5ReplicaTransportWindowSize", String.valueOf(replicationAgreement.windowSize)));
        lDAPAttributeSet.add(new LDAPAttribute("ds5ReplicaTransportGroupSize", String.valueOf(replicationAgreement.groupSize)));
        return new LDAPEntry(replicationAgreement.dn, lDAPAttributeSet);
    }

    public static String convertStatusMessage(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = stringTokenizer.nextToken();
        if (string3 != null && string3.length() > 0) {
            try {
                int n = Integer.parseInt(string3);
                if (string3.length() < string.length()) {
                    String string4 = string.substring(string3.length() + 1);
                    if (string4 != null && string4.length() > 0) {
                        if (n != 0) {
                            String[] stringArray = new String[]{string4, string3};
                            string2 = ReplicaWizard._resource.getString("replicationagreement", "convertupdatemessage-error-label", stringArray);
                        } else {
                            string2 = string4;
                        }
                    }
                } else if (n != 0) {
                    String[] stringArray = new String[]{string3};
                    string2 = ReplicaWizard._resource.getString("replicationagreement", "convertupdatecode-label", stringArray);
                } else {
                    string2 = "";
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }
}

