/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.IReplicaPanel;
import com.netscape.admin.dirserv.config.replication.IReplicaWizard;
import com.netscape.admin.dirserv.config.replication.Replica;
import com.netscape.admin.dirserv.config.replication.ReplicaChangelogPanel;
import com.netscape.admin.dirserv.config.replication.ReplicaIDPanel;
import com.netscape.admin.dirserv.config.replication.ReplicaManagerPasswordPanel;
import com.netscape.admin.dirserv.config.replication.ReplicaRolePanel;
import com.netscape.admin.dirserv.config.replication.ReplicaSummaryPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

class ReplicaWizard
extends AbstractDialog
implements IReplicaWizard,
ActionListener {
    private DSFramework _framework;
    private String _suffix;
    private String _replicaDn;
    private Replica _replica;
    private ReplicaRolePanel _rolePanel;
    private ReplicaIDPanel _idPanel;
    private ReplicaChangelogPanel _changelogPanel;
    private ReplicaManagerPasswordPanel _managerPasswordPanel;
    private ReplicaSummaryPanel _summaryPanel;
    private JPanel _contentPanel;
    private JPanel _currentPanel;
    private JButton _bCancel;
    private JButton _bHelp;
    private JButton _bNext;
    private JButton _bBack;
    private Boolean _changelogExists;
    private Boolean _replicaManagerPasswordExists;
    private boolean _isCancelled;
    static String _adminURL;
    public static ResourceSet _resource;

    public ReplicaWizard(DSFramework dSFramework, Suffix suffix) {
        super((Frame)((Object)dSFramework), "", true);
        this._framework = dSFramework;
        this._replicaDn = "cn=replica, " + suffix.getDn();
        this._suffix = suffix.getName();
        _adminURL = this._framework.getServerObject().getServerInfo().getAdminURL();
        this.createLayout();
    }

    public ReplicaWizard(DSFramework dSFramework, Replica replica, Suffix suffix) {
        super((Frame)((Object)dSFramework), "", true);
        if (replica == null) {
            throw new IllegalArgumentException("The replica to promote-demote cannot be null");
        }
        this._framework = dSFramework;
        this._replica = replica;
        this._replicaDn = this._replica.dn;
        this._suffix = suffix.getName();
        _adminURL = this._framework.getServerObject().getServerInfo().getAdminURL();
        this.createLayout();
    }

    public void pack() {
        if (this._currentPanel != null) {
            int n = 0;
            int n2 = 0;
            JPanel jPanel = new ReplicaRolePanel();
            n = Math.max(n, ((Component)jPanel).getPreferredSize().width);
            n2 = Math.max(n2, ((Component)jPanel).getPreferredSize().height);
            jPanel = new ReplicaIDPanel(this);
            n = Math.max(n, ((Component)jPanel).getPreferredSize().width);
            n2 = Math.max(n2, ((Component)jPanel).getPreferredSize().height);
            jPanel = new ReplicaChangelogPanel(this);
            n = Math.max(n, ((Component)jPanel).getPreferredSize().width);
            n2 = Math.max(n2, ((Component)jPanel).getPreferredSize().height);
            jPanel = new ReplicaManagerPasswordPanel(this);
            n = Math.max(n, ((Component)jPanel).getPreferredSize().width);
            n2 = Math.max(n2, ((Component)jPanel).getPreferredSize().height);
            jPanel = new ReplicaSummaryPanel();
            n = Math.max(n, ((Component)jPanel).getPreferredSize().width);
            n2 = Math.max(n2, ((Component)jPanel).getPreferredSize().height);
            this._currentPanel.setPreferredSize(new Dimension(n, n2));
        }
        super.pack();
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bHelp) {
            ((IReplicaPanel)((Object)this._currentPanel)).helpInvoked();
        } else if (object == this._bCancel) {
            if (this._currentPanel != this._summaryPanel) {
                int n = DSUtil.showConfirmationDialog((Component)((Object)this), "confirmation-exit", (String[])null, "replicawizard", _resource);
                if (n == 0) {
                    this._isCancelled = true;
                    super.cancelInvoked();
                }
            } else {
                super.cancelInvoked();
            }
        } else if (object == this._bNext) {
            this.actionNext();
        } else if (object == this._bBack) {
            this.actionBack();
        } else {
            Thread.dumpStack();
        }
    }

    public void setEnabledNextButton(boolean bl) {
        this._bNext.setEnabled(bl);
    }

    public DSFramework getFramework() {
        return this._framework;
    }

    private void createLayout() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._contentPanel = new JPanel();
        this._contentPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createControlButtons();
        jPanel.add("South", jPanel2);
        jPanel.add("Center", this._contentPanel);
        this._contentPanel.setBorder(new EmptyBorder(15, 20, 15, 20));
        this.setComponent(jPanel);
        this._rolePanel = this._replica == null ? new ReplicaRolePanel() : new ReplicaRolePanel(this._replica.role);
        this._currentPanel = this._rolePanel;
        this._contentPanel.add("Center", this._currentPanel);
        this._bBack.setVisible(false);
        if (this._replica == null) {
            ((Dialog)((Object)this)).setTitle(_resource.getString("replicawizard-create", "title"));
            ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("replicawizard-create", "description"));
        } else {
            ((Dialog)((Object)this)).setTitle(_resource.getString("replicawizard-promote", "title"));
            ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("replicawizard-promote", "description"));
        }
        this.setDefaultButton(this._bNext);
        this._bNext.grabFocus();
    }

    private JPanel createControlButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), 0, 0, 0));
        jPanel.setLayout(new FlowLayout(2, 0, 0));
        this._bBack = UIFactory.makeJButton(this, "replicawizard", "bback", _resource);
        jPanel.add(this._bBack);
        jPanel.add(Box.createRigidArea(new Dimension(UIFactory.getComponentSpace(), 0)));
        this._bNext = UIFactory.makeJButton(this, "replicawizard", "bnext", _resource);
        jPanel.add(this._bNext);
        jPanel.add(Box.createRigidArea(new Dimension(UIFactory.getSeparatedSpace(), 0)));
        this._bCancel = UIFactory.makeJButton(this, "replicawizard", "bcancel", _resource);
        jPanel.add(this._bCancel);
        jPanel.add(Box.createRigidArea(new Dimension(UIFactory.getSeparatedSpace(), 0)));
        this._bHelp = UIFactory.makeJButton(this, "replicawizard", "bhelp", _resource);
        jPanel.add(this._bHelp);
        JButtonFactory.resizeGroup((JButton)this._bHelp, (JButton)this._bCancel, (JButton)this._bNext, (JButton)this._bBack);
        return jPanel;
    }

    private void actionNext() {
        JPanel jPanel = this._currentPanel;
        if (this._currentPanel == this._rolePanel) {
            int n = this._rolePanel.getRole();
            switch (n) {
                case 0: {
                    if (this._idPanel == null) {
                        this._idPanel = new ReplicaIDPanel(this);
                    }
                    this._currentPanel = this._idPanel;
                    break;
                }
                case 1: {
                    if (!this.changelogExists()) {
                        if (this._changelogPanel == null) {
                            this._changelogPanel = new ReplicaChangelogPanel(this);
                        }
                        this._currentPanel = this._changelogPanel;
                        break;
                    }
                    if (!this.replicaManagerPasswordExists()) {
                        if (this._managerPasswordPanel == null) {
                            this._managerPasswordPanel = new ReplicaManagerPasswordPanel(this);
                        }
                        this._currentPanel = this._managerPasswordPanel;
                        break;
                    }
                    this.updateServer();
                    this._summaryPanel = new ReplicaSummaryPanel();
                    this._summaryPanel.setDisplayText(this.getReplicationSummary());
                    this._currentPanel = this._summaryPanel;
                    this._bCancel.setText(_resource.getString("replicawizard", "bclose-label"));
                    JButtonFactory.resize((JButton)this._bCancel);
                    break;
                }
                case 2: {
                    if (!this.replicaManagerPasswordExists()) {
                        if (this._managerPasswordPanel == null) {
                            this._managerPasswordPanel = new ReplicaManagerPasswordPanel(this);
                        }
                        this._currentPanel = this._managerPasswordPanel;
                        break;
                    }
                    this.updateServer();
                    this._summaryPanel = new ReplicaSummaryPanel();
                    this._summaryPanel.setDisplayText(this.getReplicationSummary());
                    this._currentPanel = this._summaryPanel;
                    this._bCancel.setText(_resource.getString("replicawizard", "bclose-label"));
                    JButtonFactory.resize((JButton)this._bCancel);
                    break;
                }
                default: {
                    Thread.dumpStack();
                    break;
                }
            }
        } else if (this._currentPanel == this._idPanel) {
            if (!this.changelogExists()) {
                if (this._changelogPanel == null) {
                    this._changelogPanel = new ReplicaChangelogPanel(this);
                }
                this._currentPanel = this._changelogPanel;
            } else if (!this.replicaManagerPasswordExists()) {
                if (this._managerPasswordPanel == null) {
                    this._managerPasswordPanel = new ReplicaManagerPasswordPanel(this);
                }
                this._currentPanel = this._managerPasswordPanel;
            } else {
                this.updateServer();
                this._summaryPanel = new ReplicaSummaryPanel();
                this._summaryPanel.setDisplayText(this.getReplicationSummary());
                this._currentPanel = this._summaryPanel;
                this._bCancel.setText(_resource.getString("replicawizard", "bclose-label"));
                JButtonFactory.resize((JButton)this._bCancel);
            }
        } else if (this._currentPanel == this._changelogPanel) {
            if (!this.replicaManagerPasswordExists()) {
                if (this._managerPasswordPanel == null) {
                    this._managerPasswordPanel = new ReplicaManagerPasswordPanel(this);
                }
                this._currentPanel = this._managerPasswordPanel;
            } else {
                this.updateServer();
                this._summaryPanel = new ReplicaSummaryPanel();
                this._summaryPanel.setDisplayText(this.getReplicationSummary());
                this._currentPanel = this._summaryPanel;
                this._bCancel.setText(_resource.getString("replicawizard", "bclose-label"));
                JButtonFactory.resize((JButton)this._bCancel);
            }
        } else if (this._currentPanel == this._managerPasswordPanel) {
            this.updateServer();
            this._summaryPanel = new ReplicaSummaryPanel();
            this._summaryPanel.setDisplayText(this.getReplicationSummary());
            this._currentPanel = this._summaryPanel;
            this._bCancel.setText(_resource.getString("replicawizard", "bclose-label"));
            JButtonFactory.resize((JButton)this._bCancel);
        } else if (this._currentPanel == this._summaryPanel) {
            super.okInvoked();
            this._currentPanel = null;
        } else {
            Thread.dumpStack();
        }
        if (this._currentPanel != null && ((Component)((Object)this)).isVisible()) {
            this._contentPanel.remove(jPanel);
            this._contentPanel.add("Center", this._currentPanel);
            this._contentPanel.validate();
            this._contentPanel.repaint();
            ((IReplicaPanel)((Object)this._currentPanel)).reset();
            this._bBack.setVisible(this._currentPanel != this._rolePanel && this._currentPanel != this._summaryPanel);
            this._bNext.setVisible(this._currentPanel != this._summaryPanel);
        }
    }

    private void actionBack() {
        JPanel jPanel = this._currentPanel;
        if (this._currentPanel == this._managerPasswordPanel) {
            this._currentPanel = this._rolePanel.getRole() != 2 && !this.changelogExists() ? this._changelogPanel : (this._rolePanel.getRole() == 0 ? this._idPanel : this._rolePanel);
        } else if (this._currentPanel == this._changelogPanel) {
            this._currentPanel = this._rolePanel.getRole() == 0 ? this._idPanel : this._rolePanel;
        } else if (this._currentPanel == this._idPanel) {
            this._currentPanel = this._rolePanel;
        }
        this._bNext.setEnabled(true);
        this._bNext.setVisible(true);
        this._bBack.setVisible(this._currentPanel != this._rolePanel);
        this._contentPanel.remove(jPanel);
        this._contentPanel.add("Center", this._currentPanel);
        this._contentPanel.validate();
        this._contentPanel.repaint();
    }

    private boolean changelogExists() {
        if (this._changelogExists == null) {
            this.lookForChangelogAndManagerPwd();
        }
        return this._changelogExists;
    }

    private boolean replicaManagerPasswordExists() {
        boolean bl = false;
        if (this._replica != null) {
            ListIterator listIterator = ((AbstractList)this._replica.bindDn).listIterator();
            while (listIterator.hasNext() && !bl) {
                if (LDAPDN.equals((String)((String)listIterator.next()), (String)"cn=replication manager, cn=replication, cn=config")) continue;
                bl = true;
            }
        }
        if (!bl) {
            if (this._replicaManagerPasswordExists == null) {
                this.lookForChangelogAndManagerPwd();
            }
            bl = this._replicaManagerPasswordExists;
        }
        return bl;
    }

    private void lookForChangelogAndManagerPwd() {
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("replicawizard", "reading-title"), (Component)((Object)this));
        genericProgressDialog.setTextInLabel(_resource.getString("replicawizard", "reading-msg"));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(25);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                boolean[] blArray;
                block14: {
                    block15: {
                        String[] stringArray;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LDAPConnection lDAPConnection = ReplicaWizard.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                        blArray = new boolean[]{false};
                        String[] stringArray2 = new String[]{"userpassword"};
                        try {
                            LDAPEntry lDAPEntry = lDAPConnection.read("cn=replication manager, cn=replication, cn=config", stringArray2);
                            if (lDAPEntry != null) {
                                ReplicaWizard.this._replicaManagerPasswordExists = lDAPEntry.getAttribute("userpassword") != null ? Boolean.TRUE : Boolean.FALSE;
                            } else {
                                ReplicaWizard.this._replicaManagerPasswordExists = Boolean.FALSE;
                            }
                        }
                        catch (LDAPException lDAPException) {
                            ReplicaWizard.this._replicaManagerPasswordExists = Boolean.FALSE;
                            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, stringArray, blArray){
                                    private final /* synthetic */ String[] val$arg;
                                    private final /* synthetic */ boolean[] val$stop;
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$arg = stringArray;
                                        this.val$stop = blArray;
                                    }

                                    public void run() {
                                        int n = DSUtil.showConfirmationDialog((Component)1.access$200(this.this$1), "error-reading-replicationmanager", this.val$arg, "replicawizard", _resource);
                                        this.val$stop[0] = n != 0;
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (blArray[0]) break block15;
                        stringArray2[0] = "dn";
                        try {
                            if (lDAPConnection.read("cn=changelog5, cn=config", stringArray2) != null) {
                                ReplicaWizard.this._changelogExists = Boolean.TRUE;
                                break block14;
                            }
                            ReplicaWizard.this._changelogExists = Boolean.FALSE;
                        }
                        catch (LDAPException lDAPException) {
                            ReplicaWizard.this._changelogExists = Boolean.FALSE;
                            if (lDAPException.getLDAPResultCode() == 32) break block14;
                            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, stringArray, blArray){
                                    private final /* synthetic */ String[] val$arg;
                                    private final /* synthetic */ boolean[] val$stop;
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$arg = stringArray;
                                        this.val$stop = blArray;
                                    }

                                    public void run() {
                                        int n = DSUtil.showConfirmationDialog((Component)1.access$200(this.this$1), "error-reading-changelog", this.val$arg, "replicawizard", _resource);
                                        this.val$stop[0] = n != 0;
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                        break block14;
                    }
                    ReplicaWizard.this._changelogExists = Boolean.FALSE;
                }
                genericProgressDialog.closeCallBack();
                if (blArray[0]) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ReplicaWizard.access$501(1.access$400(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ GenericProgressDialog access$200(1 var0) {
                return var0.genericProgressDialog;
            }

            static /* synthetic */ ReplicaWizard access$400(1 var0) {
                return var0.ReplicaWizard.this;
            }
        });
        thread.start();
        genericProgressDialog.packAndShow();
    }

    private void updateServer() {
        boolean bl;
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("replicawizard", "updating-title"), (Component)((Object)this));
        genericProgressDialog.setTextInLabel(_resource.getString("replicawizard", "updating-msg"));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(40);
        final boolean bl2 = this._rolePanel.getRole() != 2 && !this.changelogExists();
        boolean bl3 = bl = !this.replicaManagerPasswordExists();
        if (bl2) {
            genericProgressDialog.addStep(_resource.getString("replicawizard", "createchangelog-label"));
        }
        if (bl) {
            genericProgressDialog.addStep(_resource.getString("replicawizard", "createreplicamanagerpassword-label"));
        }
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix, 30)};
        if (this._replica == null) {
            genericProgressDialog.addStep(_resource.getString("replicawizard", "createreplicaentry-label", stringArray));
        } else {
            genericProgressDialog.addStep(_resource.getString("replicawizard", "modifyreplicaentry-label", stringArray));
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String[] stringArray;
                LDAPAttributeSet lDAPAttributeSet;
                ReplicaWizard.this._isCancelled = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LDAPConnection lDAPConnection = ReplicaWizard.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                if (bl2) {
                    lDAPAttributeSet = new LDAPAttributeSet();
                    lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleObject"));
                    lDAPAttributeSet.add(new LDAPAttribute("cn", "changelog5"));
                    lDAPAttributeSet.add(new LDAPAttribute("nsslapd-changelogdir", ReplicaWizard.this._changelogPanel.getChangelogPath()));
                    LDAPEntry lDAPEntry = new LDAPEntry("cn=changelog5, cn=config", lDAPAttributeSet);
                    try {
                        lDAPConnection.add(lDAPEntry);
                    }
                    catch (LDAPException lDAPException) {
                        ReplicaWizard.this._isCancelled = true;
                        String[] stringArray2 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, stringArray2){
                                private final /* synthetic */ String[] val$arg;
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$arg = stringArray;
                                }

                                public void run() {
                                    DSUtil.showErrorDialog(5.access$800(this.this$1), "error-creatingchangelog-title", "error-creatingchangelog-msg", this.val$arg, "replicawizard", _resource);
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!ReplicaWizard.this._isCancelled) {
                        genericProgressDialog.nextStepCompleted();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (bl && !ReplicaWizard.this._isCancelled) {
                    lDAPAttributeSet = new LDAPModification(2, new LDAPAttribute("userPassword", ReplicaWizard.this._managerPasswordPanel.getPassword()));
                    try {
                        lDAPConnection.modify("cn=replication manager, cn=replication, cn=config", (LDAPModification)lDAPAttributeSet);
                    }
                    catch (LDAPException lDAPException) {
                        stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, stringArray){
                                private final /* synthetic */ String[] val$arg;
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$arg = stringArray;
                                }

                                public void run() {
                                    ReplicaWizard.access$602(5.access$1000(this.this$1), DSUtil.showConfirmationDialog((Component)5.access$800(this.this$1), "error-creatingmanagerpassword", this.val$arg, "replicawizard", _resource) != 0);
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!ReplicaWizard.this._isCancelled) {
                        genericProgressDialog.nextStepCompleted();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!ReplicaWizard.this._isCancelled) {
                    if (ReplicaWizard.this._replica == null) {
                        lDAPAttributeSet = new LDAPAttributeSet();
                        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "nsDS5Replica"));
                        lDAPAttributeSet.add(new LDAPAttribute("cn", "replica"));
                        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaBindDN", "cn=replication manager, cn=replication, cn=config"));
                        lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaRoot", ReplicaWizard.this._suffix));
                        int n = ReplicaWizard.this._rolePanel.getRole();
                        switch (n) {
                            case 0: {
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5Flags", "1"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaType", "3"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaID", String.valueOf(ReplicaWizard.this._idPanel.getID())));
                                break;
                            }
                            case 1: {
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5Flags", "1"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaType", "2"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaID", "65535"));
                                break;
                            }
                            case 2: {
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5Flags", "0"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaType", "2"));
                                lDAPAttributeSet.add(new LDAPAttribute("nsDS5ReplicaID", "65535"));
                                break;
                            }
                            default: {
                                Thread.dumpStack();
                            }
                        }
                        stringArray = new LDAPEntry(ReplicaWizard.this._replicaDn, lDAPAttributeSet);
                        try {
                            lDAPConnection.add((LDAPEntry)stringArray);
                            genericProgressDialog.nextStepCompleted();
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (LDAPException lDAPException) {
                            ReplicaWizard.this._isCancelled = true;
                            String[] stringArray3 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, stringArray3){
                                    private final /* synthetic */ String[] val$arg;
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$arg = stringArray;
                                    }

                                    public void run() {
                                        DSUtil.showErrorDialog(5.access$800(this.this$1), "error-creatingreplica-title", "error-creatingreplica-msg", this.val$arg, "replicawizard", _resource);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        String[] stringArray4;
                        lDAPAttributeSet = new LDAPModificationSet();
                        boolean bl3 = false;
                        int n = ReplicaWizard.this._rolePanel.getRole();
                        switch (n) {
                            case 0: {
                                if (((ReplicaWizard)ReplicaWizard.this)._replica.role == 2) {
                                    int n2 = 1;
                                    if (((ReplicaWizard)ReplicaWizard.this)._replica.overwriteReferrals) {
                                        n2 |= 4;
                                    }
                                    lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5Flags", String.valueOf(n2)));
                                }
                                lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaType", "3"));
                                lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaID", String.valueOf(ReplicaWizard.this._idPanel.getID())));
                            }
                            case 1: {
                                if (((ReplicaWizard)ReplicaWizard.this)._replica.role == 2) {
                                    int n3 = 1;
                                    if (((ReplicaWizard)ReplicaWizard.this)._replica.overwriteReferrals) {
                                        n3 |= 4;
                                    }
                                    lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5Flags", String.valueOf(n3)));
                                }
                                if (((ReplicaWizard)ReplicaWizard.this)._replica.role != 0) break;
                                lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaType", "2"));
                                lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaID", "65535"));
                                break;
                            }
                            case 2: {
                                int n4 = 0;
                                if (((ReplicaWizard)ReplicaWizard.this)._replica.overwriteReferrals) {
                                    n4 |= 4;
                                }
                                lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5Flags", String.valueOf(n4)));
                                if (((ReplicaWizard)ReplicaWizard.this)._replica.role == 0) {
                                    lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaType", "2"));
                                    lDAPAttributeSet.add(2, new LDAPAttribute("nsDS5ReplicaID", "65535"));
                                }
                                bl3 = true;
                                break;
                            }
                            default: {
                                Thread.dumpStack();
                            }
                        }
                        if (bl3) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this){
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        ReplicaWizard.access$602(5.access$1000(this.this$1), DSUtil.showConfirmationDialog((Component)5.access$800(this.this$1), "needtodeleteagreements", (String[])null, "replicawizard", _resource) != 0);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!ReplicaWizard.this._isCancelled && bl3) {
                            try {
                                LDAPEntry lDAPEntry;
                                ArrayList<String> arrayList = new ArrayList<String>();
                                stringArray4 = new String[]{"dn"};
                                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(ReplicaWizard.this._replicaDn, 2, "objectclass=nsDS5ReplicationAgreement", stringArray4, false);
                                while (lDAPSearchResults.hasMoreElements()) {
                                    lDAPEntry = lDAPSearchResults.next();
                                    arrayList.add(lDAPEntry.getDN());
                                }
                                lDAPEntry = ((AbstractList)arrayList).listIterator();
                                while (lDAPEntry.hasNext()) {
                                    lDAPConnection.delete((String)lDAPEntry.next());
                                }
                            }
                            catch (LDAPException lDAPException) {
                                stringArray4 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(this, stringArray4){
                                        private final /* synthetic */ String[] val$arg;
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$arg = stringArray;
                                        }

                                        public void run() {
                                            ReplicaWizard.access$602(5.access$1000(this.this$1), DSUtil.showConfirmationDialog((Component)5.access$800(this.this$1), "error-deletingagreements", this.val$arg, "replicawizard", _resource) != 0);
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!ReplicaWizard.this._isCancelled) {
                            try {
                                lDAPConnection.modify(ReplicaWizard.this._replicaDn, (LDAPModificationSet)lDAPAttributeSet);
                                genericProgressDialog.nextStepCompleted();
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (Exception exception) {}
                            }
                            catch (LDAPException lDAPException) {
                                ReplicaWizard.this._isCancelled = true;
                                stringArray4 = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(this, stringArray4){
                                        private final /* synthetic */ String[] val$arg;
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$arg = stringArray;
                                        }

                                        public void run() {
                                            String string = "Impossible to set this server read-only, not usable Referrals to set";
                                            if (this.val$arg[0].indexOf(string) >= 0) {
                                                DSUtil.showErrorDialog(5.access$800(this.this$1), "error-demotingreplica-referral-title", "error-demotingreplica-referral-msg", null, "replicawizard", _resource);
                                            } else {
                                                DSUtil.showErrorDialog(5.access$800(this.this$1), "error-promotingreplica-title", "error-promotingreplica-msg", this.val$arg, "replicawizard", _resource);
                                            }
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                genericProgressDialog.closeCallBack();
                if (ReplicaWizard.this._isCancelled) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ReplicaWizard.access$1601(5.access$1000(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ GenericProgressDialog access$800(5 var0) {
                return var0.genericProgressDialog;
            }

            static /* synthetic */ ReplicaWizard access$1000(5 var0) {
                return var0.ReplicaWizard.this;
            }
        });
        thread.start();
        genericProgressDialog.packAndShow();
    }

    private String getReplicationSummary() {
        String string = null;
        boolean bl = this._replica != null;
        int n = this._rolePanel.getRole();
        String[] stringArray = new String[]{this._suffix};
        switch (n) {
            case 0: {
                if (bl) {
                    string = _resource.getString("replicawizard-promote", "master-summary-msg");
                    break;
                }
                string = _resource.getString("replicawizard-create", "master-summary-msg", stringArray);
                break;
            }
            case 1: {
                if (bl) {
                    string = _resource.getString("replicawizard-promote", "hub-summary-msg");
                    break;
                }
                string = _resource.getString("replicawizard-create", "hub-summary-msg", stringArray);
                break;
            }
            case 2: {
                if (bl) {
                    string = _resource.getString("replicawizard-promote", "dedicatedconsumer-summary-msg");
                    break;
                }
                string = _resource.getString("replicawizard-create", "dedicatedconsumer-summary-msg", stringArray);
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        return string;
    }

    static /* synthetic */ void access$501(ReplicaWizard replicaWizard) {
        super.cancelInvoked();
    }

    static /* synthetic */ void access$1601(ReplicaWizard replicaWizard) {
        super.cancelInvoked();
    }

    static {
        _resource = new ResourceSet("com.netscape.admin.dirserv.config.replication.replication");
    }
}

