/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.IReplicaPanel;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

class ReplicaRolePanel
extends JPanel
implements IReplicaPanel,
ActionListener {
    private JRadioButton _rbMaster;
    private JRadioButton _rbHub;
    private JRadioButton _rbDedicatedConsumer;
    private JTextArea _description;
    private int _replicaRole;
    private static ResourceSet _resource = ReplicaWizard._resource;
    private static int NO_ROLE = -1;
    static final String[] DESCRIPTIONS = new String[]{_resource.getString("replicarolepanel", "master-description-label"), _resource.getString("replicarolepanel", "dedicatedconsumer-description-label"), _resource.getString("replicarolepanel", "hub-description-label")};

    public ReplicaRolePanel() {
        this(NO_ROLE);
    }

    public ReplicaRolePanel(int n) {
        super(new GridBagLayout());
        this._replicaRole = n;
        this.layoutComponents();
    }

    public int getRole() {
        int n = NO_ROLE;
        if (this._rbMaster.isSelected()) {
            n = 0;
        } else if (this._rbHub.isSelected()) {
            n = 1;
        } else if (this._rbDedicatedConsumer.isSelected()) {
            n = 2;
        } else {
            Thread.dumpStack();
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = null;
        if (object == this._rbMaster) {
            string = DESCRIPTIONS[0];
        } else if (object == this._rbDedicatedConsumer) {
            string = DESCRIPTIONS[1];
        } else if (object == this._rbHub) {
            string = DESCRIPTIONS[2];
        } else {
            Thread.dumpStack();
        }
        this._description.setText(string);
    }

    public void helpInvoked() {
        DSUtil.help("configuration-replication-replicawizard-role-dbox-help", ReplicaWizard._adminURL);
    }

    public void reset() {
    }

    protected void layoutComponents() {
        this._rbMaster = UIFactory.makeJRadioButton(null, "replicarolepanel", "rbmaster", false, _resource);
        this._rbMaster.addActionListener(this);
        this._rbDedicatedConsumer = UIFactory.makeJRadioButton(null, "replicarolepanel", "rbdedicatedconsumer", false, _resource);
        this._rbDedicatedConsumer.addActionListener(this);
        this._rbHub = UIFactory.makeJRadioButton(null, "replicarolepanel", "rbhub", false, _resource);
        this._rbHub.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbMaster);
        buttonGroup.add(this._rbDedicatedConsumer);
        buttonGroup.add(this._rbHub);
        if (this._replicaRole == NO_ROLE) {
            this._rbDedicatedConsumer.setSelected(true);
        } else if (this._replicaRole == 1) {
            this._rbMaster.setSelected(true);
        } else {
            this._rbHub.setSelected(true);
        }
        this._description = UIFactory.makeDescriptionArea(DESCRIPTIONS[1], 3);
        ((MultilineLabel)this._description).setLabelFor((Component)this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, UIFactory.getComponentSpace(), 0);
        JLabel jLabel = UIFactory.makeJLabel("replicarolepanel", "lrole", _resource);
        jLabel.setLabelFor(this);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = 20;
        this.add((Component)this._rbDedicatedConsumer, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this.add((Component)this._rbMaster, gridBagConstraints);
        this.add((Component)this._rbHub, gridBagConstraints);
        this._rbMaster.setEnabled(this._replicaRole != 0 && this._replicaRole != 2);
        this._rbHub.setEnabled(this._replicaRole != 1);
        this._rbDedicatedConsumer.setEnabled(this._replicaRole != 2 && this._replicaRole != 0);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        this.add((Component)this._description, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

