/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.replication.AvailableServerListModel;
import com.netscape.admin.dirserv.config.replication.AvailableServers;
import com.netscape.admin.dirserv.config.replication.AvailableServersCellRenderer;
import com.netscape.admin.dirserv.config.replication.BasicServer;
import com.netscape.admin.dirserv.config.replication.PartialRule;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

class DuplicateAgreementDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private DSFramework _framework;
    private ReplicationAgreement _agreement;
    private ReplicationAgreement[] _existingAgreements;
    private AvailableServerListModel _listModel;
    private JList _listHosts;
    private JButton _bAddHost;
    private JPanel _contentPanel;
    private JPanel _mainPanel;
    private boolean _isInitialized;
    private boolean _somethingDuplicated;
    private String _helpToken = "configuration-replication-duplicate-agreement-dbox-help";
    private static final ResourceSet _resource = ReplicaWizard._resource;
    private final JLabel REFRESH_LABEL = new JLabel(_resource.getString("duplicateagreementdialog-reading", "label"));

    public DuplicateAgreementDialog(DSFramework dSFramework, ReplicationAgreement replicationAgreement, ReplicationAgreement[] replicationAgreementArray) {
        super((Frame)((Object)dSFramework), _resource.getString("duplicateagreementdialog", "title"), true, 11);
        this._framework = dSFramework;
        this._agreement = replicationAgreement;
        this._existingAgreements = replicationAgreementArray;
        this._listHosts = new JList();
        this._listHosts.addListSelectionListener(this);
        this._listHosts.setCellRenderer(new AvailableServersCellRenderer());
        MultilineLabel multilineLabel = new MultilineLabel(_resource.getString("duplicateagreementdialog", "lselect"), 2, 30);
        multilineLabel.setLabelFor((Component)this._listHosts);
        JScrollPane jScrollPane = new JScrollPane(this._listHosts);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this._bAddHost = UIFactory.makeJButton(this, "duplicateagreementdialog", "baddhost", _resource);
        this._contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this._contentPanel.add((Component)multilineLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this._contentPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)this._bAddHost, gridBagConstraints);
        this._mainPanel = new JPanel(new GridBagLayout());
        this.setComponent(this._mainPanel);
        this.showComponent(this._contentPanel);
        this.setOKButtonEnabled(false);
    }

    public void show() {
        this.showComponent(this.REFRESH_LABEL);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                LDAPConnection lDAPConnection = DuplicateAgreementDialog.this._framework.getServerObject().getConsoleInfo().getLDAPConnection();
                AvailableServers availableServers = new AvailableServers();
                try {
                    availableServers.findServers(lDAPConnection);
                    String string = DuplicateAgreementDialog.this._framework.getServerObject().getServerInfo().getHost();
                    int n = DuplicateAgreementDialog.this._framework.getServerObject().getServerInfo().getPort();
                    boolean bl = false;
                    Enumeration enumeration = availableServers.elements();
                    int n2 = 0;
                    while (enumeration.hasMoreElements() && !bl) {
                        BasicServer basicServer = (BasicServer)enumeration.nextElement();
                        if (basicServer.port == n && basicServer.name.equals(string)) {
                            bl = true;
                            if (basicServer.isSecurePort) {
                                availableServers.removeElementAt(n2);
                                availableServers.removeElementAt(n2 - 1);
                            } else {
                                availableServers.removeElementAt(n2 + 1);
                                availableServers.removeElementAt(n2);
                            }
                        }
                        ++n2;
                    }
                    int n3 = availableServers.size() - 1;
                    while (n3 >= 0) {
                        BasicServer basicServer = (BasicServer)availableServers.elementAt(n3);
                        if (!basicServer.isEnabled) {
                            availableServers.removeElementAt(n3);
                        }
                        --n3;
                    }
                    int n4 = availableServers.size() - 1;
                    while (n4 >= 0) {
                        BasicServer basicServer = (BasicServer)availableServers.elementAt(n4);
                        if (basicServer.isSecurePort != ((DuplicateAgreementDialog)DuplicateAgreementDialog.this)._agreement.isSSL) {
                            availableServers.removeElementAt(n4);
                        }
                        --n4;
                    }
                    int n5 = 0;
                    while (n5 < DuplicateAgreementDialog.this._existingAgreements.length) {
                        string = ((DuplicateAgreementDialog)DuplicateAgreementDialog.this)._existingAgreements[n5].host;
                        n = ((DuplicateAgreementDialog)DuplicateAgreementDialog.this)._existingAgreements[n5].port;
                        bl = false;
                        int n6 = availableServers.size() - 1;
                        while (n6 >= 0) {
                            BasicServer basicServer = (BasicServer)availableServers.elementAt(n6);
                            if (basicServer.port == n && basicServer.name.equals(string)) {
                                bl = true;
                                availableServers.removeElementAt(n6);
                            }
                            --n6;
                        }
                        ++n5;
                    }
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(this, availableServers){
                    private final /* synthetic */ AvailableServers val$avServers;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$avServers = availableServers;
                    }

                    public void run() {
                        DuplicateAgreementDialog.access$402(1.access$300(this.this$1), new AvailableServerListModel());
                        Enumeration<E> enumeration = this.val$avServers.elements();
                        while (enumeration.hasMoreElements()) {
                            DuplicateAgreementDialog.access$400(1.access$300(this.this$1)).addElement((Object)enumeration.nextElement());
                        }
                        DuplicateAgreementDialog.access$500(1.access$300(this.this$1)).setModel(DuplicateAgreementDialog.access$400(1.access$300(this.this$1)));
                        DuplicateAgreementDialog.access$700(1.access$300(this.this$1), DuplicateAgreementDialog.access$600(1.access$300(this.this$1)));
                    }
                });
                DuplicateAgreementDialog.this._isInitialized = true;
            }

            static /* synthetic */ DuplicateAgreementDialog access$300(1 var0) {
                return var0.DuplicateAgreementDialog.this;
            }
        });
        thread.start();
        super.show();
    }

    public boolean somethingDuplicated() {
        return this._somethingDuplicated;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bAddHost) {
            DuplicateHostDialog duplicateHostDialog = new DuplicateHostDialog((JFrame)((Object)this._framework), this._agreement.isSSL);
            duplicateHostDialog.pack();
            duplicateHostDialog.show();
            if (!duplicateHostDialog.isCancelled()) {
                BasicServer basicServer = new BasicServer();
                basicServer.name = duplicateHostDialog.getHost();
                basicServer.port = duplicateHostDialog.getPort();
                basicServer.isSecurePort = this._agreement.isSSL;
                this._listModel.addElement(basicServer);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._listHosts) {
            this.setOKButtonEnabled(!this._listHosts.isSelectionEmpty() && this._listModel.getServerNumber() > 0);
        }
    }

    protected void okInvoked() {
        if (this._isInitialized) {
            final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("duplicateagreementdialog", "duplicatingagreement-title"), (Component)((Object)this));
            genericProgressDialog.setTextInLabel(_resource.getString("duplicateagreementdialog", "duplicatingagreement-msg"));
            genericProgressDialog.setLabelRows(1);
            genericProgressDialog.setLabelColumns(25);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LDAPConnection lDAPConnection = DuplicateAgreementDialog.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    Object[] objectArray = DuplicateAgreementDialog.this._listHosts.getSelectedValues();
                    boolean[] blArray = new boolean[]{false};
                    int n = 0;
                    while (n < objectArray.length && !blArray[0]) {
                        String[] stringArray;
                        ReplicationAgreement replicationAgreement = (ReplicationAgreement)DuplicateAgreementDialog.this._agreement.clone();
                        BasicServer basicServer = (BasicServer)objectArray[n];
                        replicationAgreement.host = basicServer.name;
                        replicationAgreement.port = basicServer.port;
                        DN dN = new DN(((DuplicateAgreementDialog)DuplicateAgreementDialog.this)._agreement.dn);
                        DN dN2 = dN.getParent();
                        replicationAgreement.dn = "cn=" + replicationAgreement.host + ":" + replicationAgreement.port + "," + dN2;
                        try {
                            PartialRule partialRule;
                            LDAPEntry lDAPEntry = ReplicationAgreement.getEntryForAgreement(replicationAgreement);
                            lDAPConnection.add(lDAPEntry);
                            stringArray = DuplicateAgreementDialog.this._framework.getServerObject().getPartialReplication();
                            String string = replicationAgreement.partialReplication;
                            if (!string.equals("") && (partialRule = stringArray.getRule(string)) != null) {
                                partialRule.addAgreement(replicationAgreement);
                            }
                            DuplicateAgreementDialog.this._somethingDuplicated = true;
                        }
                        catch (LDAPException lDAPException) {
                            stringArray = new String[]{replicationAgreement.host + ":" + replicationAgreement.port, DSUtil.getLDAPErrorMessage(lDAPException)};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, stringArray, blArray){
                                    private final /* synthetic */ String[] val$args;
                                    private final /* synthetic */ boolean[] val$done;
                                    private final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$args = stringArray;
                                        this.val$done = blArray;
                                    }

                                    public void run() {
                                        int n = DSUtil.showConfirmationDialog((Component)((Object)DuplicateAgreementDialog.access$000(3.access$1000(this.this$1))), "error-duplicatingagreement", this.val$args, "duplicateagreementdialog", DuplicateAgreementDialog.access$1100());
                                        this.val$done[0] = n != 0;
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    genericProgressDialog.closeCallBack();
                    if (DuplicateAgreementDialog.this._somethingDuplicated) {
                        DuplicateAgreementDialog.super.okInvoked();
                    }
                }

                static /* synthetic */ DuplicateAgreementDialog access$1000(3 var0) {
                    return var0.DuplicateAgreementDialog.this;
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
        } else {
            DuplicateAgreementDialog.super.okInvoked();
        }
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void showComponent(JComponent jComponent) {
        this._mainPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof JLabel) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._mainPanel.add((Component)jComponent, gridBagConstraints);
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    static /* synthetic */ AvailableServerListModel access$402(DuplicateAgreementDialog duplicateAgreementDialog, AvailableServerListModel availableServerListModel) {
        duplicateAgreementDialog._listModel = availableServerListModel;
        return duplicateAgreementDialog._listModel;
    }

    static /* synthetic */ AvailableServerListModel access$400(DuplicateAgreementDialog duplicateAgreementDialog) {
        return duplicateAgreementDialog._listModel;
    }

    static /* synthetic */ JPanel access$600(DuplicateAgreementDialog duplicateAgreementDialog) {
        return duplicateAgreementDialog._contentPanel;
    }

    static /* synthetic */ void access$700(DuplicateAgreementDialog duplicateAgreementDialog, JComponent jComponent) {
        duplicateAgreementDialog.showComponent(jComponent);
    }

    private class DuplicateHostDialog
    extends AbstractDialog {
        private JTextField _tfHost;
        private JTextField _tfPort;
        private boolean _isCancelled = true;

        public DuplicateHostDialog(JFrame jFrame, boolean bl) {
            super((Frame)jFrame, _resource.getString("duplicatehostdialog", "title"), true, 3);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.setComponent(jPanel);
            DocumentListener documentListener = new DocumentListener(this){
                private final /* synthetic */ DuplicateHostDialog this$1;
                {
                    this.this$1 = duplicateHostDialog;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    boolean bl = true;
                    try {
                        int n = Integer.parseInt(DuplicateHostDialog.access$1400(this.this$1).getText());
                        bl = n >= 0 && DuplicateHostDialog.access$1500(this.this$1).getText().trim().length() > 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    this.this$1.setOKButtonEnabled(bl);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
            JLabel jLabel = !bl ? UIFactory.makeJLabel("duplicatehostdialog", "ldescription-nonsecure", _resource) : UIFactory.makeJLabel("duplicatehostdialog", "ldescription-secure", _resource);
            JLabel jLabel2 = UIFactory.makeJLabel("duplicatehostdialog", "lhost", _resource);
            this._tfHost = UIFactory.makeJTextField(documentListener, "duplicatehostdialog", "lhost", null, 20, _resource);
            jLabel2.setLabelFor(this._tfHost);
            JLabel jLabel3 = UIFactory.makeJLabel("duplicatehostdialog", "lport", _resource);
            this._tfPort = UIFactory.makeJTextField(documentListener, "duplicatehostdialog", "lport", null, 6, _resource);
            jLabel3.setLabelFor(this._tfPort);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace(), 0);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = -1;
            jPanel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this._tfHost, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.right = UIFactory.getComponentSpace();
            gridBagConstraints.gridwidth = -1;
            jPanel.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets.right = 0;
            jPanel.add((Component)this._tfPort, gridBagConstraints);
            documentListener.changedUpdate(null);
        }

        public String getHost() {
            return this._tfHost.getText();
        }

        public int getPort() {
            int n = 0;
            try {
                n = Integer.parseInt(this._tfPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n;
        }

        public boolean isCancelled() {
            return this._isCancelled;
        }

        protected void okInvoked() {
            this._isCancelled = false;
            super.okInvoked();
        }

        static /* synthetic */ JTextField access$1400(DuplicateHostDialog duplicateHostDialog) {
            return duplicateHostDialog._tfPort;
        }

        static /* synthetic */ JTextField access$1500(DuplicateHostDialog duplicateHostDialog) {
            return duplicateHostDialog._tfHost;
        }
    }
}

