/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.config.URISyntaxException;

class URI {
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");

    public URI(String string) throws URISyntaxException {
        new Parser(string).parse(false);
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '@') {
                l |= 1L << c;
            }
            ++n2;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '@' && c < '\u0080') {
                l |= 1L << c - 64;
            }
            ++n2;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n3 = n;
        while (n3 <= n2) {
            l |= 1L << n3;
            ++n3;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        int n3 = n;
        while (n3 <= n2) {
            l |= 1L << n3;
            ++n3;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String string) {
            this.input = string;
        }

        private void fail(String string) throws URISyntaxException {
            throw new URISyntaxException(this.input, string);
        }

        private void fail(String string, int n) throws URISyntaxException {
            throw new URISyntaxException(this.input, string, n);
        }

        private void failExpecting(String string, int n) throws URISyntaxException {
            this.fail("Expected " + string, n);
        }

        private void failExpecting(String string, String string2, int n) throws URISyntaxException {
            this.fail("Expected " + string + " following " + string2, n);
        }

        private String substring(int n, int n2) {
            return this.input.substring(n, n2);
        }

        private char charAt(int n) {
            return this.input.charAt(n);
        }

        private boolean at(int n, int n2, char c) {
            return n < n2 && this.charAt(n) == c;
        }

        private boolean at(int n, int n2, String string) {
            int n3 = n;
            int n4 = string.length();
            if (n4 > n2 - n3) {
                return false;
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.charAt(n3++) != string.charAt(n5++)) break;
            }
            return n5 == n4;
        }

        private int scan(int n, int n2, char c) {
            if (n < n2 && this.charAt(n) == c) {
                return n + 1;
            }
            return n;
        }

        private int scan(int n, int n2, String string, String string2) {
            int n3 = n;
            while (n3 < n2) {
                char c = this.charAt(n3);
                if (string.indexOf(c) >= 0) {
                    return -1;
                }
                if (string2.indexOf(c) >= 0) break;
                ++n3;
            }
            return n3;
        }

        private int scanEscape(int n, int n2, char c) throws URISyntaxException {
            int n3 = n;
            char c2 = c;
            if (c2 == '%') {
                if (n3 + 3 <= n2 && URI.match(this.charAt(n3 + 1), L_HEX, H_HEX) && URI.match(this.charAt(n3 + 2), L_HEX, H_HEX)) {
                    return n3 + 3;
                }
                this.fail("Malformed escape pair", n3);
            } else if (c2 > '\u0080' && !Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                return n3 + 1;
            }
            return n3;
        }

        private int scan(int n, int n2, long l, long l2) throws URISyntaxException {
            int n3 = n;
            while (n3 < n2) {
                int n4;
                char c = this.charAt(n3);
                if (URI.match(c, l, l2)) {
                    ++n3;
                    continue;
                }
                if ((l & 1L) == 0L || (n4 = this.scanEscape(n3, n2, c)) <= n3) break;
                n3 = n4;
            }
            return n3;
        }

        private void checkChars(int n, int n2, long l, long l2, String string) throws URISyntaxException {
            int n3 = this.scan(n, n2, l, l2);
            if (n3 < n2) {
                this.fail("Illegal character in " + string, n3);
            }
        }

        private void checkChar(int n, long l, long l2, String string) throws URISyntaxException {
            this.checkChars(n, n + 1, l, l2, string);
        }

        void parse(boolean bl) throws URISyntaxException {
            this.requireServerAuthority = bl;
            int n = this.input.length();
            int n2 = this.scan(0, n, "/?#", ":");
            if (n2 >= 0 && this.at(n2, n, ':')) {
                if (n2 == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, n2, L_SCHEME, H_SCHEME, "scheme name");
                int n3 = ++n2;
                if (this.at(n2, n, '/')) {
                    n2 = this.parseHierarchical(n2, n);
                } else {
                    int n4 = this.scan(n2, n, "", "#");
                    if (n4 <= n2) {
                        this.failExpecting("scheme-specific part", n2);
                    }
                    this.checkChars(n2, n4, L_URIC, H_URIC, "opaque part");
                    n2 = n4;
                }
            } else {
                boolean bl2 = false;
                n2 = this.parseHierarchical(0, n);
            }
            if (this.at(n2, n, '#')) {
                this.checkChars(n2 + 1, n, L_URIC, H_URIC, "fragment");
                n2 = n;
            }
            if (n2 < n) {
                this.fail("end of URI", n2);
            }
        }

        private int parseHierarchical(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            if (this.at(n4, n2, '/') && this.at(n4 + 1, n2, '/')) {
                n3 = this.scan(n4 += 2, n2, "", "/?#");
                if (n3 > n4) {
                    n4 = this.parseAuthority(n4, n3);
                } else if (n3 >= n2) {
                    this.failExpecting("authority", n4);
                }
            }
            n3 = this.scan(n4, n2, "", "?#");
            this.checkChars(n4, n3, L_PATH, H_PATH, "path");
            n4 = n3;
            if (this.at(n4, n2, '?')) {
                n3 = this.scan(++n4, n2, "", "#");
                this.checkChars(n4, n3, L_URIC, H_URIC, "query");
                n4 = n3;
            }
            return n4;
        }

        private int parseAuthority(int n, int n2) throws URISyntaxException {
            boolean bl;
            int n3;
            int n4 = n3 = n;
            URISyntaxException uRISyntaxException = null;
            boolean bl2 = this.scan(n3, n2, L_SERVER, H_SERVER) == n2;
            boolean bl3 = bl = this.scan(n3, n2, L_REG_NAME, H_REG_NAME) == n2;
            if (bl && !bl2) {
                return n2;
            }
            if (bl2) {
                try {
                    n4 = this.parseServer(n3, n2);
                    if (n4 < n2) {
                        this.failExpecting("end of authority", n4);
                    }
                }
                catch (URISyntaxException uRISyntaxException2) {
                    if (this.requireServerAuthority) {
                        throw uRISyntaxException2;
                    }
                    uRISyntaxException = uRISyntaxException2;
                    n4 = n3;
                }
            }
            if (n4 < n2 && !bl) {
                if (uRISyntaxException != null) {
                    throw uRISyntaxException;
                }
                this.fail("Illegal character in authority", n4);
            }
            return n2;
        }

        private int parseServer(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, "/?#", "@");
            if (n4 >= n3 && this.at(n4, n2, '@')) {
                this.checkChars(n3, n4, L_USERINFO, H_USERINFO, "user info");
                n3 = n4 + 1;
            }
            if (this.at(n3, n2, '[')) {
                if ((n4 = this.scan(++n3, n2, "/?#", "]")) > n3 && this.at(n4, n2, ']')) {
                    this.parseIPv6Reference(n3, n4);
                    n3 = n4 + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", n4);
                }
            } else {
                n4 = this.parseIPv4Address(n3, n2);
                if (n4 <= n3) {
                    n4 = this.parseHostname(n3, n2);
                }
                n3 = n4;
            }
            if (this.at(n3, n2, ':') && (n4 = this.scan(++n3, n2, "", "/")) > n3) {
                this.checkChars(n3, n4, L_DIGIT, 0L, "port number");
                try {
                    int n5 = Integer.parseInt(this.substring(n3, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fail("Malformed port number", n3);
                }
                n3 = n4;
            }
            if (n3 < n2) {
                this.failExpecting("port number", n3);
            }
            return n3;
        }

        private int scanByte(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT, 0L);
            if (n4 <= n3) {
                return n4;
            }
            if (Integer.parseInt(this.substring(n3, n4)) > 255) {
                return n3;
            }
            return n4;
        }

        private int scanIPv4Address(int n, int n2, boolean bl) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT | L_DOT, 0L | H_DOT);
            if (n4 <= n3 || bl && n4 != n2) {
                return -1;
            }
            int n5 = this.scanByte(n3, n4);
            if (n5 > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3) {
                n3 = n5;
                if (n5 >= n4) {
                    return n5;
                }
            }
            this.fail("Malformed IPv4 address", n5);
            return -1;
        }

        private int takeIPv4Address(int n, int n2, String string) throws URISyntaxException {
            int n3 = this.scanIPv4Address(n, n2, true);
            if (n3 <= n) {
                this.failExpecting(string, n);
            }
            return n3;
        }

        private int parseIPv4Address(int n, int n2) throws URISyntaxException {
            int n3 = this.scanIPv4Address(n, n2, false);
            return n3;
        }

        private int parseHostname(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            int n5 = -1;
            while ((n3 = this.scan(n4, n2, L_ALPHANUM, H_ALPHANUM)) > n4) {
                n5 = n4;
                if (n3 > n4 && (n3 = this.scan(n4 = n3, n2, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > n4) {
                    if (this.charAt(n3 - 1) == '-') {
                        this.fail("Illegal character in hostname", n3 - 1);
                    }
                    n4 = n3;
                }
                if ((n3 = this.scan(n4, n2, '.')) > n4 && (n4 = n3) < n2) continue;
            }
            if (n4 < n2 && !this.at(n4, n2, ':')) {
                this.fail("Illegal character in hostname", n4);
            }
            if (n5 < 0) {
                this.failExpecting("hostname", n);
            }
            if (!URI.match(this.charAt(n5), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", n5);
            }
            return n4;
        }

        private int parseIPv6Reference(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, "::")) {
                    n3 = this.scanHexPost(n3 + 2, n2);
                } else if (this.at(n3, n2, ':')) {
                    n3 = this.takeIPv4Address(n3 + 1, n2, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(n3, n2, "::")) {
                n3 = this.scanHexPost(n3 + 2, n2);
            }
            if (n3 < n2) {
                this.fail("Malformed IPv6 address", n);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", n);
            }
            return n3;
        }

        private int scanHexPost(int n, int n2) throws URISyntaxException {
            int n3 = n;
            if (n3 == n2) {
                return n3;
            }
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, ':')) {
                    ++n3;
                    n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return n3;
        }

        private int scanHexSeq(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_HEX, H_HEX);
            if (n4 <= n3) {
                return -1;
            }
            if (this.at(n4, n2, '.')) {
                return -1;
            }
            this.ipv6byteCount += 2;
            n3 = n4;
            while (n3 < n2) {
                if (!this.at(n3, n2, ':') || this.at(n3 + 1, n2, ':')) break;
                if ((n4 = this.scan(++n3, n2, L_HEX, H_HEX)) <= n3) {
                    this.failExpecting("digits for an IPv6 address", n3);
                }
                if (this.at(n4, n2, '.')) {
                    --n3;
                    break;
                }
                if (n4 > n3 + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", n3);
                }
                this.ipv6byteCount += 2;
                n3 = n4;
            }
            return n3;
        }
    }
}

