/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.CustomTableModel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.LDAPSuffixReindex;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ReindexSuffixDialog
extends AbstractDialog
implements ActionListener,
TableModelListener {
    private DSFramework _framework;
    private String _suffix;
    private String _databaseName;
    private JPanel _mainPanel;
    private JPanel _contentPanel;
    private JTable _table;
    private JButton _bCheckAll;
    private JButton _bCheckNone;
    private ArrayList _lOrderedIndexes;
    private ArrayList _lSystemIndexes;
    private ArrayList _lEditableIndexes;
    private String[] _preselectedIndexes;
    private boolean _ignoreTableEvent;
    private static String HELP_TOKEN = "configuration-reindex-suffix-dbox-help";
    private static ResourceSet _resource = DSConfigPage._resource;
    private final JLabel REFRESH_LABEL = new JLabel(_resource.getString("reindexsuffixdialog-reading", "label"));
    private static final String[] HEADERS = new String[]{_resource.getString("reindexsuffixdialog", "header0"), _resource.getString("reindexsuffixdialog", "header1")};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public ReindexSuffixDialog(DSFramework dSFramework, String string, String string2, String[] stringArray) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        this._suffix = string;
        this._databaseName = string2;
        this._preselectedIndexes = stringArray;
        String[] stringArray2 = new String[]{DSUtil.abreviateString(this._suffix, 30)};
        ((Dialog)((Object)this)).setTitle(_resource.getString("reindexsuffixdialog", "title", stringArray2));
        this._lOrderedIndexes = new ArrayList();
        this._lSystemIndexes = new ArrayList();
        this._lEditableIndexes = new ArrayList();
        this._mainPanel = new JPanel(new GridBagLayout());
        this.setComponent(this._mainPanel);
        this.layoutContentPane();
        this.showComponent(this._contentPanel);
    }

    public void show() {
        this.setOKButtonEnabled(false);
        this.showComponent(this.REFRESH_LABEL);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ReindexSuffixDialog.this.readIndexes();
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ReindexSuffixDialog.access$200(1.access$100(this.this$1));
                            ReindexSuffixDialog.access$400(1.access$100(this.this$1), ReindexSuffixDialog.access$300(1.access$100(this.this$1)));
                        }
                    });
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(this, stringArray){
                        private final /* synthetic */ String[] val$arg;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$arg = stringArray;
                        }

                        public void run() {
                            MultilineLabel multilineLabel = new MultilineLabel(ReindexSuffixDialog.access$500().getString("reindexsuffixdialog", "error-reading-label", this.val$arg), 5, 30);
                            1.access$100(this.this$1).setOKButtonEnabled(false);
                            ReindexSuffixDialog.access$400(1.access$100(this.this$1), (JComponent)multilineLabel);
                        }
                    });
                }
            }

            static /* synthetic */ ReindexSuffixDialog access$100(1 var0) {
                return var0.ReindexSuffixDialog.this;
            }
        });
        thread.start();
        super.show();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!this._ignoreTableEvent) {
            boolean bl = false;
            int n = this._table.getRowCount();
            int n2 = 0;
            while (n2 < n && !bl) {
                Boolean bl2 = (Boolean)this._table.getValueAt(n2, 1);
                if (bl2.booleanValue()) {
                    bl = true;
                }
                ++n2;
            }
            this.setOKButtonEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bCheckAll) {
            this._ignoreTableEvent = true;
            int n = this._table.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                this._table.setValueAt(Boolean.TRUE, n2, 1);
                ++n2;
            }
            this.setOKButtonEnabled(true);
            this._ignoreTableEvent = false;
        } else if (object == this._bCheckNone) {
            this._ignoreTableEvent = true;
            int n = this._table.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                this._table.setValueAt(Boolean.FALSE, n3, 1);
                ++n3;
            }
            this.setOKButtonEnabled(false);
            this._ignoreTableEvent = false;
        }
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        int n;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = this._table.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            if (((Boolean)this._table.getValueAt(n3, 1)).booleanValue()) {
                object = (String)this._lOrderedIndexes.get(n3);
                arrayList.add((String[])object);
                if (this._lSystemIndexes.indexOf(object) >= 0) {
                    bl2 = true;
                }
            }
            ++n3;
        }
        object = new String[]{this._suffix};
        if (bl2) {
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-reindexsystemattribute", (String[])null, "reindexsuffixdialog", _resource);
            bl = 0 != n;
        } else {
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-reindex", (String[])null, "reindexsuffixdialog", _resource);
            boolean bl3 = bl = 0 != n;
        }
        if (!bl) {
            super.okInvoked();
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            new LDAPSuffixReindex(this._framework, this._suffix, stringArray, this._databaseName);
        }
    }

    private void layoutContentPane() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._table = new JTable(new CustomTableModel(this._lOrderedIndexes, this._lSystemIndexes, HEADERS));
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this._table.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReindexSuffixDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CheckBoxTableCellRenderer());
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ReindexSuffixDialog.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        this._table.setShowGrid(true);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        TableColumn tableColumn = this._table.getColumnModel().getColumn(0);
        Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, HEADERS[0], false, false, 0, 0);
        int n = component.getPreferredSize().width;
        Component component2 = labelCellRenderer.getTableCellRendererComponent(this._table, "thelongestnameoftheattribute", false, false, 0, 0);
        n = Math.max(n, (int)component2.getPreferredSize().getWidth());
        tableColumn.setPreferredWidth(n);
        tableColumn = this._table.getColumnModel().getColumn(1);
        component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, HEADERS[1], false, false, 0, 0);
        tableColumn.setPreferredWidth(component.getPreferredSize().width);
        int n2 = n + component.getPreferredSize().width + jScrollPane.getVerticalScrollBar().getPreferredSize().width;
        this._table.setPreferredScrollableViewportSize(new Dimension(n2, this._table.getRowHeight() * 20));
        this._bCheckAll = UIFactory.makeJButton(this, "reindexsuffixdialog", "bcheckall", _resource);
        this._bCheckNone = UIFactory.makeJButton(this, "reindexsuffixdialog", "bchecknone", _resource);
        JLabel jLabel = UIFactory.makeJLabel("reindexsuffixdialog", "linformation", _resource);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, UIFactory.getComponentSpace(), 0);
        jPanel.add((Component)this._bCheckAll, gridBagConstraints);
        jPanel.add((Component)this._bCheckNone, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        this._contentPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
    }

    private void readIndexes() throws LDAPException {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"cn", "nsSystemIndex"};
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=index, cn=" + this._databaseName + ", cn=ldbm database, cn=plugins, cn=config", 1, "objectclass=nsIndex", stringArray, false);
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            String string = DSUtil.getAttrValue(lDAPEntry, "cn");
            boolean bl = DSUtil.getAttrValue(lDAPEntry, "nsSystemIndex").equalsIgnoreCase("true");
            DSUtil.insertAlphabetically(this._lOrderedIndexes, string);
            if (bl) {
                this._lSystemIndexes.add(string);
                continue;
            }
            this._lEditableIndexes.add(string);
        }
    }

    private void initializeTable() {
        boolean bl = false;
        CustomTableModel customTableModel = (CustomTableModel)this._table.getModel();
        customTableModel.initValues();
        if (this._preselectedIndexes != null) {
            int n = 0;
            while (n < this._preselectedIndexes.length) {
                int n2 = this._lOrderedIndexes.indexOf(this._preselectedIndexes[n]);
                if (n2 >= 0) {
                    this._table.setValueAt(Boolean.TRUE, n2, 1);
                    bl = true;
                }
                ++n;
            }
        }
        this.setOKButtonEnabled(bl);
        customTableModel.addTableModelListener(this);
    }

    private void showComponent(JComponent jComponent) {
        this._mainPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (jComponent != this._contentPanel) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._mainPanel.add((Component)jComponent, gridBagConstraints);
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    static /* synthetic */ void access$200(ReindexSuffixDialog reindexSuffixDialog) {
        reindexSuffixDialog.initializeTable();
    }

    static /* synthetic */ JPanel access$300(ReindexSuffixDialog reindexSuffixDialog) {
        return reindexSuffixDialog._contentPanel;
    }

    static /* synthetic */ void access$400(ReindexSuffixDialog reindexSuffixDialog, JComponent jComponent) {
        reindexSuffixDialog.showComponent(jComponent);
    }

    static /* synthetic */ ResourceSet access$500() {
        return _resource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

