/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.LocalSuffixComboRenderer;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.AbstractList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class NewSuffixOptionsDialog
extends GenericDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private JCheckBox _cbClone;
    private JCheckBox _cbCloneIndex;
    private JCheckBox _cbCloneEncryptedAttributes;
    private JCheckBox _cbCloneReplication;
    private JComboBox _comboSuffixes;
    private JPanel _contentPanel;
    private JTextField _tfDbName;
    private JTextField _tfDbLocation;
    private JRadioButton _rbUseDefaultName;
    private JRadioButton _rbUseCustomName;
    private JButton _bBrowse;
    private String _helpToken = "configuration-new-suffix-dbox-options-help";
    private boolean _isInitialized;
    private boolean _isCancelled = true;
    private String _defaultLocation;
    private static final ResourceSet _resource = DSConfigPage._resource;
    public static final String NO_SUFFIX_AVAILABLE = _resource.getString("newsuffixoptionsdialog", "nosuffixavailable-label");

    public NewSuffixOptionsDialog(DSFramework dSFramework) {
        super((JFrame)((Object)dSFramework), _resource.getString("newsuffixoptionsdialog", "title"), 11, 0);
        this._framework = dSFramework;
        this.layoutContentPane();
        this.getContentPane().add(this._contentPanel);
        String string = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
        String string2 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
        this._defaultLocation = string + '/' + string2 + "/db";
    }

    public void show() {
        this._isCancelled = true;
        super.show();
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void setDbName(String string) {
        this._tfDbName.setText(string);
        if (string != null) {
            this._rbUseCustomName.setSelected(true);
            this._tfDbName.setEnabled(true);
            this.checkOKButtonEnabled();
        } else {
            this._rbUseDefaultName.setSelected(true);
            this._tfDbName.setEnabled(false);
            this.checkOKButtonEnabled();
        }
    }

    public void setDbLocation(String string) {
        this._tfDbLocation.setText(string);
    }

    public void setSuffixToClone(Suffix suffix) {
        this._comboSuffixes.setSelectedItem(suffix);
    }

    public void setCloneValues(boolean[] blArray) {
        this._cbClone.setSelected(blArray[0]);
        this._cbCloneIndex.setSelected(blArray[1]);
        this._cbCloneEncryptedAttributes.setSelected(blArray[2]);
        this._cbCloneReplication.setSelected(blArray[3]);
        this._cbCloneIndex.setEnabled(blArray[0]);
        this._cbCloneEncryptedAttributes.setEnabled(blArray[0]);
        this._cbCloneReplication.setEnabled(blArray[0]);
        this._comboSuffixes.setEnabled(blArray[0]);
    }

    public String getDbName() {
        if (this._rbUseCustomName.isSelected()) {
            return this._tfDbName.getText();
        }
        return null;
    }

    public String getDbLocation() {
        return this._tfDbLocation.getText();
    }

    public Suffix getSuffixToClone() {
        Object object = this._comboSuffixes.getSelectedItem();
        Suffix suffix = null;
        if (object instanceof Suffix) {
            suffix = (Suffix)object;
        }
        return suffix;
    }

    public boolean[] getCloneValues() {
        boolean[] blArray = new boolean[]{this._cbClone.isSelected(), this._cbCloneIndex.isSelected(), this._cbCloneEncryptedAttributes.isSelected(), this._cbCloneReplication.isSelected()};
        return blArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbClone) {
            boolean bl = this._cbClone.isSelected();
            this._cbCloneIndex.setEnabled(bl);
            this._cbCloneEncryptedAttributes.setEnabled(bl);
            this._cbCloneReplication.setEnabled(bl);
            this._comboSuffixes.setEnabled(bl);
            this.checkOKButtonEnabled();
        } else if (object == this._bBrowse) {
            Object object2;
            String string = this._tfDbLocation.getText().trim();
            if (string.length() == 0) {
                if (DSFileDialog.getDefaultDirectory() == null) {
                    object2 = new File(this._defaultLocation);
                    while (!((File)object2).exists() && object2 != null) {
                        object2 = ((File)object2).getParentFile();
                    }
                    if (object2 != null) {
                        DSFileDialog.setDefaultDirectory(((File)object2).getPath());
                    }
                }
            } else {
                object2 = new File(string);
                while (!((File)object2).exists() && object2 != null) {
                    object2 = ((File)object2).getParentFile();
                }
                if (object2 != null) {
                    DSFileDialog.setDefaultDirectory(((File)object2).getPath());
                }
            }
            if ((object2 = DSFileDialog.browseDirectories(true, this._bBrowse)) != null) {
                this._tfDbLocation.setText((String)object2);
            }
        } else if (object == this._rbUseCustomName || object == this._rbUseDefaultName) {
            this._tfDbName.setEnabled(this._rbUseCustomName.isSelected());
            this.checkOKButtonEnabled();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOKButtonEnabled();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void okInvoked() {
        if (this._rbUseCustomName.isSelected()) {
            boolean bl = false;
            String string = this._tfDbName.getText();
            DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
            ListIterator listIterator = ((AbstractList)databaseConfig.getDatabases()).listIterator();
            while (listIterator.hasNext() && !bl) {
                Database database = (Database)listIterator.next();
                if (database.getType() != 0) continue;
                bl = string.equalsIgnoreCase(database.getName());
            }
            if (bl) {
                DSUtil.showErrorDialog((Component)((Object)this), "error-databaseexists-title", "error-databaseexists-msg", null, "newsuffixoptionsdialog", _resource);
            } else {
                this._isCancelled = false;
                super.okInvoked();
            }
        } else {
            this._isCancelled = false;
            super.okInvoked();
        }
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void layoutContentPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._cbClone = UIFactory.makeJCheckBox(this, "newsuffixoptionsdialog", "cbclone", false, _resource);
        ConfigBasePanel.addComponentBorder(jPanel, this._cbClone);
        this._cbCloneIndex = UIFactory.makeJCheckBox(null, "newsuffixoptionsdialog", "cbcloneindex", false, _resource);
        this._cbCloneEncryptedAttributes = UIFactory.makeJCheckBox(null, "newsuffixoptionsdialog", "cbcloneencryptedattributes", true, _resource);
        this._cbCloneReplication = UIFactory.makeJCheckBox(null, "newsuffixoptionsdialog", "cbclonereplication", true, _resource);
        this._comboSuffixes = new JComboBox();
        this._comboSuffixes.setRenderer(new LocalSuffixComboRenderer());
        JLabel jLabel = UIFactory.makeJLabel("newsuffixoptionsdialog", "lsuffix", _resource);
        jLabel.setLabelFor(this._comboSuffixes);
        GroupPanel groupPanel = new GroupPanel(_resource.getString("newsuffixoptionsdialog", "dbpanel-label"));
        this._rbUseDefaultName = UIFactory.makeJRadioButton(this, "newsuffixoptionsdialog", "rbusedefaultname", false, _resource);
        this._rbUseCustomName = UIFactory.makeJRadioButton(this, "newsuffixoptionsdialog", "rbusecustomname", false, _resource);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbUseDefaultName);
        buttonGroup.add(this._rbUseCustomName);
        this._rbUseDefaultName.setSelected(true);
        JLabel jLabel2 = UIFactory.makeJLabel("newsuffixoptionsdialog", "ldbname", _resource);
        this._tfDbName = UIFactory.makeJTextField(this, "newsuffixoptionsdialog", "ldbname", null, 30, _resource);
        this._tfDbName.setEnabled(false);
        jLabel2.setLabelFor(this._tfDbName);
        JLabel jLabel3 = UIFactory.makeJLabel("newsuffixoptionsdialog", "ldblocation", _resource);
        this._tfDbLocation = UIFactory.makeJTextField(this, "newsuffixoptionsdialog", "ldblocation", null, 30, _resource);
        jLabel3.setLabelFor(this._tfDbLocation);
        this._bBrowse = UIFactory.makeJButton(this, "newsuffixoptionsdialog", "bbrowse", _resource);
        this._contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, UIFactory.getComponentSpace() - 4, 0, UIFactory.getComponentSpace() - 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this._comboSuffixes, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel.add((Component)this._cbCloneIndex, gridBagConstraints);
        jPanel.add((Component)this._cbCloneEncryptedAttributes, gridBagConstraints);
        jPanel.add((Component)this._cbCloneReplication, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 4;
        groupPanel.add((Component)jLabel2, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        groupPanel.add((Component)this._rbUseDefaultName, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        groupPanel.add((Component)this._rbUseCustomName, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._tfDbName, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._tfDbLocation, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        groupPanel.add((Component)jPanel2, gridBagConstraints);
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext()) {
            Database database;
            Suffix suffix = (Suffix)listIterator.next();
            if (suffix.getDatabases().size() != 1 || (database = (Database)suffix.getDatabases().get(0)).getType() != 0) continue;
            this._comboSuffixes.addItem(suffix);
        }
        if (this._comboSuffixes.getItemCount() == 0) {
            this._comboSuffixes.addItem(NO_SUFFIX_AVAILABLE);
        }
        this._bBrowse.setEnabled(DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost()));
    }

    private void checkOKButtonEnabled() {
        boolean bl = !this._tfDbLocation.getText().trim().equals("") && (!this._cbClone.isSelected() || this._comboSuffixes.getItemAt(0) != NO_SUFFIX_AVAILABLE);
        this.setOKButtonEnabled(bl);
    }
}

