/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.DecryptInfo;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class LDAPSuffixExport
implements Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private String _suffix;
    private String _fileName;
    private String _databaseName;
    private boolean _exportReplicaInformation;
    private DecryptInfo _decryptInfo;
    private boolean _taskCancelled;
    private String _taskDn;
    private static ResourceSet _resource = DSConfigPage._resource;

    public LDAPSuffixExport(DSFramework dSFramework, String string, String string2, String string3, boolean bl, DecryptInfo decryptInfo) {
        this._framework = dSFramework;
        this._suffix = string;
        this._fileName = string2;
        this._databaseName = string3;
        this._exportReplicaInformation = bl;
        this._decryptInfo = decryptInfo;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            this.initTask();
        }
        catch (LDAPException object) {
            bl = true;
            stringArray = object;
            SwingUtilities.invokeLater(new Runnable((LDAPException)stringArray){
                private final /* synthetic */ LDAPException val$fLde;
                {
                    this.val$fLde = lDAPException;
                }

                public void run() {
                    if (((LDAPSuffixExport)LDAPSuffixExport.this)._decryptInfo.decrypt && this.val$fLde.getLDAPResultCode() == 53) {
                        DSUtil.showErrorDialog((Component)((Object)LDAPSuffixExport.this._framework), "error-decrypt-authentication-title", "error-decrypt-authentication-msg", null, "ldapsuffixexport", _resource);
                    } else {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(this.val$fLde)};
                        DSUtil.showErrorDialog((Component)((Object)LDAPSuffixExport.this._framework), "error-launching-title", "error-launching-msg", stringArray, "ldapsuffixexport", _resource);
                    }
                }
            });
        }
        if (!bl) {
            try {
                this.updateProgressDialog();
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)LDAPSuffixExport.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "ldapsuffixexport", _resource);
                    }
                });
            }
            this._dlg.waitForClose();
        } else {
            this._dlg.closeCallBack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "ldapsuffixexport", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("ldapsuffixexport", "title"), null, this);
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix, 40), DSUtil.inverseAbreviateString(this._fileName, 40)};
        this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "exporting-label", stringArray));
        this._dlg.setLabelRows(2);
        this._dlg.disableCancelButton();
        this._dlg.addStep(_resource.getString("ldapsuffixexport", "firststep-label"));
        this._dlg.addStep(_resource.getString("ldapsuffixexport", "secondstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("ldapsuffixexport", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException {
        this._taskCancelled = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsFilename", this._fileName));
        lDAPAttributeSet.add(new LDAPAttribute("nsInstance", this._databaseName));
        if (this._exportReplicaInformation) {
            lDAPAttributeSet.add(new LDAPAttribute("nsExportReplica", "TRUE"));
        } else {
            lDAPAttributeSet.add(new LDAPAttribute("nsExportReplica", "FALSE"));
        }
        if (this._decryptInfo.decrypt) {
            lDAPAttributeSet.add(new LDAPAttribute("dsDecryptAttrs", "true"));
            if (this._decryptInfo.usePassword) {
                lDAPAttributeSet.add(new LDAPAttribute("dsKeyDbPwd", this._decryptInfo.password));
            }
            if (this._decryptInfo.useFile) {
                lDAPAttributeSet.add(new LDAPAttribute("dsKeyDbPwdFile", this._decryptInfo.fileName));
            }
        } else {
            lDAPAttributeSet.add(new LDAPAttribute("dsDecryptAttrs", "false"));
        }
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=export" + System.currentTimeMillis() + ", cn=export, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        while (!bl && !this._taskCancelled) {
            String[] stringArray;
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                stringArray = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                if (stringArray.lastIndexOf("Beginning export of") >= 0) {
                    this._dlg.stepCompleted(0);
                }
                if (stringArray.lastIndexOf("Export finished") >= 0) {
                    this._dlg.stepCompleted(1);
                }
                this._dlg.setTextInTextArea((String)stringArray);
                String string = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (string.equals("")) continue;
                bl = true;
                String[] stringArray2 = new String[]{DSUtil.abreviateString(this._suffix, 40)};
                if (string.equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "successful-label", stringArray2));
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "unsuccessful-label", stringArray2));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                stringArray = new String[]{DSUtil.abreviateString(this._suffix, 40)};
                this._dlg.setTextInLabel(_resource.getString("ldapsuffixexport", "successful-label", stringArray));
            }
        }
    }
}

