/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.DecryptInfo;
import com.netscape.admin.dirserv.config.LDAPSuffixExport;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class ExportSuffixDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private String _suffix;
    private String _databaseName;
    private boolean _isLocal;
    private JTextField _tfFile;
    private JButton _bBrowse;
    private JCheckBox _cbExportReplicaInformation;
    private JCheckBox _cbExportDecrypted;
    private JRadioButton _rbPasswordToDecrypt;
    private JRadioButton _rbFileToDecrypt;
    private JTextField _tfFileToDecrypt;
    private JPasswordField _pfPasswordToDecrypt;
    private JButton _bBrowseToDecrypt;
    private String _defaultLocation;
    private String _fileName;
    private boolean _isCancelled = true;
    private boolean _hasEncryptedAttributes = false;
    private static final String HELP_TOKEN = "configuration-export-suffix-dbox-help";
    private static ResourceSet _resource = DSConfigPage._resource;

    public ExportSuffixDialog(DSFramework dSFramework, String string, String string2) {
        super((Frame)((Object)dSFramework), null, true, 11);
        Serializable serializable;
        this._framework = dSFramework;
        this._suffix = string;
        this._databaseName = string2;
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix, 30)};
        ((Dialog)((Object)this)).setTitle(_resource.getString("exportsuffixdialog", "title", stringArray));
        this._hasEncryptedAttributes = this.hasEncryptedAttributes(this._databaseName);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        String string3 = this._isLocal ? "lfile" : "lfileonserver";
        JLabel jLabel = UIFactory.makeJLabel("exportsuffixdialog", string3, _resource);
        this._tfFile = UIFactory.makeJTextField(this, "exportsuffixdialog", string3, null, 30, _resource);
        jLabel.setLabelFor(this._tfFile);
        this._bBrowse = UIFactory.makeJButton(this, "exportsuffixdialog", "bbrowse", _resource);
        this._bBrowse.setEnabled(this._isLocal);
        this._cbExportReplicaInformation = UIFactory.makeJCheckBox(this, "exportsuffixdialog", "cbexportreplicainformation", false, _resource);
        String string4 = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
        String string5 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
        this._defaultLocation = string4 + '/' + string5 + "/ldif";
        JLabel jLabel2 = null;
        if (this._hasEncryptedAttributes) {
            jLabel2 = UIFactory.makeJLabel("exportsuffixdialog", "lencrypted", _resource);
            jLabel2.setIcon((Icon)DSUtil.getPackageImage("failed.gif"));
            jLabel2.setFont(jLabel2.getFont().deriveFont(2));
            this._cbExportDecrypted = UIFactory.makeJCheckBox(this, "exportsuffixdialog", "cbexportdecrypted", false, _resource);
            this._rbPasswordToDecrypt = UIFactory.makeJRadioButton(this, "exportsuffixdialog", "rbpasswordtodecrypt", false, _resource);
            this._rbFileToDecrypt = UIFactory.makeJRadioButton(this, "exportsuffixdialog", "rbfiletodecrypt", false, _resource);
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this._rbPasswordToDecrypt);
            ((ButtonGroup)serializable).add(this._rbFileToDecrypt);
            this._pfPasswordToDecrypt = UIFactory.makeJPasswordField(this, "exportsuffixdialog", "rbpasswordtodecrypt", null, 15, _resource);
            this._tfFileToDecrypt = UIFactory.makeJTextField(this, "exportsuffixdialog", "rbfiletodecrypt", null, 15, _resource);
            this._bBrowseToDecrypt = UIFactory.makeJButton(this, "exportsuffixdialog", "bbrowsetodecrypt", _resource);
        }
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridwidth = 3;
        jPanel.add((Component)jLabel, serializable);
        ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        jPanel.add((Component)this._tfFile, serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        jPanel.add((Component)this._bBrowse, serializable);
        ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).insets.left = 0;
        jPanel.add((Component)this._cbExportReplicaInformation, serializable);
        if (this._hasEncryptedAttributes) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
            ((GridBagConstraints)serializable).insets.left = 0;
            jPanel.add((Component)new JSeparator(0), serializable);
            jPanel.add((Component)jPanel2, serializable);
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
            ((GridBagConstraints)serializable).fill = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).anchor = 17;
            jPanel2.add((Component)jLabel2, serializable);
            ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
            jPanel2.add((Component)this._cbExportDecrypted, serializable);
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).gridwidth = -1;
            ((GridBagConstraints)serializable).weightx = 0.0;
            jPanel2.add((Component)this._rbPasswordToDecrypt, serializable);
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
            jPanel2.add((Component)this._pfPasswordToDecrypt, serializable);
            ((GridBagConstraints)serializable).insets.left = 0;
            ((GridBagConstraints)serializable).insets.top = 0;
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            ((GridBagConstraints)serializable).gridwidth = -1;
            ((GridBagConstraints)serializable).weightx = 1.0;
            jPanel3.add((Component)this._tfFileToDecrypt, serializable);
            ((GridBagConstraints)serializable).weightx = 0.0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
            jPanel3.add((Component)this._bBrowseToDecrypt, serializable);
            ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
            ((GridBagConstraints)serializable).insets.left = 0;
            ((GridBagConstraints)serializable).gridwidth = -1;
            ((GridBagConstraints)serializable).weightx = 0.0;
            jPanel2.add((Component)this._rbFileToDecrypt, serializable);
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
            jPanel2.add((Component)jPanel3, serializable);
            this._cbExportDecrypted.setSelected(false);
            this._rbPasswordToDecrypt.setSelected(true);
            this.checkEnablingDecryptPanel();
        }
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).fill = 3;
        ((GridBagConstraints)serializable).insets.top = 0;
        jPanel.add(Box.createVerticalGlue(), serializable);
        this.setComponent(jPanel);
        this.setFocusComponent(this._tfFile);
        this.checkOKButton();
    }

    public String getFileName() {
        return this._fileName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bBrowse) {
            String string;
            String string2 = this._tfFile.getText().trim();
            String[] stringArray = new String[]{"ldif"};
            String[] stringArray2 = new String[]{_resource.getString("exportsuffixdialog", "ldif-description")};
            if (DSFileDialog.getDefaultDirectory() == null) {
                DSFileDialog.setDefaultDirectory(this._defaultLocation);
            }
            if ((string = DSFileDialog.browseFiles(string2, true, stringArray, stringArray2, this._bBrowse)) != null) {
                this._tfFile.setText(string);
            }
        } else if (object == this._cbExportDecrypted) {
            this.checkEnablingDecryptPanel();
            this.checkOKButton();
        } else if (object == this._rbPasswordToDecrypt) {
            this.checkEnablingDecryptPanel();
            this.checkOKButton();
        } else if (object == this._rbFileToDecrypt) {
            this.checkEnablingDecryptPanel();
            this.checkOKButton();
        } else if (object == this._bBrowseToDecrypt) {
            String string;
            String string3 = this._tfFileToDecrypt.getText().trim();
            if (DSFileDialog.getDefaultDirectory() == null) {
                DSFileDialog.setDefaultDirectory(this._defaultLocation);
            }
            if ((string = DSFileDialog.browseFiles(string3, true, null, null, this._bBrowseToDecrypt)) != null) {
                this._tfFileToDecrypt.setText(string);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._tfFile.getDocument()) {
            this.checkOKButton();
        } else if (documentEvent.getDocument() == this._pfPasswordToDecrypt.getDocument()) {
            this.checkOKButton();
        } else if (documentEvent.getDocument() == this._tfFileToDecrypt.getDocument()) {
            this.checkOKButton();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        Object object;
        String string = this._tfFile.getText().trim();
        File file = new File(string);
        if (this._isLocal && !file.isAbsolute()) {
            string = DSFileDialog.getDefaultDirectory() != null ? DSFileDialog.getDefaultDirectory() + File.separator + string : this._defaultLocation + File.separator + string;
        }
        boolean bl = false;
        if (this._isLocal && DSUtil.fileExists(file)) {
            object = new String[]{string};
            int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmation-fileexists", object, "exportsuffixdialog", _resource);
            boolean bl2 = bl = 0 != n;
        }
        if (!bl) {
            DSUtil.showInformationDialog((Component)((Object)this._framework), "warning-server-permission", null, "exportsuffixdialog", _resource);
            this._isCancelled = false;
            super.okInvoked();
            object = new DecryptInfo();
            if (this._hasEncryptedAttributes) {
                object.decrypt = this._cbExportDecrypted.isSelected();
                object.usePassword = this._rbPasswordToDecrypt.isEnabled() && this._rbPasswordToDecrypt.isSelected();
                boolean bl3 = object.useFile = this._rbFileToDecrypt.isEnabled() && this._rbFileToDecrypt.isSelected();
                if (object.usePassword) {
                    object.password = String.valueOf(this._pfPasswordToDecrypt.getPassword());
                }
                if (object.useFile) {
                    object.fileName = this._tfFileToDecrypt.getText();
                }
            } else {
                object.decrypt = false;
            }
            this._fileName = string;
            new LDAPSuffixExport(this._framework, this._suffix, string, this._databaseName, this._cbExportReplicaInformation.isSelected(), (DecryptInfo)object);
        }
    }

    private boolean hasEncryptedAttributes(String string) {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        String string2 = "cn=" + string + ", cn=ldbm database, cn=plugins, cn=config";
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(1);
        String[] stringArray = new String[]{"dn"};
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=encrypted attributes, " + string2, 1, "objectclass=dsAttributeEncryption", stringArray, false, lDAPSearchConstraints);
            while (lDAPSearchResults.hasMoreElements() && !bl) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                boolean bl2 = bl = lDAPEntry != null;
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return bl;
    }

    private void checkEnablingDecryptPanel() {
        boolean bl = this._cbExportDecrypted.isSelected();
        this._rbFileToDecrypt.setEnabled(bl);
        this._rbPasswordToDecrypt.setEnabled(bl);
        this._pfPasswordToDecrypt.setEnabled(bl && this._rbPasswordToDecrypt.isSelected());
        if (!this._pfPasswordToDecrypt.isEnabled()) {
            this._tfFileToDecrypt.setEnabled(false);
            this._pfPasswordToDecrypt.setBackground(this._tfFileToDecrypt.getBackground());
        } else {
            this._tfFileToDecrypt.setEnabled(true);
            this._pfPasswordToDecrypt.setBackground(this._tfFileToDecrypt.getBackground());
        }
        this._tfFileToDecrypt.setEnabled(bl && this._rbFileToDecrypt.isSelected());
        this._bBrowseToDecrypt.setEnabled(bl && this._rbFileToDecrypt.isSelected() && this._isLocal);
    }

    private void checkOKButton() {
        boolean bl;
        boolean bl2 = bl = !this._tfFile.getText().trim().equals("");
        if (bl && this._hasEncryptedAttributes) {
            if (!this._cbExportDecrypted.isSelected()) {
                bl = true;
            } else if (this._rbPasswordToDecrypt.isSelected()) {
                bl = this._pfPasswordToDecrypt.getPassword().length > 0;
            } else if (this._rbPasswordToDecrypt.isSelected()) {
                bl = this._tfFileToDecrypt.getText().trim().equals("");
            }
        }
        this.setOKButtonEnabled(bl);
    }
}

