/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IChangeClient;
import com.netscape.admin.dirserv.IStartStopListener;
import com.netscape.admin.dirserv.config.ConfigDataNode;
import com.netscape.admin.dirserv.config.ConfigMenuController;
import com.netscape.admin.dirserv.config.ConfigSuffixNode;
import com.netscape.admin.dirserv.config.ConfigTreeController;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.admin.dirserv.config.IDatabaseConfigListener;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.ConfigReplicationPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class DSConfigPage
extends JPanel
implements IPage,
IAuthenticationChangeListener,
IStartStopListener,
TreeSelectionListener,
TreeWillExpandListener,
MouseListener,
ActionListener,
IDatabaseConfigListener {
    private ConfigMenuController _menuController;
    private ConfigDataNode _dataNode;
    private DSFramework _framework;
    private JTree _tree;
    private JScrollPane _treePanel;
    private JPanel _contentPanel;
    private Component _displayedCustomPanel;
    private JPopupMenu _contextMenu;
    private ConfigTreeController _treeController;
    private boolean _isInitialized = false;
    private boolean _isPageSelected = false;
    private boolean _refreshUponSelect = false;
    private boolean _dataRefreshUponSelect = false;
    private boolean _ignoreAuthenticationEvent = false;
    private boolean _ignoreDatabaseConfigEvents = false;
    private Vector _authListeners = new Vector();
    private Vector _changeClients = new Vector();
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.config.config");

    public void addChangeClient(IChangeClient iChangeClient) {
        this._changeClients.addElement(iChangeClient);
    }

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        Enumeration enumeration = this._changeClients.elements();
        while (enumeration.hasMoreElements()) {
            if (!((IChangeClient)enumeration.nextElement()).isDirty()) continue;
            throw new CloseVetoException();
        }
        this.shutDown();
    }

    public Object clone() {
        throw new IllegalStateException("DSConfigPage.clone() should not be called");
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public String getPageTitle() {
        return _resource.getString("configpage", "title");
    }

    public void initialize(IFramework iFramework) {
        this._framework = (DSFramework)iFramework;
        this._framework.getServerObject().getDatabaseConfig().addChangeListener(this);
        this._framework.getServerObject().addStartStopListener(this);
        this._tree = new JTree();
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        this._tree.addTreeWillExpandListener(this);
        this._tree.addMouseListener(this);
        this._treeController = new ConfigTreeController(this._tree, new CustomTreeModel(), this._framework);
        this.layoutComponents();
        this._contextMenu = new JPopupMenu();
        this._menuController = new ConfigMenuController(this._contextMenu, (IFramework)this._framework, this);
        this._menuController.addShortCutRegisterer(this._tree);
        this._tree.setSelectionRow(0);
        this.getAccessibleContext().setAccessibleName(this.getPageTitle());
        this.getAccessibleContext().setAccessibleDescription(_resource.getString("configpage", "description"));
        this._isInitialized = true;
    }

    public void pageSelected(IFramework iFramework) {
        this._isPageSelected = true;
        this._menuController.populateMenuItems();
        if (this._refreshUponSelect) {
            this.refreshPage();
        } else if (this._dataRefreshUponSelect) {
            this.getDataNode().refreshNode();
        }
        this._refreshUponSelect = false;
        this._dataRefreshUponSelect = false;
        if (this._displayedCustomPanel instanceof ConfigReplicationPanel) {
            ((ConfigReplicationPanel)this._displayedCustomPanel).notifyPanelVisible();
        }
    }

    public void pageUnselected(IFramework iFramework) {
        this._isPageSelected = false;
        this.shutDown();
        this._menuController.unpopulateMenuItems();
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        if (this._isInitialized && !this._ignoreAuthenticationEvent) {
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSConfigPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public boolean getNewAuthentication() {
        this._ignoreAuthenticationEvent = true;
        boolean bl = false;
        DSUtil.DeferAuthListeners deferAuthListeners = null;
        String string = (String)this._framework.getServerObject().getServerInfo().get("rootdn");
        deferAuthListeners = DSUtil.reauthenticateDefer(this._framework.getServerObject().getServerInfo().getLDAPConnection(), (JFrame)((Object)this._framework), this._authListeners, string, null);
        boolean bl2 = bl = deferAuthListeners != null;
        if (bl) {
            this.actionRefreshTree();
        }
        if (bl) {
            deferAuthListeners.notifyListeners();
        }
        this._ignoreAuthenticationEvent = false;
        return bl;
    }

    public void setAuthenticationChangeListener(Vector vector) {
        this._authListeners = vector;
    }

    public void serverStarted() {
        if (this._isInitialized) {
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSConfigPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public void serverStopped() {
        this.serverStarted();
    }

    public void serverRestarted() {
        this.serverStarted();
    }

    public void databaseConfigChanged() {
        if (!this._ignoreDatabaseConfigEvents) {
            if (!this._isPageSelected) {
                this._dataRefreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSConfigPage.this.getDataNode().refreshNode();
                    }
                });
            }
        }
    }

    public void suffixAdded(final Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Suffix suffix2 = suffix.getParentSuffix();
                    if (suffix2 == null) {
                        ConfigSuffixNode configSuffixNode = new ConfigSuffixNode(DSConfigPage.this._framework, suffix, DSConfigPage.this._tree);
                        ((DefaultTreeModel)DSConfigPage.this._tree.getModel()).insertNodeInto(configSuffixNode, DSConfigPage.this.getDataNode(), DSConfigPage.this.getDataNode().getChildCount());
                    } else {
                        ConfigSuffixNode configSuffixNode = DSConfigPage.this.getSuffixNode(suffix2);
                        if (configSuffixNode != null) {
                            ConfigSuffixNode configSuffixNode2 = new ConfigSuffixNode(DSConfigPage.this._framework, suffix, DSConfigPage.this._tree);
                            ((DefaultTreeModel)DSConfigPage.this._tree.getModel()).insertNodeInto(configSuffixNode2, configSuffixNode, configSuffixNode.getChildCount());
                        }
                    }
                }
            });
        }
    }

    public void suffixDeleted(final Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixNode configSuffixNode = DSConfigPage.this.getSuffixNode(suffix);
                    if (configSuffixNode != null) {
                        ((DefaultTreeModel)DSConfigPage.this._tree.getModel()).removeNodeFromParent(configSuffixNode);
                    }
                }
            });
        }
    }

    public void parentChanged(final Suffix suffix, Suffix suffix2, final Suffix suffix3) {
        if (!this._ignoreDatabaseConfigEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixNode configSuffixNode = DSConfigPage.this.getSuffixNode(suffix);
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DSConfigPage.this._tree.getModel();
                    if (configSuffixNode == null) {
                        configSuffixNode = new ConfigSuffixNode(DSConfigPage.this._framework, suffix, DSConfigPage.this._tree);
                    } else {
                        ((DefaultTreeModel)DSConfigPage.this._tree.getModel()).removeNodeFromParent(configSuffixNode);
                    }
                    if (suffix3 == null) {
                        defaultTreeModel.insertNodeInto(configSuffixNode, DSConfigPage.this.getDataNode(), DSConfigPage.this.getDataNode().getChildCount());
                    } else {
                        ConfigSuffixNode configSuffixNode2 = DSConfigPage.this.getSuffixNode(suffix3);
                        if (configSuffixNode2 != null) {
                            defaultTreeModel.insertNodeInto(configSuffixNode, configSuffixNode2, configSuffixNode2.getChildCount());
                        }
                    }
                }
            });
        }
    }

    public void rootEntryAdded(Suffix suffix) {
    }

    public void rootEntryDeleted(Suffix suffix) {
    }

    public void databaseAdded(Database database) {
        final Suffix suffix = database.getSuffix();
        if (!this._ignoreDatabaseConfigEvents && suffix != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixNode configSuffixNode = DSConfigPage.this.getSuffixNode(suffix);
                    if (configSuffixNode != null) {
                        configSuffixNode.refreshNode();
                    }
                }
            });
        }
    }

    public void databaseDeleted(Database database) {
        final Suffix suffix = database.getSuffix();
        if (!this._ignoreDatabaseConfigEvents && suffix != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixNode configSuffixNode = DSConfigPage.this.getSuffixNode(suffix);
                    if (configSuffixNode != null) {
                        configSuffixNode.refreshNode();
                    }
                }
            });
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IConfigNode iConfigNode = this._treeController.getSelectedNode();
        this.updateRightPane(iConfigNode);
        this._menuController.updateMenu(iConfigNode);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null && treePath.getPathCount() <= 1) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "REFRESH_ALL") {
            this.actionRefreshTree();
        } else if (string == "AUTHENTICATE") {
            this.actionAuthenticate();
        } else {
            this.actionToNode(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    protected void popupContextMenu(MouseEvent mouseEvent) {
        TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            if (!this._tree.isPathSelected(treePath)) {
                this._tree.setSelectionPath(treePath);
            }
            if (this._contextMenu.getComponentCount() > 0) {
                this._contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._treePanel = new JScrollPane();
        this._treePanel.getViewport().add(this._tree);
        this._treePanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._treePanel.setPreferredSize(new Dimension(200, 200));
        this._treePanel.setMinimumSize(new Dimension(1, 1));
        this._contentPanel = new JPanel();
        this._contentPanel.setLayout(new GridBagLayout());
        this._contentPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JSplitPane jSplitPane = new JSplitPane(1, this._treePanel, this._contentPanel);
        jSplitPane.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        jSplitPane.setDividerLocation((int)this._treePanel.getPreferredSize().getWidth());
        this.add((Component)jSplitPane, gridBagConstraints);
    }

    protected void updateRightPane(IConfigNode iConfigNode) {
        this._contentPanel.removeAll();
        if (this._displayedCustomPanel instanceof ConfigReplicationPanel) {
            ((ConfigReplicationPanel)this._displayedCustomPanel).notifyPanelInvisible();
        }
        this._displayedCustomPanel = null;
        if (iConfigNode != null) {
            this._displayedCustomPanel = iConfigNode.getCustomPanel();
            if (this._displayedCustomPanel != null) {
                if (this._displayedCustomPanel instanceof ConfigReplicationPanel) {
                    ((ConfigReplicationPanel)this._displayedCustomPanel).notifyPanelVisible();
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
                this._contentPanel.add(this._displayedCustomPanel, gridBagConstraints);
            }
        }
        this._contentPanel.validate();
        this._contentPanel.repaint();
    }

    private void actionAuthenticate() {
        this.getNewAuthentication();
    }

    private void actionRefreshTree() {
        String[] stringArray;
        DSUtil.setSchema(this._framework.getServerObject().getServerInfo(), null);
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        try {
            this._framework.getServerObject().getPartialReplication().reload(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-reloading-partial-title", "error-reloading-partial-msg", stringArray, "configpage", _resource);
        }
        this._ignoreDatabaseConfigEvents = true;
        try {
            this._framework.getServerObject().getDatabaseConfig().reload(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-reloading-databaseconfig-title", "error-reloading-databaseconfig-msg", stringArray, "configpage", _resource);
        }
        this.refreshPage();
        this._ignoreDatabaseConfigEvents = false;
    }

    private void refreshPage() {
        this._treeController.refreshTree();
        this._tree.clearSelection();
        this._tree.setSelectionRow(0);
    }

    private void actionToNode(String string) {
        IConfigNode iConfigNode = this._treeController.getSelectedNode();
        if (iConfigNode != null) {
            iConfigNode.menuAction(string);
        }
    }

    private void shutDown() {
        if (this._displayedCustomPanel instanceof ConfigReplicationPanel) {
            ((ConfigReplicationPanel)this._displayedCustomPanel).notifyPanelInvisible();
        }
    }

    private ConfigDataNode getDataNode() {
        if (this._dataNode == null) {
            boolean bl = false;
            Enumeration<? extends TreeNode> enumeration = ((TreeNode)this._tree.getModel().getRoot()).children();
            while (!bl && enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                if (!(treeNode instanceof ConfigDataNode)) continue;
                bl = true;
                this._dataNode = (ConfigDataNode)treeNode;
            }
        }
        return this._dataNode;
    }

    private ConfigSuffixNode getSuffixNode(Suffix suffix) {
        DN dN = new DN(suffix.getName());
        Enumeration<TreeNode> enumeration = this.getDataNode().children();
        return this.getNode(dN, enumeration);
    }

    private ConfigSuffixNode getNode(DN dN, Enumeration enumeration) {
        ConfigSuffixNode configSuffixNode = null;
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ConfigSuffixNode)) continue;
            ConfigSuffixNode configSuffixNode2 = (ConfigSuffixNode)e;
            DN dN2 = new DN(configSuffixNode2.getName());
            if (dN.equals(dN2)) {
                configSuffixNode = configSuffixNode2;
                bl = true;
                continue;
            }
            if (!dN.isDescendantOf(dN2)) continue;
            configSuffixNode = this.getNode(dN, configSuffixNode2.children());
            bl = true;
        }
        return configSuffixNode;
    }

    private class CustomTreeModel
    extends DefaultTreeModel {
        public CustomTreeModel() {
            super(new DefaultMutableTreeNode());
        }

        public void nodeChanged(TreeNode treeNode) {
            super.nodeChanged(treeNode);
            if (DSConfigPage.this._treeController.getSelectedNode() == treeNode) {
                DSConfigPage.this.updateRightPane((IConfigNode)((Object)treeNode));
                DSConfigPage.this._menuController.updateMenu((IConfigNode)((Object)treeNode));
            }
        }
    }
}

