/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IChangeClient;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigPanel;
import com.netscape.admin.dirserv.config.IDirtyValidListener;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ConfigTabbedBasePanel
extends JPanel
implements ActionListener,
ChangeListener,
IDirtyValidListener,
IChangeClient {
    private DSFramework _framework;
    private JButton _bOK = null;
    private JButton _bReset = null;
    private JButton _bHelp = null;
    private JPanel _innerPanel;
    private JPanel _buttonPanel;
    protected JTabbedPane _tabbedPane;
    private final JLabel SAVING_LABEL = UIFactory.makeJLabel("tabbedbasepanel", "saving", _resource);
    private final JLabel RESETTING_LABEL = UIFactory.makeJLabel("tabbedbasepanel", "resetting", _resource);
    private Vector _validDirty;
    private static ResourceSet _resource = DSConfigPage._resource;
    private static RemoteImage DIRTY_ICON = DSUtil.getPackageImage(_resource.getString("general", "tab-gif"));

    public ConfigTabbedBasePanel(DSFramework dSFramework) {
        this._framework = dSFramework;
        this.basicLayout();
        this._validDirty = new Vector();
        ((DSConfigPage)this._framework.getSelectedPage()).addChangeClient(this);
    }

    public void refreshPanel() {
        this.actionReset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bOK) {
            this.actionOK();
        } else if (object == this._bReset) {
            this.actionReset();
        } else if (object == this._bHelp) {
            this.actionHelp();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IConfigPanel iConfigPanel;
        if (changeEvent.getSource() == this._tabbedPane && !(iConfigPanel = (IConfigPanel)((Object)this._tabbedPane.getSelectedComponent())).isInitialized()) {
            iConfigPanel.setFramework(this._framework);
            iConfigPanel.init();
        }
    }

    public void setDirtyFlag(IConfigPanel iConfigPanel) {
        int n = this._tabbedPane.indexOfComponent((JComponent)((Object)iConfigPanel));
        boolean[] blArray = (boolean[])this._validDirty.elementAt(n);
        this._tabbedPane.setIconAt(n, (Icon)DIRTY_ICON);
        blArray[1] = true;
        this.updateButtons();
    }

    public void clearDirtyFlag(IConfigPanel iConfigPanel) {
        int n = this._tabbedPane.indexOfComponent((JComponent)((Object)iConfigPanel));
        boolean[] blArray = (boolean[])this._validDirty.elementAt(n);
        blArray[1] = false;
        this._tabbedPane.setIconAt(n, null);
        this.updateButtons();
    }

    public void setValidFlag(IConfigPanel iConfigPanel) {
        int n = this._tabbedPane.indexOfComponent((JComponent)((Object)iConfigPanel));
        boolean[] blArray = (boolean[])this._validDirty.elementAt(n);
        blArray[0] = true;
        this.updateButtons();
    }

    public void clearValidFlag(IConfigPanel iConfigPanel) {
        int n = this._tabbedPane.indexOfComponent((JComponent)((Object)iConfigPanel));
        boolean[] blArray = (boolean[])this._validDirty.elementAt(n);
        blArray[0] = false;
        this.updateButtons();
    }

    public boolean isDirty() {
        boolean bl = false;
        Enumeration enumeration = this._validDirty.elements();
        while (enumeration.hasMoreElements() && !bl) {
            boolean[] blArray = (boolean[])enumeration.nextElement();
            boolean bl2 = bl = bl || blArray[1];
        }
        return bl;
    }

    protected void addTab(IConfigPanel iConfigPanel) {
        this._tabbedPane.addTab(iConfigPanel.getTitle(), (JComponent)((Object)iConfigPanel));
        iConfigPanel.addValidDirtyListener(this);
        boolean[] blArray = new boolean[]{true, false};
        this._validDirty.addElement(blArray);
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        this._innerPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (bl) {
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.remove(this._buttonPanel);
        } else {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            if (!this.isAncestorOf(this._buttonPanel)) {
                this.add("South", this._buttonPanel);
            }
        }
        this._innerPanel.add((Component)jComponent, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void createButtonPanels() {
        this._bOK = UIFactory.makeJButton(this, "general", "apply", _resource);
        this._bOK.setEnabled(false);
        this._bReset = UIFactory.makeJButton(this, "general", "reset", _resource);
        this._bReset.setEnabled(false);
        this._bHelp = UIFactory.makeJButton(this, "general", "help", _resource);
        JButton[] jButtonArray = new JButton[]{this._bOK, this._bReset, this._bHelp};
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new BorderLayout());
        this._buttonPanel.add("Center", UIFactory.makeJButtonPanel(jButtonArray, true));
        this._buttonPanel.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
    }

    private void updateButtons() {
        Enumeration enumeration = this._validDirty.elements();
        boolean bl = true;
        boolean bl2 = false;
        while (enumeration.hasMoreElements() && (!bl2 || bl)) {
            boolean[] blArray = (boolean[])enumeration.nextElement();
            bl = bl && blArray[0];
            boolean bl3 = bl2 = bl2 || blArray[1];
        }
        this._bOK.setEnabled(bl && bl2);
        this._bReset.setEnabled(!bl || bl2);
    }

    private void actionOK() {
        int n = this._tabbedPane.getTabCount();
        ConfigPanelException configPanelException = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n && configPanelException == null) {
            IConfigPanel iConfigPanel = (IConfigPanel)((Object)this._tabbedPane.getComponentAt(n3));
            if (iConfigPanel.isInitialized()) {
                try {
                    boolean bl2 = true;
                    if (iConfigPanel.needsConfirmation()) {
                        this._tabbedPane.setSelectedIndex(n3);
                        bl2 = iConfigPanel.askForConfirmation();
                    }
                    if (bl2) {
                        iConfigPanel.okCallback();
                        boolean bl3 = bl = bl || iConfigPanel.needsRestartServer();
                        if (iConfigPanel.hasWarningMessage()) {
                            this._tabbedPane.setSelectedIndex(n3);
                            iConfigPanel.displayWarningMessage();
                        }
                    }
                }
                catch (ConfigPanelException configPanelException2) {
                    configPanelException = configPanelException2;
                    n2 = n3;
                }
            }
            ++n3;
        }
        this.showComponent(this._tabbedPane, false);
        if (configPanelException != null) {
            this._tabbedPane.setSelectedIndex(n2);
            JOptionPane.showMessageDialog(this, configPanelException.getMessage(), configPanelException.getTitle(), 0, (Icon)DSUtil.getPackageImage("error.gif"));
        }
        if (bl) {
            DSUtil.showInformationDialog((Component)((Object)this._framework), "needsrestartserver", null, "tabbedbasepanel", _resource);
        }
    }

    private void actionReset() {
        this.showComponent(this.RESETTING_LABEL, true);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n = ConfigTabbedBasePanel.this._tabbedPane.getTabCount();
                int n2 = 0;
                while (n2 < n) {
                    IConfigPanel iConfigPanel = (IConfigPanel)((Object)ConfigTabbedBasePanel.this._tabbedPane.getComponentAt(n2));
                    if (iConfigPanel.isInitialized()) {
                        iConfigPanel.resetCallback();
                    }
                    ++n2;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ConfigTabbedBasePanel.access$100(1.access$000(this.this$1), 1.access$000(this.this$1)._tabbedPane, false);
                    }
                });
            }

            static /* synthetic */ ConfigTabbedBasePanel access$000(1 var0) {
                return var0.ConfigTabbedBasePanel.this;
            }
        });
        thread.start();
    }

    private void actionHelp() {
        IConfigPanel iConfigPanel = (IConfigPanel)((Object)this._tabbedPane.getSelectedComponent());
        iConfigPanel.helpCallback();
    }

    private void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        this.createButtonPanels();
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addChangeListener(this);
        this._innerPanel = new JPanel(new GridBagLayout());
        this._innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this._innerPanel, "Center");
        this.showComponent(this._tabbedPane, false);
    }

    static /* synthetic */ void access$100(ConfigTabbedBasePanel configTabbedBasePanel, JComponent jComponent, boolean bl) {
        configTabbedBasePanel.showComponent(jComponent, bl);
    }
}

