/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.replication.Replica;
import com.netscape.admin.dirserv.config.replication.ReplicaChangeListener;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPUrl;

public class ConfigSuffixSettingsPanel
extends ConfigBasePanel
implements ActionListener,
ReplicaChangeListener {
    private boolean _isLocalSuffix;
    private boolean _isInitializing;
    private boolean _isCancelled;
    private JPanel _contentPanel;
    private JCheckBox _cbEnableSuffix;
    private JRadioButton _rbReadWrite;
    private JRadioButton _rbReferralOnUpdate;
    private JRadioButton _rbReferral;
    private JLabel _lReferral;
    private JList _listReferral;
    private DefaultListModel _listDataReferral;
    private JButton _bAddReferral;
    private JButton _bDeleteReferral;
    private boolean _saveReplicaEnabled;
    private int _saveSuffixState;
    private Vector _saveReferrals;
    private boolean _isSuffixStateDirty;
    private boolean _isReferralDirty;
    private String _mappingEntryDn;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("suffixsettingspanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("suffixsettingspanel-no-rights", "label"), 2, 50);
    private JPanel REPLICATION_ENABLED;
    private final int DISABLE_SUFFIX = 0;
    private final int READ_WRITE_SUFFIX = 1;
    private final int REFERRAL_ON_UPDATE_SUFFIX = 2;
    private final int REFERRAL_SUFFIX = 3;

    public ConfigSuffixSettingsPanel(String string, boolean bl) {
        this.setTitle(ConfigBasePanel._resource.getString("suffixsettingspanel", "title"));
        this._mappingEntryDn = string;
        this._helpToken = this._isLocalSuffix ? "configuration-suffix-settings-help" : "configuration-chainingsuffix-settings-help";
        this._saveReferrals = new Vector();
        this._isLocalSuffix = bl;
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigSuffixSettingsPanel.this.createContentPanel();
                        ConfigSuffixSettingsPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigSuffixSettingsPanel.access$300(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigSuffixSettingsPanel.access$400(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigSuffixSettingsPanel.access$500(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("suffixsettingspanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigSuffixSettingsPanel.this._isInitialized = true;
                    ConfigSuffixSettingsPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigSuffixSettingsPanel access$200(1 var0) {
                    return var0.ConfigSuffixSettingsPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixSettingsPanel.this.initComponentsFromServerValues();
                    ConfigSuffixSettingsPanel.this.fireValidDirtyChange();
                    ConfigSuffixSettingsPanel.this.showComponent(ConfigSuffixSettingsPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixSettingsPanel.this.showComponent((JComponent)ConfigSuffixSettingsPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("suffixsettingspanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixSettingsPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        LDAPConnection lDAPConnection;
        if (this._cbEnableSuffix.isSelected() && this._listDataReferral.isEmpty() && (this._rbReferralOnUpdate.isSelected() || this._rbReferral.isSelected())) {
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("suffixsettingspanel", "noreferral-error-title"), ConfigBasePanel._resource.getString("suffixsettingspanel", "noreferral-error-msg"));
        }
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        String string = null;
        if (this._isSuffixStateDirty) {
            if (!this._cbEnableSuffix.isSelected()) {
                string = "disabled";
            } else if (this._rbReadWrite.isSelected()) {
                string = "backend";
            } else if (this._rbReferralOnUpdate.isSelected()) {
                string = "referral on update";
            } else if (this._rbReferral.isSelected()) {
                string = "referral";
            } else {
                Thread.dumpStack();
            }
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-state", string));
        }
        if (this._isReferralDirty && this._cbEnableSuffix.isSelected()) {
            lDAPConnection = new String[this._listDataReferral.size()];
            int n = 0;
            while (n < this._listDataReferral.size()) {
                lDAPConnection[n] = (String)this._listDataReferral.elementAt(n);
                ++n;
            }
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-referral", (String[])lDAPConnection));
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                lDAPConnection = this.getServerInfo().getLDAPConnection();
                lDAPConnection.modify(this._mappingEntryDn, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("suffixsettingspanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("suffixsettingspanel", "updating-server-error-msg", stringArray));
            }
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbEnableSuffix) {
            this._isSuffixStateDirty = this._saveSuffixState != this.getState();
            this.enableComponents(this._cbEnableSuffix.isSelected());
            if (this._isSuffixStateDirty) {
                BlankPanel.setChangeState(this._cbEnableSuffix, 2);
            } else {
                BlankPanel.setChangeState(this._cbEnableSuffix, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._bAddReferral) {
            this.actionAddReferral();
            this._bDeleteReferral.setEnabled(!this._listReferral.isSelectionEmpty());
            this._isReferralDirty = this._listDataReferral.size() != this._saveReferrals.size();
            int n = 0;
            while (n < this._listDataReferral.size() && !this._isReferralDirty) {
                this._isReferralDirty = !this._listDataReferral.elementAt(n).equals(this._saveReferrals.elementAt(n));
                ++n;
            }
            if (this._isReferralDirty) {
                BlankPanel.setChangeState(this._lReferral, 2);
            } else {
                BlankPanel.setChangeState(this._lReferral, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._bDeleteReferral) {
            this.actionDeleteReferral();
            this._bDeleteReferral.setEnabled(!this._listReferral.isSelectionEmpty());
            this._isReferralDirty = this._listDataReferral.size() != this._saveReferrals.size();
            int n = 0;
            while (n < this._listDataReferral.size() && !this._isReferralDirty) {
                this._isReferralDirty = !this._listDataReferral.elementAt(n).equals(this._saveReferrals.elementAt(n));
                ++n;
            }
            if (this._isReferralDirty) {
                BlankPanel.setChangeState(this._lReferral, 2);
            } else {
                BlankPanel.setChangeState(this._lReferral, 1);
            }
            this.fireValidDirtyChange();
        } else if (object instanceof JRadioButton) {
            boolean bl = this._isSuffixStateDirty = this._saveSuffixState != this.getState();
            if (this._isSuffixStateDirty) {
                BlankPanel.setChangeState(this._rbReadWrite, 2);
                BlankPanel.setChangeState(this._rbReferralOnUpdate, 2);
                BlankPanel.setChangeState(this._rbReferral, 2);
            } else {
                BlankPanel.setChangeState(this._rbReadWrite, 1);
                BlankPanel.setChangeState(this._rbReferralOnUpdate, 1);
                BlankPanel.setChangeState(this._rbReferral, 1);
            }
            this.fireValidDirtyChange();
        }
    }

    public void replicaChanged(Replica replica) {
        boolean bl = this._saveReplicaEnabled = replica != null;
        if (this.REPLICATION_ENABLED != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigSuffixSettingsPanel.this.REPLICATION_ENABLED.setVisible(ConfigSuffixSettingsPanel.this._saveReplicaEnabled);
                }
            });
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this.REPLICATION_ENABLED = new JPanel(new GridBagLayout());
        this._cbEnableSuffix = UIFactory.makeJCheckBox(this, "suffixsettingspanel", "cbenablesuffix", false, ConfigBasePanel._resource);
        this._rbReadWrite = UIFactory.makeJRadioButton(null, "suffixsettingspanel", "rbreadwrite", false, ConfigBasePanel._resource);
        this._rbReadWrite.addActionListener(this);
        this._rbReferralOnUpdate = UIFactory.makeJRadioButton(null, "suffixsettingspanel", "rbreferralonupdate", false, ConfigBasePanel._resource);
        this._rbReferralOnUpdate.addActionListener(this);
        this._rbReferral = UIFactory.makeJRadioButton(null, "suffixsettingspanel", "rbreferral", false, ConfigBasePanel._resource);
        this._rbReferral.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbReadWrite);
        buttonGroup.add(this._rbReferralOnUpdate);
        buttonGroup.add(this._rbReferral);
        this._lReferral = UIFactory.makeJLabel("suffixsettingspanel", "lreferral", ConfigBasePanel._resource);
        this._listDataReferral = new DefaultListModel();
        this._listReferral = new JList(this._listDataReferral);
        this._listReferral.setVisibleRowCount(7);
        this._listReferral.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() == ConfigSuffixSettingsPanel.this._listReferral) {
                    ConfigSuffixSettingsPanel.this._bDeleteReferral.setEnabled(!ConfigSuffixSettingsPanel.this._listReferral.isSelectionEmpty());
                }
            }
        });
        this._lReferral.setLabelFor(this._listReferral);
        this._bAddReferral = UIFactory.makeJButton(this, "suffixsettingspanel", "baddreferral", ConfigBasePanel._resource);
        this._bDeleteReferral = UIFactory.makeJButton(this, "suffixsettingspanel", "bdeletereferral", ConfigBasePanel._resource);
        JLabel jLabel = new JLabel((Icon)DSUtil.getPackageImage("failed.gif"));
        jLabel.setText(ConfigBasePanel._resource.getString("suffixsettingspanel-replication-enabled", "label"));
        jLabel.setLabelFor(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        this.REPLICATION_ENABLED.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.REPLICATION_ENABLED.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 16, 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace() + 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace() + 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel, this._cbEnableSuffix);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace() - 4;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        if (this._isLocalSuffix) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left -= 4;
            gridBagConstraints.insets.right = UIFactory.getComponentSpace();
            jPanel.add((Component)this.REPLICATION_ENABLED, gridBagConstraints);
            gridBagConstraints.insets.left += 4;
            gridBagConstraints.insets.right = 0;
        }
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._rbReadWrite, gridBagConstraints);
        jPanel.add((Component)this._rbReferralOnUpdate, gridBagConstraints);
        jPanel.add((Component)this._rbReferral, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this._lReferral, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._bAddReferral, gridBagConstraints);
        jPanel2.add((Component)this._bDeleteReferral, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.fill = 2;
        JScrollPane jScrollPane = new JScrollPane(this._listReferral);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"nsslapd-state", "nsslapd-referral"};
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPEntry lDAPEntry = lDAPConnection.read(this._mappingEntryDn, stringArray2);
        String string = this.getValue(lDAPEntry, "nsslapd-state");
        if (string.equalsIgnoreCase("disabled")) {
            this._saveSuffixState = 0;
        } else if (string.equalsIgnoreCase("backend")) {
            this._saveSuffixState = 1;
        } else if (string.equalsIgnoreCase("referral on update")) {
            this._saveSuffixState = 2;
        } else if (string.equalsIgnoreCase("referral")) {
            this._saveSuffixState = 3;
        }
        this._saveReferrals.clear();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-referral");
        if (lDAPAttribute != null) {
            stringArray = lDAPAttribute.getStringValues();
            while (stringArray.hasMoreElements()) {
                this._saveReferrals.addElement(stringArray.nextElement());
            }
        }
        if (this._isLocalSuffix) {
            stringArray = new String[]{"dn"};
            try {
                this._saveReplicaEnabled = lDAPConnection.read("cn=replica, " + this._mappingEntryDn) != null;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                this._saveReplicaEnabled = false;
            }
        }
    }

    private void initComponentsFromServerValues() {
        this._cbEnableSuffix.setSelected(this._saveSuffixState != 0);
        BlankPanel.setChangeState(this._cbEnableSuffix, 1);
        this.REPLICATION_ENABLED.setVisible(this._saveReplicaEnabled);
        switch (this._saveSuffixState) {
            case 0: {
                this._rbReadWrite.setSelected(true);
                break;
            }
            case 1: {
                this._rbReadWrite.setSelected(true);
                break;
            }
            case 2: {
                this._rbReferralOnUpdate.setSelected(true);
                break;
            }
            case 3: {
                this._rbReferral.setSelected(true);
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        BlankPanel.setChangeState(this._rbReadWrite, 1);
        BlankPanel.setChangeState(this._rbReferralOnUpdate, 1);
        BlankPanel.setChangeState(this._rbReferral, 1);
        this._isSuffixStateDirty = false;
        this._listDataReferral.clear();
        Enumeration enumeration = this._saveReferrals.elements();
        while (enumeration.hasMoreElements()) {
            this._listDataReferral.addElement(enumeration.nextElement());
        }
        BlankPanel.setChangeState(this._lReferral, 1);
        this._isReferralDirty = false;
        this.enableComponents(this._saveSuffixState != 0);
    }

    private void actionAddReferral() {
        LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog((JFrame)((Object)this._framework));
        lDAPUrlDialog.packAndShow();
        LDAPUrl lDAPUrl = lDAPUrlDialog.getLDAPUrl();
        if (lDAPUrl != null) {
            this._listDataReferral.addElement(lDAPUrl.getUrl());
        }
    }

    private void actionDeleteReferral() {
        int[] nArray = this._listReferral.getSelectedIndices();
        if (nArray != null) {
            int n = nArray.length - 1;
            while (n >= 0) {
                this._listDataReferral.removeElementAt(nArray[n]);
                --n;
            }
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = bl = this._isSuffixStateDirty || this._isReferralDirty && this._cbEnableSuffix.isSelected();
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private void enableComponents(boolean bl) {
        this._rbReadWrite.setEnabled(bl);
        this._rbReferralOnUpdate.setEnabled(bl);
        this._rbReferral.setEnabled(bl);
        this._lReferral.setEnabled(bl);
        this._listReferral.setEnabled(bl);
        this._bAddReferral.setEnabled(bl);
        this._bDeleteReferral.setEnabled(bl && !this._listReferral.isSelectionEmpty());
    }

    private int getState() {
        int n = 0;
        if (!this._cbEnableSuffix.isSelected()) {
            n = 0;
        } else if (this._rbReadWrite.isSelected()) {
            n = 1;
        } else if (this._rbReferralOnUpdate.isSelected()) {
            n = 2;
        } else if (this._rbReferral.isSelected()) {
            n = 3;
        } else {
            Thread.dumpStack();
        }
        return n;
    }
}

