/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class ConfigServerSettingsPanel
extends ConfigBasePanel
implements ActionListener {
    private boolean _isInitializing;
    private boolean _isCancelled;
    private JPanel _contentPanel;
    private JCheckBox _cbReadOnly;
    private JCheckBox _cbTrackChanges;
    private JLabel _lManagerDn;
    private JTextField _tfManagerDn;
    private JLabel _lStorageScheme;
    private JComboBox _comboStorageScheme;
    private JLabel _lManagerPwd;
    private JPasswordField _pfManagerPwd;
    private JLabel _lManagerConfirmPwd;
    private JPasswordField _pfManagerConfirmPwd;
    private boolean _isReadOnlyDirty;
    private boolean _isTrackChangesDirty;
    private boolean _isManagerDnDirty;
    private boolean _isManagerDnValid;
    private boolean _isStorageSchemeDirty;
    private boolean _isManagerPwdDirty;
    private boolean _isManagerPwdValid;
    private boolean _saveReadOnly;
    private boolean _saveTrackChanges;
    private String _saveManagerDn;
    private String _saveManagerPwd;
    private String _saveManagerPwdScheme;
    private Vector _pwdSchemeNames;
    private Vector _pwdSchemeDesc;
    private ArrayList _readPwdSchemeNames;
    private ArrayList _readPwdSchemeDesc;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("serversettingspanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("serversettingspanel-no-rights", "label"), 2, 50);

    public ConfigServerSettingsPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("serversettingspanel", "title"));
        this._helpToken = "configuration-system-settings-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigServerSettingsPanel.this._isManagerDnValid = true;
                        ConfigServerSettingsPanel.this._isManagerPwdValid = true;
                        ConfigServerSettingsPanel.this._pwdSchemeNames = new Vector();
                        ConfigServerSettingsPanel.this._pwdSchemeDesc = new Vector();
                        ConfigServerSettingsPanel.this._readPwdSchemeNames = new ArrayList();
                        ConfigServerSettingsPanel.this._readPwdSchemeDesc = new ArrayList();
                        ConfigServerSettingsPanel.this.createContentPanel();
                        ConfigServerSettingsPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigServerSettingsPanel.access$900(1.access$800(this.this$1));
                                1.access$800(this.this$1).showComponent(ConfigServerSettingsPanel.access$1000(1.access$800(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$800(this.this$1).showComponent((JComponent)ConfigServerSettingsPanel.access$1100(1.access$800(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("serversettingspanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$800(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigServerSettingsPanel.this._isInitialized = true;
                    ConfigServerSettingsPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigServerSettingsPanel access$800(1 var0) {
                    return var0.ConfigServerSettingsPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigServerSettingsPanel.this.initComponentsFromServerValues();
                    ConfigServerSettingsPanel.this.fireValidDirtyChange();
                    ConfigServerSettingsPanel.this.showComponent(ConfigServerSettingsPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigServerSettingsPanel.this.showComponent((JComponent)ConfigServerSettingsPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("serversettingspanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigServerSettingsPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        DN dN;
        String[] stringArray;
        String string;
        String string2;
        boolean bl = false;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        LDAPModificationSet lDAPModificationSet2 = new LDAPModificationSet();
        if (this._isManagerDnDirty) {
            string2 = this._tfManagerDn.getText();
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-rootdn", string2));
            lDAPModificationSet2.add(2, new LDAPAttribute("nsbinddn", string2));
        }
        if (this._isManagerPwdDirty) {
            string2 = new String(this._pfManagerPwd.getPassword());
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-rootpw", string2));
            lDAPModificationSet2.add(2, new LDAPAttribute("userPassword", string2));
            string = this.getServerInfo();
            stringArray = new DN(string.getCurrentDN());
            dN = new DN((String)((Hashtable)((Object)string)).get("AdminUsername"));
            if (stringArray.equals(dN)) {
                ((Hashtable)((Object)string)).put("AdminUserPassword", string2);
            }
        }
        if (this._isStorageSchemeDirty) {
            string2 = (String)this._comboStorageScheme.getSelectedItem();
            int n = this._pwdSchemeDesc.indexOf(string2);
            stringArray = (String[])this._pwdSchemeNames.elementAt(n);
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-rootpwstoragescheme", (String)stringArray));
        }
        if (this._isReadOnlyDirty) {
            string2 = this._cbReadOnly.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-readonly", string2));
        }
        if (this._isTrackChangesDirty) {
            string2 = this._cbTrackChanges.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-lastmod", string2));
        }
        if (lDAPModificationSet2.size() > 0 && !this._isCancelled) {
            string2 = this.getConsoleInfo().getLDAPConnection();
            string = this.getConsoleInfo().getCurrentDN();
            try {
                string2.modify(string, lDAPModificationSet2);
                bl = true;
            }
            catch (LDAPException lDAPException) {
                dN = new DN[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("serversettingspanel", "updating-topologyserver-error-title"), ConfigBasePanel._resource.getString("serversettingspanel", "updating-topologyserver-error-msg", (String[])dN));
            }
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            string2 = this.getServerInfo().getLDAPConnection();
            try {
                string2.modify("cn=config", lDAPModificationSet);
                bl = true;
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("serversettingspanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("serversettingspanel", "updating-server-error-msg", stringArray));
            }
        }
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbReadOnly) {
            this._isReadOnlyDirty = this._saveReadOnly != this._cbReadOnly.isSelected();
            BlankPanel.setChangeState(this._cbReadOnly, this._isReadOnlyDirty ? 2 : 1);
            this.fireValidDirtyChange();
        } else if (object == this._cbTrackChanges) {
            this._isTrackChangesDirty = this._saveTrackChanges != this._cbTrackChanges.isSelected();
            BlankPanel.setChangeState(this._cbTrackChanges, this._isTrackChangesDirty ? 2 : 1);
            this.fireValidDirtyChange();
        } else if (object == this._comboStorageScheme) {
            Object object2;
            int n = this._pwdSchemeNames.indexOf(this._saveManagerPwdScheme);
            this._isStorageSchemeDirty = n != this._pwdSchemeDesc.indexOf(object2 = this._comboStorageScheme.getSelectedItem());
            BlankPanel.setChangeState(this._lStorageScheme, this._isStorageSchemeDirty ? 2 : 1);
            this.fireValidDirtyChange();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbReadOnly = UIFactory.makeJCheckBox(this, "serversettingspanel", "cbreadonly", false, ConfigBasePanel._resource);
        this._cbTrackChanges = UIFactory.makeJCheckBox(this, "serversettingspanel", "cbtrackchanges", false, ConfigBasePanel._resource);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                String string = ConfigServerSettingsPanel.this._tfManagerDn.getText();
                ConfigServerSettingsPanel.this._isManagerDnDirty = !string.equals(ConfigServerSettingsPanel.this._saveManagerDn);
                ConfigServerSettingsPanel.this._isManagerDnValid = DN.isDN((String)string);
                if (!ConfigServerSettingsPanel.this._isManagerDnValid) {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerDn, 3);
                } else if (ConfigServerSettingsPanel.this._isManagerDnDirty) {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerDn, 2);
                } else {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerDn, 1);
                }
                ConfigServerSettingsPanel.this.fireValidDirtyChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfManagerDn = UIFactory.makeJTextField(documentListener, "serversettingspanel", "lmanagerdn", null, 20, ConfigBasePanel._resource);
        this._lManagerDn = UIFactory.makeJLabel("serversettingspanel", "lmanagerdn", ConfigBasePanel._resource);
        this._lManagerDn.setLabelFor(this._tfManagerDn);
        this._comboStorageScheme = new JComboBox(this._pwdSchemeDesc);
        this._comboStorageScheme.addActionListener(this);
        this._lStorageScheme = UIFactory.makeJLabel("serversettingspanel", "lstoragescheme", ConfigBasePanel._resource);
        if (this._lStorageScheme.getToolTipText() != null) {
            this._comboStorageScheme.setToolTipText(this._lStorageScheme.getToolTipText());
        }
        this._lStorageScheme.setLabelFor(this._comboStorageScheme);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                char[] cArray = ConfigServerSettingsPanel.this._pfManagerPwd.getPassword();
                char[] cArray2 = ConfigServerSettingsPanel.this._pfManagerConfirmPwd.getPassword();
                ConfigServerSettingsPanel.this._isManagerPwdDirty = !ConfigServerSettingsPanel.this._saveManagerPwd.equals(new String(cArray));
                ConfigServerSettingsPanel.this._isManagerPwdValid = cArray.length == cArray2.length && cArray.length >= 1;
                int n = 0;
                while (n < cArray.length && ConfigServerSettingsPanel.this._isManagerPwdValid) {
                    ConfigServerSettingsPanel.this._isManagerPwdValid = cArray[n] == cArray2[n];
                    ++n;
                }
                if (!ConfigServerSettingsPanel.this._isManagerPwdValid) {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerPwd, 3);
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerConfirmPwd, 3);
                } else if (ConfigServerSettingsPanel.this._isManagerPwdDirty) {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerPwd, 2);
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerConfirmPwd, 2);
                } else {
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerPwd, 1);
                    BlankPanel.setChangeState(ConfigServerSettingsPanel.this._lManagerConfirmPwd, 1);
                }
                ConfigServerSettingsPanel.this.fireValidDirtyChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._pfManagerPwd = UIFactory.makeJPasswordField(documentListener2, "serversettingspanel", "lmanagerpwd", null, 20, ConfigBasePanel._resource);
        this._lManagerPwd = UIFactory.makeJLabel("serversettingspanel", "lmanagerpwd", ConfigBasePanel._resource);
        this._lManagerPwd.setLabelFor(this._pfManagerPwd);
        this._pfManagerConfirmPwd = UIFactory.makeJPasswordField(documentListener2, "serversettingspanel", "lmanagerconfirmpwd", null, 20, ConfigBasePanel._resource);
        this._lManagerConfirmPwd = UIFactory.makeJLabel("serversettingspanel", "lmanagerconfirmpwd", ConfigBasePanel._resource);
        this._lManagerConfirmPwd.setLabelFor(this._pfManagerConfirmPwd);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 16, 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._cbReadOnly, gridBagConstraints);
        this._contentPanel.add((Component)this._cbTrackChanges, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("serversettingspanel", "managerpanel-label"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        groupPanel.add((Component)this._lManagerDn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._tfManagerDn, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        groupPanel.add((Component)this._lStorageScheme, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._comboStorageScheme, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        groupPanel.add((Component)this._lManagerPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._pfManagerPwd, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        groupPanel.add((Component)this._lManagerConfirmPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._pfManagerConfirmPwd, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException {
        String[] stringArray;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray2 = new String[]{"nsslapd-lastmod", "nsslapd-readonly", "nsslapd-rootdn", "nsslapd-rootpw", "nsslapd-rootpwstoragescheme"};
        if (!this._isCancelled) {
            stringArray = lDAPConnection.read("cn=config", stringArray2, lDAPSearchConstraints);
            this._saveReadOnly = this.getValue((LDAPEntry)stringArray, "nsslapd-readonly").equalsIgnoreCase("on");
            this._saveTrackChanges = this.getValue((LDAPEntry)stringArray, "nsslapd-lastmod").equalsIgnoreCase("on");
            this._saveManagerDn = this.getValue((LDAPEntry)stringArray, "nsslapd-rootdn");
            this._saveManagerPwd = this.getValue((LDAPEntry)stringArray, "nsslapd-rootpw");
            this._saveManagerPwdScheme = this.getValue((LDAPEntry)stringArray, "nsslapd-rootpwstoragescheme").toLowerCase();
        }
        stringArray = new String[]{"cn", "nsslapd-plugindescription"};
        if (!this._isCancelled) {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins, cn=config", 2, "nsslapd-plugintype=pwdstoragescheme", stringArray, false, lDAPSearchConstraints);
            this._readPwdSchemeNames.clear();
            this._readPwdSchemeDesc.clear();
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = this.getValue(lDAPEntry, "cn");
                if (string.equalsIgnoreCase("ns-mta-md5")) continue;
                this._readPwdSchemeNames.add(string.toLowerCase());
                if (lDAPEntry.getAttribute("nsslapd-plugindescription") != null) {
                    this._readPwdSchemeDesc.add(this.getValue(lDAPEntry, "nsslapd-plugindescription"));
                    continue;
                }
                this._readPwdSchemeDesc.add(string);
            }
        }
        this._isCancelled = false;
    }

    private void initComponentsFromServerValues() {
        this._pwdSchemeNames.clear();
        this._pwdSchemeDesc.clear();
        this._pwdSchemeNames.addAll(this._readPwdSchemeNames);
        this._pwdSchemeDesc.addAll(this._readPwdSchemeDesc);
        this._cbReadOnly.setSelected(this._saveReadOnly);
        BlankPanel.setChangeState(this._cbReadOnly, 1);
        this._isReadOnlyDirty = false;
        this._cbTrackChanges.setSelected(this._saveTrackChanges);
        BlankPanel.setChangeState(this._cbTrackChanges, 1);
        this._isTrackChangesDirty = false;
        this._tfManagerDn.setText(this._saveManagerDn);
        BlankPanel.setChangeState(this._lManagerDn, 1);
        this._isManagerDnDirty = false;
        this._isManagerDnValid = true;
        this._comboStorageScheme.setSelectedIndex(this._pwdSchemeNames.indexOf(this._saveManagerPwdScheme));
        this._isStorageSchemeDirty = false;
        BlankPanel.setChangeState(this._lStorageScheme, 1);
        ((JTextComponent)this._pfManagerPwd).setText(this._saveManagerPwd);
        ((JTextComponent)this._pfManagerConfirmPwd).setText(this._saveManagerPwd);
        this._isManagerPwdDirty = false;
        this._isManagerPwdValid = true;
        BlankPanel.setChangeState(this._lManagerPwd, 1);
        BlankPanel.setChangeState(this._lManagerConfirmPwd, 1);
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this._isReadOnlyDirty || this._isTrackChangesDirty || this._isManagerDnDirty || this._isStorageSchemeDirty || this._isManagerPwdDirty;
        if (bl2) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        boolean bl4 = bl = this._isManagerDnValid && this._isManagerPwdValid;
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

