/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.ISSLConfigListener;
import com.netscape.admin.dirserv.config.URI;
import com.netscape.admin.dirserv.config.URISyntaxException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;

public class ConfigNetworkSettingsPanel
extends ConfigBasePanel
implements ActionListener,
ISSLConfigListener {
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private boolean _needsRestartServer;
    private JPanel _contentPanel;
    private JLabel _lLDAPPort;
    private JTextField _tfLDAPPort;
    private JLabel _lLDAPSecurePort;
    private JTextField _tfLDAPSecurePort;
    private JTextField _tfReferral;
    private JCheckBox _cbEnableReferral;
    private JCheckBox _cbEnableDSML;
    private JButton _bConstructReferral;
    private JRadioButton _rbOnlyNonSecureLdapPort;
    private JRadioButton _rbBothLdapPort;
    private JRadioButton _rbOnlyNonSecureDsmlPort;
    private JRadioButton _rbOnlySecureDsmlPort;
    private JRadioButton _rbBothDsmlPort;
    private JLabel _lDSMLPort;
    private JTextField _tfDSMLPort;
    private JLabel _lDSMLSecurePort;
    private JTextField _tfDSMLSecurePort;
    private JLabel _lDSMLUrl;
    private JTextField _tfDSMLUrl;
    private JTextArea _taDSMLUrl;
    private boolean[] _ldapPortValidDirty = new boolean[2];
    private boolean[] _ldapSecurePortValidDirty = new boolean[2];
    private boolean[] _isReferralValidDirty = new boolean[2];
    private boolean _isEnableReferralDirty;
    private boolean _isEnableDSMLDirty;
    private boolean[] _dsmlPortValidDirty = new boolean[2];
    private boolean[] _dsmlSecurePortValidDirty = new boolean[2];
    private boolean[] _dsmlUrlValidDirty = new boolean[2];
    private boolean _dsmlTypePortDirty;
    private int _saveLDAPPort;
    private int _saveLDAPSecurePort;
    private boolean _saveEnableReferral;
    private String _saveReferral;
    private boolean _saveEnableDSML;
    private int _saveDSMLPort;
    private boolean _saveDSMLPortDefined;
    private int _saveDSMLSecurePort;
    private boolean _saveDSMLSecurePortDefined;
    private String _saveDSMLUrl;
    private boolean _isSSLEnabled;
    private String _localHost;
    private String _lastReadAttribute;
    private String _lastReadEntry;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("networksettingspanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("networksettingspanel-no-rights", "label"), 2, 50);
    private final JLabel SSL_NOT_ENABLED = new JLabel(ConfigBasePanel._resource.getString("networksettingspanel-ssl-not-enabled", "label"), (Icon)DSUtil.getPackageImage("failed.gif"), 2);
    private final int NUMBER_PORT_FIELDS = 4;

    public ConfigNetworkSettingsPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("networksettingspanel", "title"));
        this._helpToken = "configuration-system-network-help";
    }

    public void notifySSLEnabled() {
        this._isSSLEnabled = true;
        if (this._isInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigNetworkSettingsPanel.this._tfLDAPSecurePort.setEnabled(true);
                    ConfigNetworkSettingsPanel.this._lLDAPSecurePort.setEnabled(true);
                    ConfigNetworkSettingsPanel.this._rbBothLdapPort.setEnabled(true);
                    int n = 0;
                    try {
                        n = Integer.parseInt(ConfigNetworkSettingsPanel.this._tfLDAPSecurePort.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ConfigNetworkSettingsPanel.this._rbBothLdapPort.setSelected(n > 0);
                    ConfigNetworkSettingsPanel.this.actionLDAPRadioButtonSelected();
                    ConfigNetworkSettingsPanel.this.SSL_NOT_ENABLED.setVisible(false);
                    ConfigNetworkSettingsPanel.this._rbBothDsmlPort.setEnabled(true);
                    ConfigNetworkSettingsPanel.this._rbOnlySecureDsmlPort.setEnabled(true);
                    ConfigNetworkSettingsPanel.this.fireValidDirtyChange();
                }
            });
        }
    }

    public void notifySSLDisabled() {
        this._isSSLEnabled = false;
        if (this._isInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigNetworkSettingsPanel.this._tfLDAPSecurePort.setEnabled(false);
                    ConfigNetworkSettingsPanel.this._lLDAPSecurePort.setEnabled(false);
                    ConfigNetworkSettingsPanel.this.SSL_NOT_ENABLED.setVisible(true);
                    ConfigNetworkSettingsPanel.this._rbBothLdapPort.setEnabled(false);
                    ConfigNetworkSettingsPanel.this._rbOnlyNonSecureLdapPort.setSelected(true);
                    ConfigNetworkSettingsPanel.this.actionLDAPRadioButtonSelected();
                    ConfigNetworkSettingsPanel.this._rbBothDsmlPort.setEnabled(false);
                    ConfigNetworkSettingsPanel.this._rbOnlySecureDsmlPort.setEnabled(false);
                    ConfigNetworkSettingsPanel.this._rbOnlyNonSecureDsmlPort.setSelected(true);
                    ConfigNetworkSettingsPanel.this.actionDSMLRadioButtonSelected();
                }
            });
        }
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigNetworkSettingsPanel.this._localHost = ConfigNetworkSettingsPanel.this._framework.getServerObject().getServerInfo().getHost();
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._ldapPortValidDirty[0] = true;
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._ldapSecurePortValidDirty[0] = true;
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlPortValidDirty[0] = true;
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlSecurePortValidDirty[0] = true;
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlUrlValidDirty[0] = true;
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._isReferralValidDirty[0] = true;
                        ConfigNetworkSettingsPanel.this.createContentPanel();
                        ConfigNetworkSettingsPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigNetworkSettingsPanel.access$2100(3.access$2000(this.this$1));
                                3.access$2000(this.this$1).showComponent(ConfigNetworkSettingsPanel.access$2200(3.access$2000(this.this$1)), false);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigNetworkSettingsPanel.access$2300(3.access$2000(this.this$1)), ConfigNetworkSettingsPanel.access$2400(3.access$2000(this.this$1))};
                                3.access$2000(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("networksettingspanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                3.access$2000(this.this$1).showComponent((JComponent)ConfigNetworkSettingsPanel.access$2500(3.access$2000(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("networksettingspanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                3.access$2000(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigNetworkSettingsPanel.this._isInitialized = true;
                    ConfigNetworkSettingsPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigNetworkSettingsPanel access$2000(3 var0) {
                    return var0.ConfigNetworkSettingsPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigNetworkSettingsPanel.this.initComponentsFromServerValues();
                    ConfigNetworkSettingsPanel.this.fireValidDirtyChange();
                    ConfigNetworkSettingsPanel.this.showComponent(ConfigNetworkSettingsPanel.this._contentPanel, false);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigNetworkSettingsPanel.this._lastReadAttribute, ConfigNetworkSettingsPanel.this._lastReadEntry};
                    ConfigNetworkSettingsPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("networksettingspanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigNetworkSettingsPanel.this.showComponent((JComponent)ConfigNetworkSettingsPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("networksettingspanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigNetworkSettingsPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        Object object;
        ArrayList arrayList;
        String string;
        this._needsRestartServer = false;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        LDAPModificationSet lDAPModificationSet2 = new LDAPModificationSet();
        LDAPModificationSet lDAPModificationSet3 = new LDAPModificationSet();
        String string2 = null;
        if (this._ldapPortValidDirty[1]) {
            string2 = this._tfLDAPPort.getText();
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-port", string2));
            lDAPModificationSet2.add(2, new LDAPAttribute("nsServerPort", string2));
        }
        if (this._saveLDAPSecurePort > 0 && this._rbOnlyNonSecureLdapPort.isSelected() && this._isSSLEnabled) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-secureport", "0"));
            lDAPModificationSet2.add(2, new LDAPAttribute("nsSecureServerPort", "0"));
        } else if (this._ldapSecurePortValidDirty[1] && this._rbBothLdapPort.isSelected()) {
            string2 = this._tfLDAPSecurePort.getText();
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-secureport", string2));
            lDAPModificationSet2.add(2, new LDAPAttribute("nsSecureServerPort", string2));
        }
        if (this._isEnableReferralDirty) {
            if (!this._cbEnableReferral.isSelected()) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-referral", "remove"));
            } else {
                string = this._tfReferral.getText();
                arrayList = this.getReferralList(string);
                object = new String[arrayList.size()];
                arrayList.toArray((T[])object);
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-referral", object));
            }
        } else if (this._cbEnableReferral.isSelected() && this._isReferralValidDirty[1]) {
            string = this._tfReferral.getText();
            arrayList = this.getReferralList(string);
            object = new String[arrayList.size()];
            arrayList.toArray((T[])object);
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-referral", object));
        }
        if (this._isEnableDSMLDirty) {
            string2 = this._cbEnableDSML.isSelected() ? "on" : "off";
            lDAPModificationSet3.add(2, new LDAPAttribute("nsslapd-pluginenabled", string2));
        }
        if (this._cbEnableDSML.isSelected()) {
            if (this._rbBothDsmlPort.isSelected()) {
                if (this._dsmlPortValidDirty[1] || !this._saveDSMLPortDefined) {
                    string2 = this._tfDSMLPort.getText();
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-port", string2));
                }
                if (this._dsmlSecurePortValidDirty[1] || !this._saveDSMLSecurePortDefined) {
                    string2 = this._tfDSMLSecurePort.getText();
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-secureport", string2));
                }
            } else if (this._rbOnlySecureDsmlPort.isSelected()) {
                if (this._saveDSMLPortDefined) {
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-port"));
                }
                if (this._dsmlSecurePortValidDirty[1] || !this._saveDSMLSecurePortDefined) {
                    string2 = this._tfDSMLSecurePort.getText();
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-secureport", string2));
                }
            } else if (this._rbOnlyNonSecureDsmlPort.isSelected()) {
                if (this._saveDSMLSecurePortDefined) {
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-secureport"));
                }
                if (this._dsmlPortValidDirty[1] || !this._saveDSMLPortDefined) {
                    string2 = this._tfDSMLPort.getText();
                    lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-port", string2));
                }
            }
            if (this._dsmlUrlValidDirty[1]) {
                string2 = this._tfDSMLUrl.getText().trim();
                lDAPModificationSet3.add(2, new LDAPAttribute("ds-hdsml-rooturl", string2));
            }
        }
        string = this.getServerInfo().getLDAPConnection();
        try {
            if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
                string.modify("cn=config", lDAPModificationSet);
                this._needsRestartServer = true;
            }
            if (lDAPModificationSet3.size() > 0 && !this._isCancelled) {
                string.modify("cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config", lDAPModificationSet3);
                this._needsRestartServer = true;
            }
        }
        catch (LDAPException lDAPException) {
            object = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("networksettingspanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("networksettingspanel", "updating-server-error-msg", object));
        }
        if (lDAPModificationSet2.size() > 0 && !this._isCancelled) {
            arrayList = this.getConsoleInfo().getLDAPConnection();
            object = this.getServerInfo().getCurrentDN();
            try {
                arrayList.modify((String)object, lDAPModificationSet2);
                this.modifyPrefEntries();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("networksettingspanel", "updating-topologyserver-error-title"), ConfigBasePanel._resource.getString("networksettingspanel", "updating-topologyserver-error-msg", stringArray));
            }
        }
        this.resetCallback();
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public boolean needsConfirmation() {
        return this._ldapPortValidDirty[1] || this._ldapSecurePortValidDirty[1];
    }

    public boolean askForConfirmation() {
        LDAPConnection lDAPConnection = this.getConsoleInfo().getLDAPConnection();
        LDAPConnection lDAPConnection2 = this.getServerInfo().getLDAPConnection();
        boolean bl = lDAPConnection.getPort() == lDAPConnection2.getPort() && lDAPConnection.getHost().equals(lDAPConnection2.getHost());
        int n = bl ? DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmmodifyconfigport", (String[])null, "networksettingspanel", ConfigBasePanel._resource) : DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmmodifyport", (String[])null, "networksettingspanel", ConfigBasePanel._resource);
        return n == 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cbEnableReferral) {
            boolean bl = this._isEnableReferralDirty = this._cbEnableReferral.isSelected() != this._saveEnableReferral;
            if (!this._cbEnableReferral.isSelected()) {
                if (this._isEnableReferralDirty) {
                    BlankPanel.setChangeState(this._cbEnableReferral, 2);
                } else {
                    BlankPanel.setChangeState(this._cbEnableReferral, 1);
                }
            } else if (!this._isReferralValidDirty[0]) {
                BlankPanel.setChangeState(this._cbEnableReferral, 3);
            } else if (this._isReferralValidDirty[0] || this._isEnableReferralDirty) {
                BlankPanel.setChangeState(this._cbEnableReferral, 2);
            } else {
                BlankPanel.setChangeState(this._cbEnableReferral, 1);
            }
            this._tfReferral.setEnabled(this._cbEnableReferral.isSelected());
            this._bConstructReferral.setEnabled(this._cbEnableReferral.isSelected());
            this.fireValidDirtyChange();
        } else if (actionEvent.getSource() == this._cbEnableDSML) {
            boolean bl = this._isEnableDSMLDirty = this._cbEnableDSML.isSelected() != this._saveEnableDSML;
            if (this._isEnableDSMLDirty) {
                BlankPanel.setChangeState(this._cbEnableDSML, 2);
            } else {
                BlankPanel.setChangeState(this._cbEnableDSML, 1);
            }
            this._rbOnlyNonSecureDsmlPort.setEnabled(this._cbEnableDSML.isSelected());
            this._rbBothDsmlPort.setEnabled(this._isSSLEnabled && this._cbEnableDSML.isSelected());
            this._rbOnlySecureDsmlPort.setEnabled(this._isSSLEnabled && this._cbEnableDSML.isSelected());
            if (this._cbEnableDSML.isSelected()) {
                this.actionDSMLRadioButtonSelected();
            } else {
                this._tfDSMLPort.setEnabled(false);
                this._lDSMLPort.setEnabled(false);
                this._tfDSMLSecurePort.setEnabled(false);
                this._lDSMLSecurePort.setEnabled(false);
            }
            this._tfDSMLUrl.setEnabled(this._cbEnableDSML.isSelected());
            this._lDSMLUrl.setEnabled(this._cbEnableDSML.isSelected());
            this.fireValidDirtyChange();
        } else if (actionEvent.getSource() == this._bConstructReferral) {
            LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog((JFrame)((Object)this._framework), this._tfReferral.getText(), 7);
            lDAPUrlDialog.packAndShow();
            LDAPUrl lDAPUrl = lDAPUrlDialog.getLDAPUrl();
            if (lDAPUrl != null) {
                this._tfReferral.setText(lDAPUrl.getUrl());
            }
        } else if (actionEvent.getSource() == this._rbOnlyNonSecureLdapPort || actionEvent.getSource() == this._rbBothLdapPort) {
            this.actionLDAPRadioButtonSelected();
        } else if (actionEvent.getSource() instanceof JRadioButton) {
            this.actionDSMLRadioButtonSelected();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._rbOnlyNonSecureLdapPort = UIFactory.makeJRadioButton(null, "networksettingspanel", "rbonlynonsecureldapport", false, ConfigBasePanel._resource);
        this._rbOnlyNonSecureLdapPort.addActionListener(this);
        this._rbBothLdapPort = UIFactory.makeJRadioButton(null, "networksettingspanel", "rbbothldapport", false, ConfigBasePanel._resource);
        this._rbBothLdapPort.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbOnlyNonSecureLdapPort);
        buttonGroup.add(this._rbBothLdapPort);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    ConfigNetworkSettingsPanel.this.checkPort(ConfigNetworkSettingsPanel.this._lLDAPPort, ConfigNetworkSettingsPanel.this._tfLDAPPort, ConfigNetworkSettingsPanel.this._saveLDAPPort, ConfigNetworkSettingsPanel.this._ldapPortValidDirty);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lLDAPPort = UIFactory.makeJLabel("networksettingspanel", "lldapport", ConfigBasePanel._resource);
        this._tfLDAPPort = UIFactory.makeJTextField(documentListener, "networksettingspanel", "lldapport", null, 5, ConfigBasePanel._resource);
        this._lLDAPPort.setLabelFor(this._tfLDAPPort);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    ConfigNetworkSettingsPanel.this.checkPort(ConfigNetworkSettingsPanel.this._lLDAPSecurePort, ConfigNetworkSettingsPanel.this._tfLDAPSecurePort, ConfigNetworkSettingsPanel.this._saveLDAPSecurePort, ConfigNetworkSettingsPanel.this._ldapSecurePortValidDirty);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lLDAPSecurePort = UIFactory.makeJLabel("networksettingspanel", "lldapsecureport", ConfigBasePanel._resource);
        this._tfLDAPSecurePort = UIFactory.makeJTextField(documentListener2, "networksettingspanel", "lldapsecureport", null, 5, ConfigBasePanel._resource);
        this._lLDAPSecurePort.setLabelFor(this._tfLDAPSecurePort);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    String string = ConfigNetworkSettingsPanel.this._tfReferral.getText();
                    ArrayList arrayList = ConfigNetworkSettingsPanel.this.getReferralList(string);
                    ListIterator listIterator = ((AbstractList)arrayList).listIterator();
                    try {
                        while (listIterator.hasNext()) {
                            LDAPUrl lDAPUrl = new LDAPUrl((String)listIterator.next());
                        }
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._isReferralValidDirty[0] = true;
                    }
                    catch (Exception exception) {
                        ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._isReferralValidDirty[0] = false;
                    }
                    boolean bl = ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._isReferralValidDirty[1] = !string.equals(ConfigNetworkSettingsPanel.this._saveReferral);
                    if (!ConfigNetworkSettingsPanel.this._isReferralValidDirty[0]) {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._cbEnableReferral, 3);
                    } else if (ConfigNetworkSettingsPanel.this._isReferralValidDirty[0]) {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._cbEnableReferral, 2);
                    } else {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._cbEnableReferral, 1);
                    }
                    ConfigNetworkSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfReferral = UIFactory.makeJTextField(documentListener3, "networksettingspanel", "cbenablereferral", null, 20, ConfigBasePanel._resource);
        this._cbEnableReferral = UIFactory.makeJCheckBox(this, "networksettingspanel", "cbenablereferral", false, ConfigBasePanel._resource);
        this._bConstructReferral = UIFactory.makeJButton(this, "networksettingspanel", "bconstructreferral", ConfigBasePanel._resource);
        this._cbEnableDSML = UIFactory.makeJCheckBox(this, "networksettingspanel", "cbenabledsml", false, ConfigBasePanel._resource);
        this._rbOnlyNonSecureDsmlPort = UIFactory.makeJRadioButton(null, "networksettingspanel", "rbonlynonsecuredsmlport", false, ConfigBasePanel._resource);
        this._rbOnlyNonSecureDsmlPort.addActionListener(this);
        this._rbOnlySecureDsmlPort = UIFactory.makeJRadioButton(null, "networksettingspanel", "rbonlysecuredsmlport", false, ConfigBasePanel._resource);
        this._rbOnlySecureDsmlPort.addActionListener(this);
        this._rbBothDsmlPort = UIFactory.makeJRadioButton(null, "networksettingspanel", "rbbothdsmlport", false, ConfigBasePanel._resource);
        this._rbBothDsmlPort.addActionListener(this);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbOnlyNonSecureDsmlPort);
        buttonGroup.add(this._rbOnlySecureDsmlPort);
        buttonGroup.add(this._rbBothDsmlPort);
        DocumentListener documentListener4 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    ConfigNetworkSettingsPanel.this.checkPort(ConfigNetworkSettingsPanel.this._lDSMLPort, ConfigNetworkSettingsPanel.this._tfDSMLPort, ConfigNetworkSettingsPanel.this._saveDSMLPort, ConfigNetworkSettingsPanel.this._dsmlPortValidDirty);
                    ConfigNetworkSettingsPanel.this.updateDSMLUrl();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lDSMLPort = UIFactory.makeJLabel("networksettingspanel", "ldsmlport", ConfigBasePanel._resource);
        this._tfDSMLPort = UIFactory.makeJTextField(documentListener4, "networksettingspanel", "ldsmlport", null, 5, ConfigBasePanel._resource);
        this._lDSMLPort.setLabelFor(this._tfDSMLPort);
        DocumentListener documentListener5 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    ConfigNetworkSettingsPanel.this.checkPort(ConfigNetworkSettingsPanel.this._lDSMLSecurePort, ConfigNetworkSettingsPanel.this._tfDSMLSecurePort, ConfigNetworkSettingsPanel.this._saveDSMLSecurePort, ConfigNetworkSettingsPanel.this._dsmlSecurePortValidDirty);
                    ConfigNetworkSettingsPanel.this.updateDSMLUrl();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lDSMLSecurePort = UIFactory.makeJLabel("networksettingspanel", "ldsmlsecureport", ConfigBasePanel._resource);
        this._tfDSMLSecurePort = UIFactory.makeJTextField(documentListener5, "networksettingspanel", "ldsmlsecureport", null, 5, ConfigBasePanel._resource);
        this._lDSMLSecurePort.setLabelFor(this._tfDSMLSecurePort);
        DocumentListener documentListener6 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigNetworkSettingsPanel.this._isInitializingComponents) {
                    String string = ConfigNetworkSettingsPanel.this._tfDSMLUrl.getText().trim();
                    ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlUrlValidDirty[0] = string.startsWith("/");
                    if (ConfigNetworkSettingsPanel.this._dsmlUrlValidDirty[0]) {
                        try {
                            URI uRI = new URI("http://host.domain:389" + string);
                            ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlUrlValidDirty[0] = true;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlUrlValidDirty[0] = false;
                        }
                    }
                    boolean bl = ((ConfigNetworkSettingsPanel)ConfigNetworkSettingsPanel.this)._dsmlUrlValidDirty[1] = !string.equals(ConfigNetworkSettingsPanel.this._saveDSMLUrl);
                    if (!ConfigNetworkSettingsPanel.this._dsmlUrlValidDirty[0]) {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._lDSMLUrl, 3);
                    } else if (ConfigNetworkSettingsPanel.this._dsmlUrlValidDirty[1]) {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._lDSMLUrl, 2);
                    } else {
                        BlankPanel.setChangeState(ConfigNetworkSettingsPanel.this._lDSMLUrl, 1);
                    }
                    ConfigNetworkSettingsPanel.this.updateDSMLUrl();
                    ConfigNetworkSettingsPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lDSMLUrl = UIFactory.makeJLabel("networksettingspanel", "ldsmlurl", ConfigBasePanel._resource);
        this._tfDSMLUrl = UIFactory.makeJTextField(documentListener6, "networksettingspanel", "ldsmlurl", null, 20, ConfigBasePanel._resource);
        this._lDSMLUrl.setLabelFor(this._tfDSMLUrl);
        this._taDSMLUrl = new MultilineLabel(2, 20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        this._contentPanel.add((Component)this.SSL_NOT_ENABLED, gridBagConstraints);
        this.SSL_NOT_ENABLED.setLabelFor(this._contentPanel);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("networksettingspanel", "ldappanel-label"));
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel, this._cbEnableDSML);
        ((MultilineLabel)this._taDSMLUrl).setLabelFor((Component)jPanel);
        gridBagConstraints.insets.left += 2;
        gridBagConstraints.insets.right += 2;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._rbOnlyNonSecureLdapPort, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._rbBothLdapPort, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        groupPanel.add((Component)jPanel2, gridBagConstraints);
        JComponent[] jComponentArray = new JComponent[]{this._lLDAPPort, this._tfLDAPPort};
        this.addLine(groupPanel, jComponentArray, UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        JComponent[] jComponentArray2 = new JComponent[]{this._lLDAPSecurePort, this._tfLDAPSecurePort};
        this.addLine(groupPanel, jComponentArray2, UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        groupPanel.add((Component)this._cbEnableReferral, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._tfReferral, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._bConstructReferral, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)this._rbOnlyNonSecureDsmlPort, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._rbOnlySecureDsmlPort, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)this._rbBothDsmlPort, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        jPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JComponent[] jComponentArray3 = new JComponent[]{this._lDSMLPort, this._tfDSMLPort};
        int n = UIFactory.getComponentSpace() - 4;
        this.addLine(jPanel, jComponentArray3, n, UIFactory.getComponentSpace());
        JComponent[] jComponentArray4 = new JComponent[]{this._lDSMLSecurePort, this._tfDSMLSecurePort};
        this.addLine(jPanel, jComponentArray4, n, UIFactory.getComponentSpace());
        JComponent[] jComponentArray5 = new JComponent[]{this._lDSMLUrl, this._tfDSMLUrl};
        this.addLine(jPanel, jComponentArray5, true, n, UIFactory.getDifferentSpace());
        gridBagConstraints.insets = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        JScrollPane jScrollPane = new JScrollPane(this._taDSMLUrl);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(this.getBackground());
        int n2 = (int)this._taDSMLUrl.getPreferredSize().getHeight() + (int)jScrollPane.getHorizontalScrollBar().getPreferredSize().getHeight();
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        CompoundBorder compoundBorder = new CompoundBorder(UITools.createLoweredBorder(), new EmptyBorder(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), UIFactory.getDifferentSpace(), UIFactory.getComponentSpace()));
        jPanel4.setBorder(compoundBorder);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 0;
        jPanel4.add(Box.createVerticalStrut(n2), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel4, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"nsslapd-port", "nsslapd-secureport", "nsslapd-security", "nsslapd-referral"};
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        this._lastReadEntry = "cn=config";
        LDAPEntry lDAPEntry = lDAPConnection.read(this._lastReadEntry, stringArray2);
        this._lastReadAttribute = "nsslapd-port";
        this._saveLDAPPort = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsslapd-secureport";
        this._saveLDAPSecurePort = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-referral");
        this._saveReferral = "";
        if (lDAPAttribute != null) {
            stringArray = lDAPAttribute.getStringValueArray();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    this._saveReferral = this._saveReferral + " ";
                }
                this._saveReferral = this._saveReferral + stringArray[n];
                ++n;
            }
        }
        this._saveEnableReferral = !this._saveReferral.equals("");
        this._isSSLEnabled = DSUtil.getAttrValue(lDAPEntry, "nsslapd-security").equalsIgnoreCase("on");
        stringArray = new String[]{"nsslapd-pluginenabled", "ds-hdsml-port", "ds-hdsml-secureport", "ds-hdsml-rooturl"};
        this._lastReadEntry = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
        LDAPEntry lDAPEntry2 = lDAPConnection.read(this._lastReadEntry, stringArray);
        this._lastReadAttribute = "nsslapd-pluginenabled";
        this._saveEnableDSML = this.getValue(lDAPEntry2, "nsslapd-pluginenabled").equalsIgnoreCase("on");
        this._lastReadAttribute = "ds-hdsml-port";
        if (DSUtil.getAttrValue(lDAPEntry2, this._lastReadAttribute).equals("")) {
            this._saveDSMLPort = 0;
            this._saveDSMLPortDefined = false;
        } else {
            this._saveDSMLPort = Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
            this._saveDSMLPortDefined = true;
        }
        this._lastReadAttribute = "ds-hdsml-secureport";
        if (DSUtil.getAttrValue(lDAPEntry2, this._lastReadAttribute).equals("")) {
            this._saveDSMLSecurePort = 0;
            this._saveDSMLSecurePortDefined = false;
        } else {
            this._saveDSMLSecurePort = Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
            this._saveDSMLSecurePortDefined = true;
        }
        this._saveDSMLUrl = DSUtil.getAttrValue(lDAPEntry2, "ds-hdsml-rooturl");
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._tfLDAPPort.setText(Integer.toString(this._saveLDAPPort));
        BlankPanel.setChangeState(this._lLDAPPort, 1);
        this._ldapPortValidDirty[0] = true;
        this._ldapPortValidDirty[1] = false;
        if (this._saveLDAPSecurePort > 0) {
            this._tfLDAPSecurePort.setText(Integer.toString(this._saveLDAPSecurePort));
        } else {
            this._tfLDAPSecurePort.setText(null);
        }
        this._tfLDAPSecurePort.setEnabled(this._isSSLEnabled && this._saveLDAPSecurePort > 0);
        this._lLDAPSecurePort.setEnabled(this._isSSLEnabled && this._saveLDAPSecurePort > 0);
        this._rbBothLdapPort.setEnabled(this._isSSLEnabled);
        this._rbBothLdapPort.setSelected(this._isSSLEnabled && this._saveLDAPSecurePort > 0);
        this._rbOnlyNonSecureLdapPort.setSelected(!this._rbBothLdapPort.isSelected());
        BlankPanel.setChangeState(this._lLDAPSecurePort, 1);
        this._ldapSecurePortValidDirty[0] = true;
        this._ldapSecurePortValidDirty[1] = false;
        this._cbEnableReferral.setSelected(this._saveEnableReferral);
        this._isEnableReferralDirty = false;
        this._tfReferral.setText(this._saveReferral);
        this._tfReferral.setEnabled(this._saveEnableReferral);
        this._bConstructReferral.setEnabled(this._saveEnableReferral);
        BlankPanel.setChangeState(this._cbEnableReferral, 1);
        this._isReferralValidDirty[0] = this._saveReferral.length() > 0;
        this._isReferralValidDirty[1] = false;
        this._cbEnableDSML.setSelected(this._saveEnableDSML);
        BlankPanel.setChangeState(this._cbEnableDSML, 1);
        this._isEnableDSMLDirty = false;
        if (this._saveDSMLPortDefined && this._saveDSMLSecurePortDefined && this._isSSLEnabled) {
            this._rbBothDsmlPort.setSelected(true);
        } else if (this._saveDSMLSecurePortDefined && this._isSSLEnabled) {
            this._rbOnlySecureDsmlPort.setSelected(true);
        } else {
            this._rbOnlyNonSecureDsmlPort.setSelected(true);
        }
        this._rbOnlyNonSecureDsmlPort.setEnabled(this._saveEnableDSML);
        this._rbBothDsmlPort.setEnabled(this._isSSLEnabled && this._saveEnableDSML);
        this._rbOnlySecureDsmlPort.setEnabled(this._isSSLEnabled && this._saveEnableDSML);
        if (this._saveEnableDSML) {
            this.actionDSMLRadioButtonSelected();
        } else {
            this._tfDSMLPort.setEnabled(false);
            this._lDSMLPort.setEnabled(false);
            this._tfDSMLSecurePort.setEnabled(false);
            this._lDSMLSecurePort.setEnabled(false);
        }
        if (this._saveDSMLPortDefined) {
            this._tfDSMLPort.setText(Integer.toString(this._saveDSMLPort));
            this._dsmlPortValidDirty[0] = true;
            BlankPanel.setChangeState(this._lDSMLPort, 1);
        } else {
            this._tfDSMLPort.setText(null);
            this._dsmlPortValidDirty[0] = false;
            BlankPanel.setChangeState(this._lDSMLPort, 3);
        }
        this._dsmlPortValidDirty[1] = false;
        if (this._saveDSMLSecurePortDefined) {
            this._tfDSMLSecurePort.setText(Integer.toString(this._saveDSMLSecurePort));
            this._dsmlSecurePortValidDirty[0] = true;
            BlankPanel.setChangeState(this._lDSMLSecurePort, 1);
        } else {
            this._tfDSMLSecurePort.setText(null);
            this._dsmlSecurePortValidDirty[0] = false;
            BlankPanel.setChangeState(this._lDSMLSecurePort, 3);
        }
        this._dsmlSecurePortValidDirty[1] = false;
        this._tfDSMLUrl.setText(this._saveDSMLUrl);
        BlankPanel.setChangeState(this._lDSMLUrl, 1);
        this._dsmlUrlValidDirty[0] = true;
        this._dsmlUrlValidDirty[1] = false;
        this._tfDSMLUrl.setEnabled(this._saveEnableDSML);
        this._lDSMLUrl.setEnabled(this._saveEnableDSML);
        this.updateDSMLUrl();
        this.SSL_NOT_ENABLED.setVisible(!this._isSSLEnabled);
        this._isInitializingComponents = false;
    }

    private void checkPort(JLabel jLabel, JTextField jTextField, int n, boolean[] blArray) {
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n2 = Integer.parseInt(jTextField.getText());
            bl2 = n2 != n;
            bl = n2 > 0 && n2 <= 65535;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            bl2 = true;
        }
        if (!bl) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (bl2) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        blArray[0] = bl;
        blArray[1] = bl2;
        this.fireValidDirtyChange();
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !(!this._ldapPortValidDirty[0] || this._rbBothLdapPort.isSelected() && !this._ldapSecurePortValidDirty[0] || this._cbEnableReferral.isSelected() && !this._isReferralValidDirty[0] || this._cbEnableDSML.isSelected() && (!this._rbOnlySecureDsmlPort.isSelected() && !this._dsmlPortValidDirty[0] || !this._rbOnlyNonSecureDsmlPort.isSelected() && !this._dsmlSecurePortValidDirty[0] || !this._dsmlUrlValidDirty[0]));
        boolean bl3 = this._ldapSecurePortValidDirty[1] && this._rbBothLdapPort.isSelected() || this._saveLDAPSecurePort > 0 && !this._rbBothLdapPort.isSelected() && this._isSSLEnabled;
        boolean bl4 = bl = this._ldapPortValidDirty[1] || bl3 || this._isEnableReferralDirty || this._isReferralValidDirty[1] && this._cbEnableReferral.isSelected() || this._isEnableDSMLDirty || this._cbEnableDSML.isSelected() && !this._rbOnlySecureDsmlPort.isSelected() && this._dsmlPortValidDirty[1] || !this._rbOnlyNonSecureDsmlPort.isSelected() && this._dsmlSecurePortValidDirty[1] || this._dsmlUrlValidDirty[1] || this._dsmlTypePortDirty;
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private void addLine(Container container, JComponent[] jComponentArray, int n, int n2) {
        this.addLine(container, jComponentArray, false, n, n2);
    }

    private void addLine(Container container, JComponent[] jComponentArray, boolean bl, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, n, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        int n3 = 1;
        while (n3 < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add((Component)jComponentArray[n3], gridBagConstraints);
            ++n3;
        }
        gridBagConstraints.insets.right = n;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = bl ? 1.0 : 0.0;
        gridBagConstraints.fill = bl ? 2 : 0;
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 0;
        container.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void updateDSMLUrl() {
        if (this._rbOnlyNonSecureDsmlPort.isSelected() && this._dsmlPortValidDirty[0]) {
            String[] stringArray = new String[]{"http://" + this._localHost + ":" + this._tfDSMLPort.getText() + this._tfDSMLUrl.getText().trim()};
            this._taDSMLUrl.setText(ConfigBasePanel._resource.getString("networksettingspanel", "tanonsecuredsmlurl-label", stringArray));
        } else if (this._rbOnlySecureDsmlPort.isSelected() && this._dsmlSecurePortValidDirty[0]) {
            String[] stringArray = new String[]{"https://" + this._localHost + ":" + this._tfDSMLSecurePort.getText() + this._tfDSMLUrl.getText().trim()};
            this._taDSMLUrl.setText(ConfigBasePanel._resource.getString("networksettingspanel", "tasecuredsmlurl-label", stringArray));
        } else if (this._rbBothDsmlPort.isSelected() && this._dsmlPortValidDirty[0] && this._dsmlSecurePortValidDirty[0]) {
            String[] stringArray = new String[]{"http://" + this._localHost + ":" + this._tfDSMLPort.getText() + this._tfDSMLUrl.getText().trim(), "https://" + this._localHost + ":" + this._tfDSMLSecurePort.getText() + this._tfDSMLUrl.getText().trim()};
            this._taDSMLUrl.setText(ConfigBasePanel._resource.getString("networksettingspanel", "tabothdsmlulr-label", stringArray));
        }
    }

    private void actionDSMLRadioButtonSelected() {
        if (this._rbOnlyNonSecureDsmlPort.isSelected()) {
            this._lDSMLPort.setEnabled(true);
            this._tfDSMLPort.setEnabled(true);
            this._lDSMLSecurePort.setEnabled(false);
            this._tfDSMLSecurePort.setEnabled(false);
            this._dsmlTypePortDirty = this._saveDSMLSecurePortDefined && this._isSSLEnabled;
        } else if (this._rbOnlySecureDsmlPort.isSelected()) {
            this._lDSMLPort.setEnabled(false);
            this._tfDSMLPort.setEnabled(false);
            this._lDSMLSecurePort.setEnabled(this._isSSLEnabled);
            this._tfDSMLSecurePort.setEnabled(this._isSSLEnabled);
            this._dsmlTypePortDirty = this._saveDSMLPortDefined;
        } else if (this._rbBothDsmlPort.isSelected()) {
            this._lDSMLPort.setEnabled(true);
            this._tfDSMLPort.setEnabled(true);
            this._lDSMLSecurePort.setEnabled(this._isSSLEnabled);
            this._tfDSMLSecurePort.setEnabled(this._isSSLEnabled);
            this._dsmlTypePortDirty = !this._saveDSMLPortDefined || !this._saveDSMLSecurePortDefined;
        } else {
            Thread.dumpStack();
        }
        this.updateDSMLUrl();
        this.fireValidDirtyChange();
    }

    private void actionLDAPRadioButtonSelected() {
        boolean bl = !this._rbOnlyNonSecureLdapPort.isSelected();
        this._tfLDAPSecurePort.setEnabled(bl);
        this._lLDAPSecurePort.setEnabled(bl);
        if (bl) {
            String string = this._tfLDAPSecurePort.getText();
            this._tfLDAPSecurePort.setText("foo");
            this._tfLDAPSecurePort.setText(string);
        } else {
            this.fireValidDirtyChange();
        }
    }

    private ArrayList getReferralList(String string) {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = string.length() <= 0;
        if (bl) {
            arrayList.add("");
        }
        while (!bl) {
            int n3 = string.indexOf(" ldap://", n);
            int n4 = string.indexOf(" ldaps://", n);
            if (n4 < 0) {
                if (n3 < 0) {
                    arrayList.add(string.substring(n));
                    bl = true;
                } else {
                    n2 = n3;
                }
            } else {
                n2 = n3 < 0 ? n4 : Math.min(n4, n3);
            }
            if (bl) continue;
            arrayList.add(string.substring(n, n2).trim());
            n = n2 + 1;
        }
        return arrayList;
    }

    private void modifyPrefEntries() throws LDAPException {
        try {
            LDAPConnection lDAPConnection = this.getConsoleInfo().getLDAPConnection();
            String[] stringArray = new String[]{"nsDirectoryURL"};
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("o=netscaperoot", 2, "(cn=userdirectory)", stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPUrl lDAPUrl;
                String string;
                boolean bl;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string2 = DSUtil.getAttrValue(lDAPEntry, "nsDirectoryURL");
                if (string2.equals("") || !(bl = (string = (lDAPUrl = new LDAPUrl(string2)).getHost()).equals(this.getServerInfo().getHost()))) continue;
                String string3 = null;
                int n = Integer.parseInt(this._tfLDAPPort.getText());
                if (this._rbOnlyNonSecureLdapPort.isSelected()) {
                    if (lDAPUrl.getPort() != n || lDAPUrl.isSecure()) {
                        string3 = "ldap://" + lDAPUrl.getHost() + ":" + n + "/" + lDAPUrl.getDN();
                    }
                } else {
                    int n2 = Integer.parseInt(this._tfLDAPSecurePort.getText());
                    if (lDAPUrl.isSecure()) {
                        if (lDAPUrl.getPort() != n2) {
                            string3 = "ldaps://" + lDAPUrl.getHost() + ":" + n2 + "/" + lDAPUrl.getDN();
                        }
                    } else if (lDAPUrl.getPort() != n) {
                        string3 = "ldap://" + lDAPUrl.getHost() + ":" + n + "/" + lDAPUrl.getDN();
                    }
                }
                if (string3 == null) continue;
                LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsDirectoryURL", string3));
                lDAPConnection.modify(lDAPEntry.getDN(), lDAPModification);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

