/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigLogTabbedPanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.management.client.IMenuItem;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConfigLogNode
extends DefaultMutableTreeNode
implements IConfigNode {
    protected DSFramework _framework;
    protected String _name;
    protected Icon _icon;
    protected ConfigLogTabbedPanel _customPanel;
    protected boolean _refreshPanelOnRequest;
    private static final IMenuItem[] _objectMenuItems = new IMenuItem[0];
    private static final IMenuItem[] _contextMenuItems = new IMenuItem[0];
    private static final String LOG_ICON_NAME = "logobject.gif";

    public ConfigLogNode(DSFramework dSFramework) {
        this._framework = dSFramework;
        this._name = DSConfigPage._resource.getString("lognode", "label");
        this._icon = DSUtil.getPackageImage(LOG_ICON_NAME);
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.refreshPanel();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return false;
    }

    public void refreshNode() {
        this._refreshPanelOnRequest = true;
    }

    public void menuAction(String string) {
    }

    public IMenuItem[] getObjectMenuItems() {
        return _objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return _contextMenuItems;
    }

    private ConfigLogTabbedPanel createCustomPanel() {
        return new ConfigLogTabbedPanel(this._framework);
    }
}

