/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSAdminEvent;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSAdminEventListener;
import com.netscape.admin.dirserv.config.CipherSetup;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.ISSLConfigListener;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CipherPreferenceDialog;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.security.EncryptionPanel;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class ConfigEncryptionPanel
extends ConfigBasePanel
implements ActionListener,
EncryptionOptions,
IDSAdminEventListener {
    private boolean _isRefreshing;
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _needsRestartServer;
    private ArrayList _warnings;
    private JPanel _contentPanel;
    private JPanel _encryptParent;
    private EncryptionPanel _encrypt;
    private JCheckBox _cbSSLInConsole;
    private JRadioButton _rbNoClientAuth;
    private JRadioButton _rbAllowClientAuth;
    private JRadioButton _rbRequireClientAuth;
    private JLabel _lDSMLClientAuth;
    private JComboBox _comboDSMLClientAuth;
    private boolean _isSSLInConsoleDirty;
    private boolean _isClientAuthDirty;
    private boolean _isDSMLClientAuthDirty;
    private boolean _isEncryptionPanelDirty;
    private String _cipherPrefs;
    private boolean _enableSSL;
    private Hashtable _htCipherSetup = new Hashtable(5);
    private String _saveClientAuth;
    private String _saveDSMLClientAuth;
    private boolean _saveSSLInConsole;
    private ArrayList _listeners;
    private ArrayList _suffixesWithEncryptedAttributes;
    private int HTTP_BASIC_ONLY = 0;
    private int CLIENT_CERT_FIRST = 1;
    private int ONLY_CERT = 2;
    private int CLIENT_CERT = 3;
    private int ANONYMOUS = 4;
    private String[] DSML_CLIENT_VALUES = new String[]{ConfigBasePanel._resource.getString("encryptionpanel", "httponly-label"), ConfigBasePanel._resource.getString("encryptionpanel", "clientcertificatefirst-label"), ConfigBasePanel._resource.getString("encryptionpanel", "onlycertificate-label"), ConfigBasePanel._resource.getString("encryptionpanel", "clientcertificate-label"), ConfigBasePanel._resource.getString("encryptionpanel", "useanonymous-label")};
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("encryptionpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("encryptionpanel-no-rights", "label"), 2, 50);
    private static final String CIPHER_PREFS = "-rsa_null_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_des_sha,+rsa_fips_des_sha,+rsa_3des_sha,+rsa_fips_3des_sha,+fortezza,+fortezza_rc4_128_sha,+fortezza_null,+tls_rsa_export1024_with_rc4_56_sha,+tls_rsa_export1024_with_des_cbc_sha";
    private static final String CIPHER_SSL3_OFF = "-rsa_null_md5,-rsa_rc4_128_md5,-rsa_rc4_40_md5,-rsa_rc2_40_md5,-rsa_des_sha,-rsa_fips_des_sha,-rsa_3des_sha,-rsa_fips_3des_sha,-fortezza,-fortezza_rc4_128_sha,-fortezza_null";
    private static final String CIPHER_TLS_OFF = "-tls_rsa_export1024_with_rc4_56_sha,-tls_rsa_export1024_with_des_cbc_sha";

    public ConfigEncryptionPanel() {
        this._helpToken = "configuration-system-encryption-help";
        this.setTitle(ConfigBasePanel._resource.getString("encryptionpanel", "title"));
    }

    public void addSSLConfigListener(ISSLConfigListener iSSLConfigListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(iSSLConfigListener);
    }

    public void removeSSLConfigListener(ISSLConfigListener iSSLConfigListener) {
        if (this._listeners != null) {
            ((AbstractCollection)this._listeners).remove(iSSLConfigListener);
        }
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this._framework.getServerObject().addDSAdminEventListener(this);
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigEncryptionPanel.this._warnings = new ArrayList();
                        ConfigEncryptionPanel.this.readDataFromServer();
                        ConfigEncryptionPanel.this.createContentPanel();
                        ConfigEncryptionPanel.this._isEncryptionPanelDirty = false;
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$400(this.this$1).showComponent(ConfigEncryptionPanel.access$500(1.access$400(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$400(this.this$1).showComponent((JComponent)ConfigEncryptionPanel.access$600(1.access$400(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("encryptionpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$400(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigEncryptionPanel.this._isInitialized = true;
                    ConfigEncryptionPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigEncryptionPanel access$400(1 var0) {
                    return var0.ConfigEncryptionPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        this._isRefreshing = true;
        try {
            this.readDataFromServer();
            if (this._contentPanel == null) {
                this.createContentPanel();
            }
            BlankPanel.setChangeState(this._cbSSLInConsole, 1);
            this._cbSSLInConsole.setSelected(this._saveSSLInConsole);
            this._isSSLInConsoleDirty = false;
            if (this._saveClientAuth.equalsIgnoreCase("off")) {
                this._rbNoClientAuth.setSelected(true);
            } else if (this._saveClientAuth.equalsIgnoreCase("allowed")) {
                this._rbAllowClientAuth.setSelected(true);
            } else if (this._saveClientAuth.equalsIgnoreCase("required")) {
                this._rbRequireClientAuth.setSelected(true);
            } else {
                Thread.dumpStack();
            }
            BlankPanel.setChangeState(this._rbNoClientAuth, 1);
            BlankPanel.setChangeState(this._rbAllowClientAuth, 1);
            BlankPanel.setChangeState(this._rbRequireClientAuth, 1);
            this._isClientAuthDirty = false;
            if (this._saveDSMLClientAuth.equalsIgnoreCase("httpBasicOnly")) {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
            } else if (this._saveDSMLClientAuth.equalsIgnoreCase("clientCertFirst")) {
                if (this._rbNoClientAuth.isSelected()) {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
                } else if (this._rbRequireClientAuth.isSelected()) {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT]);
                } else {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT_FIRST]);
                }
            } else if (this._saveDSMLClientAuth.equalsIgnoreCase("clientCertOnly")) {
                if (this._rbNoClientAuth.isSelected()) {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.ANONYMOUS]);
                } else if (this._rbRequireClientAuth.isSelected()) {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT]);
                } else {
                    this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.ONLY_CERT]);
                }
            }
            BlankPanel.setChangeState(this._lDSMLClientAuth, 1);
            this._isDSMLClientAuthDirty = false;
            this._encryptParent.remove((Component)this._encrypt);
            this._encrypt = new EncryptionPanel(this.getConsoleInfo(), (String)this.getServerInfo().get("SIE"), (EncryptionOptions)this);
            this.hackToSelectCertificate();
            this._encryptParent.add("Center", (Component)this._encrypt);
            this._isEncryptionPanelDirty = false;
            this._rbNoClientAuth.setEnabled(this._enableSSL);
            this._rbAllowClientAuth.setEnabled(this._enableSSL);
            this._rbRequireClientAuth.setEnabled(this._enableSSL);
            this._cbSSLInConsole.setEnabled(this._enableSSL && !this._rbRequireClientAuth.isSelected());
            this._comboDSMLClientAuth.setEnabled(this._enableSSL);
            this._lDSMLClientAuth.setEnabled(this._enableSSL);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigEncryptionPanel.this.showComponent(ConfigEncryptionPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigEncryptionPanel.this.showComponent((JComponent)ConfigEncryptionPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("encryptionpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigEncryptionPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
        this.fireValidDirtyChange();
        this._isRefreshing = false;
    }

    public void okCallback() throws ConfigPanelException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this._needsRestartServer = false;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        if (this._enableSSL) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            object4 = this._htCipherSetup.keys();
            while (object4.hasMoreElements()) {
                object3 = object4.nextElement();
                object2 = (CipherSetup)this._htCipherSetup.get(object3);
                if (!object2.enabled) continue;
                ++n;
                if (object2.selectedDevice.length() == 0) {
                    ++n2;
                }
                if (object2.selectedCertificate.length() != 0) continue;
                ++n3;
            }
            if (n == 0) {
                vector.addElement(ConfigBasePanel._resource.getString("encryptionpanel", "nosslpreferences-msg"));
            }
            if (n2 >= 1) {
                vector.addElement(ConfigBasePanel._resource.getString("encryptionpanel", "nosslfamily-msg"));
            }
            if (n3 >= 1) {
                vector.addElement(ConfigBasePanel._resource.getString("encryptionpanel", "nocertificate-msg"));
            }
            if (vector.size() > 0) {
                object4 = vector.elements();
                object3 = (String)object4.nextElement();
                while (object4.hasMoreElements()) {
                    object3 = object3 + "\n" + (String)object4.nextElement();
                }
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("encryptionpanel", "invalidsslsettings-title"), (String)object3);
            }
        }
        String string = null;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        String string2 = this.getConsoleInfo().getCurrentDN();
        try {
            if (this._enableSSL) {
                if (this._isEncryptionPanelDirty) {
                    object4 = this._htCipherSetup.keys();
                    while (object4.hasMoreElements()) {
                        object3 = (CipherSetup)this._htCipherSetup.get(object4.nextElement());
                        object2 = new LDAPAttributeSet();
                        if (((CipherSetup)object3).selectedDevice.length() >= 1) {
                            object2.add(new LDAPAttribute("nsssltoken", ((CipherSetup)object3).selectedDevice));
                        }
                        if (((CipherSetup)object3).selectedCertificate.length() >= 1) {
                            object2.add(new LDAPAttribute("nssslpersonalityssl", ((CipherSetup)object3).selectedCertificate));
                        }
                        object = ((CipherSetup)object3).enabled && this._enableSSL ? "on" : "off";
                        object2.add(new LDAPAttribute("nssslactivation", (String)object));
                        stringArray = new String[]{"top", "nsEncryptionModule"};
                        object2.add(new LDAPAttribute("objectclass", stringArray));
                        String string3 = "cn=" + ((CipherSetup)object3).family + ",cn=encryption,cn=config";
                        LDAPEntry lDAPEntry = new LDAPEntry(string3, (LDAPAttributeSet)object2);
                        string = lDAPEntry.getDN();
                        this.addOrModifyLDAPEntry(lDAPConnection, lDAPEntry);
                        bl = true;
                    }
                }
                object4 = new LDAPModificationSet();
                if (this._isEncryptionPanelDirty) {
                    object3 = this._enableSSL ? "on" : "off";
                    object4.add(2, new LDAPAttribute("nsssl3", object3));
                    object4.add(2, new LDAPAttribute("nsssl3ciphers", this._cipherPrefs));
                    object2 = LDAPDN.explodeDN((String)string2, (boolean)true)[0];
                    object3 = "alias/" + object2.toLowerCase() + "-key3.db";
                    object4.add(2, new LDAPAttribute("nskeyfile", object3));
                    object3 = "alias/" + object2.toLowerCase() + "-cert7.db";
                    object4.add(2, new LDAPAttribute("nscertfile", object3));
                }
                if (this._isClientAuthDirty) {
                    object3 = null;
                    if (this._rbNoClientAuth.isSelected()) {
                        object3 = "off";
                    } else if (this._rbAllowClientAuth.isSelected()) {
                        object3 = "allowed";
                    } else if (this._rbRequireClientAuth.isSelected()) {
                        object3 = "required";
                    } else {
                        Thread.dumpStack();
                    }
                    object4.add(2, new LDAPAttribute("nssslclientauth", object3));
                }
                if (object4.size() > 0 && !this._isCancelled) {
                    string = "cn=encryption,cn=config";
                    lDAPConnection.modify(string, (LDAPModificationSet)object4);
                    bl = true;
                }
            }
            if (this._isEncryptionPanelDirty && !this._isCancelled) {
                object4 = new LDAPModificationSet();
                object3 = this._enableSSL ? "on" : "off";
                object4.add(2, new LDAPAttribute("nsslapd-security", object3));
                string = "cn=config";
                lDAPConnection.modify(string, (LDAPModificationSet)object4);
                if (this._listeners != null) {
                    object2 = ((AbstractList)this._listeners).listIterator();
                    while (object2.hasNext()) {
                        object = (ISSLConfigListener)object2.next();
                        if (this._enableSSL) {
                            object.notifySSLEnabled();
                            continue;
                        }
                        object.notifySSLDisabled();
                    }
                }
                bl = true;
            }
            if (this._isDSMLClientAuthDirty) {
                object4 = new LDAPModificationSet();
                object3 = null;
                object2 = this._comboDSMLClientAuth.getSelectedItem();
                if (object2 == this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]) {
                    object3 = "httpBasicOnly";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.CLIENT_CERT_FIRST]) {
                    object3 = "clientCertFirst";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.ONLY_CERT]) {
                    object3 = "clientCertOnly";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.CLIENT_CERT]) {
                    object3 = "clientCertFirst";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.ANONYMOUS]) {
                    object3 = "clientCertOnly";
                } else {
                    Thread.dumpStack();
                }
                object4.add(2, new LDAPAttribute("ds-hdsml-SSLClientAuthMethod", object3));
                string = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
                lDAPConnection.modify(string, (LDAPModificationSet)object4);
                bl = true;
            }
        }
        catch (LDAPException lDAPException) {
            object3 = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("encryptionpanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("encryptionpanel", "updating-server-error-msg", object3));
        }
        boolean bl2 = false;
        object3 = this.getConsoleInfo().getLDAPConnection();
        try {
            if (this._enableSSL) {
                if (this._isSSLInConsoleDirty && !this._isCancelled) {
                    object2 = this._cbSSLInConsole.isSelected() ? "on" : "off";
                    object = new LDAPAttribute("nsserversecurity", (String)object2);
                    object3.modify(string2, new LDAPModification(2, (LDAPAttribute)object));
                    bl = true;
                }
            } else if (this._saveSSLInConsole && !this._isCancelled) {
                object2 = "off";
                object = new LDAPAttribute("nsserversecurity", (String)object2);
                object3.modify(string2, new LDAPModification(2, (LDAPAttribute)object));
                bl = true;
                bl2 = true;
            }
        }
        catch (LDAPException lDAPException) {
            object = new LDAPAttribute[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("encryptionpanel", "updating-topologyserver-error-title"), ConfigBasePanel._resource.getString("encryptionpanel", "updating-topologyserver-error-msg", (String[])object));
        }
        if (this._enableSSL) {
            this._framework.getServerObject().setSecurityState(DSAdmin.SECURITY_ENABLE);
        } else {
            this._framework.getServerObject().setSecurityState(DSAdmin.SECURITY_DISABLE);
        }
        this._warnings.clear();
        if (this._enableSSL && this._isEncryptionPanelDirty) {
            try {
                object2 = new String[]{Integer.toString(lDAPConnection.getPort())};
                this._warnings.add(ConfigBasePanel._resource.getString("encryptionpanel", "nonsslportworking-msg", object2));
                object = new String[]{"nsslapd-port", "nsslapd-secureport"};
                stringArray = lDAPConnection.read("cn=config", (String[])object);
                int n = Integer.parseInt(this.getValue((LDAPEntry)stringArray, (String)object[0]).trim());
                int n4 = Integer.parseInt(this.getValue((LDAPEntry)stringArray, (String)object[1]).trim());
                if (n4 <= 0) {
                    this._warnings.add(ConfigBasePanel._resource.getString("encryptionpanel", "sslport-not-configured-msg"));
                } else if (!DSUtil.isNT(this.getConsoleInfo()) && n >= 1024 && n4 < 1024) {
                    String[] stringArray2 = new String[]{Integer.toString(n4)};
                    this._warnings.add(ConfigBasePanel._resource.getString("encryptionpanel", "confirm-sslport-msg", stringArray2));
                }
            }
            catch (LDAPException lDAPException) {
            }
            catch (NumberFormatException numberFormatException) {
                Thread.dumpStack();
            }
        }
        if (bl2) {
            this._warnings.add(ConfigBasePanel._resource.getString("encryptionpanel", "sslinconsole-disabled-msg"));
        }
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._needsRestartServer = bl;
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsConfirmation() {
        if (this._suffixesWithEncryptedAttributes == null) {
            this._suffixesWithEncryptedAttributes = new ArrayList();
        }
        this._suffixesWithEncryptedAttributes.clear();
        if (!this._enableSSL && this._isEncryptionPanelDirty) {
            DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
            try {
                LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
                String[] stringArray = new String[]{"dn"};
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=ldbm database,cn=plugins,cn=config", 2, "objectclass=dsAttributeEncryption", stringArray, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    DN dN = new DN(lDAPEntry.getDN());
                    DN dN2 = dN.getParent().getParent();
                    String string = dN2.explodeDN(true)[0];
                    ListIterator listIterator = ((AbstractList)databaseConfig.getDatabases()).listIterator();
                    boolean bl = false;
                    while (listIterator.hasNext() && !bl) {
                        Database database = (Database)listIterator.next();
                        if (!database.getName().equalsIgnoreCase(string)) continue;
                        bl = true;
                        Suffix suffix = database.getSuffix();
                        if (suffix == null) continue;
                        this._suffixesWithEncryptedAttributes.add(suffix.getName());
                    }
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
        return this._suffixesWithEncryptedAttributes.size() > 0;
    }

    public boolean askForConfirmation() {
        int n;
        if (this._suffixesWithEncryptedAttributes.size() == 1) {
            String[] stringArray = new String[]{(String)this._suffixesWithEncryptedAttributes.get(0)};
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-disablesslwithencryptedattributes-onesuffix", stringArray, "encryptionpanel", ConfigBasePanel._resource);
        } else {
            String string = (String)this._suffixesWithEncryptedAttributes.get(0);
            int n2 = 1;
            while (n2 < this._suffixesWithEncryptedAttributes.size()) {
                string = string + "; " + this._suffixesWithEncryptedAttributes.get(n2);
                ++n2;
            }
            String[] stringArray = new String[]{string};
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-disablesslwithencryptedattributes-severalsuffixes", stringArray, "encryptionpanel", ConfigBasePanel._resource);
        }
        return n == 0;
    }

    public boolean hasWarningMessage() {
        return this._warnings.size() > 0;
    }

    public void displayWarningMessage() {
        ListIterator listIterator = ((AbstractList)this._warnings).listIterator();
        String string = (String)listIterator.next();
        while (listIterator.hasNext()) {
            string = string + "\n" + (String)listIterator.next();
        }
        String[] stringArray = new String[]{string};
        DSUtil.showInformationDialog((Component)((Object)this._framework), "general-warning", stringArray, "encryptionpanel", ConfigBasePanel._resource);
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbSSLInConsole) {
            this._isSSLInConsoleDirty = this._saveSSLInConsole != this._cbSSLInConsole.isSelected();
            BlankPanel.setChangeState(this._cbSSLInConsole, this._isSSLInConsoleDirty ? 2 : 1);
            this.fireValidDirtyChange();
        } else if (object == this._rbNoClientAuth || object == this._rbAllowClientAuth || object == this._rbRequireClientAuth) {
            boolean bl = this._rbRequireClientAuth.isSelected();
            this._cbSSLInConsole.setEnabled(!bl);
            if (bl && this._cbSSLInConsole.isSelected()) {
                this._cbSSLInConsole.setSelected(false);
                this._isSSLInConsoleDirty = this._saveSSLInConsole != this._cbSSLInConsole.isSelected();
                BlankPanel.setChangeState(this._cbSSLInConsole, this._isSSLInConsoleDirty ? 2 : 1);
                DSUtil.showInformationDialog(this, "nosslinconsolepossible", null, "encryptionpanel", ConfigBasePanel._resource);
            }
            String string = "";
            if (this._rbNoClientAuth.isSelected()) {
                string = "off";
            } else if (this._rbAllowClientAuth.isSelected()) {
                string = "allowed";
            } else if (this._rbRequireClientAuth.isSelected()) {
                string = "required";
            }
            this._isClientAuthDirty = !this._saveClientAuth.equalsIgnoreCase(string);
            BlankPanel.setChangeState(this._rbNoClientAuth, this._isClientAuthDirty ? 2 : 1);
            BlankPanel.setChangeState(this._rbAllowClientAuth, this._isClientAuthDirty ? 2 : 1);
            BlankPanel.setChangeState(this._rbRequireClientAuth, this._isClientAuthDirty ? 2 : 1);
            this.updateDSMLCombo();
            this.fireValidDirtyChange();
        } else if (object == this._comboDSMLClientAuth) {
            String string = "";
            Object object2 = this._comboDSMLClientAuth.getSelectedItem();
            if (object2 != null) {
                if (object2 == this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]) {
                    string = this._rbNoClientAuth.isSelected() ? (!this._saveDSMLClientAuth.equalsIgnoreCase("httpBasicOnly") && !this._saveDSMLClientAuth.equalsIgnoreCase("clientCertFirst") ? "httpBasicOnly" : this._saveDSMLClientAuth) : "httpBasicOnly";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.CLIENT_CERT_FIRST]) {
                    string = "clientCertFirst";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.ONLY_CERT]) {
                    string = "clientCertOnly";
                } else if (object2 == this.DSML_CLIENT_VALUES[this.CLIENT_CERT]) {
                    string = !this._saveDSMLClientAuth.equalsIgnoreCase("clientCertOnly") && !this._saveDSMLClientAuth.equalsIgnoreCase("clientCertFirst") ? "clientCertFirst" : this._saveDSMLClientAuth;
                } else if (object2 == this.DSML_CLIENT_VALUES[this.ANONYMOUS]) {
                    string = "clientCertOnly";
                } else {
                    Thread.dumpStack();
                }
            }
            this._isDSMLClientAuthDirty = !this._saveDSMLClientAuth.equalsIgnoreCase(string);
            BlankPanel.setChangeState(this._lDSMLClientAuth, this._isDSMLClientAuthDirty ? 2 : 1);
            this.fireValidDirtyChange();
        }
    }

    public void showCipherPreferenceDialog(String string) {
        CipherPreferenceDialog cipherPreferenceDialog = new CipherPreferenceDialog((Frame)((Object)this._framework), null, CIPHER_SSL3_OFF, CIPHER_TLS_OFF);
        cipherPreferenceDialog.setCipherEnabled("V3", this._cipherPrefs);
        cipherPreferenceDialog.setCipherEnabled("TLS", this._cipherPrefs);
        cipherPreferenceDialog.showModal();
        if (!cipherPreferenceDialog.isCancel()) {
            this._cipherPrefs = cipherPreferenceDialog.getCipherPreference("V3") + "," + cipherPreferenceDialog.getCipherPreference("TLS");
            this._isEncryptionPanelDirty = true;
            this.fireValidDirtyChange();
        }
    }

    public void cipherFamilyEnabledChanged(String string, boolean bl) {
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.enabled = bl;
        this._isEncryptionPanelDirty = true;
        this.fireValidDirtyChange();
    }

    public String getSelectedCertificate(String string) {
        CipherSetup cipherSetup = (CipherSetup)this._htCipherSetup.get(string);
        return cipherSetup == null ? null : cipherSetup.selectedCertificate;
    }

    public void selectedCertificateChanged(String string, String string2) {
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.selectedCertificate = string2;
        this._isEncryptionPanelDirty = true;
        this.fireValidDirtyChange();
    }

    public String getSelectedDevice(String string) {
        CipherSetup cipherSetup = (CipherSetup)this._htCipherSetup.get(string);
        return cipherSetup == null ? null : cipherSetup.selectedDevice;
    }

    public void selectedDeviceChanged(String string, String string2) {
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.selectedDevice = string2;
        this._isEncryptionPanelDirty = true;
        this.fireValidDirtyChange();
    }

    public void setSecurityIsDomestic(boolean bl) {
    }

    public boolean isSecurityEnabled() {
        return this._enableSSL;
    }

    public boolean isCipherFamilyEnabled(String string) {
        CipherSetup cipherSetup = (CipherSetup)this._htCipherSetup.get(string);
        return cipherSetup != null && cipherSetup.enabled;
    }

    public void securityEnabledChanged(boolean bl) {
        this._enableSSL = bl;
        this._isEncryptionPanelDirty = true;
        this._rbNoClientAuth.setEnabled(this._enableSSL);
        this._rbAllowClientAuth.setEnabled(this._enableSSL);
        this._rbRequireClientAuth.setEnabled(this._enableSSL);
        this._cbSSLInConsole.setEnabled(this._enableSSL && !this._rbRequireClientAuth.isSelected());
        this._lDSMLClientAuth.setEnabled(this._enableSSL);
        this._comboDSMLClientAuth.setEnabled(this._enableSSL);
        this.fireValidDirtyChange();
    }

    public void processDSAdminEvent(DSAdminEvent dSAdminEvent) {
        if (this._isInitialized) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    if (!ConfigEncryptionPanel.this._isRefreshing) {
                        ConfigEncryptionPanel.this.showComponent(ConfigEncryptionPanel.this.REFRESH_LABEL, true);
                        ConfigEncryptionPanel.this.resetCallback();
                    }
                }
            });
            thread.start();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._encrypt = new EncryptionPanel(this.getConsoleInfo(), (String)this.getServerInfo().get("SIE"), (EncryptionOptions)this);
        this.hackToSelectCertificate();
        this._encryptParent = new JPanel(new GridLayout());
        this._encryptParent.add("Center", (Component)this._encrypt);
        this._rbNoClientAuth = UIFactory.makeJRadioButton(this, "encryptionpanel", "rbnoclientauth", false, ConfigBasePanel._resource);
        this._rbAllowClientAuth = UIFactory.makeJRadioButton(this, "encryptionpanel", "rballowclientauth", false, ConfigBasePanel._resource);
        this._rbRequireClientAuth = UIFactory.makeJRadioButton(this, "encryptionpanel", "rbrequireclientauth", false, ConfigBasePanel._resource);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbNoClientAuth);
        buttonGroup.add(this._rbAllowClientAuth);
        buttonGroup.add(this._rbRequireClientAuth);
        if (this._saveClientAuth.equalsIgnoreCase("off")) {
            this._rbNoClientAuth.setSelected(true);
        } else if (this._saveClientAuth.equalsIgnoreCase("allowed")) {
            this._rbAllowClientAuth.setSelected(true);
        } else if (this._saveClientAuth.equalsIgnoreCase("required")) {
            this._rbRequireClientAuth.setSelected(true);
        } else {
            Thread.dumpStack();
        }
        this._cbSSLInConsole = UIFactory.makeJCheckBox(this, "encryptionpanel", "cbsslinconsole", false, ConfigBasePanel._resource);
        this._cbSSLInConsole.setSelected(this._saveSSLInConsole);
        this._lDSMLClientAuth = UIFactory.makeJLabel("encryptionpanel", "ldsmlclientauth", ConfigBasePanel._resource);
        this._comboDSMLClientAuth = new JComboBox<String>(this.DSML_CLIENT_VALUES);
        this._comboDSMLClientAuth.addActionListener(this);
        this._lDSMLClientAuth.setLabelFor(this._comboDSMLClientAuth);
        if (this._saveDSMLClientAuth.equalsIgnoreCase("httpBasicOnly")) {
            this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
        } else if (this._saveDSMLClientAuth.equalsIgnoreCase("clientCertFirst")) {
            if (this._rbNoClientAuth.isSelected()) {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
            } else if (this._rbRequireClientAuth.isSelected()) {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT]);
            } else {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT_FIRST]);
            }
        } else if (this._saveDSMLClientAuth.equalsIgnoreCase("clientCertOnly")) {
            if (this._rbNoClientAuth.isSelected()) {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.ANONYMOUS]);
            } else if (this._rbRequireClientAuth.isSelected()) {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT]);
            } else {
                this._comboDSMLClientAuth.setSelectedItem(this.DSML_CLIENT_VALUES[this.ONLY_CERT]);
            }
        }
        this.updateDSMLCombo();
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("encryptionpanel", "clientauthpanel-title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        int n = 2;
        gridBagConstraints.insets.left += n;
        gridBagConstraints.insets.right += n;
        this._contentPanel.add((Component)this._encryptParent, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        groupPanel.add((Component)this._rbNoClientAuth, gridBagConstraints);
        groupPanel.add((Component)this._rbAllowClientAuth, gridBagConstraints);
        groupPanel.add((Component)this._rbRequireClientAuth, gridBagConstraints);
        groupPanel.add((Component)this._cbSSLInConsole, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._lDSMLClientAuth, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 0;
        groupPanel.add((Component)this._comboDSMLClientAuth, gridBagConstraints);
        this._rbNoClientAuth.setEnabled(this._enableSSL);
        this._rbAllowClientAuth.setEnabled(this._enableSSL);
        this._rbRequireClientAuth.setEnabled(this._enableSSL);
        this._cbSSLInConsole.setEnabled(this._enableSSL && !this._rbRequireClientAuth.isSelected());
        this._lDSMLClientAuth.setEnabled(this._enableSSL);
        this._comboDSMLClientAuth.setEnabled(this._enableSSL);
    }

    private void readDataFromServer() throws LDAPException {
        this._htCipherSetup.clear();
        ConsoleInfo consoleInfo = this.getServerInfo();
        ConsoleInfo consoleInfo2 = this.getConsoleInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        LDAPConnection lDAPConnection2 = consoleInfo2.getLDAPConnection();
        String string = consoleInfo2.getCurrentDN();
        String[] stringArray = new String[]{"nsserversecurity"};
        LDAPEntry lDAPEntry = lDAPConnection2.read(string, stringArray);
        this._saveSSLInConsole = this.getValue(lDAPEntry, stringArray[0]).equals("on");
        String[] stringArray2 = new String[]{"nsslapd-security"};
        LDAPEntry lDAPEntry2 = lDAPConnection.read("cn=config", stringArray2);
        this._enableSSL = this.getValue(lDAPEntry2, stringArray2[0]).equals("on");
        LDAPEntry lDAPEntry3 = lDAPConnection.read("cn=encryption, cn=config");
        this._saveClientAuth = this.getValue(lDAPEntry3, "nssslclientauth");
        this._cipherPrefs = DSUtil.getAttrValue(lDAPEntry3, "nsssl3ciphers");
        String[] stringArray3 = new String[]{"ds-hdsml-SSLClientAuthMethod"};
        LDAPEntry lDAPEntry4 = lDAPConnection.read("cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config", stringArray3);
        this._saveDSMLClientAuth = DSUtil.getAttrValue(lDAPEntry4, "ds-hdsml-SSLClientAuthMethod");
        if (this._saveDSMLClientAuth.equals("")) {
            this._saveDSMLClientAuth = "clientCertFirst";
        }
        if (this._cipherPrefs.length() == 0) {
            this._cipherPrefs = CIPHER_PREFS;
        }
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=encryption, cn=config", 1, "objectclass=*", null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry5 = lDAPSearchResults.next();
            CipherSetup cipherSetup = new CipherSetup();
            String string2 = lDAPEntry5.getDN();
            int n = string2.indexOf(44);
            cipherSetup.family = string2.substring(string2.indexOf(61) + 1, n);
            cipherSetup.enabled = this.getValue(lDAPEntry5, "nssslactivation").equalsIgnoreCase("on");
            cipherSetup.selectedDevice = DSUtil.getAttrValue(lDAPEntry5, "nsssltoken");
            cipherSetup.selectedCertificate = DSUtil.getAttrValue(lDAPEntry5, "nssslpersonalityssl");
            this._htCipherSetup.put(cipherSetup.family, cipherSetup);
        }
    }

    private CipherSetup findOrCreateCipherSetup(String string) {
        CipherSetup cipherSetup = (CipherSetup)this._htCipherSetup.get(string);
        if (cipherSetup == null) {
            cipherSetup = new CipherSetup();
            cipherSetup.family = string;
            this._htCipherSetup.put(cipherSetup.family, cipherSetup);
        }
        return cipherSetup;
    }

    private void fireValidDirtyChange() {
        if (this._isInitialized) {
            boolean bl;
            boolean bl2 = bl = this._isSSLInConsoleDirty || this._isClientAuthDirty || this._isDSMLClientAuthDirty || this._isEncryptionPanelDirty;
            if (bl) {
                this.setDirtyFlag();
            } else {
                this.clearDirtyFlag();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addOrModifyLDAPEntry(LDAPConnection var1_1, LDAPEntry var2_2) throws LDAPException {
        block4: {
            try {
                var1_1.add(var2_2);
                break block4;
            }
            catch (LDAPException var3_3) {
                if (var3_3.getLDAPResultCode() != 68) {
                    throw var3_3;
                }
                var4_4 = new LDAPModificationSet();
                var5_5 = var2_2.getAttributeSet().getAttributes();
                ** while (var5_5.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var6_6 = (LDAPAttribute)var5_5.nextElement();
                var4_4.add(2, var6_6);
                continue;
            }
lbl13:
            // 1 sources

            var1_1.modify(var2_2.getDN(), var4_4);
        }
    }

    private void updateDSMLCombo() {
        Object object = this._comboDSMLClientAuth.getSelectedItem();
        this._comboDSMLClientAuth.removeAllItems();
        if (this._rbNoClientAuth.isSelected()) {
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.ANONYMOUS]);
        } else if (this._rbRequireClientAuth.isSelected()) {
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT]);
        } else {
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.HTTP_BASIC_ONLY]);
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.CLIENT_CERT_FIRST]);
            this._comboDSMLClientAuth.addItem(this.DSML_CLIENT_VALUES[this.ONLY_CERT]);
        }
        this._comboDSMLClientAuth.setSelectedItem(object);
    }

    private void hackToSelectCertificate() {
        try {
            Component[] componentArray = this._encrypt.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JPanel) {
                    this.hackPane((JPanel)componentArray[n]);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void hackPane(JPanel jPanel) {
        Component[] componentArray = jPanel.getComponents();
        JComboBox[] jComboBoxArray = new JComboBox[2];
        this.getComboBoxes(componentArray, jComboBoxArray);
        if (!jComboBoxArray[0].isEnabled() && jComboBoxArray[1].getItemCount() == 0) {
            jComboBoxArray[0].setSelectedItem(jComboBoxArray[0].getSelectedItem());
            if (jComboBoxArray[1].getSelectedItem() != null) {
                jComboBoxArray[1].setSelectedItem(jComboBoxArray[1].getSelectedItem());
            }
        }
    }

    private void getComboBoxes(Component[] componentArray, JComboBox[] jComboBoxArray) {
        int n = 0;
        while (n < componentArray.length && (jComboBoxArray[0] == null || jComboBoxArray[1] == null)) {
            if (componentArray[n] instanceof JComboBox) {
                if (jComboBoxArray[0] == null) {
                    jComboBoxArray[0] = (JComboBox)componentArray[n];
                } else {
                    jComboBoxArray[1] = (JComboBox)componentArray[n];
                }
            } else if (componentArray[n] instanceof Container) {
                this.getComboBoxes(((Container)componentArray[n]).getComponents(), jComboBoxArray);
            }
            ++n;
        }
    }
}

