/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigPanel;
import com.netscape.admin.dirserv.config.IDirtyValidListener;
import com.netscape.admin.dirserv.config.ToggleBorder;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public abstract class ConfigBasePanel
extends JPanel
implements IConfigPanel {
    protected boolean _isInitialized;
    protected String _helpToken;
    protected JPanel _innerPanel;
    protected DSFramework _framework;
    private String _title;
    private Vector _validDirtyListeners;
    protected static final ResourceSet _resource = DSConfigPage._resource;

    public ConfigBasePanel() {
        this.basicLayout();
        this._validDirtyListeners = new Vector();
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void addValidDirtyListener(IDirtyValidListener iDirtyValidListener) {
        this._validDirtyListeners.addElement(iDirtyValidListener);
    }

    public void removeValidDirtyListener(IDirtyValidListener iDirtyValidListener) {
        this._validDirtyListeners.remove(iDirtyValidListener);
    }

    public void setFramework(DSFramework dSFramework) {
        this._framework = dSFramework;
    }

    public DSFramework getFramework() {
        return this._framework;
    }

    public abstract void init();

    public abstract void resetCallback();

    public abstract void okCallback() throws ConfigPanelException;

    public abstract void cancelCallback();

    public boolean needsConfirmation() {
        return false;
    }

    public boolean askForConfirmation() {
        return false;
    }

    public boolean needsRestartServer() {
        return false;
    }

    public boolean hasWarningMessage() {
        return false;
    }

    public void displayWarningMessage() {
    }

    public void helpCallback() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getTitle() {
        return this._title;
    }

    protected void setValidFlag() {
        Enumeration enumeration = this._validDirtyListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDirtyValidListener iDirtyValidListener = (IDirtyValidListener)enumeration.nextElement();
            iDirtyValidListener.setValidFlag(this);
        }
    }

    protected void clearValidFlag() {
        Enumeration enumeration = this._validDirtyListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDirtyValidListener iDirtyValidListener = (IDirtyValidListener)enumeration.nextElement();
            iDirtyValidListener.clearValidFlag(this);
        }
    }

    protected void setDirtyFlag() {
        Enumeration enumeration = this._validDirtyListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDirtyValidListener iDirtyValidListener = (IDirtyValidListener)enumeration.nextElement();
            iDirtyValidListener.setDirtyFlag(this);
        }
    }

    protected void clearDirtyFlag() {
        Enumeration enumeration = this._validDirtyListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDirtyValidListener iDirtyValidListener = (IDirtyValidListener)enumeration.nextElement();
            iDirtyValidListener.clearDirtyFlag(this);
        }
    }

    protected String getValue(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        String string2 = (String)lDAPAttribute.getStringValues().nextElement();
        return string2;
    }

    protected void showComponent(JComponent jComponent, boolean bl) {
        if (!this._innerPanel.isAncestorOf(jComponent)) {
            this._innerPanel.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            if (bl) {
                gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
            } else {
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
            }
            this._innerPanel.add((Component)jComponent, gridBagConstraints);
            this.revalidate();
            this.repaint();
        }
    }

    protected ConsoleInfo getConsoleInfo() {
        return this._framework.getServerObject().getConsoleInfo();
    }

    protected ConsoleInfo getServerInfo() {
        return this._framework.getServerObject().getServerInfo();
    }

    protected void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        this._innerPanel = new JPanel(new GridBagLayout());
        this._innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this._innerPanel);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)jScrollPane, "Center");
    }

    public static void addComponentBorder(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jComponent2);
        CompoundBorder compoundBorder = new CompoundBorder(new ToggleBorder(jPanel, 1), new EmptyBorder(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        jComponent.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridwidth = 0;
        jComponent.add((Component)jPanel, gridBagConstraints);
    }
}

