/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.BackupTableCellRenderer;
import com.netscape.admin.dirserv.config.BackupTableModel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.Backup;
import com.netscape.admin.dirserv.task.ListDB;
import com.netscape.admin.dirserv.task.Restore;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ConfigBackupPanel
extends JPanel
implements ActionListener {
    private DSFramework _framework;
    private boolean _isReloading;
    private boolean _errorGettingBackupList;
    private Vector _names;
    private Vector _paths;
    private JPanel _innerPane;
    private JPanel _contentPane;
    private JPanel _errorPane;
    private JTable _table;
    private JButton _bHelp;
    private JButton _bRefresh;
    private JButton _bNewBackup;
    private JButton _bRestore;
    private String[] _backups;
    private final JLabel REFRESHING_LABEL = new JLabel(DSConfigPage._resource.getString("backuppanel-refresh", "label"));
    private final MultilineLabel RIGHTS_LABEL = new MultilineLabel(DSConfigPage._resource.getString("backuppanel-norights", "label"), 8, 50);
    private static final String HELP_TOKEN = "configuration-backup-help";
    private static final String[] TABLE_HEADERS = new String[]{DSConfigPage._resource.getString("backuppanel-table-name", "label"), DSConfigPage._resource.getString("backuppanel-table-path", "label")};
    static /* synthetic */ Class class$java$lang$String;

    public ConfigBackupPanel(DSFramework dSFramework) {
        this._framework = dSFramework;
        this.basicLayout();
        this.readAndUpdate();
    }

    public void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            this.showComponent(this.REFRESHING_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    if (ConfigBackupPanel.this._contentPane == null) {
                        ConfigBackupPanel.this.layoutContentPane();
                    }
                    if (ConfigBackupPanel.this._errorPane == null) {
                        ConfigBackupPanel.this.layoutErrorPane();
                    }
                    if (ConfigBackupPanel.this.hasRights()) {
                        int n;
                        ListDB listDB = new ListDB(ConfigBackupPanel.this._framework.getServerObject().getServerInfo());
                        ConfigBackupPanel.access$602(ConfigBackupPanel.this, listDB.getBackupList());
                        ConfigBackupPanel.this._errorGettingBackupList = listDB.getStatus() == -1;
                        ConfigBackupPanel.this._names.clear();
                        ConfigBackupPanel.this._paths.clear();
                        int n2 = 0;
                        while (n2 < ConfigBackupPanel.this._backups.length) {
                            n = ConfigBackupPanel.this._backups[n2].lastIndexOf(47);
                            ConfigBackupPanel.this._names.addElement(ConfigBackupPanel.this._backups[n2].substring(n + 1));
                            ConfigBackupPanel.this._paths.addElement(ConfigBackupPanel.this._backups[n2].substring(0, n));
                            ++n2;
                        }
                        n = ConfigBackupPanel.this._backups.length < 10 ? ConfigBackupPanel.this._table.getRowHeight() * 10 : ConfigBackupPanel.this._table.getRowHeight() * ConfigBackupPanel.this._backups.length;
                        int n3 = ConfigBackupPanel.this._table.getRowCount();
                        int n4 = 0;
                        int n5 = 0;
                        Enumeration<TableColumn> enumeration = ConfigBackupPanel.this._table.getColumnModel().getColumns();
                        while (enumeration.hasMoreElements()) {
                            TableColumn tableColumn = enumeration.nextElement();
                            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
                            n5 = component.getPreferredSize().width;
                            int n6 = 0;
                            while (n6 < n3) {
                                Object object = ConfigBackupPanel.this._table.getValueAt(n6, n4);
                                BackupTableCellRenderer backupTableCellRenderer = (BackupTableCellRenderer)ConfigBackupPanel.this._table.getCellRenderer(n6, n4);
                                Component component2 = backupTableCellRenderer.getTableCellRendererComponent(ConfigBackupPanel.this._table, object, false, false, n6, n4);
                                n5 = Math.max(n5, (int)component2.getPreferredSize().getWidth());
                                ++n6;
                            }
                            tableColumn.setPreferredWidth(n5);
                            ++n4;
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigBackupPanel.access$1200(1.access$1100(this.this$1));
                                if (!ConfigBackupPanel.access$700(1.access$1100(this.this$1))) {
                                    ConfigBackupPanel.access$1300(1.access$1100(this.this$1), ConfigBackupPanel.access$000(1.access$1100(this.this$1)), false);
                                } else {
                                    ConfigBackupPanel.access$1300(1.access$1100(this.this$1), ConfigBackupPanel.access$200(1.access$1100(this.this$1)), false);
                                }
                            }
                        });
                        ConfigBackupPanel.this._isReloading = false;
                    } else {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigBackupPanel.access$1300(1.access$1100(this.this$1), (JComponent)ConfigBackupPanel.access$1500(1.access$1100(this.this$1)), true);
                            }
                        });
                    }
                }

                static /* synthetic */ ConfigBackupPanel access$1100(1 var0) {
                    return var0.ConfigBackupPanel.this;
                }
            });
            thread.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bHelp) {
            DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
        } else if (object == this._bRefresh) {
            this.readAndUpdate();
        } else if (object == this._bNewBackup) {
            this.actionNewBackup();
        } else if (object == this._bRestore) {
            this.actionRestore();
        }
    }

    private void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.createButtonPanel();
        this.add((Component)jPanel, "South");
        this._innerPane = new JPanel(new GridBagLayout());
        this.add((Component)this._innerPane, "Center");
    }

    private void layoutContentPane() {
        this._contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        JLabel jLabel = new JLabel(DSConfigPage._resource.getString("backuppanel-list", "label"));
        this._names = new Vector();
        this._paths = new Vector();
        BackupTableModel backupTableModel = new BackupTableModel(TABLE_HEADERS, this._names, this._paths);
        this._table = new JTable(backupTableModel);
        jLabel.setLabelFor(this._table);
        this._table.setColumnSelectionAllowed(false);
        this._table.setSelectionMode(0);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ConfigBackupPanel.class$("java.lang.String")) : class$java$lang$String, new BackupTableCellRenderer());
        this._table.setShowGrid(true);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConfigBackupPanel.this.checkRestoreButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._table);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this._contentPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 0;
        this._contentPane.add((Component)jScrollPane, gridBagConstraints);
    }

    private void layoutErrorPane() {
        this._errorPane = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)new MultilineLabel(DSConfigPage._resource.getString("backuppanel", "errorgettingbackups-label"), 8, 50), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._errorPane.add((Component)jScrollPane, gridBagConstraints);
    }

    private JPanel createButtonPanel() {
        this._bHelp = UIFactory.makeJButton(this, "backuppanel", "help-button", DSConfigPage._resource);
        this._bRefresh = UIFactory.makeJButton(this, "backuppanel", "refresh-button", DSConfigPage._resource);
        this._bNewBackup = UIFactory.makeJButton(this, "backuppanel", "newbackup-button", DSConfigPage._resource);
        this._bRestore = UIFactory.makeJButton(this, "backuppanel", "restore-button", DSConfigPage._resource);
        JButton[] jButtonArray = new JButton[]{this._bRestore, this._bNewBackup, this._bRefresh};
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)UIFactory.makeJButtonPanel(jButtonArray, false), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bHelp, gridBagConstraints);
        return jPanel;
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        this._innerPane.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (bl) {
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._bHelp.setVisible(!bl);
        this._bRefresh.setVisible(!bl);
        this._bNewBackup.setVisible(!bl);
        this._bRestore.setVisible(!bl);
        this._innerPane.add((Component)jComponent, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void actionNewBackup() {
        Backup backup = new Backup();
        if (backup.run(this._framework.getSelectedPage())) {
            this.readAndUpdate();
        }
    }

    private void actionRestore() {
        int n = this._table.getSelectedRow();
        String string = this._backups[n];
        Restore restore = new Restore();
        if (restore.run(this._framework.getSelectedPage(), this._backups, string)) {
            this.readAndUpdate();
        }
    }

    private void checkRestoreButton() {
        int n = this._table.getSelectedRow();
        this._bRestore.setEnabled(n != -1);
    }

    private boolean hasRights() {
        DSAdmin dSAdmin = this._framework.getServerObject();
        boolean bl = dSAdmin.isTaskAvailable("ListBackups");
        return bl;
    }

    static /* synthetic */ String[] access$602(ConfigBackupPanel configBackupPanel, String[] stringArray) {
        configBackupPanel._backups = stringArray;
        return stringArray;
    }

    static /* synthetic */ boolean access$700(ConfigBackupPanel configBackupPanel) {
        return configBackupPanel._errorGettingBackupList;
    }

    static /* synthetic */ void access$1300(ConfigBackupPanel configBackupPanel, JComponent jComponent, boolean bl) {
        configBackupPanel.showComponent(jComponent, bl);
    }

    static /* synthetic */ MultilineLabel access$1500(ConfigBackupPanel configBackupPanel) {
        return configBackupPanel.RIGHTS_LABEL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

