/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigAccountLockoutPanel
extends ConfigBasePanel
implements ActionListener {
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private String _lastReadAttribute;
    private JPanel _contentPanel;
    private JCheckBox _cbLockout;
    private JLabel _lLockoutAfter;
    private JTextField _tfLockoutAfter;
    private JLabel _lLoginFailures;
    private JLabel _lResetAfter;
    private JTextField _tfResetAfter;
    private JLabel _lMinutes;
    private JRadioButton _rbLockoutForever;
    private JRadioButton _rbLockoutMinutes;
    private JTextField _tfLockoutMinutes;
    private JLabel _lLockoutMinutes;
    private boolean _saveLockout;
    private int _saveLockoutAfter;
    private int _saveResetAfter;
    private boolean _saveLockoutForever;
    private int _saveLockoutMinutes;
    private boolean _isLockoutDirty;
    private boolean[] _isLockoutAfterValidDirty = new boolean[2];
    private boolean[] _isResetAfterValidDirty = new boolean[2];
    private boolean _isLockoutForeverDirty;
    private boolean[] _isLockoutMinutesValidDirty = new boolean[2];
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("accountlockoutpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("accountlockoutpanel-no-rights", "label"), 2, 50);
    private static final int MIN_TO_SEC_FACTOR = 60;

    public ConfigAccountLockoutPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("accountlockoutpanel", "title"));
        this._helpToken = "configuration-data-accountlockout-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigAccountLockoutPanel.this.createContentPanel();
                        ConfigAccountLockoutPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigAccountLockoutPanel.access$300(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigAccountLockoutPanel.access$400(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigAccountLockoutPanel.access$500(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigAccountLockoutPanel.access$600(1.access$200(this.this$1))};
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("accountlockoutpanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("accountlockoutpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigAccountLockoutPanel.this._isInitialized = true;
                    ConfigAccountLockoutPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigAccountLockoutPanel access$200(1 var0) {
                    return var0.ConfigAccountLockoutPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAccountLockoutPanel.this.initComponentsFromServerValues();
                    ConfigAccountLockoutPanel.this.fireValidDirtyChange();
                    ConfigAccountLockoutPanel.this.showComponent(ConfigAccountLockoutPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAccountLockoutPanel.this.showComponent((JComponent)ConfigAccountLockoutPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigAccountLockoutPanel.this._lastReadAttribute};
                    ConfigAccountLockoutPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("accountlockoutpanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("accountlockoutpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAccountLockoutPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        String string;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isLockoutDirty) {
            string = this._cbLockout.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordLockout", string));
        }
        if (this._cbLockout.isSelected()) {
            int n;
            if (this._isLockoutAfterValidDirty[1]) {
                string = this._tfLockoutAfter.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("passwordMaxFailure", string));
            }
            if (this._isResetAfterValidDirty[1]) {
                n = 0;
                try {
                    n = Integer.parseInt(this._tfResetAfter.getText()) * 60;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                string = Integer.toString(n);
                lDAPModificationSet.add(2, new LDAPAttribute("passwordResetFailureCount", string));
            }
            if (this._isLockoutForeverDirty) {
                string = this._rbLockoutForever.isSelected() ? "off" : "on";
                lDAPModificationSet.add(2, new LDAPAttribute("passwordUnlock", string));
            }
            if (this._rbLockoutMinutes.isSelected() && this._isLockoutMinutesValidDirty[1]) {
                n = 0;
                try {
                    n = Integer.parseInt(this._tfLockoutMinutes.getText()) * 60;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                string = Integer.toString(n);
                lDAPModificationSet.add(2, new LDAPAttribute("passwordLockoutDuration", string));
            }
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify("cn=Password Policy, cn=config", lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("accountlockoutpanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("accountlockoutpanel", "updating-server-error-msg", stringArray));
            }
            this.resetCallback();
        }
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this._cbLockout)) {
            boolean bl = this._isLockoutDirty = this._saveLockout != this._cbLockout.isSelected();
            if (this._isLockoutDirty) {
                BlankPanel.setChangeState(this._cbLockout, 2);
            } else {
                BlankPanel.setChangeState(this._cbLockout, 1);
            }
            this.checkEnablingPanel();
            this.fireValidDirtyChange();
        } else if (object == this._rbLockoutForever || object == this._rbLockoutMinutes) {
            boolean bl = this._isLockoutForeverDirty = this._saveLockoutForever != this._rbLockoutForever.isSelected();
            if (this._isLockoutForeverDirty) {
                BlankPanel.setChangeState(this._rbLockoutForever, 2);
                BlankPanel.setChangeState(this._rbLockoutMinutes, 2);
            } else {
                BlankPanel.setChangeState(this._rbLockoutForever, 1);
                BlankPanel.setChangeState(this._rbLockoutMinutes, 1);
            }
            this._tfLockoutMinutes.setEnabled(!this._rbLockoutForever.isSelected());
            this._lLockoutMinutes.setEnabled(!this._rbLockoutForever.isSelected());
            this.fireValidDirtyChange();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbLockout = UIFactory.makeJCheckBox(this, "accountlockoutpanel", "cblockout", false, ConfigBasePanel._resource);
        this._lLockoutAfter = UIFactory.makeJLabel("accountlockoutpanel", "llockoutafter", ConfigBasePanel._resource);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigAccountLockoutPanel.this._isInitializingComponents) {
                    ConfigAccountLockoutPanel.this.checkField(ConfigAccountLockoutPanel.this._lLockoutAfter, ConfigAccountLockoutPanel.this._tfLockoutAfter.getText(), ConfigAccountLockoutPanel.this._saveLockoutAfter, ConfigAccountLockoutPanel.this._isLockoutAfterValidDirty, 1, Short.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfLockoutAfter = UIFactory.makeJTextField(documentListener, "accountlockoutpanel", "llockoutafter", null, 5, ConfigBasePanel._resource);
        this._lLoginFailures = UIFactory.makeJLabel("accountlockoutpanel", "lloginfailures", ConfigBasePanel._resource);
        this._lLockoutAfter.setLabelFor(this._tfLockoutAfter);
        this._lLoginFailures.setLabelFor(this._tfLockoutAfter);
        this._lResetAfter = UIFactory.makeJLabel("accountlockoutpanel", "lresetafter", ConfigBasePanel._resource);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigAccountLockoutPanel.this._isInitializingComponents) {
                    ConfigAccountLockoutPanel.this.checkField(ConfigAccountLockoutPanel.this._lResetAfter, ConfigAccountLockoutPanel.this._tfResetAfter.getText(), ConfigAccountLockoutPanel.this._saveResetAfter, ConfigAccountLockoutPanel.this._isResetAfterValidDirty, 1, 0x2222222);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfResetAfter = UIFactory.makeJTextField(documentListener2, "accountlockoutpanel", "lresetafter", null, 8, ConfigBasePanel._resource);
        this._lMinutes = UIFactory.makeJLabel("accountlockoutpanel", "lminutes", ConfigBasePanel._resource);
        this._lResetAfter.setLabelFor(this._tfResetAfter);
        this._lMinutes.setLabelFor(this._tfResetAfter);
        this._rbLockoutForever = UIFactory.makeJRadioButton(this, "accountlockoutpanel", "rblockoutforever", false, ConfigBasePanel._resource);
        this._rbLockoutMinutes = UIFactory.makeJRadioButton(this, "accountlockoutpanel", "rblockoutminutes", false, ConfigBasePanel._resource);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbLockoutForever);
        buttonGroup.add(this._rbLockoutMinutes);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigAccountLockoutPanel.this._isInitializingComponents) {
                    ConfigAccountLockoutPanel.this.checkField(ConfigAccountLockoutPanel.this._lLockoutMinutes, ConfigAccountLockoutPanel.this._tfLockoutMinutes.getText(), ConfigAccountLockoutPanel.this._saveLockoutMinutes, ConfigAccountLockoutPanel.this._isLockoutMinutesValidDirty, 1, 0x2222222);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfLockoutMinutes = UIFactory.makeJTextField(documentListener3, "accountlockoutpanel", "llockoutminutes", null, 8, ConfigBasePanel._resource);
        this._lLockoutMinutes = UIFactory.makeJLabel("accountlockoutpanel", "llockoutminutes", ConfigBasePanel._resource);
        this._lLockoutMinutes.setLabelFor(this._tfLockoutMinutes);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel, this._cbLockout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace() - 4, UIFactory.getComponentSpace() + 2, 0, UIFactory.getComponentSpace() + 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace() - 2, UIFactory.getComponentSpace() - 2, UIFactory.getComponentSpace(), 0);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this._lLockoutAfter, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this._tfLockoutAfter, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel.add((Component)this._lLoginFailures, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this._lResetAfter, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this._tfResetAfter, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel.add((Component)this._lMinutes, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)this._rbLockoutForever, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this._rbLockoutMinutes);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel2.add(this._tfLockoutMinutes);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel2.add(this._lLockoutMinutes);
        gridBagConstraints.insets.bottom -= 4;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NullPointerException, NumberFormatException {
        String[] stringArray = new String[]{"passwordLockout", "passwordMaxFailure", "passwordResetFailureCount", "passwordUnlock", "passwordLockoutDuration"};
        LDAPEntry lDAPEntry = this.getServerInfo().getLDAPConnection().read("cn=Password Policy, cn=config", stringArray);
        this._saveLockout = this.getValue(lDAPEntry, "passwordLockout").equalsIgnoreCase("on");
        this._lastReadAttribute = "passwordMaxFailure";
        this._saveLockoutAfter = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "passwordResetFailureCount";
        this._saveResetAfter = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim()) / 60;
        this._saveLockoutForever = this.getValue(lDAPEntry, "passwordUnlock").equalsIgnoreCase("off");
        this._lastReadAttribute = "passwordLockoutDuration";
        this._saveLockoutMinutes = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim()) / 60;
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._cbLockout.setSelected(this._saveLockout);
        BlankPanel.setChangeState(this._cbLockout, 1);
        this._isLockoutDirty = false;
        this._tfLockoutAfter.setText(Integer.toString(this._saveLockoutAfter));
        BlankPanel.setChangeState(this._lLockoutAfter, 1);
        this._isLockoutAfterValidDirty[0] = true;
        this._isLockoutAfterValidDirty[1] = false;
        this._tfResetAfter.setText(Integer.toString(this._saveResetAfter));
        BlankPanel.setChangeState(this._lResetAfter, 1);
        this._isResetAfterValidDirty[0] = true;
        this._isResetAfterValidDirty[1] = false;
        this._rbLockoutForever.setSelected(this._saveLockoutForever);
        this._rbLockoutMinutes.setSelected(!this._saveLockoutForever);
        BlankPanel.setChangeState(this._rbLockoutForever, 1);
        BlankPanel.setChangeState(this._rbLockoutMinutes, 1);
        this._isLockoutForeverDirty = false;
        this._tfLockoutMinutes.setText(Integer.toString(this._saveLockoutMinutes));
        BlankPanel.setChangeState(this._lLockoutMinutes, 1);
        this._isLockoutMinutesValidDirty[0] = true;
        this._isLockoutMinutesValidDirty[1] = false;
        this.checkEnablingPanel();
        this._isInitializingComponents = false;
    }

    private void checkField(JLabel jLabel, String string, int n, boolean[] blArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n4 = Integer.parseInt(string);
            bl2 = n4 != n;
            bl = n4 >= n2 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            bl2 = true;
        }
        if (!bl) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (bl2) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        blArray[0] = bl;
        blArray[1] = bl2;
        this.fireValidDirtyChange();
    }

    private void checkEnablingPanel() {
        boolean bl = this._cbLockout.isSelected();
        this._lLockoutAfter.setEnabled(bl);
        this._tfLockoutAfter.setEnabled(bl);
        this._lLoginFailures.setEnabled(bl);
        this._lResetAfter.setEnabled(bl);
        this._tfResetAfter.setEnabled(bl);
        this._lMinutes.setEnabled(bl);
        this._rbLockoutForever.setEnabled(bl);
        this._rbLockoutMinutes.setEnabled(bl);
        this._tfLockoutMinutes.setEnabled(bl && this._rbLockoutMinutes.isSelected());
        this._lLockoutMinutes.setEnabled(bl && this._rbLockoutMinutes.isSelected());
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !this._cbLockout.isSelected() || this._isLockoutAfterValidDirty[0] && this._isResetAfterValidDirty[0] && (this._rbLockoutForever.isSelected() || this._isLockoutMinutesValidDirty[0]);
        boolean bl3 = bl = this._isLockoutDirty || this._cbLockout.isSelected() && (this._isLockoutAfterValidDirty[1] || this._isResetAfterValidDirty[1] || this._isLockoutForeverDirty || this._rbLockoutForever.isSelected() && this._isLockoutMinutesValidDirty[1]);
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

