/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.browser.NotSupportedSuffixTypeException;
import com.netscape.admin.dirserv.browser.SuffixNotFoundException;
import com.netscape.admin.dirserv.browser.VLVIndexHelper;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

class VLVIndexDeleter
implements Runnable {
    private boolean _deleteDone;
    private GenericProgressDialog _dlg;
    private String _vlvIndexDn;
    private DSFramework _framework;
    private static ResourceSet _resource = DSUtil._resource;

    public VLVIndexDeleter(String string, DSFramework dSFramework) {
        boolean bl = false;
        if (DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_INDEX)) {
            int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-delete-index", (String[])null, "vlvindexhelper", _resource);
            boolean bl2 = bl = n != 0;
        }
        if (!bl) {
            this._framework = dSFramework;
            this.createVlvIndexDn(string);
            if (this._vlvIndexDn != null) {
                this.createProgressDialog();
                Thread thread = new Thread(this);
                thread.start();
                this._dlg.packAndShow();
            }
        }
    }

    public boolean deleteDone() {
        return this._deleteDone;
    }

    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String[] stringArray;
            String[] stringArray2 = new String[]{"dn"};
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this._vlvIndexDn, 1, "objectClass=vlvindex", stringArray2, false);
            while (lDAPSearchResults.hasMoreElements()) {
                stringArray = lDAPSearchResults.next().getDN();
                String[] stringArray3 = new String[]{DSUtil.abreviateString((String)stringArray, 40)};
                this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "deleting-label", stringArray3));
                lDAPConnection.delete((String)stringArray);
            }
            stringArray = new String[]{DSUtil.abreviateString(this._vlvIndexDn, 40)};
            this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "deleting-label", stringArray));
            lDAPConnection.delete(this._vlvIndexDn);
            this._deleteDone = true;
            this._dlg.closeCallBack();
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        VLVIndexDeleter.this._dlg.closeCallBack();
                        DSUtil.showErrorDialog((Component)((Object)VLVIndexDeleter.this._framework), "error-deleting-title", "error-deleting-msg", stringArray, "vlvindexhelper", _resource);
                    }
                });
            }
            this._deleteDone = true;
            this._dlg.closeCallBack();
        }
    }

    private void createVlvIndexDn(String string) {
        try {
            DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
            Database database = VLVIndexHelper.getDatabaseForEntry(string, databaseConfig);
            this._vlvIndexDn = "cn=" + VLVIndexHelper.getVlvIndexCnForEntry(string) + ", " + database.getDn();
        }
        catch (SuffixNotFoundException suffixNotFoundException) {
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-suffixnotfound-title", "error-suffixnotfound-msg", stringArray, "vlvindexhelper", _resource);
        }
        catch (NotSupportedSuffixTypeException notSupportedSuffixTypeException) {
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-suffixnotsupportedforvlv-title", "error-suffixnotsupportedforvlv-msg", stringArray, "vlvindexhelper", _resource);
        }
    }

    private void createProgressDialog() {
        String string = _resource.getString("vlvindexhelper", "deleteindex-title");
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, string, null, null);
        this._dlg.setLabelRows(1);
    }
}

