/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.NotSupportedSuffixTypeException;
import com.netscape.admin.dirserv.browser.SuffixNotFoundException;
import com.netscape.admin.dirserv.browser.VLVIndexHelper;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class VLVIndexCreator
implements Runnable,
ActionListener {
    private boolean _creationDone;
    private GenericProgressDialog _dlg;
    private String _vlvIndexDn;
    private String _dn;
    private Database _db;
    private boolean _taskCancelled;
    private String _taskDn;
    private String _nsIndexVlvAttribute;
    private DSFramework _framework;
    private static ResourceSet _resource = DSUtil._resource;

    public VLVIndexCreator(String string, DSFramework dSFramework) {
        this._framework = dSFramework;
        this.createVlvIndexDnAndDb(string);
        if (this._vlvIndexDn != null) {
            this._dn = string;
            this.createProgressDialog();
            Thread thread = new Thread(this);
            thread.start();
            this._dlg.packAndShow();
        }
    }

    public boolean creationDone() {
        return this._creationDone;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "vlvindexhelper", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.addEntries();
        }
        catch (LDAPException lDAPException) {
            bl = true;
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VLVIndexCreator.this._dlg.closeCallBack();
                    DSUtil.showErrorDialog((Component)((Object)VLVIndexCreator.this._framework), "error-adding-title", "error-adding-msg", stringArray, "vlvindexhelper", _resource);
                }
            });
        }
        if (!bl) {
            this._dlg.stepCompleted(0);
            try {
                this.initTask();
            }
            catch (LDAPException lDAPException) {
                bl = true;
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)VLVIndexCreator.this._framework), "error-launching-title", "error-launching-msg", stringArray, "vlvindexhelper", _resource);
                    }
                });
            }
            if (!bl) {
                try {
                    this.updateProgressDialog();
                }
                catch (LDAPException lDAPException) {
                    stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DSUtil.showErrorDialog((Component)((Object)VLVIndexCreator.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "vlvindexhelper", _resource);
                        }
                    });
                }
                this._dlg.waitForClose();
            } else {
                this._dlg.closeCallBack();
            }
        }
    }

    private void addEntries() throws LDAPException {
        block6: {
            String[] stringArray;
            LDAPConnection lDAPConnection;
            LDAPEntry lDAPEntry;
            String string;
            block5: {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass");
                lDAPAttribute.addValue("top");
                lDAPAttribute.addValue("vlvSearch");
                lDAPAttributeSet.add(lDAPAttribute);
                lDAPAttribute = new LDAPAttribute("vlvbase", this._dn);
                lDAPAttributeSet.add(lDAPAttribute);
                lDAPAttribute = new LDAPAttribute("vlvscope", "1");
                lDAPAttributeSet.add(lDAPAttribute);
                lDAPAttribute = new LDAPAttribute("vlvfilter", "(|(objectclass=*)(objectclass=ldapsubentry))");
                lDAPAttributeSet.add(lDAPAttribute);
                LDAPEntry lDAPEntry2 = new LDAPEntry(this._vlvIndexDn, lDAPAttributeSet);
                LDAPAttributeSet lDAPAttributeSet2 = new LDAPAttributeSet();
                lDAPAttribute = new LDAPAttribute("objectclass");
                lDAPAttribute.addValue("top");
                lDAPAttribute.addValue("vlvIndex");
                lDAPAttributeSet2.add(lDAPAttribute);
                String string2 = BrowserController.SORT_ATTRIBUTES[0];
                int n = 1;
                while (n < BrowserController.SORT_ATTRIBUTES.length) {
                    string2 = string2 + " " + BrowserController.SORT_ATTRIBUTES[n];
                    ++n;
                }
                lDAPAttribute = new LDAPAttribute("vlvsort", string2);
                lDAPAttributeSet2.add(lDAPAttribute);
                this._nsIndexVlvAttribute = "by " + VLVIndexHelper.getVlvIndexCnForEntry(this._dn);
                string = "cn=" + this._nsIndexVlvAttribute + " ," + this._vlvIndexDn;
                lDAPEntry = new LDAPEntry(string, lDAPAttributeSet2);
                lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                try {
                    stringArray = new String[]{DSUtil.abreviateString(this._vlvIndexDn, 30)};
                    this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "adding-label", stringArray));
                    lDAPConnection.add(lDAPEntry2);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 68) break block5;
                    throw lDAPException;
                }
            }
            try {
                stringArray = new String[]{DSUtil.abreviateString(string, 30)};
                this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "adding-label", stringArray));
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 68) break block6;
                throw lDAPException;
            }
        }
    }

    private void createVlvIndexDnAndDb(String string) {
        try {
            DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
            this._db = VLVIndexHelper.getDatabaseForEntry(string, databaseConfig);
            this._vlvIndexDn = "cn=" + VLVIndexHelper.getVlvIndexCnForEntry(string) + ", " + this._db.getDn();
        }
        catch (SuffixNotFoundException suffixNotFoundException) {
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-suffixnotfound-title", "error-suffixnotfound-msg", stringArray, "vlvindexhelper", _resource);
        }
        catch (NotSupportedSuffixTypeException notSupportedSuffixTypeException) {
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-suffixnotsupportedforvlv-title", "error-suffixnotsupportedforvlv-msg", stringArray, "vlvindexhelper", _resource);
        }
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("vlvindexhelper", "createdialog-title"), null, this);
        this._dlg.setLabelRows(1);
        this._dlg.disableCancelButton();
        this._dlg.addStep(_resource.getString("vlvindexhelper", "firststep-label"));
        this._dlg.addStep(_resource.getString("vlvindexhelper", "secondstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("vlvindexhelper", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException {
        this._taskCancelled = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsIndexVLVAttribute", this._nsIndexVlvAttribute));
        lDAPAttributeSet.add(new LDAPAttribute("nsInstance", this._db.getName()));
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=index" + System.currentTimeMillis() + ", cn=index, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        while (!bl && !this._taskCancelled) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] stringArray;
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                String string = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                int n = string.lastIndexOf("Indexing VLV:");
                if (n >= 0) {
                    stringArray = new String[]{DSUtil.abreviateString(string.substring(n + 14), 40)};
                    String string2 = _resource.getString("vlvindexhelper", "create-progress-label", stringArray);
                    this._dlg.setTextInLabel(string2);
                }
                this._dlg.setTextInTextArea(string);
                stringArray = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (stringArray.equals("")) continue;
                bl = true;
                if (stringArray.equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "successful-label"));
                    this._creationDone = true;
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "unsuccessful-label"));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                this._dlg.setTextInLabel(_resource.getString("vlvindexhelper", "successful-label"));
                this._creationDone = true;
            }
        }
        this._dlg.stepCompleted(1);
    }
}

