/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSContentPage;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class SubtreeSelectionDialog
extends AbstractDialog
implements TreeSelectionListener,
DocumentListener {
    private DSFramework _framework;
    private JTree _tree = null;
    private BrowserController _controller;
    private boolean _isOk = false;
    private JLabel _selectedDnLabel;
    private JTextField _tfDn;
    private String _dnString;
    private boolean _displaySuffixes;
    private boolean _displaySelectionField = false;
    static final String NO_SELECTED_DN = "  ";
    Preferences _preferences = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0").getPreferences("DS_MISCELLANEOUS");
    private static final String _helpToken = "subtree-selection-dbox-help";
    private static final String _section = "general";
    private static ResourceSet _resource = DSUtil._resource;

    public SubtreeSelectionDialog(DSFramework dSFramework) {
        this(dSFramework, true);
    }

    public SubtreeSelectionDialog(DSFramework dSFramework, boolean bl) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        String string = this._framework.getServerObject().getServerInfo().getHost() + ":" + this._framework.getServerObject().getServerInfo().getPort();
        ((Dialog)((Object)this)).setTitle(_resource.getString("browser", "title") + " [" + string + "]");
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("browser", "description"));
        ((Component)((Object)this)).setSize(350, 300);
        this._displaySuffixes = bl;
        this.setComponent(this.createTreePanel());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo == null) {
            this._selectedDnLabel.setText(NO_SELECTED_DN);
            this._tfDn.setText(NO_SELECTED_DN);
        } else {
            String string = null;
            LDAPUrl lDAPUrl = iBrowserNodeInfo.getURL();
            if (lDAPUrl != null) {
                string = lDAPUrl.getDN();
            }
            if (string == null || string.equals("")) {
                this._selectedDnLabel.setText(NO_SELECTED_DN);
                this._tfDn.setText(NO_SELECTED_DN);
            } else {
                this._selectedDnLabel.setText(DSContentPage.findDisplayNameFromNode(iBrowserNodeInfo));
                this._tfDn.setText(DSContentPage.findDisplayNameFromNode(iBrowserNodeInfo));
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._displaySelectionField) {
            boolean bl = DN.isDN((String)this._tfDn.getText());
            this.setOKButtonEnabled(bl);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public boolean isOk() {
        return this._isOk;
    }

    public String getDN() {
        return this._dnString;
    }

    public void addSuffix(String string) {
        this._controller.addSuffix(string, null);
    }

    public void setShowContainerOnly(boolean bl) {
        this._controller.setShowContainerOnly(bl);
    }

    protected void okInvoked() {
        String string = !this._displaySelectionField ? this._selectedDnLabel.getText() : this._tfDn.getText();
        this._dnString = string.equals(NO_SELECTED_DN) ? "" : string;
        this._isOk = true;
        super.okInvoked();
    }

    protected void cancelInvoked() {
        this._isOk = false;
        super.cancelInvoked();
    }

    protected void helpInvoked() {
        DSUtil.help(_helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private JComponent createTreePanel() {
        this._tree = new JTree();
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        JLabel jLabel = UIFactory.makeJLabel("browser", "linstructions", _resource);
        JLabel jLabel2 = UIFactory.makeJLabel("browser", "lselecteddn", _resource);
        this._selectedDnLabel = new JLabel(NO_SELECTED_DN);
        this._selectedDnLabel.setLabelFor(this._tree);
        this._tfDn = UIFactory.makeJTextField(this, "browser", "lselecteddn", NO_SELECTED_DN, 30, _resource);
        jLabel2.setLabelFor(this._tfDn);
        this._controller = new BrowserController(this._tree, this._framework.getServerObject().getConnectionPool(), this._framework.getServerObject().getIconPool());
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        this._controller.setNumSubordinateHacker(databaseConfig.getNumSubordinateHacker());
        this._controller.setContainerClasses(DSContentPage.CONTAINER_OBJECTCLASSES);
        this._controller.setShowContainerOnly(true);
        this._controller.setLDAPConnection(lDAPConnection);
        boolean bl = this._preferences.getBoolean("SORT_PREFERENCES", false);
        boolean bl2 = this._preferences.getBoolean("FOLLOW_REFERRALS_PREFERENCES", true);
        int n = this._preferences.getInt("DISPLAY_PREFERENCES", 1);
        String string = this._preferences.getString("DISPLAY_ATTRIBUTE", "rdn attribute");
        this._controller.setSorted(bl);
        this._controller.setFollowReferrals(bl2);
        this._controller.setDisplayFlags(n);
        this._controller.setDisplayAttribute(string);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._tree);
        jScrollPane.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jLabel.setLabelFor(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)this._selectedDnLabel, gridBagConstraints);
        jPanel.add((Component)this._tfDn, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        this._selectedDnLabel.setVisible(!this._displaySelectionField);
        this._tfDn.setVisible(this._displaySelectionField);
        if (this._displaySuffixes) {
            Object object;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = databaseConfig.getSuffixes().elements();
            while (enumeration.hasMoreElements()) {
                object = (Suffix)enumeration.nextElement();
                if (((Suffix)object).getParentSuffix() != null || !((Suffix)object).hasRootEntry()) continue;
                vector.addElement(((Suffix)object).getName());
            }
            if (vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this._controller.addSuffix((String)object.nextElement(), null);
                }
            }
        }
        return jPanel;
    }

    public void packAndShow() {
        this.pack();
        super.show();
    }

    public void displaySelectionField(boolean bl) {
        this._displaySelectionField = bl;
        this._selectedDnLabel.setVisible(!this._displaySelectionField);
        this._tfDn.setVisible(this._displaySelectionField);
    }

    protected IBrowserNodeInfo getSelectedNodeInfo() {
        IBrowserNodeInfo iBrowserNodeInfo = null;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null) {
            iBrowserNodeInfo = this._controller.getNodeInfoFromPath(treePath);
        }
        return iBrowserNodeInfo;
    }
}

