/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.AuthRecord;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.ServerDialog;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class ReferralAuthenticationDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private LDAPConnectionPool _connectionPool;
    private JTable _tServer;
    private JScrollPane _scroll;
    private ReferralAuthenticationModel _modelServer;
    private JButton _bAddServer;
    private JButton _bEditServer;
    private JButton _bDeleteServer;
    private JFrame _frame;
    private Hashtable _htUserData;
    private Hashtable _htSavedData;
    private String _helpToken = "referralauthentication-dbox-help";
    private String[] HEADERS = new String[]{_resource.getString("referralauthenticationdialog", "header0"), _resource.getString("referralauthenticationdialog", "header1")};
    private static final ResourceSet _resource = DSUtil._resource;
    static /* synthetic */ Class class$java$lang$String;

    public ReferralAuthenticationDialog(JFrame jFrame, LDAPConnectionPool lDAPConnectionPool) {
        super((Frame)jFrame, _resource.getString("referralauthenticationdialog", "title"), true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("referralauthenticationdialog", "description"));
        this._frame = jFrame;
        this._connectionPool = lDAPConnectionPool;
        this.layoutContentPane();
        this.initData(this._connectionPool);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bAddServer) {
            this.actionAddServer();
        } else if (object == this._bEditServer) {
            this.actionEditServer();
        } else if (object == this._bDeleteServer) {
            this.actionDeleteServer();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._tServer.getSelectionModel()) {
            int n = this._tServer.getSelectionModel().getMinSelectionIndex();
            int n2 = this._tServer.getSelectionModel().getMaxSelectionIndex();
            int n3 = n == -1 ? 0 : n2 - n + 1;
            this._bEditServer.setEnabled(n3 == 1);
            this._bDeleteServer.setEnabled(n3 > 0);
        }
    }

    public void pack() {
        int n = 0;
        TableColumnModel tableColumnModel = this._tServer.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, this.HEADERS[0], false, false, 0, 0);
            TableCellRenderer tableCellRenderer = this._tServer.getCellRenderer(0, n2);
            int n3 = (int)component.getPreferredSize().getWidth();
            int n4 = 0;
            if (n2 == 0) {
                Component component2 = tableCellRenderer.getTableCellRendererComponent(this._tServer, "myhostname.domain.com:389", true, true, 0, 0);
                n4 = (int)component2.getPreferredSize().getWidth();
            } else if (n2 == 1) {
                Component component3 = tableCellRenderer.getTableCellRendererComponent(this._tServer, "cn=bindname, dc=domain, dc=com", true, true, 0, 1);
                n4 = (int)component3.getPreferredSize().getWidth();
            }
            int n5 = Math.max(n3, n4);
            int n6 = 0;
            while (n6 < this._tServer.getRowCount()) {
                Component component4 = tableCellRenderer.getTableCellRendererComponent(this._tServer, this._tServer.getValueAt(n6, n2), true, true, n6, n2);
                int n7 = (int)component4.getPreferredSize().getWidth();
                n5 = Math.max(n5, n7);
                ++n6;
            }
            tableColumn.setPreferredWidth(n5 += this._tServer.getIntercellSpacing().width);
            n += n5;
            ++n2;
        }
        this._tServer.setPreferredScrollableViewportSize(new Dimension(n, this._tServer.getRowHeight() * 10));
        super.pack();
        int n8 = (int)this._scroll.getPreferredSize().getWidth();
        if (n > n8) {
            this._tServer.setAutoResizeMode(0);
        } else {
            this._tServer.setAutoResizeMode(3);
        }
    }

    protected void okInvoked() {
        AuthRecord authRecord;
        AuthRecord authRecord2;
        String string;
        Object object;
        Enumeration enumeration = this._htUserData.keys();
        LDAPException lDAPException = null;
        String string2 = null;
        while (enumeration.hasMoreElements() && lDAPException == null) {
            object = enumeration.nextElement();
            string = (String)object;
            authRecord2 = (AuthRecord)this._htUserData.get(object);
            authRecord = (AuthRecord)this._htSavedData.get(object);
            boolean bl = false;
            if (authRecord == null) {
                bl = true;
            } else if (!DSUtil.equalDNs(authRecord2.dn, authRecord.dn)) {
                bl = true;
            } else if (!authRecord2.password.equals(authRecord.password)) {
                bl = true;
            }
            if (!bl) continue;
            try {
                this._connectionPool.registerAuth(authRecord2.ldapUrl, authRecord2.dn, authRecord2.password, true);
            }
            catch (LDAPException lDAPException2) {
                string2 = string;
                lDAPException = lDAPException2;
            }
        }
        enumeration = this._htSavedData.keys();
        while (enumeration.hasMoreElements() && lDAPException == null) {
            object = enumeration.nextElement();
            string = (String)object;
            authRecord2 = (AuthRecord)this._htUserData.get(object);
            if (authRecord2 != null) continue;
            authRecord = (AuthRecord)this._htSavedData.get(object);
            try {
                this._connectionPool.unRegisterAuth(authRecord.ldapUrl);
            }
            catch (LDAPException lDAPException3) {
                lDAPException = lDAPException3;
            }
        }
        if (lDAPException != null) {
            object = new String[]{string2, DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog(this._frame, "error-connecting-title", "error-connecting-msg", object, "referralauthenticationdialog", _resource);
        } else {
            super.okInvoked();
        }
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, ((DSFramework)((Object)this._frame)).getServerObject().getServerInfo().getAdminURL());
    }

    private void layoutContentPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        MultilineLabel multilineLabel = new MultilineLabel(_resource.getString("referralauthenticationdialog", "linformation-label"));
        multilineLabel.setLabelFor((Component)jPanel);
        this._modelServer = new ReferralAuthenticationModel();
        this._tServer = new JTable(this._modelServer);
        this._tServer.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = ReferralAuthenticationDialog.this._tServer.getSelectedRow()) >= 0) {
                    ReferralAuthenticationDialog.this.actionEditServer();
                }
            }
        });
        this._tServer.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ReferralAuthenticationDialog.class$("java.lang.String")) : class$java$lang$String, new LabelCellRenderer());
        this._tServer.getSelectionModel().addListSelectionListener(this);
        this._scroll = new JScrollPane(this._tServer);
        this._scroll.setBorder(UITools.createLoweredBorder());
        this._bAddServer = UIFactory.makeJButton(this, "referralauthenticationdialog", "baddserver", _resource);
        this._bEditServer = UIFactory.makeJButton(this, "referralauthenticationdialog", "beditserver", _resource);
        this._bDeleteServer = UIFactory.makeJButton(this, "referralauthenticationdialog", "bdeleteserver", _resource);
        JLabel jLabel = new JLabel((Icon)DSUtil.getPackageImage("failed.gif"));
        jLabel.setLabelFor(jPanel);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jLabel.setText(_resource.getString("referralauthenticationdialog", "lwarning-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)multilineLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this._scroll, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._bAddServer, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._bEditServer, gridBagConstraints);
        jPanel2.add((Component)this._bDeleteServer, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._bEditServer.setEnabled(false);
        this._bDeleteServer.setEnabled(false);
        this.setComponent(jPanel);
    }

    private void initData(LDAPConnectionPool lDAPConnectionPool) {
        this._modelServer.clear();
        if (this._htUserData == null) {
            this._htUserData = new Hashtable();
            this._htSavedData = new Hashtable();
        } else {
            this._htUserData.clear();
            this._htSavedData.clear();
        }
        Collection collection = lDAPConnectionPool.getRegisteredAuthentication();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            AuthRecord authRecord = (AuthRecord)iterator.next();
            LDAPConnection lDAPConnection = ((DSFramework)((Object)this._frame)).getServerObject().getServerInfo().getLDAPConnection();
            boolean bl2 = bl = lDAPConnection.getHost().equals(authRecord.ldapUrl.getHost()) && lDAPConnection.getPort() == authRecord.ldapUrl.getPort();
            if (bl) continue;
            String string = this.getDisplayName(authRecord.ldapUrl.getHost(), authRecord.ldapUrl.getPort(), authRecord.ldapUrl.isSecure());
            this._modelServer.addServer(string);
            this._htUserData.put(string, authRecord);
            AuthRecord authRecord2 = new AuthRecord();
            authRecord2.ldapUrl = authRecord.ldapUrl;
            authRecord2.dn = authRecord.dn;
            authRecord2.password = authRecord.password;
            this._htSavedData.put(string, authRecord2);
        }
    }

    private void checkOkButton() {
        boolean bl = true;
        Collection collection = this._htUserData.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && bl) {
            AuthRecord authRecord = (AuthRecord)iterator.next();
            if (!authRecord.dn.equals("")) {
                bl = DN.isDN((String)authRecord.dn);
                if (!bl) continue;
                bl = authRecord.password.length() > 0;
                continue;
            }
            bl = false;
        }
        this.setOKButtonEnabled(bl);
    }

    private String getDisplayName(String string, int n, boolean bl) {
        String[] stringArray = new String[]{string, String.valueOf(n)};
        String string2 = bl ? _resource.getString("referralauthenticationdialog", "securehost-label", stringArray) : _resource.getString("referralauthenticationdialog", "nonsecurehost-label", stringArray);
        return string2;
    }

    private void actionAddServer() {
        ServerDialog serverDialog = new ServerDialog(this._frame);
        serverDialog.pack();
        serverDialog.show();
        if (!serverDialog.isCancelled()) {
            AuthRecord authRecord = new AuthRecord();
            authRecord.ldapUrl = LDAPConnectionPool.makeLDAPUrl(serverDialog.getHost(), serverDialog.getPort(), "", serverDialog.isSSL());
            authRecord.dn = serverDialog.getDn();
            authRecord.password = serverDialog.getPassword();
            String string = this.getDisplayName(serverDialog.getHost(), serverDialog.getPort(), serverDialog.isSSL());
            this._htUserData.put(string, authRecord);
            this._modelServer.addServer(string);
        }
    }

    public void actionEditServer() {
        int n = this._tServer.getSelectedRow();
        if (n >= 0) {
            Object object = this._tServer.getValueAt(n, 0);
            AuthRecord authRecord = (AuthRecord)this._htUserData.get(object);
            LDAPUrl lDAPUrl = authRecord.ldapUrl;
            ServerDialog serverDialog = new ServerDialog(this._frame);
            serverDialog.setHost(lDAPUrl.getHost());
            serverDialog.setPort(lDAPUrl.getPort());
            serverDialog.setSSL(lDAPUrl.isSecure());
            serverDialog.setDn(authRecord.dn);
            serverDialog.setPassword(authRecord.password);
            serverDialog.pack();
            serverDialog.show();
            if (!serverDialog.isCancelled()) {
                AuthRecord authRecord2 = new AuthRecord();
                authRecord2.ldapUrl = LDAPConnectionPool.makeLDAPUrl(serverDialog.getHost(), serverDialog.getPort(), "", serverDialog.isSSL());
                authRecord2.dn = serverDialog.getDn();
                authRecord2.password = serverDialog.getPassword();
                String string = this.getDisplayName(serverDialog.getHost(), serverDialog.getPort(), serverDialog.isSSL());
                this._htUserData.remove(object);
                this._htUserData.put(string, authRecord2);
                this._modelServer.modifyServer(object, string);
            }
        }
    }

    public void actionDeleteServer() {
        int[] nArray = this._tServer.getSelectedRows();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                Object object = this._tServer.getValueAt(nArray[n], 0);
                this._modelServer.deleteServer(object);
                this._htUserData.remove(object);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ReferralAuthenticationModel
    extends AbstractTableModel {
        ArrayList _servers = new ArrayList();
        static /* synthetic */ Class class$java$lang$String;

        ReferralAuthenticationModel() {
        }

        public void addServer(Object object) {
            this._servers.add(object);
            this.fireTableDataChanged();
        }

        public void deleteServer(Object object) {
            ((AbstractCollection)this._servers).remove(object);
            this.fireTableDataChanged();
        }

        public void modifyServer(Object object, Object object2) {
            int n = this._servers.indexOf(object);
            if (n >= 0) {
                this._servers.set(n, object2);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this._servers.clear();
        }

        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = ReferralAuthenticationDialog.this.HEADERS[0];
            } else if (n == 1) {
                string = ReferralAuthenticationDialog.this.HEADERS[1];
            } else {
                Thread.dumpStack();
            }
            return string;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = ReferralAuthenticationModel.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return ReferralAuthenticationDialog.this.HEADERS.length;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getRowCount() {
            return this._servers.size();
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            switch (n2) {
                case 0: {
                    string = (String)this._servers.get(n);
                    break;
                }
                case 1: {
                    string = ((AuthRecord)((ReferralAuthenticationDialog)ReferralAuthenticationDialog.this)._htUserData.get(this._servers.get((int)n))).dn;
                    break;
                }
                default: {
                    Thread.dumpStack();
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            Thread.dumpStack();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

