/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSContentPage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.browser.Clipboard;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class CutDeleter
implements Runnable,
ActionListener {
    boolean _cut;
    boolean _isCancelled = false;
    JFrame _frame;
    GenericProgressDialog _progressDialog;
    int _numberDeletedObjects = 0;
    ArrayList _deletedSubtrees = new ArrayList();
    String[] _startDns;
    Clipboard _clipboard;
    LDAPConnection[] _ldcs;
    String[] _attrs;
    String[] CUT_ATTRS = new String[]{"*"};
    String[] NOT_CUT_ATTRS = new String[]{"dn"};
    final String CHILDREN_FILTER = "|(objectclass=*)(objectclass=ldapsubentry)";

    public CutDeleter(LDAPConnection[] lDAPConnectionArray, String[] stringArray, JFrame jFrame, Clipboard clipboard, boolean bl) {
        this._frame = jFrame;
        this._ldcs = lDAPConnectionArray;
        this._startDns = stringArray;
        this._cut = bl;
        this._clipboard = clipboard;
        if (this._cut) {
            this._attrs = this.CUT_ATTRS;
            this._clipboard.clean();
        } else {
            this._attrs = this.NOT_CUT_ATTRS;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._isCancelled = true;
            this._progressDialog.disableCancelButton();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._progressDialog.closeCallBack();
        }
    }

    public void execute() {
        this._deletedSubtrees.clear();
        boolean bl = false;
        int n = 0;
        while (!bl && n < this._startDns.length) {
            bl = this._startDns[n].equals("");
            ++n;
        }
        if (bl) {
            DSUtil.showErrorDialog((Component)this._frame, "delete-root-error-title", "delete-root-error-msg", (String[])null, "browser");
        } else {
            boolean bl2 = true;
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < this._startDns.length && !bl3) {
                try {
                    bl3 = CutDeleter.entryHasChildren(this._startDns[n2], this._ldcs[n2]);
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                ++n2;
            }
            bl2 = this.confirmDelete(bl3, this._startDns);
            if (bl2) {
                this.createDeleteProgressDialog(bl3);
                Thread thread = new Thread(this);
                thread.start();
                this._progressDialog.packAndShow();
            }
        }
    }

    public ArrayList getDeletedSubtrees() {
        return this._deletedSubtrees;
    }

    public void run() {
        boolean bl = this.deleteTrees(this._ldcs, this._startDns);
        int n = 0;
        while (n < this._startDns.length) {
            if (!this.entryExists(this._ldcs[n], this._startDns[n])) {
                this._deletedSubtrees.add(this._startDns[n]);
            }
            ++n;
        }
        this.updateProgressDialogForEnd(bl);
    }

    private boolean confirmDelete(boolean bl, String[] stringArray) {
        boolean bl2 = true;
        boolean bl3 = false;
        String string = null;
        String[] stringArray2 = new String[1];
        if (stringArray.length == 1) {
            stringArray2[0] = DSUtil.abreviateString(stringArray[0], 30);
            string = bl ? "confirmDeleteTree" : "confirmDeleteObject";
        } else {
            string = bl ? "confirmDeleteTrees" : "confirmDeleteObjects";
        }
        boolean bl4 = bl3 = bl && DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_SUBTREE) || !bl && DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_ENTRY);
        if (bl3) {
            int n = DSUtil.showConfirmationDialog((Component)this._frame, string, stringArray2, "browser");
            bl2 = n == 0;
        }
        return bl2;
    }

    private boolean deleteTrees(LDAPConnection[] lDAPConnectionArray, String[] stringArray) {
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length && bl) {
            try {
                lDAPConnectionArray[n].setOption(30, (Object)new Integer(0));
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            try {
                LDAPEntry lDAPEntry = lDAPConnectionArray[n].read(stringArray[n], this._attrs);
                if (lDAPEntry != null) {
                    bl &= this.recursiveDelete(lDAPEntry, lDAPConnectionArray[n]);
                }
            }
            catch (LDAPException lDAPException) {
                this._progressDialog.appendTextToTextArea(stringArray[n] + ": " + DSUtil.getLDAPErrorMessage(lDAPException) + "\n");
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private boolean recursiveDelete(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        boolean bl = true;
        String string = lDAPEntry.getDN();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "|(objectclass=*)(objectclass=ldapsubentry)", this._attrs, false);
        while (lDAPSearchResults.hasMoreElements() && !this._isCancelled) {
            String[] stringArray;
            Object object2 = lDAPSearchResults.nextElement();
            object = null;
            try {
                if (object2 instanceof LDAPEntry) {
                    object = (LDAPEntry)object2;
                    String string2 = object.getDN();
                    lDAPConnection.delete(string2);
                    if (this._numberDeletedObjects % 5 == 0) {
                        stringArray = new String[]{DSUtil.abreviateString(string2, 45)};
                        String string3 = DSUtil._resource.getString("browser", "deleting-object-label", stringArray);
                        this._progressDialog.setTextInLabel(string3);
                    }
                    ++this._numberDeletedObjects;
                    if (!this._cut) continue;
                    this._clipboard.putEntry((LDAPEntry)object);
                    continue;
                }
                if (!(object2 instanceof LDAPException)) continue;
                throw (LDAPException)((Object)object2);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 66) {
                    stringArray = DSUtil.getLDAPErrorMessage(lDAPException);
                    if (object != null) {
                        this._progressDialog.appendTextToTextArea(object.getDN() + ": " + (String)stringArray + "\n");
                    } else {
                        this._progressDialog.appendTextToTextArea((String)stringArray + "\n");
                    }
                    bl = false;
                    continue;
                }
                vector.addElement((LDAPEntry)object);
            }
        }
        if (this._isCancelled) {
            lDAPConnection.abandon(lDAPSearchResults);
        } else {
            int n = 0;
            while (n < vector.size() && !this._isCancelled) {
                bl &= this.recursiveDelete((LDAPEntry)vector.elementAt(n), lDAPConnection);
                ++n;
            }
        }
        if (!this._isCancelled) {
            try {
                lDAPConnection.delete(string);
                String[] stringArray = new String[]{DSUtil.abreviateString(string, 45)};
                object = DSUtil._resource.getString("browser", "deleting-object-label", stringArray);
                this._progressDialog.setTextInLabel((String)object);
                ++this._numberDeletedObjects;
                if (this._cut) {
                    this._clipboard.putEntry(lDAPEntry);
                }
            }
            catch (LDAPException lDAPException) {
                this._progressDialog.appendTextToTextArea(string + ": " + DSUtil.getLDAPErrorMessage(lDAPException) + "\n");
                bl = false;
            }
        }
        return bl;
    }

    private void updateProgressDialogForEnd(boolean bl) {
        if (this._isCancelled || this._numberDeletedObjects < 2 && bl) {
            this._progressDialog.closeCallBack();
        } else {
            String[] stringArray = new String[]{String.valueOf(this._numberDeletedObjects)};
            this._progressDialog.setTextInLabel(DSUtil._resource.getString("browser", "deleted-objects-label", stringArray));
            this._progressDialog.waitForClose();
        }
    }

    private void createDeleteProgressDialog(boolean bl) {
        String string = bl ? DSUtil._resource.getString("browser", "delete-objects-title") : DSUtil._resource.getString("browser", "delete-object-title");
        this._progressDialog = new GenericProgressDialog(this._frame, true, 7, string, null, null);
        this._progressDialog.setTextInTextAreaLabel(DSUtil._resource.getString("browser", "non-deleted-objects-label"));
        this._progressDialog.setTextAreaRows(3);
        this._progressDialog.setLabelColumns(50);
        this._progressDialog.addActionListener(this);
    }

    private boolean entryExists(LDAPConnection lDAPConnection, String string) {
        boolean bl = false;
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string, this.NOT_CUT_ATTRS);
            bl = lDAPEntry != null;
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                // empty if block
            }
        }
        return bl;
    }

    protected static boolean entryHasChildren(String string, LDAPConnection lDAPConnection) throws LDAPException {
        boolean bl;
        block3: {
            bl = false;
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            lDAPSearchConstraints.setMaxResults(1);
            lDAPSearchConstraints.setServerControls(DSContentPage._manageDSAITControl);
            String[] stringArray = new String[]{"dn"};
            String string2 = "|(objectclass=*)(objectclass=ldapsubentry)";
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, string2, stringArray, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements() && lDAPSearchResults.nextElement() != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block3;
                throw lDAPException;
            }
        }
        return bl;
    }
}

