/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.browser.Clipboard;
import com.netscape.admin.dirserv.browser.CutDeleter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class Copier
implements Runnable,
ActionListener {
    boolean _isCancelled = false;
    JFrame _frame;
    GenericProgressDialog _progressDialog;
    int _numberCopiedObjects = 0;
    String[] _startDns;
    LDAPConnection[] _ldcs;
    String[] COPY_ATTRS = new String[]{"*"};
    Clipboard _clipboard;
    final String CHILDREN_FILTER = "|(objectclass=*)(objectclass=ldapsubentry)";

    public Copier(LDAPConnection[] lDAPConnectionArray, String[] stringArray, JFrame jFrame, Clipboard clipboard) {
        this._frame = jFrame;
        this._ldcs = lDAPConnectionArray;
        this._startDns = stringArray;
        this._clipboard = clipboard;
        this._clipboard.clean();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._isCancelled = true;
            this._progressDialog.disableCancelButton();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._progressDialog.closeCallBack();
        }
    }

    public void execute() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this._startDns.length) {
            bl = this._startDns[n].equals("");
            ++n;
        }
        if (bl) {
            DSUtil.showErrorDialog((Component)this._frame, "copy-root-error-title", "copy-root-error-msg", (String[])null, "browser");
        } else {
            this.createCopyProgressDialog();
            Thread thread = new Thread(this);
            thread.start();
            this._progressDialog.packAndShow();
        }
    }

    public void run() {
        try {
            int n = 0;
            while (n < this._startDns.length) {
                this.copyTree(this._ldcs[n], this._startDns[n]);
                ++n;
            }
            this.updateProgressDialogForEnd();
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            String string = DSUtil._resource.getString("browser", "copying-error-label", stringArray);
            this._progressDialog.setTextInLabel(string);
            this._progressDialog.waitForClose();
        }
    }

    private void copyTree(LDAPConnection lDAPConnection, String string) throws LDAPException {
        boolean bl = true;
        LDAPEntry lDAPEntry = lDAPConnection.read(string, this.COPY_ATTRS);
        this.recursiveCopy(lDAPEntry, lDAPConnection);
    }

    private void recursiveCopy(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        String[] stringArray;
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        String string = lDAPEntry.getDN();
        if (CutDeleter.entryHasChildren(lDAPEntry.getDN(), lDAPConnection)) {
            stringArray = lDAPConnection.search(string, 1, "|(objectclass=*)(objectclass=ldapsubentry)", this.COPY_ATTRS, false);
            while (stringArray.hasMoreElements() && !this._isCancelled) {
                Object object2;
                object = stringArray.nextElement();
                LDAPEntry lDAPEntry2 = null;
                if (object instanceof LDAPEntry) {
                    lDAPEntry2 = (LDAPEntry)object;
                    if (CutDeleter.entryHasChildren(lDAPEntry2.getDN(), lDAPConnection)) {
                        vector.addElement(lDAPEntry2);
                        continue;
                    }
                    object2 = lDAPEntry2.getDN();
                    if (this._numberCopiedObjects % 5 == 0) {
                        String[] stringArray2 = new String[]{DSUtil.abreviateString((String)object2, 45)};
                        String string2 = DSUtil._resource.getString("browser", "copying-object-label", stringArray2);
                        this._progressDialog.setTextInLabel(string2);
                    }
                    ++this._numberCopiedObjects;
                    this._clipboard.putEntry(lDAPEntry2);
                    continue;
                }
                if (!(object instanceof LDAPException)) continue;
                object2 = (LDAPException)((Object)object);
                lDAPConnection.abandon((LDAPSearchResults)stringArray);
                if (object2.getLDAPResultCode() == 32) {
                    vector.clear();
                    continue;
                }
                throw object2;
            }
            if (this._isCancelled) {
                lDAPConnection.abandon((LDAPSearchResults)stringArray);
            } else {
                int n = 0;
                while (n < vector.size() && !this._isCancelled) {
                    this.recursiveCopy((LDAPEntry)vector.elementAt(n), lDAPConnection);
                    ++n;
                }
            }
        }
        if (!this._isCancelled) {
            stringArray = new String[]{DSUtil.abreviateString(string, 45)};
            object = DSUtil._resource.getString("browser", "copying-object-label", stringArray);
            this._progressDialog.setTextInLabel((String)object);
            ++this._numberCopiedObjects;
            this._clipboard.putEntry(lDAPEntry);
        }
    }

    private void updateProgressDialogForEnd() {
        if (this._isCancelled || this._numberCopiedObjects < 2) {
            this._progressDialog.closeCallBack();
        } else {
            String[] stringArray = new String[]{String.valueOf(this._numberCopiedObjects)};
            this._progressDialog.setTextInLabel(DSUtil._resource.getString("browser", "copied-objects-label", stringArray));
            this._progressDialog.waitForClose();
        }
    }

    private void createCopyProgressDialog() {
        String string = DSUtil._resource.getString("browser", "copy-objects-title");
        this._progressDialog = new GenericProgressDialog(this._frame, true, 0, string, null, null);
        this._progressDialog.setLabelColumns(50);
        this._progressDialog.addActionListener(this);
    }
}

