/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.MenuController;
import com.netscape.admin.dirserv.browser.IContentPageInfo;
import com.netscape.admin.dirserv.browser.MenuItemRadioButton;
import com.netscape.admin.dirserv.browser.VLVCache;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ContentMenuController
extends MenuController {
    IContentPageInfo _contentPage;
    DatabaseConfig _databaseConfig;
    private String[] _categoryID = null;
    IMenuItem[] _viewMenuItems;
    IMenuItem[] _displayMenuItems;
    IMenuItem[] _objectNewRootEntryMenuItems;
    IMenuItem[] _contextNewRootEntryMenuItems;
    IMenuItem[] _objectTopMenuItems = new IMenuItem[]{new MenuItemCategory("OBJECT", Framework.i18n((String)"menu", (String)"Object"))};
    IMenuItem[] _fileMenuItems;
    IMenuItem[] _contextMenuItems;
    IMenuItem[] _contextNewMenuItems;
    IMenuItem[] _objectNewMenuItems;
    IMenuItem[] _editMenuItems;
    IMenuItem[] _objectMenuItems;
    IMenuItem[] _layoutMenuItems;
    static ResourceSet _resource = DSUtil._resource;
    public static final String OPEN = "open";
    public static final String ADVANCED_OPEN = "advanced open";
    public static final String ACL = "acl";
    public static final String ROLES = "roles";
    public static final String PASSWORDPOLICIES = "password policies";
    public static final String AUTHENTICATE = "authenticate";
    public static final String REFERRAL_AUTHENTICATION = "REFERRAL_AUTHENTICATION";
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String UNDO = "undo";
    public static final String DELETE = "delete";
    public static final String NEW_USER = "newuser";
    public static final String NEW_GROUP = "newgroup";
    public static final String NEW_ORGANIZATIONALUNIT = "newou";
    public static final String NEW_ROLE = "newrole";
    public static final String NEW_PASSWORDPOLICY = "newpasswordpolicy";
    public static final String NEW_COS = "newcos";
    public static final String NEW_REFERRAL = "newreferral";
    public static final String NEW_OBJECT = "newobject";
    public static final String SEARCH_UG = "search";
    public static final String EFFECTIVE_RIGHTS = "effective rights";
    public static final String CREATE_VLV_INDEX = "createVLVIndex";
    public static final String DELETE_VLV_INDEX = "deleteVLVIndex";
    public static final String CONTEXTNEW = "CONTEXTNEW";
    public static final String CONTEXTNEWROOTENTRY = "CONTEXTNEWROOTENTRY";
    public static final String OBJECTNEW = "OBJECTNEW";
    public static final String OBJECTNEWROOTENTRY = "OBJECTNEWROOTENTRY";
    public static final String REFRESHTREE = "REFRESHTREE";
    public static final String FOLLOW_REFERRALS = "FOLLOW_REFERRALS";
    public static final String COPYDN = "copydn";
    public static final String COPYLDAPURL = "copyldapurl";
    public static final String SORT = "SORT";
    public static final String DISPLAY = "DISPLAY";
    public static final String DISPLAY_ACI_COUNT = "DISPLAY_ACI_COUNT";
    public static final String DISPLAY_ROLE_COUNT = "DISPLAY_ROLE_COUNT";
    public static final String DISPLAY_ACCOUNT_INACTIVATION = "DISPLAY_ACCOUNT_INACTIVATION";
    public static final String LAYOUT = "LAYOUT";
    public static final String DISPLAY_ATTRIBUTE = "DISPLAY_ATTRIBUTE";
    public static final String ACTIVATE = "activate";
    public static final String INACTIVATE = "inactivate";
    public static final String ONLY_TREE_LAYOUT = "ONLY_TREE_LAYOUT";
    public static final String NODE_LEAF_LAYOUT = "NODE_LEAF_LAYOUT";
    public static final String ATTRIBUTE_LAYOUT = "ATTRIBUTE_LAYOUT";

    public ContentMenuController(IContentPageInfo iContentPageInfo, JPopupMenu jPopupMenu, IFramework iFramework, DatabaseConfig databaseConfig, ActionListener actionListener) {
        super(jPopupMenu, iFramework, actionListener);
        this._contentPage = iContentPageInfo;
        this._databaseConfig = databaseConfig;
    }

    public void recreateNewRootEntryMenus() {
        this.unpopulateMenuCategory(CONTEXTNEWROOTENTRY);
        this.unpopulateMenuCategory(OBJECTNEWROOTENTRY);
        this._objectNewRootEntryMenuItems = null;
        this._contextNewRootEntryMenuItems = null;
        this.populateMenuCategory(CONTEXTNEWROOTENTRY);
        this.populateMenuCategory(OBJECTNEWROOTENTRY);
        this.updateMenuState();
    }

    public void updateMenuState() {
        this.unpopulateMenuCategory("OBJECT");
        this.populateMenuCategory("OBJECT");
        boolean bl = this._contentPage.isSelectionMultiple();
        boolean bl2 = this._contentPage.isRootSelected();
        boolean bl3 = this._contentPage.isSelectedNodeRemote();
        boolean bl4 = this._contentPage.isClipboardEmpty();
        boolean bl5 = this._contentPage.hasSelectedNodeCustomEditor();
        Integer n = new Integer(10);
        Integer n2 = VLVCache.CANNOT_HAVE_INDEX;
        if (!bl3 && !bl) {
            n = this._contentPage.getSelectionActivationState();
            n2 = this._contentPage.getSelectionVlvState();
        }
        this.updateNewMenuItems(bl2, bl);
        this.updateAciMenuItems(bl2, bl);
        this.updateRoleMenuItems(bl2, bl);
        this.updatePasswordPolicyMenuItems(bl2, bl);
        this.updateCutCopyPasteMenuItems(bl2, bl, bl4);
        this.updateSearchMenuItems(bl2, bl);
        this.updateActivateInactivateMenuItems(n, bl3, bl);
        this.updateVLVMenuItems(n2, bl3, bl);
        this.setEnabledMenuItem(this._contextMenuItems, OPEN, !bl && bl5);
        this.setEnabledMenuItem(this._objectMenuItems, OPEN, !bl && bl5);
        this.setEnabledMenuItem(this._contextMenuItems, ADVANCED_OPEN, !bl);
        this.setEnabledMenuItem(this._objectMenuItems, ADVANCED_OPEN, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, EFFECTIVE_RIGHTS, !bl);
        this.setEnabledMenuItem(this._objectMenuItems, EFFECTIVE_RIGHTS, !bl);
    }

    public void noObjectSelected() {
        this.unpopulateMenuCategory("OBJECT");
        this.setEnabledMenuItem(this._editMenuItems, COPY, false);
        this.setEnabledMenuItem(this._editMenuItems, CUT, false);
        this.setEnabledMenuItem(this._editMenuItems, DELETE, false);
        this.setEnabledMenuItem(this._editMenuItems, COPYDN, false);
        this.setEnabledMenuItem(this._editMenuItems, COPYLDAPURL, false);
        this.setEnabledMenuItem(this._editMenuItems, PASTE, false);
    }

    private void createFileMenuItems() {
        this._fileMenuItems = new IMenuItem[]{new MenuItemText(AUTHENTICATE, _resource.getString("menu", AUTHENTICATE), _resource.getString("menu", "authenticate-description"), this._listener), new MenuItemText(REFERRAL_AUTHENTICATION, _resource.getString("menu", "referralauthentication"), _resource.getString("menu", "referralauthentication-description"), this._listener), new MenuItemSeparator()};
        this.addShortCuts(this._fileMenuItems);
        this.setActionCommand(this._fileMenuItems);
    }

    private void createContextMenuItems() {
        this._contextMenuItems = new IMenuItem[]{new MenuItemText(OPEN, _resource.getString("menu", "properties"), _resource.getString("menu", "properties-description"), this._listener), new MenuItemText(ADVANCED_OPEN, _resource.getString("menu", "advanced-properties"), _resource.getString("menu", "advanced-properties-description"), this._listener), new MenuItemText(SEARCH_UG, _resource.getString("menu", "EditFindUG"), _resource.getString("menu", "EditFindUG-description"), this._listener), new MenuItemText(EFFECTIVE_RIGHTS, _resource.getString("menu", "effectiverights"), _resource.getString("menu", "effectiverights-description"), this._listener), new MenuItemSeparator(), new MenuItemCategory(CONTEXTNEW, _resource.getString("menu", "EditNew")), new MenuItemCategory(CONTEXTNEWROOTENTRY, _resource.getString("menu", "EditNewRootEntry")), new MenuItemSeparator(), new MenuItemText(ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), this._listener), new MenuItemText(ROLES, _resource.getString("menu", "editroles"), _resource.getString("menu", "editroles-description"), this._listener), new MenuItemText(PASSWORDPOLICIES, _resource.getString("menu", "editpasswordpolicies"), _resource.getString("menu", "editpasswordpolicies-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CREATE_VLV_INDEX, _resource.getString("menu", "createIndex"), _resource.getString("menu", "createIndex-description"), this._listener), new MenuItemText(DELETE_VLV_INDEX, _resource.getString("menu", "deleteIndex"), _resource.getString("menu", "deleteIndex-description"), this._listener), new MenuItemSeparator(), new MenuItemText(ACTIVATE, _resource.getString("menu", ACTIVATE), _resource.getString("menu", "activate-description"), this._listener), new MenuItemText(INACTIVATE, _resource.getString("menu", INACTIVATE), _resource.getString("menu", "inactivate-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CUT, _resource.getString("menu", "EditCut"), _resource.getString("menu", "EditCut-description"), this._listener), new MenuItemText(COPY, _resource.getString("menu", "EditCopy"), _resource.getString("menu", "EditCopy-description"), this._listener), new MenuItemText(PASTE, _resource.getString("menu", "EditPaste"), _resource.getString("menu", "EditPaste-description"), this._listener), new MenuItemText(DELETE, _resource.getString("menu", "EditDelete"), _resource.getString("menu", "EditDelete-description"), this._listener), new MenuItemSeparator(), new MenuItemText(REFRESHTREE, _resource.getString("menu", "refresh"), _resource.getString("menu", "refresh-description"), this._listener)};
        this.addShortCuts(this._contextMenuItems);
        this.setActionCommand(this._contextMenuItems);
    }

    private void createContextNewMenuItems() {
        this._contextNewMenuItems = new IMenuItem[]{new MenuItemText(NEW_USER, _resource.getString("menu", "EditNewUser"), _resource.getString("menu", "EditNewUser-description"), this._listener), new MenuItemText(NEW_GROUP, _resource.getString("menu", "EditNewGroup"), _resource.getString("menu", "EditNewGroup-description"), this._listener), new MenuItemText(NEW_ORGANIZATIONALUNIT, _resource.getString("menu", "EditNewOu"), _resource.getString("menu", "EditNewOu-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_ROLE, _resource.getString("menu", "EditNewRole"), _resource.getString("menu", "EditNewRole-description"), this._listener), new MenuItemText(NEW_COS, _resource.getString("menu", "EditNewCos"), _resource.getString("menu", "EditNewCos-description"), this._listener), new MenuItemText(NEW_PASSWORDPOLICY, _resource.getString("menu", "EditNewPasswordPolicy"), _resource.getString("menu", "EditNewPasswordPolicy-description"), this._listener), new MenuItemText(NEW_REFERRAL, _resource.getString("menu", "EditNewReferral"), _resource.getString("menu", "EditNewReferral-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_OBJECT, _resource.getString("menu", "EditNewObject"), _resource.getString("menu", "EditNewObject-description"), this._listener)};
        this.addShortCuts(this._contextNewMenuItems);
        this.setActionCommand(this._contextNewMenuItems);
    }

    private void createObjectNewMenuItems() {
        this._objectNewMenuItems = new IMenuItem[]{new MenuItemText(NEW_USER, _resource.getString("menu", "EditNewUser"), _resource.getString("menu", "EditNewUser-description"), this._listener), new MenuItemText(NEW_GROUP, _resource.getString("menu", "EditNewGroup"), _resource.getString("menu", "EditNewGroup-description"), this._listener), new MenuItemText(NEW_ORGANIZATIONALUNIT, _resource.getString("menu", "EditNewOu"), _resource.getString("menu", "EditNewOu-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_ROLE, _resource.getString("menu", "EditNewRole"), _resource.getString("menu", "EditNewRole-description"), this._listener), new MenuItemText(NEW_COS, _resource.getString("menu", "EditNewCos"), _resource.getString("menu", "EditNewCos-description"), this._listener), new MenuItemText(NEW_PASSWORDPOLICY, _resource.getString("menu", "EditNewPasswordPolicy"), _resource.getString("menu", "EditNewPasswordPolicy-description"), this._listener), new MenuItemText(NEW_REFERRAL, _resource.getString("menu", "EditNewReferral"), _resource.getString("menu", "EditNewReferral-description"), this._listener), new MenuItemSeparator(), new MenuItemText(NEW_OBJECT, _resource.getString("menu", "EditNewObject"), _resource.getString("menu", "EditNewObject-description"), this._listener)};
        this.addShortCuts(this._objectNewMenuItems);
        this.setActionCommand(this._objectNewMenuItems);
    }

    private void createObjectMenuItems() {
        this._objectMenuItems = new IMenuItem[]{new MenuItemText(OPEN, _resource.getString("menu", "properties"), _resource.getString("menu", "properties-description"), this._listener), new MenuItemText(ADVANCED_OPEN, _resource.getString("menu", "advanced-properties"), _resource.getString("menu", "advanced-properties-description"), this._listener), new MenuItemText(SEARCH_UG, _resource.getString("menu", "EditFindUG"), _resource.getString("menu", "EditFindUG-description"), this._listener), new MenuItemText(EFFECTIVE_RIGHTS, _resource.getString("menu", "effectiverights"), _resource.getString("menu", "effectiverights-description"), this._listener), new MenuItemSeparator(), new MenuItemCategory(OBJECTNEW, _resource.getString("menu", "EditNew")), new MenuItemCategory(OBJECTNEWROOTENTRY, _resource.getString("menu", "EditNewRootEntry")), new MenuItemSeparator(), new MenuItemText(ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), this._listener), new MenuItemText(ROLES, _resource.getString("menu", "editroles"), _resource.getString("menu", "editroles-description"), this._listener), new MenuItemText(PASSWORDPOLICIES, _resource.getString("menu", "editpasswordpolicies"), _resource.getString("menu", "editpasswordpolicies-description"), this._listener), new MenuItemSeparator(), new MenuItemText(CREATE_VLV_INDEX, _resource.getString("menu", "createIndex"), _resource.getString("menu", "createIndex-description"), this._listener), new MenuItemText(DELETE_VLV_INDEX, _resource.getString("menu", "deleteIndex"), _resource.getString("menu", "deleteIndex-description"), this._listener), new MenuItemSeparator(), new MenuItemText(ACTIVATE, _resource.getString("menu", ACTIVATE), _resource.getString("menu", "activate-description"), this._listener), new MenuItemText(INACTIVATE, _resource.getString("menu", INACTIVATE), _resource.getString("menu", "inactivate-description"), this._listener)};
        this.addShortCuts(this._objectMenuItems);
        this.setActionCommand(this._objectMenuItems);
    }

    private void createEditMenuItems() {
        this._editMenuItems = new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(CUT, _resource.getString("menu", "EditCut"), _resource.getString("menu", "EditCut-description"), this._listener), new MenuItemText(COPY, _resource.getString("menu", "EditCopy"), _resource.getString("menu", "EditCopy-description"), this._listener), new MenuItemText(PASTE, _resource.getString("menu", "EditPaste"), _resource.getString("menu", "EditPaste-description"), this._listener), new MenuItemText(DELETE, _resource.getString("menu", "EditDelete"), _resource.getString("menu", "EditDelete-description"), this._listener), new MenuItemSeparator(), new MenuItemText(COPYDN, _resource.getString("menu", "EditCopyDN"), _resource.getString("menu", "EditCopyDN-description"), this._listener), new MenuItemText(COPYLDAPURL, _resource.getString("menu", "EditCopyLDAPURL"), _resource.getString("menu", "EditCopyLDAPURL-description"), this._listener)};
        this.addShortCuts(this._editMenuItems);
        this.setActionCommand(this._editMenuItems);
    }

    private void createNewRootEntryMenuItems() {
        Debug.println((String)"ContentMenuController.createNewRootEntryMenuItems()");
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.getParentSuffix() != null || suffix.hasRootEntry()) continue;
            vector.addElement(suffix.getName());
        }
        Debug.println((String)("ContentMenuController.createNewRootEntryMenuItems() the list is " + vector));
        if (vector != null) {
            int n = vector.size();
            this._objectNewRootEntryMenuItems = new IMenuItem[n];
            this._contextNewRootEntryMenuItems = new IMenuItem[n];
            int n2 = 0;
            while (n2 < this._objectNewRootEntryMenuItems.length) {
                String string = (String)vector.elementAt(n2);
                this._objectNewRootEntryMenuItems[n2] = new MenuItemText(string, string, _resource.getString("menu", "EditNewRoot-description", string), this._listener);
                this._contextNewRootEntryMenuItems[n2] = new MenuItemText(string, string, _resource.getString("menu", "EditNewRoot-description", string), this._listener);
                ++n2;
            }
            this.addShortCuts(this._contextNewRootEntryMenuItems);
            this.setActionCommand(this._contextNewRootEntryMenuItems);
            this.addShortCuts(this._objectNewRootEntryMenuItems);
            this.setActionCommand(this._objectNewRootEntryMenuItems);
        }
    }

    private void createLayoutMenuItems() {
        this._layoutMenuItems = new IMenuItem[]{new MenuItemRadioButton(NODE_LEAF_LAYOUT, _resource.getString("menu", "nodeleaflayout"), _resource.getString("menu", "nodeleafview-description"), this._contentPage.getPanelLayout().equals(NODE_LEAF_LAYOUT), this._listener), new MenuItemRadioButton(ONLY_TREE_LAYOUT, _resource.getString("menu", "onlytreelayout"), _resource.getString("menu", "onlytreeview-description"), this._contentPage.getPanelLayout().equals(ONLY_TREE_LAYOUT), this._listener), new MenuItemRadioButton(ATTRIBUTE_LAYOUT, _resource.getString("menu", "attributelayout"), _resource.getString("menu", "attributeview-description"), this._contentPage.getPanelLayout().equals(ATTRIBUTE_LAYOUT), this._listener)};
        this.addShortCuts(this._layoutMenuItems);
        this.setActionCommand(this._layoutMenuItems);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this._layoutMenuItems.length) {
            if (this._layoutMenuItems[n] instanceof MenuItemRadioButton) {
                buttonGroup.add((MenuItemRadioButton)this._layoutMenuItems[n]);
            }
            ++n;
        }
    }

    private void createDisplayMenuItems() {
        this._displayMenuItems = new IMenuItem[]{new MenuItemCheckBox(DISPLAY_ACI_COUNT, _resource.getString("menu", "acicount"), _resource.getString("menu", "acicount-description"), this._listener, (this._contentPage.getDisplay() & 1) != 0), new MenuItemCheckBox(DISPLAY_ROLE_COUNT, _resource.getString("menu", "rolecount"), _resource.getString("menu", "rolecount-description"), this._listener, (this._contentPage.getDisplay() & 2) != 0), new MenuItemCheckBox(DISPLAY_ACCOUNT_INACTIVATION, _resource.getString("menu", "viewaccountinactivation"), _resource.getString("menu", "viewaccountinactivation-description"), this._listener, (this._contentPage.getDisplay() & 4) != 0)};
        this.addShortCuts(this._displayMenuItems);
        this.setActionCommand(this._displayMenuItems);
    }

    private void createViewMenuItems() {
        IMenuItem[] iMenuItemArray = new IMenuItem[]{new MenuItemSeparator(), new MenuItemCheckBox(FOLLOW_REFERRALS, _resource.getString("menu", "referrals"), _resource.getString("menu", "referrals-description"), this._listener, this._contentPage.getFollowReferrals()), new MenuItemCheckBox(SORT, _resource.getString("menu", "sort"), _resource.getString("menu", "sort-description"), this._listener, this._contentPage.isSorted()), new MenuItemSeparator(), new MenuItemCategory(DISPLAY, _resource.getString("menu", "display")), new MenuItemCategory(LAYOUT, _resource.getString("menu", "layout")), new MenuItemText(DISPLAY_ATTRIBUTE, _resource.getString("menu", "displayattribute"), _resource.getString("menu", "displayattribute-description"), this._listener), new MenuItemSeparator(), new MenuItemText(REFRESHTREE, _resource.getString("menu", "refresh"), _resource.getString("menu", "refresh-description"), this._listener)};
        this._viewMenuItems = iMenuItemArray;
        this.addShortCuts(this._viewMenuItems);
        this.setActionCommand(this._viewMenuItems);
    }

    protected String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"<top>", "FILE", "EDIT", "VIEW", "CONTEXT", "OBJECT", CONTEXTNEW, CONTEXTNEWROOTENTRY, OBJECTNEW, OBJECTNEWROOTENTRY, DISPLAY, LAYOUT};
        }
        return this._categoryID;
    }

    protected IMenuItem[] getMenuItems(String string) {
        if (string == "<top>") {
            return this._objectTopMenuItems;
        }
        if (string == "FILE") {
            if (this._fileMenuItems == null) {
                this.createFileMenuItems();
            }
            return this._fileMenuItems;
        }
        if (string == "CONTEXT") {
            if (this._contextMenuItems == null) {
                this.createContextMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string == CONTEXTNEW) {
            if (this._contextNewMenuItems == null) {
                this.createContextNewMenuItems();
            }
            return this._contextNewMenuItems;
        }
        if (string == OBJECTNEW) {
            if (this._objectNewMenuItems == null) {
                this.createObjectNewMenuItems();
            }
            return this._objectNewMenuItems;
        }
        if (string == CONTEXTNEWROOTENTRY) {
            if (this._contextNewRootEntryMenuItems == null) {
                this.createNewRootEntryMenuItems();
            }
            return this._contextNewRootEntryMenuItems;
        }
        if (string == OBJECTNEWROOTENTRY) {
            if (this._objectNewRootEntryMenuItems == null) {
                this.createNewRootEntryMenuItems();
            }
            return this._objectNewRootEntryMenuItems;
        }
        if (string == "EDIT") {
            if (this._editMenuItems == null) {
                this.createEditMenuItems();
            }
            return this._editMenuItems;
        }
        if (string == "VIEW") {
            if (this._viewMenuItems == null) {
                this.createViewMenuItems();
            }
            return this._viewMenuItems;
        }
        if (string == "OBJECT") {
            if (this._objectMenuItems == null) {
                this.createObjectMenuItems();
            }
            return this._objectMenuItems;
        }
        if (string == LAYOUT) {
            if (this._layoutMenuItems == null) {
                this.createLayoutMenuItems();
            }
            return this._layoutMenuItems;
        }
        if (string == DISPLAY) {
            if (this._displayMenuItems == null) {
                this.createDisplayMenuItems();
            }
            return this._displayMenuItems;
        }
        return null;
    }

    private void updateSearchMenuItems(boolean bl, boolean bl2) {
        this.setEnabledMenuItem(this._objectMenuItems, SEARCH_UG, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, SEARCH_UG, !bl && !bl2);
    }

    private void updateAciMenuItems(boolean bl, boolean bl2) {
        this.setEnabledMenuItem(this._objectMenuItems, ACL, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, ACL, !bl && !bl2);
    }

    private void updateRoleMenuItems(boolean bl, boolean bl2) {
        this.setEnabledMenuItem(this._objectMenuItems, ROLES, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, ROLES, !bl && !bl2);
    }

    private void updatePasswordPolicyMenuItems(boolean bl, boolean bl2) {
        this.setEnabledMenuItem(this._objectMenuItems, PASSWORDPOLICIES, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, PASSWORDPOLICIES, !bl && !bl2);
    }

    private void updateCutCopyPasteMenuItems(boolean bl, boolean bl2, boolean bl3) {
        this.setEnabledMenuItem(this._editMenuItems, COPY, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, COPY, !bl);
        this.setEnabledMenuItem(this._editMenuItems, CUT, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, CUT, !bl);
        this.setEnabledMenuItem(this._editMenuItems, DELETE, !bl);
        this.setEnabledMenuItem(this._contextMenuItems, DELETE, !bl);
        this.setEnabledMenuItem(this._editMenuItems, COPYDN, !bl);
        this.setEnabledMenuItem(this._editMenuItems, COPYLDAPURL, !bl);
        this.setEnabledMenuItem(this._editMenuItems, PASTE, !bl && !bl2 && !bl3);
        this.setEnabledMenuItem(this._contextMenuItems, PASTE, !bl && !bl2 && !bl3);
    }

    private void updateNewMenuItems(boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (this._contextNewRootEntryMenuItems != null) {
            bl3 = this._contextNewRootEntryMenuItems.length > 0;
        }
        this.setEnabledMenuItem(this._objectMenuItems, OBJECTNEWROOTENTRY, bl && bl3 && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, CONTEXTNEWROOTENTRY, bl && bl3 && !bl2);
        this.setEnabledMenuItem(this._objectMenuItems, OBJECTNEW, !bl && !bl2);
        this.setEnabledMenuItem(this._contextMenuItems, CONTEXTNEW, !bl && !bl2);
    }

    private void updateVLVMenuItems(Integer n, boolean bl, boolean bl2) {
        if (bl2) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        } else if (bl) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        } else if (n == VLVCache.HAS_NOT_INDEX) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        } else if (n == VLVCache.HAS_INDEX) {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, true);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, true);
        } else {
            this.setEnabledMenuItem(this._objectMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, CREATE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._objectMenuItems, DELETE_VLV_INDEX, false);
            this.setEnabledMenuItem(this._contextMenuItems, DELETE_VLV_INDEX, false);
        }
    }

    private void updateActivateInactivateMenuItems(Integer n, boolean bl, boolean bl2) {
        if (bl2) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, false);
        } else if (bl) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, true);
        } else if (n == 10) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, false);
        } else if (n == 9) {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, false);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, true);
        } else {
            this.setEnabledMenuItem(this._objectMenuItems, ACTIVATE, true);
            this.setEnabledMenuItem(this._contextMenuItems, ACTIVATE, true);
            this.setEnabledMenuItem(this._objectMenuItems, INACTIVATE, false);
            this.setEnabledMenuItem(this._contextMenuItems, INACTIVATE, false);
        }
    }

    protected void createShortCutKeys() {
        this._shortCutTable = new Hashtable();
        this._shortCutTable.put(OPEN, KeyStroke.getKeyStroke(80, 2));
        this._shortCutTable.put(ACL, KeyStroke.getKeyStroke(76, 2));
        this._shortCutTable.put(REFRESHTREE, KeyStroke.getKeyStroke(82, 2));
        this._shortCutTable.put(COPY, KeyStroke.getKeyStroke(67, 2));
        this._shortCutTable.put(CUT, KeyStroke.getKeyStroke(88, 2));
        this._shortCutTable.put(PASTE, KeyStroke.getKeyStroke(86, 2));
        this._shortCutTable.put(DELETE, KeyStroke.getKeyStroke(68, 2));
    }
}

