/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.browser.BasicNode;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.BrowserEvent;
import com.netscape.admin.dirserv.browser.BrowserEventListener;
import com.netscape.admin.dirserv.browser.ChildrenCellRenderer;
import com.netscape.admin.dirserv.browser.ChildrenTask;
import com.netscape.admin.dirserv.browser.CustomListModel;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.browser.IReferralAuthenticationListener;
import com.netscape.admin.dirserv.browser.IconPool;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.NodeTaskQueue;
import com.netscape.admin.dirserv.browser.RootNode;
import com.netscape.admin.dirserv.browser.SuffixNode;
import com.netscape.management.client.util.RemoteImage;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPSortControl;

public class ChildrenController
implements IReferralAuthenticationListener {
    JList _list;
    CustomListModel _listModel;
    int _displayFlags;
    String _displayAttribute;
    boolean _showAttributeName;
    LDAPConnection _ldc;
    boolean _followReferrals;
    boolean _sorted;
    String[] _containerClasses;
    int _maxChildren = 0;
    Vector _listeners;
    LDAPConnectionPool _connectionPool;
    IconPool _iconPool;
    LDAPSearchConstraints _searchConstraints;
    BasicNode _parentNode;
    NodeTaskQueue _childrenQueue;
    int _queueTotalSize;

    public ChildrenController(JList jList, LDAPConnectionPool lDAPConnectionPool, IconPool iconPool) {
        this._list = jList;
        this._listModel = new CustomListModel();
        this._list.setModel(this._listModel);
        this._iconPool = iconPool;
        this._displayFlags = 1;
        this._displayAttribute = "rdn attribute";
        this._followReferrals = true;
        this._sorted = false;
        this._containerClasses = new String[0];
        this._connectionPool = lDAPConnectionPool;
        this._connectionPool.addReferralAuthenticationListener(this);
        this._searchConstraints = null;
        this._list.setCellRenderer(new ChildrenCellRenderer(this));
        this._listeners = new Vector(2);
        this._queueTotalSize = 0;
        this._childrenQueue = new NodeTaskQueue("New child", 1);
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        this._ldc = lDAPConnection;
        if (this._ldc != null) {
            String string = this._ldc.getHost() + ":" + this._ldc.getPort();
        } else {
            String string = "";
        }
        this.startRefresh();
    }

    public LDAPConnection getLDAPConnection() {
        return this._ldc;
    }

    public JList getList() {
        return this._list;
    }

    public void notifyAuthDataChanged() {
        this.notifyAuthDataChanged(null);
    }

    public LDAPConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    public int getDisplayFlags() {
        return this._displayFlags;
    }

    public void setDisplayFlags(int n) {
        this._displayFlags = n;
    }

    public void setDisplayAttribute(String string) {
        this._displayAttribute = string;
        this.startRefresh();
    }

    public String getDisplayAttribute() {
        return this._displayAttribute;
    }

    public void showAttributeName(boolean bl) {
        this._showAttributeName = bl;
        this.startRefresh();
    }

    public boolean isAttributeNameShown() {
        return this._showAttributeName;
    }

    public void setMaxChildren(int n) {
        this._maxChildren = n;
    }

    public int getMaxChildren() {
        return this._maxChildren;
    }

    public boolean getFollowReferrals() {
        return this._followReferrals;
    }

    public void setFollowReferrals(boolean bl) {
        this._followReferrals = bl;
        this.startRefreshReferralNodes();
    }

    public boolean isSorted() {
        return this._sorted;
    }

    public void setSorted(boolean bl) {
        this.stopRefresh();
        this._sorted = bl;
        this._searchConstraints = null;
    }

    public IBrowserNodeInfo getNodeInfoFromIndex(int n) {
        BasicNode basicNode = (BasicNode)this._listModel.getElementAt(n);
        return new ChildrenNodeInfo(basicNode);
    }

    public String[] getContainerClasses() {
        return this._containerClasses;
    }

    public void setContainerClasses(String[] stringArray) {
        this._containerClasses = stringArray;
        this.startRefresh();
    }

    public void addBrowserEventListener(BrowserEventListener browserEventListener) {
        this._listeners.addElement(browserEventListener);
    }

    public void removeBrowserEventListener(BrowserEventListener browserEventListener) {
        this._listeners.removeElement(browserEventListener);
    }

    public int notifyEntryAdded(String string) {
        BasicNode basicNode = new BasicNode(string);
        int n = this._listModel.getSize();
        this._listModel.insertElementAt(basicNode, n);
        this.startRefreshNode(basicNode);
        this.nodeChanged(basicNode);
        return n;
    }

    public void notifyEntryDeleted(IBrowserNodeInfo iBrowserNodeInfo) {
        BasicNode basicNode = ((ChildrenNodeInfo)iBrowserNodeInfo).getNode();
        this.removeOneNode(basicNode);
        this.nodeChanged(basicNode);
    }

    public void notifyEntryChanged(IBrowserNodeInfo iBrowserNodeInfo) {
        BasicNode basicNode = ((ChildrenNodeInfo)iBrowserNodeInfo).getNode();
        this.startRefreshNode(basicNode);
        this.nodeChanged(basicNode);
    }

    public void notifyAuthDataChanged(LDAPUrl lDAPUrl) {
        this.startRefreshReferralNodes();
    }

    public void setBaseNodeInfo(IBrowserNodeInfo iBrowserNodeInfo) {
        this._parentNode = iBrowserNodeInfo == null ? null : (iBrowserNodeInfo.isRootNode() ? null : (this._followReferrals && iBrowserNodeInfo.getNode().getError() != null && iBrowserNodeInfo.getNode().getReferral() != null ? null : iBrowserNodeInfo.getNode()));
        this.startRefresh();
    }

    public void startRefresh() {
        this.stopRefresh();
        this._listModel.clear();
        if (this._parentNode != null) {
            this._childrenQueue.queue(new ChildrenTask(this._parentNode, this));
        }
    }

    public void startRefresh(IBrowserNodeInfo iBrowserNodeInfo) {
        this.startRefreshNode(iBrowserNodeInfo.getNode());
    }

    public void shutDown() {
        this.stopRefresh();
    }

    public void startRefreshNode(BasicNode basicNode) {
        this._childrenQueue.queue(new ChildrenTask(this, basicNode));
    }

    void startRefreshNode(BasicNode basicNode, LDAPEntry lDAPEntry) {
        this._childrenQueue.queue(new ChildrenTask(this, basicNode, lDAPEntry));
    }

    void stopRefresh() {
        this._childrenQueue.cancelAll();
    }

    void stopRefreshNode(BasicNode basicNode) {
        this._childrenQueue.cancelForNode(basicNode);
    }

    void startRefreshReferralNodes() {
        Enumeration enumeration = this._listModel.elements();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode = (BasicNode)enumeration.nextElement();
            if (basicNode.getReferral() == null && basicNode.getRemoteUrl() == null) continue;
            this.startRefreshNode(basicNode);
        }
    }

    IconPool getIconPool() {
        return this._iconPool;
    }

    String getChildSearchFilter() {
        String string = "(|(objectclass=*)(objectclass=ldapsubentry))";
        return string;
    }

    LDAPConnection findConnectionForLocalEntry(BasicNode basicNode) throws LDAPException {
        BasicNode basicNode2;
        LDAPConnection lDAPConnection = basicNode instanceof RootNode ? this._ldc : ((basicNode2 = (BasicNode)basicNode.getParent()) != null ? this.findConnectionForDisplayedEntry(basicNode2) : (this._parentNode != null && basicNode != this._parentNode ? this.findConnectionForDisplayedEntry(this._parentNode) : this._ldc));
        return lDAPConnection;
    }

    LDAPConnection findConnectionForDisplayedEntry(BasicNode basicNode) throws LDAPException {
        LDAPConnection lDAPConnection = this._followReferrals && basicNode.getRemoteUrl() != null ? this._connectionPool.getConnection(basicNode.getRemoteUrl()) : this.findConnectionForLocalEntry(basicNode);
        return lDAPConnection;
    }

    void releaseLDAPConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection != this._ldc) {
            this._connectionPool.releaseConnection(lDAPConnection);
        }
    }

    LDAPUrl findUrlForLocalEntry(BasicNode basicNode) {
        LDAPUrl lDAPUrl = null;
        if (basicNode instanceof RootNode) {
            lDAPUrl = LDAPConnectionPool.makeLDAPUrl(this._ldc, "");
        } else {
            BasicNode basicNode2 = (BasicNode)basicNode.getParent();
            if (basicNode2 != null) {
                LDAPUrl lDAPUrl2 = this.findUrlForDisplayedEntry(basicNode2);
                lDAPUrl = LDAPConnectionPool.makeLDAPUrl(lDAPUrl2, basicNode.getDN());
            } else if (this._parentNode != null && basicNode != this._parentNode) {
                LDAPUrl lDAPUrl3 = this.findUrlForDisplayedEntry(this._parentNode);
                lDAPUrl = LDAPConnectionPool.makeLDAPUrl(lDAPUrl3, basicNode.getDN());
            } else {
                lDAPUrl = LDAPConnectionPool.makeLDAPUrl(this._ldc, basicNode.getDN());
            }
        }
        return lDAPUrl;
    }

    LDAPUrl findUrlForDisplayedEntry(BasicNode basicNode) {
        LDAPUrl lDAPUrl = this._followReferrals && basicNode.getRemoteUrl() != null ? basicNode.getRemoteUrl() : this.findUrlForLocalEntry(basicNode);
        return lDAPUrl;
    }

    String findBaseDNForChildEntries(BasicNode basicNode) {
        String string = this._followReferrals && basicNode.getRemoteUrl() != null ? basicNode.getRemoteUrl().getDN() : basicNode.getDN();
        return string;
    }

    boolean isDisplayedEntryRemote(BasicNode basicNode) {
        boolean bl = false;
        if (this._followReferrals && basicNode != null) {
            if (basicNode instanceof RootNode) {
                bl = false;
            } else if (basicNode.getRemoteUrl() != null) {
                bl = true;
            } else {
                BasicNode basicNode2 = (BasicNode)basicNode.getParent();
                if (basicNode2 != null) {
                    bl = this.isDisplayedEntryRemote(basicNode2);
                } else if (this._parentNode != null && basicNode != this._parentNode) {
                    bl = this.isDisplayedEntryRemote(this._parentNode);
                }
            }
        }
        return bl;
    }

    String[] getAttrsForRedSearch() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("objectclass");
        vector.addElement("numsubordinates");
        vector.addElement("ref");
        if ((this._displayFlags & 1) != 0) {
            vector.addElement("aci");
        }
        if ((this._displayFlags & 2) != 0) {
            vector.addElement("nsrole");
        }
        if ((this._displayFlags & 4) != 0) {
            vector.addElement("nsaccountlock");
        }
        if (!this._displayAttribute.equals("rdn attribute")) {
            vector.addElement(this._displayAttribute);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    String[] getAttrsForBlackSearch() {
        if (!this._displayAttribute.equals("rdn attribute")) {
            return new String[]{"objectclass", "numsubordinates", "ref", "aci", "nsrole", "nsaccountlock", this._displayAttribute};
        }
        return new String[]{"objectclass", "numsubordinates", "ref", "aci", "nsrole", "nsaccountlock"};
    }

    LDAPSearchConstraints getSearchConstraints() {
        if (this._searchConstraints == null) {
            LDAPControl[] lDAPControlArray = new LDAPControl[this._sorted ? 2 : 1];
            lDAPControlArray[0] = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
            if (this._sorted) {
                LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[BrowserController.SORT_ATTRIBUTES.length];
                int n = 0;
                while (n < lDAPSortKeyArray.length) {
                    lDAPSortKeyArray[n] = new LDAPSortKey(BrowserController.SORT_ATTRIBUTES[n]);
                    ++n;
                }
                lDAPControlArray[1] = new LDAPSortControl(lDAPSortKeyArray, true);
            }
            this._searchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
            this._searchConstraints.setMaxResults(this._maxChildren);
            this._searchConstraints.setServerControls(lDAPControlArray);
        }
        return this._searchConstraints;
    }

    private void childrenTaskDidProgress(ChildrenTask childrenTask, int n, int n2) {
        BasicNode basicNode = childrenTask.getNode();
        boolean bl = false;
        if (n == 0) {
            this.checkUpdateEvent(true);
        }
        if (childrenTask.isInFinalState()) {
            this.checkUpdateEvent(false);
        }
        if (n2 == 10) {
            if (n == 2) {
                basicNode.setRemoteUrl(childrenTask.getRemoteUrl());
                if (childrenTask.getRemoteEntry() != null) {
                    this.updateNodeRendering(basicNode, childrenTask.getRemoteEntry());
                }
                basicNode.setError(new BasicNode.Error(n, childrenTask.getException(), childrenTask.getExceptionArg()));
                bl = this.updateNodeRendering(basicNode, childrenTask.getDisplayedEntry());
            }
        } else if (n2 == 8) {
            this._listModel.clear();
        } else {
            if (n == 1) {
                basicNode.setRemoteUrl(null);
                LDAPEntry lDAPEntry = childrenTask.getLocalEntry();
                bl = this.updateNodeRendering(basicNode, lDAPEntry);
            } else if (n == 2) {
                basicNode.setRemoteUrl(childrenTask.getRemoteUrl());
                this.updateNodeRendering(basicNode, childrenTask.getRemoteEntry());
                bl = true;
            } else if (n == 5) {
                this.updateChildNodes(childrenTask);
            }
            if (n2 == 7 && basicNode.getError() != null && basicNode != this._parentNode) {
                basicNode.setError(null);
                bl = this.updateNodeRendering(basicNode, childrenTask.getDisplayedEntry());
            }
        }
        if (bl) {
            this.nodeChanged(childrenTask.getNode());
        }
    }

    void invokeChildrenTaskDidProgress(final ChildrenTask childrenTask, final int n, final int n2) throws InterruptedException {
        Runnable runnable = new Runnable(){
            ChildrenTask _task;
            int _oldState;
            int _newState;
            {
                this._task = childrenTask;
                this._oldState = n;
                this._newState = n2;
            }

            public void run() {
                try {
                    ChildrenController.this.childrenTaskDidProgress(this._task, this._oldState, this._newState);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        ChildrenController.swingInvoke(runnable);
    }

    private void updateChildNodes(ChildrenTask childrenTask) {
        BasicNode basicNode = childrenTask.getNode();
        Enumeration enumeration = childrenTask.getChildEntries().elements();
        while (enumeration.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
            int n = this._listModel.getSize();
            BasicNode basicNode2 = new BasicNode(lDAPEntry.getDN());
            this._listModel.insertElementAt(basicNode2, n);
            this.updateNodeRendering(basicNode2, lDAPEntry);
            if (basicNode2.getReferral() == null) continue;
            this.startRefreshNode(basicNode2, lDAPEntry);
        }
    }

    private boolean updateNodeRendering(BasicNode basicNode, LDAPEntry lDAPEntry) {
        boolean bl;
        LDAPAttribute lDAPAttribute;
        CharSequence charSequence;
        boolean bl2;
        Object object;
        RemoteImage remoteImage;
        boolean bl3;
        LDAPAttribute lDAPAttribute2;
        LDAPAttribute lDAPAttribute3;
        LDAPAttribute lDAPAttribute4;
        if (lDAPEntry != null) {
            basicNode.setNumSubOrdinates(ChildrenController.getNumSubOrdinates(lDAPEntry));
            basicNode.setReferral(BrowserController.getReferral(lDAPEntry));
            if (lDAPEntry.getAttribute("objectclass") != null) {
                basicNode.setObjectClassValues(lDAPEntry.getAttribute("objectclass").getStringValueArray());
            }
        }
        int n = (this._displayFlags & 1) != 0 && lDAPEntry != null ? ((lDAPAttribute4 = lDAPEntry.getAttribute("aci")) != null ? lDAPAttribute4.size() : 0) : 0;
        int n2 = (this._displayFlags & 2) != 0 && lDAPEntry != null ? ((lDAPAttribute3 = lDAPEntry.getAttribute("nsrole")) != null ? lDAPAttribute3.size() : 0) : 0;
        if ((this._displayFlags & 4) != 0 && lDAPEntry != null) {
            LDAPAttribute lDAPAttribute5 = lDAPEntry.getAttribute("nsaccountlock");
            if (lDAPAttribute5 != null) {
                lDAPAttribute2 = lDAPAttribute5.getStringValueArray();
                if (((String[])lDAPAttribute2).length >= 1) {
                    bl3 = lDAPAttribute2[0].equalsIgnoreCase("true");
                    if (bl3 && (remoteImage = lDAPEntry.getAttribute("objectclass")) != null) {
                        object = remoteImage.getStringValues();
                        bl2 = false;
                        boolean bl4 = false;
                        while (!(!object.hasMoreElements() || bl2 && bl4)) {
                            charSequence = (String)object.nextElement();
                            if (((String)charSequence).equalsIgnoreCase("nsroledefinition")) {
                                bl2 = true;
                                continue;
                            }
                            if (!((String)charSequence).equalsIgnoreCase("ldapsubentry")) continue;
                            bl4 = true;
                        }
                        if (bl2 && bl4) {
                            bl3 = false;
                        }
                    }
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        } else {
            bl3 = false;
        }
        int n3 = 0;
        if (basicNode.isLeaf() && basicNode.getNumSubOrdinates() <= 0) {
            n3 |= 1;
        }
        if (basicNode.getReferral() != null) {
            n3 |= 2;
        }
        if (basicNode.getError() != null) {
            n3 |= 8;
        }
        if (bl3) {
            n3 |= 4;
        }
        lDAPAttribute2 = null;
        if (lDAPEntry != null) {
            lDAPAttribute2 = lDAPEntry.getAttribute("objectclass");
        }
        remoteImage = this._iconPool.getIcon(lDAPAttribute2, n3);
        object = new StringBuffer();
        if (n >= 1) {
            ((StringBuffer)object).append(String.valueOf(n));
            if (n == 1) {
                ((StringBuffer)object).append(" aci");
            } else {
                ((StringBuffer)object).append(" acis");
            }
        }
        if (n2 >= 1) {
            if (((StringBuffer)object).length() >= 1) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(String.valueOf(n2));
            if (n2 == 1) {
                ((StringBuffer)object).append(" role");
            } else {
                ((StringBuffer)object).append(" roles");
            }
        }
        charSequence = new StringBuffer();
        bl2 = true;
        if (!this._displayAttribute.equals("rdn attribute") && lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(this._displayAttribute)) != null) {
            String string = this._showAttributeName ? this._displayAttribute + "=" + lDAPAttribute.getStringValueArray()[0] : lDAPAttribute.getStringValueArray()[0];
            ((StringBuffer)charSequence).append(string);
            bl2 = false;
        }
        if (bl2) {
            String string = this._followReferrals && basicNode.getRemoteUrl() != null ? (this._showAttributeName ? basicNode.getRemoteRDNWithAttributeName() : basicNode.getRemoteRDN()) : (this._showAttributeName ? basicNode.getRDNWithAttributeName() : basicNode.getRDN());
            ((StringBuffer)charSequence).append(string);
        }
        if (((StringBuffer)object).length() >= 1) {
            ((StringBuffer)charSequence).append("  (");
            ((StringBuffer)charSequence).append(object);
            ((StringBuffer)charSequence).append(")");
        }
        String string = ((StringBuffer)charSequence).toString();
        int n4 = 0;
        if (this.isDisplayedEntryRemote(basicNode)) {
            n4 |= 2;
        }
        if (basicNode instanceof SuffixNode) {
            n4 |= 1;
        }
        boolean bl5 = bl = basicNode.getIcon() != remoteImage || basicNode.getDisplayName() != string || basicNode.getFontStyle() != n4;
        if (bl) {
            basicNode.setIcon((Icon)remoteImage);
            basicNode.setDisplayName(string);
            basicNode.setFontStyle(n4);
        }
        return bl;
    }

    int findChildNode(BasicNode basicNode, String string) {
        int n = this._sorted ? this.findSortedChildNode(basicNode, string, 0, basicNode.getChildCount() - 1) : this.findUnSortedChildNode(basicNode, string);
        return n;
    }

    int findSortedChildNode(BasicNode basicNode, String string, int n, int n2) {
        int n3;
        if (n > n2) {
            if (n != n2 + 1) {
                throw new IllegalStateException("Bug in findSortedChildNode");
            }
            n3 = -(n + 1);
        } else {
            int n4;
            int n5 = this.compareDnToChildNode(string, basicNode, n);
            n3 = n5 < 0 ? -(n + 1) : (n5 == 0 ? n : (n == n2 ? -(n2 + 1 + 1) : ((n5 = this.compareDnToChildNode(string, basicNode, n2)) > 0 ? -(n2 + 1 + 1) : (n5 == 0 ? n2 : ((n5 = this.compareDnToChildNode(string, basicNode, n4 = (n + n2) / 2)) < 0 ? this.findSortedChildNode(basicNode, string, n + 1, n4 - 1) : (n5 == 0 ? n4 : this.findSortedChildNode(basicNode, string, n4 + 1, n2 - 1)))))));
        }
        return n3;
    }

    int findUnSortedChildNode(BasicNode basicNode, String string) {
        int n = basicNode.getChildCount();
        int n2 = 0;
        int n3 = -1;
        while (n2 < n && !string.equals(((BasicNode)basicNode.getChildAt(n2)).getDN())) {
            ++n2;
        }
        if (n2 >= n) {
            n2 = -(n + 1);
        }
        return n2;
    }

    int compareDnToChildNode(String string, BasicNode basicNode, int n) {
        BasicNode basicNode2 = (BasicNode)basicNode.getChildAt(n);
        return Collator.getInstance().compare(string, basicNode2.getDN());
    }

    private void removeOneNode(BasicNode basicNode) {
        this.stopRefreshNode(basicNode);
        this._listModel.removeElement(basicNode);
    }

    private void checkUpdateEvent(boolean bl) {
        int n = this._childrenQueue.size();
        if (!bl) {
            --n;
        }
        if (n != this._queueTotalSize) {
            if (this._queueTotalSize == 0 && n >= 1) {
                this.fireEvent(1);
            } else if (this._queueTotalSize >= 1 && n == 0) {
                this.fireEvent(2);
            }
            this._queueTotalSize = n;
        }
    }

    private void fireEvent(int n) {
        BrowserEvent browserEvent = new BrowserEvent(this, n);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            BrowserEventListener browserEventListener = (BrowserEventListener)enumeration.nextElement();
            browserEventListener.processBrowserEvent(browserEvent);
        }
    }

    void nodeChanged(BasicNode basicNode) {
        int n = this._listModel.indexOf(basicNode);
        if (n >= 0) {
            this._listModel.fireContentsChanged(this._listModel, n, n);
        }
    }

    private boolean isNoSuchObjectLDAPException(Object object) {
        LDAPException lDAPException;
        boolean bl = object instanceof LDAPException ? (lDAPException = (LDAPException)((Object)object)).getLDAPResultCode() == 32 : false;
        return bl;
    }

    public static int getNumSubOrdinates(LDAPEntry lDAPEntry) {
        int n;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("numsubordinates");
        if (lDAPAttribute == null) {
            n = -1;
        } else {
            try {
                n = Integer.parseInt(lDAPAttribute.getStringValueArray()[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    static int[] intArrayFromVector(Vector vector) {
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)vector.elementAt(n);
            ++n;
        }
        return nArray;
    }

    static LDAPEntry[] entryArrayFromVector(Vector vector) {
        LDAPEntry[] lDAPEntryArray = new LDAPEntry[vector.size()];
        vector.toArray(lDAPEntryArray);
        return lDAPEntryArray;
    }

    static BasicNode[] nodeArrayFromVector(Vector vector) {
        BasicNode[] basicNodeArray = new BasicNode[vector.size()];
        vector.toArray(basicNodeArray);
        return basicNodeArray;
    }

    static void swingInvoke(Runnable runnable) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    class ChildrenNodeInfo
    implements IBrowserNodeInfo {
        BasicNode _node;
        LDAPUrl _url;
        boolean _isRemote;
        boolean _isSuffix;
        boolean _isRootNode;
        String[] _referral;
        int _numSubOrdinates;
        int _errorType;
        Exception _errorException;
        Object _errorArg;
        String[] _objectClassValues;

        public ChildrenNodeInfo(BasicNode basicNode) {
            this._node = basicNode;
            this._url = ChildrenController.this.findUrlForDisplayedEntry(basicNode);
            this._isRootNode = basicNode instanceof RootNode;
            this._isRemote = ChildrenController.this.isDisplayedEntryRemote(basicNode);
            this._isSuffix = basicNode instanceof SuffixNode;
            this._referral = basicNode.getReferral();
            this._numSubOrdinates = basicNode.getNumSubOrdinates();
            this._objectClassValues = basicNode.getObjectClassValues();
            if (basicNode.getError() != null) {
                BasicNode.Error error = basicNode.getError();
                switch (error.getType()) {
                    case 1: {
                        this._errorType = 1;
                        break;
                    }
                    case 2: {
                        this._errorType = 2;
                        break;
                    }
                    case 5: {
                        this._errorType = 3;
                    }
                }
                this._errorException = error.getException();
                this._errorArg = error.getArg();
            }
        }

        public BasicNode getNode() {
            return this._node;
        }

        public LDAPUrl getURL() {
            return this._url;
        }

        public boolean isRootNode() {
            return this._isRootNode;
        }

        public boolean isSuffix() {
            return this._isSuffix;
        }

        public boolean isRemote() {
            return this._isRemote;
        }

        public String[] getReferral() {
            return this._referral;
        }

        public int getNumSubOrdinates() {
            return this._numSubOrdinates;
        }

        public int getErrorType() {
            return this._errorType;
        }

        public Exception getErrorException() {
            return this._errorException;
        }

        public Object getErrorArg() {
            return this._errorArg;
        }

        public TreePath getTreePath() {
            return null;
        }

        public String[] getObjectClassValues() {
            return this._objectClassValues;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getURL());
            if (this.getReferral() != null) {
                stringBuffer.append(" -> ");
                stringBuffer.append(this.getReferral());
            }
            return stringBuffer.toString();
        }

        public boolean representsSameNode(IBrowserNodeInfo iBrowserNodeInfo) {
            boolean bl = false;
            if (iBrowserNodeInfo != null) {
                bl = iBrowserNodeInfo.getNode() == this._node;
            }
            return bl;
        }
    }
}

