/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.attredit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.attredit.AttributeEditor;
import com.netscape.admin.dirserv.attredit.RequestFileDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class BinaryAttributeEditor
extends AttributeEditor
implements ActionListener {
    private static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "attrEdit";
    private static String _buttonText = _resource.getString("attrEdit", "replace-label");

    public Object getDefaultValue() {
        return new byte[0];
    }

    protected JComponent fetchField(Object object) {
        JButton jButton;
        int n = 0;
        if (this._blankField != null) {
            jButton = (JButton)this._blankField;
            this._blankField = null;
        } else {
            jButton = (JButton)this.makeField();
            n = this.getValueCount() - 1;
        }
        jButton.setOpaque(true);
        jButton.setBorder(this._textBorder);
        jButton.setEnabled(true);
        jButton.addFocusListener(this);
        jButton.addMouseListener(this);
        Dimension dimension = new Dimension(18, 22);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        if (this._textFont != null) {
            jButton.setFont(this._textFont);
        }
        jButton.setActionCommand(Integer.toString(n));
        return jButton;
    }

    public void addValue(Object object) {
        super.addValue(object);
        int n = this.getValueCount();
        if (n > 0) {
            this.update(n - 1);
        }
    }

    protected void update(int n) {
        JButton jButton = (JButton)this._fields.elementAt(n);
        jButton.setText(_buttonText);
    }

    protected JComponent makeField() {
        JButton jButton = UIFactory.makeJButton((Object)this, "");
        jButton.setEnabled(!this._isReadOnly);
        return jButton;
    }

    public JComponent getLastFocusableComponent() {
        int n = this.getValueCount();
        if (n > 1) {
            return (JComponent)this._fields.elementAt(n - 1);
        }
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            String string;
            RequestFileDialog requestFileDialog = this.makeRequestFileDialog(null);
            requestFileDialog.show();
            ((Window)((Object)requestFileDialog)).dispose();
            if (!requestFileDialog.isCancel() && (string = requestFileDialog.getFileName()) != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    int n = fileInputStream.available();
                    byte[] byArray = new byte[n];
                    fileInputStream.read(byArray);
                    int n2 = Integer.parseInt(actionEvent.getActionCommand());
                    this.replaceValue(byArray, n2);
                    this.setDirty();
                    this.update(n2);
                }
                catch (Exception exception) {
                    DSUtil.showUnknownErrorDialog(null, exception, "111-title");
                }
            }
        }
    }

    protected RequestFileDialog makeRequestFileDialog(JFrame jFrame) {
        String string = _resource.getString(_section, "binary-request-label");
        return new RequestFileDialog(null, string);
    }
}

