/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class CloneServer {
    private static Hashtable noCopyAttrs = new Hashtable();
    private static Hashtable specialDeleteAttrs;
    private static Hashtable convertAttrs;
    private static Hashtable replacePathAttrs;
    private static Hashtable differentHostsAttrs;
    private static Hashtable specialRemoveAttrs;

    public static boolean cloneServer(LDAPConnection lDAPConnection, String string, String string2, JFrame jFrame) {
        Debug.println((String)("CloneServer.cloneServer: begin: configDS=" + DSUtil.format(lDAPConnection) + " sourceDN=" + string + " destDN=" + string2));
        Hashtable hashtable = new Hashtable();
        LDAPConnection lDAPConnection2 = CloneServer.getConnection(lDAPConnection, string, hashtable, jFrame);
        if (lDAPConnection2 == null) {
            return false;
        }
        Hashtable hashtable2 = new Hashtable();
        LDAPConnection lDAPConnection3 = CloneServer.getConnection(lDAPConnection, string2, hashtable2, jFrame);
        if (lDAPConnection3 == null) {
            try {
                lDAPConnection2.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        DN[] dNArray = CloneServer.getEntriesToClone(lDAPConnection2, jFrame);
        if (dNArray == null) {
            DSUtil.showErrorDialog((Component)jFrame, "clonesourceempty", "cn=config");
            try {
                lDAPConnection2.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lDAPConnection3.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        int n = 0;
        while (n < dNArray.length) {
            Debug.println((String)("entryList[" + n + "]=" + dNArray[n]));
            ++n;
        }
        String string3 = CloneServer.replace(hashtable.get("serverroot").toString() + "/" + hashtable.get("nsserverid").toString(), "\\", "/");
        String string4 = CloneServer.replace(hashtable2.get("serverroot").toString() + "/" + hashtable2.get("nsserverid").toString(), "\\", "/");
        String string5 = (String)hashtable.get("serverhostname");
        try {
            string5 = DSUtil.canonicalHost(string5);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string5 == null || string5.equals("")) {
            string5 = (String)hashtable.get("serverhostname");
        }
        String string6 = (String)hashtable2.get("serverhostname");
        try {
            string6 = DSUtil.canonicalHost(string6);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string6 == null || string6.equals("")) {
            string6 = (String)hashtable2.get("serverhostname");
        }
        boolean bl = string5.equalsIgnoreCase(string6);
        String string7 = null;
        String[] stringArray = null;
        boolean bl2 = true;
        int n2 = 0;
        while (bl2 && n2 < dNArray.length) {
            LDAPEntry lDAPEntry = null;
            Debug.println((String)("CloneServer.cloneServer: reading entry DN=" + dNArray[n2].toString()));
            boolean bl3 = false;
            while (!bl3) {
                try {
                    lDAPEntry = lDAPConnection2.read(dNArray[n2].toString());
                    if (lDAPEntry == null) {
                        throw new LDAPException("no elements", 50);
                    }
                    bl3 = true;
                }
                catch (LDAPException lDAPException) {
                    bl3 = CloneServer.reauthenticate(lDAPConnection2, lDAPException, dNArray[n2].toString(), jFrame, "clonesourceread");
                    if (!bl3) continue;
                    bl2 = false;
                }
            }
            if (lDAPEntry != null) {
                Debug.println((String)("CloneServer.cloneServer: modifying DN=" + lDAPEntry.getDN()));
                LDAPModificationSet lDAPModificationSet = CloneServer.getMods(lDAPEntry, lDAPConnection3, jFrame, bl, string3, string4);
                bl3 = false;
                if (lDAPModificationSet == null || lDAPModificationSet.size() == 0) {
                    bl3 = true;
                } else {
                    Debug.println((String)("CloneServer.cloneServer: DN=" + lDAPEntry.getDN() + " num attrs to modify=" + lDAPModificationSet.size()));
                }
                while (!bl3) {
                    try {
                        lDAPConnection3.modify(dNArray[n2].toString(), lDAPModificationSet);
                        bl3 = true;
                    }
                    catch (LDAPException lDAPException) {
                        bl3 = CloneServer.reauthenticate(lDAPConnection3, lDAPException, dNArray[n2].toString(), jFrame, "clonedestwrite");
                        if (!bl3) continue;
                        bl2 = false;
                    }
                }
            } else {
                Debug.println((String)("DSAdmin.cloneFrom(): could not read entry from source " + DSUtil.format(lDAPConnection2)));
                string7 = "clonesourceempty";
                stringArray = new String[]{dNArray[n2].toString()};
            }
            if (string7 != null) {
                DSUtil.showErrorDialog((Component)jFrame, string7, stringArray);
                bl2 = false;
            }
            string7 = null;
            stringArray = null;
            ++n2;
        }
        if (bl2) {
            bl2 = CloneServer.cloneSchema(lDAPConnection2, lDAPConnection3, jFrame);
        }
        try {
            lDAPConnection2.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDAPConnection3.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            DSUtil.showInformationDialog((Component)jFrame, "clonesuccess", (String)null);
        } else {
            DSUtil.showErrorDialog((Component)jFrame, "clonefailed", (String)null);
        }
        return bl2;
    }

    private static LDAPConnection getConnection(LDAPConnection lDAPConnection, String string, Hashtable hashtable, JFrame jFrame) {
        String string2;
        String string3;
        hashtable.put("nsbinddn", "");
        hashtable.put("cn", "");
        hashtable.put("serverroot", "");
        hashtable.put("nsserverid", "");
        LDAPConnection lDAPConnection2 = null;
        try {
            lDAPConnection2 = DSAdmin.getLDAPConnection(lDAPConnection, string, "serverhostname", "nsserverport", hashtable);
        }
        catch (LDAPException lDAPException) {
            string3 = (String)hashtable.get("serverhostname");
            string2 = (String)hashtable.get("nsserverport");
            Debug.println((String)("CloneServer.cloneServer(): could not read DN = " + string + " or connect to " + string3 + ":" + string2 + " LDAP exception = " + (Object)((Object)lDAPException)));
        }
        catch (Exception exception) {
            string2 = (String)hashtable.get("serverhostname");
            String string4 = (String)hashtable.get("nsserverport");
            Debug.println((String)("CloneServer.cloneServer(): could not read DN = " + string + " or connect to " + string2 + ":" + string4 + " exception = " + exception));
        }
        if (lDAPConnection2 == null || !lDAPConnection2.isConnected()) {
            String string5 = (String)hashtable.get("cn");
            string3 = (String)hashtable.get("serverhostname");
            string2 = (String)hashtable.get("nsserverport");
            DSUtil.showErrorDialog((Component)jFrame, "120", string5 + " " + string3 + ":" + string2);
            return null;
        }
        return lDAPConnection2;
    }

    private static DN[] getEntriesToClone(LDAPConnection lDAPConnection, JFrame jFrame) {
        Object[] objectArray;
        Vector<DN> vector = null;
        String string = "cn=config";
        String[] stringArray = new String[]{"cn=monitor", "cn=schema", "cn=encryption", "cn=features"};
        String string2 = "nsslapd-privatenamespaces";
        LDAPEntry lDAPEntry = null;
        String[] stringArray2 = new String[]{string2};
        boolean bl = false;
        while (!bl) {
            try {
                lDAPEntry = lDAPConnection.read(string, stringArray2);
                if (lDAPEntry == null) {
                    throw new LDAPException("no elements", 50);
                }
                bl = true;
            }
            catch (LDAPException lDAPException) {
                bl = CloneServer.reauthenticate(lDAPConnection, lDAPException, string, jFrame, "clonesourcread");
            }
        }
        if (lDAPEntry == null) {
            return null;
        }
        vector = new Vector<DN>();
        int n = 0;
        while (n < stringArray2.length) {
            objectArray = lDAPEntry.getAttribute(stringArray2[n]).getStringValues();
            while (objectArray.hasMoreElements()) {
                String string3 = (String)objectArray.nextElement();
                if (string3.equals("")) continue;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (string3.indexOf(stringArray[n2]) != -1) {
                        string3 = null;
                        break;
                    }
                    ++n2;
                }
                if (string3 == null) continue;
                LDAPSearchResults lDAPSearchResults = null;
                String string4 = "(objectclass=*)";
                try {
                    lDAPSearchResults = lDAPConnection.search(string3, 2, string4, null, false);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("error CloneServer.getEntriesToClone: LDAP search failed: " + string4));
                    Debug.println((String)("error CloneServer.getEntriesToClone: could not find any servers under " + string3 + " error: " + (Object)((Object)lDAPException)));
                }
                while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = (LDAPEntry)lDAPSearchResults.nextElement();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (lDAPEntry2.getDN().indexOf(stringArray[n3]) != -1) {
                            lDAPEntry2 = null;
                            break;
                        }
                        ++n3;
                    }
                    if (lDAPEntry2 == null) continue;
                    vector.addElement(new DN(lDAPEntry2.getDN()));
                }
            }
            ++n;
        }
        objectArray = null;
        if (vector != null && vector.size() > 0) {
            objectArray = new DN[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private static boolean reauthenticate(LDAPConnection lDAPConnection, LDAPException lDAPException, String string, JFrame jFrame, String string2) {
        boolean bl = false;
        Debug.println((String)("CloneServer.reauthenticate(): LDAP error code=" + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
        Debug.println((String)("CloneServer.reauthenticate(): could not read DN = " + string + " from source ldap = " + DSUtil.format(lDAPConnection)));
        if (lDAPException.getLDAPResultCode() == 50) {
            DSUtil.showPermissionDialog((Component)jFrame, lDAPConnection);
            try {
                lDAPConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = !DSUtil.reauthenticate(lDAPConnection, jFrame, null, lDAPConnection.getAuthenticationDN(), null);
        } else {
            Debug.println((String)("CloneServer.reauthenticate(): could not handle the exception, entry will not be read from source " + DSUtil.format(lDAPConnection)));
            if (string2 != null) {
                String[] stringArray = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)jFrame, string2, stringArray);
            }
            bl = true;
        }
        return bl;
    }

    private static boolean cloneSchema(LDAPConnection lDAPConnection, LDAPConnection lDAPConnection2, JFrame jFrame) {
        LDAPAttribute lDAPAttribute;
        Enumeration enumeration;
        Object object;
        String[] stringArray;
        Object object2;
        String string = "cn=schema";
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(string);
        }
        catch (LDAPException lDAPException) {
            lDAPEntry = null;
            object2 = new String[]{string, lDAPException.toString()};
            DSUtil.showErrorDialog((Component)jFrame, "clonesourceread", (String[])object2);
        }
        if (lDAPEntry == null) {
            return false;
        }
        Debug.println((String)"CloneServer.cloneSchema(): read source schema");
        LDAPEntry lDAPEntry2 = null;
        try {
            lDAPEntry2 = lDAPConnection2.read(string);
        }
        catch (LDAPException lDAPException) {
            lDAPEntry2 = null;
            stringArray = new String[]{string, lDAPException.toString()};
            DSUtil.showErrorDialog((Component)jFrame, "clonedestwrite", stringArray);
        }
        if (lDAPEntry2 == null) {
            return false;
        }
        Debug.println((String)"CloneServer.cloneSchema(): read dest schema");
        object2 = new Hashtable();
        stringArray = lDAPEntry2.getAttributeSet();
        Enumeration enumeration2 = stringArray.getAttributes();
        while (enumeration2.hasMoreElements()) {
            object = (LDAPAttribute)enumeration2.nextElement();
            enumeration = object.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 == null) continue;
                ((Hashtable)object2).put(string2, object.getName());
            }
        }
        Debug.println((String)("CloneServer.cloneSchema(): dest schema size=" + ((Hashtable)object2).size()));
        object = null;
        enumeration = null;
        int n = 0;
        stringArray = lDAPEntry.getAttributeSet();
        Enumeration enumeration3 = stringArray.getAttributes();
        while (enumeration3.hasMoreElements()) {
            LDAPAttribute lDAPAttribute2 = (LDAPAttribute)enumeration3.nextElement();
            lDAPAttribute = null;
            Enumeration enumeration4 = lDAPAttribute2.getStringValues();
            while (enumeration4.hasMoreElements()) {
                String string3 = (String)enumeration4.nextElement();
                if (string3 == null || ((Hashtable)object2).containsKey(string3)) continue;
                if (CloneServer.isObjectClass(lDAPAttribute2)) {
                    if (object == null) {
                        object = new Vector();
                    }
                    object.addElement(new LDAPObjectClassSchema(string3));
                } else {
                    if (lDAPAttribute == null) {
                        lDAPAttribute = new LDAPAttribute(lDAPAttribute2.getName());
                    }
                    lDAPAttribute.addValue(string3);
                }
                Debug.println((int)9, (String)("CloneServer.cloneSchema(): found attribute value not present on dest=" + lDAPAttribute));
            }
            if (lDAPAttribute == null) continue;
            if (enumeration == null) {
                enumeration = new LDAPModificationSet();
            }
            enumeration.add(n, lDAPAttribute);
        }
        if ((enumeration == null || enumeration.size() == 0) && object == null && object.size() == 0) {
            Debug.println((String)"CloneServer.cloneSchema(): source and dest are identical, nothing to modify");
            return true;
        }
        Debug.println((String)("CloneServer.cloneSchema(): modifying " + enumeration.size() + " schema elements"));
        try {
            lDAPConnection2.modify(string, (LDAPModificationSet)enumeration);
            int n2 = 0;
            while (object != null && n2 < object.size()) {
                lDAPAttribute = (LDAPObjectClassSchema)object.elementAt(n2);
                lDAPAttribute.add(lDAPConnection2);
                ++n2;
            }
        }
        catch (LDAPException lDAPException) {
            lDAPEntry2 = null;
            lDAPAttribute = new LDAPAttribute[]{string, lDAPException.toString()};
            DSUtil.showErrorDialog((Component)jFrame, "clonedestwrite", (String[])lDAPAttribute);
            return false;
        }
        Debug.println((String)"CloneServer.cloneSchema(): success");
        return true;
    }

    private static LDAPAttribute convertValue(LDAPAttribute lDAPAttribute, int n) {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            Object var8_7;
            object = (String)enumeration.nextElement();
            int n2 = -1;
            try {
                block5: {
                    try {
                        Debug.println((String)("Converting value=" + (String)object + " using" + " factor=" + n));
                        n2 = Integer.parseInt((String)object);
                        if (n == 0) break block5;
                        object = Integer.toString(n2 /= n);
                        Debug.println((String)("Converting new value=" + (String)object));
                    }
                    catch (Exception exception) {
                        var8_7 = null;
                        vector.addElement((Object[])object);
                        continue;
                    }
                }
                var8_7 = null;
                vector.addElement((Object[])object);
            }
            catch (Throwable throwable) {
                var8_7 = null;
                vector.addElement((Object[])object);
                throw throwable;
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return new LDAPAttribute(lDAPAttribute.getName(), object);
    }

    private static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private static LDAPAttribute replaceValue(LDAPAttribute lDAPAttribute, String string, String string2) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            objectArray = (String)enumeration.nextElement();
            vector.addElement(CloneServer.replace((String)objectArray, string, string2));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return new LDAPAttribute(lDAPAttribute.getName(), (String[])objectArray);
    }

    private static LDAPModificationSet getMods(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection, JFrame jFrame, boolean bl, String string, String string2) {
        int n;
        Enumeration enumeration;
        Object object;
        LDAPEntry lDAPEntry2 = null;
        boolean bl2 = false;
        Debug.println((String)("CloneServer.getMods(): getting attributes to modify for DN=" + lDAPEntry.getDN()));
        boolean bl3 = false;
        while (!bl2) {
            try {
                lDAPEntry2 = lDAPConnection.read(lDAPEntry.getDN());
                if (lDAPEntry2 == null) {
                    throw new LDAPException("no elements", 50);
                }
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) {
                    bl3 = true;
                    bl2 = true;
                    continue;
                }
                bl2 = CloneServer.reauthenticate(lDAPConnection, lDAPException, lDAPEntry.getDN(), jFrame, "clonedestread");
            }
        }
        if (lDAPEntry2 == null && !bl3) {
            return null;
        }
        Debug.println((String)("CloneServer.getMods(): got dest entry DN=" + lDAPEntry.getDN()));
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        Enumeration enumeration2 = lDAPAttributeSet.getAttributes();
        while (enumeration2.hasMoreElements()) {
            object = (LDAPAttribute)enumeration2.nextElement();
            enumeration = object.getStringValues();
            if (!CloneServer.hasAValue((LDAPAttribute)object)) continue;
            n = 2;
            if (lDAPEntry2 == null || !CloneServer.hasAValue(lDAPEntry2.getAttribute(object.getName()))) {
                n = 0;
            } else if (noCopyAttrs.containsKey(object.getName())) continue;
            if (convertAttrs.containsKey(object.getName())) {
                Debug.println((String)("converting attribute " + object.getName()));
                Integer n2 = (Integer)convertAttrs.get(object.getName());
                object = CloneServer.convertValue((LDAPAttribute)object, n2);
            } else if (replacePathAttrs.containsKey(object.getName())) {
                object = CloneServer.replaceValue((LDAPAttribute)object, string, string2);
            } else if (bl && differentHostsAttrs.containsKey(object.getName())) continue;
            lDAPModificationSet.add(n, (LDAPAttribute)object);
        }
        if (lDAPEntry2 != null) {
            lDAPAttributeSet = lDAPEntry2.getAttributeSet();
            object = lDAPAttributeSet.getAttributes();
            while (object.hasMoreElements()) {
                enumeration = (LDAPAttribute)object.nextElement();
                if (!CloneServer.hasAValue((LDAPAttribute)enumeration) || CloneServer.hasAValue(lDAPEntry.getAttribute(enumeration.getName()))) continue;
                n = 1;
                if (specialRemoveAttrs.containsKey(enumeration.getName())) {
                    enumeration.addValue(specialRemoveAttrs.get(enumeration.getName()).toString());
                    n = 2;
                }
                lDAPModificationSet.add(n, (LDAPAttribute)enumeration);
            }
        }
        return lDAPModificationSet;
    }

    private static boolean hasAValue(LDAPAttribute lDAPAttribute) {
        if (lDAPAttribute == null) {
            Debug.println((String)"CloneServer.hasAValue(): attr is null");
            return false;
        }
        if (lDAPAttribute.size() == 0) {
            Debug.println((String)("CloneServer.hasAValue(): attr=" + lDAPAttribute.getName() + " is empty"));
            return false;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Debug.println((String)("CloneServer.hasAValue(): attr=" + lDAPAttribute.getName() + " has no values"));
            return false;
        }
        boolean bl = false;
        if (specialDeleteAttrs.containsKey(lDAPAttribute.getName())) {
            Debug.println((String)("checking for deletion of attr=" + lDAPAttribute.getName() + " value=" + lDAPAttribute.toString()));
            while (!bl && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)specialDeleteAttrs.get(lDAPAttribute.getName());
                boolean bl2 = bl = string != null && !string.equals(string2);
            }
        } else {
            bl = true;
        }
        if (!bl) {
            Debug.println((String)("CloneServer.hasAValue(): attr=" + lDAPAttribute.getName() + " has all null values"));
        } else {
            Debug.println((int)9, (String)("CloneServer.hasAValue(): attr=" + lDAPAttribute.getName() + " has value=" + lDAPAttribute.toString()));
        }
        return bl;
    }

    private static boolean isObjectClass(LDAPAttribute lDAPAttribute) {
        return lDAPAttribute.getName().equalsIgnoreCase("objectclasses");
    }

    static {
        noCopyAttrs.put("cn", "");
        noCopyAttrs.put("objectclass", "");
        noCopyAttrs.put("oid", "");
        noCopyAttrs.put("nsslapd-config", "");
        noCopyAttrs.put("nsslapd-betype", "");
        noCopyAttrs.put("nsslapd-privatenamespaces", "");
        noCopyAttrs.put("nsslapd-rootdn", "");
        noCopyAttrs.put("nsslapd-rootpw", "");
        noCopyAttrs.put("nsslapd-instancedir", "");
        noCopyAttrs.put("nsslapd-useroc", "");
        noCopyAttrs.put("nsslapd-userat", "");
        noCopyAttrs.put("nsslapd-localhost", "");
        noCopyAttrs.put("nsslapd-security", "");
        noCopyAttrs.put("nsslapd-plugin", "");
        noCopyAttrs.put("nsslapd-include", "");
        noCopyAttrs.put("nsslapd-backendconfig", "");
        noCopyAttrs.put("nsslapd-accesslog", "");
        noCopyAttrs.put("nsslapd-accesslog-list", "");
        noCopyAttrs.put("nsslapd-errorlog", "");
        noCopyAttrs.put("nsslapd-errorlog-list", "");
        noCopyAttrs.put("nsslapd-auditlog", "");
        noCopyAttrs.put("nsslapd-auditlog-list", "");
        noCopyAttrs.put("nsslapd-requiresrestart", "");
        noCopyAttrs.put("nsslapd-database", "");
        noCopyAttrs.put("nsslapd-directory", "");
        noCopyAttrs.put("nsslapd-allidsthreshold", "");
        noCopyAttrs.put("nsslapd-parentcheck", "");
        noCopyAttrs.put("nsslapd-mode", "");
        noCopyAttrs.put("nsslapd-groupevalnestlevel", "");
        noCopyAttrs.put("nsslapd-pluginpath", "");
        noCopyAttrs.put("nsslapd-plugininitfunc", "");
        noCopyAttrs.put("nsslapd-plugintype", "");
        noCopyAttrs.put("nsslapd-pluginid", "");
        noCopyAttrs.put("nsslapd-pluginversion", "");
        noCopyAttrs.put("nsslapd-pluginvendor", "");
        noCopyAttrs.put("nsslapd-plugindescription", "");
        noCopyAttrs.put("nsslapd-backend", "");
        noCopyAttrs.put("nsslapd-referralmode", "");
        specialDeleteAttrs = new Hashtable();
        specialDeleteAttrs.put("nsslapd-changelogmaxentries", "0");
        specialDeleteAttrs.put("nsslapd-changelogmaxage", "0");
        specialDeleteAttrs.put("nsslapd-accesslog-logmaxdiskspace", "0");
        specialDeleteAttrs.put("nsslapd-errorlog-logmaxdiskspace", "0");
        specialDeleteAttrs.put("nsslapd-auditlog-logmaxdiskspace", "0");
        specialDeleteAttrs.put("nsslapd-accesslog-maxlogsize", "0");
        specialDeleteAttrs.put("nsslapd-errorlog-maxlogsize", "0");
        specialDeleteAttrs.put("nsslapd-auditlog-maxlogsize", "0");
        convertAttrs = new Hashtable();
        replacePathAttrs = new Hashtable();
        replacePathAttrs.put("nsslapd-changelogdir", "");
        differentHostsAttrs = new Hashtable();
        differentHostsAttrs.put("nsslapd-port", "");
        differentHostsAttrs.put("nsslapd-secureport", "");
        differentHostsAttrs.put("nsslapd-ntsynch-port", "");
        specialRemoveAttrs = new Hashtable();
        specialRemoveAttrs.put("nsslapd-referral", "remove");
    }
}

